/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MediaTransportControlDataStatusRequest is the corresponding interface of MediaTransportControlDataStatusRequest
type MediaTransportControlDataStatusRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	MediaTransportControlData
	// IsMediaTransportControlDataStatusRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMediaTransportControlDataStatusRequest()
	// CreateBuilder creates a MediaTransportControlDataStatusRequestBuilder
	CreateMediaTransportControlDataStatusRequestBuilder() MediaTransportControlDataStatusRequestBuilder
}

// _MediaTransportControlDataStatusRequest is the data-structure of this message
type _MediaTransportControlDataStatusRequest struct {
	MediaTransportControlDataContract
}

var _ MediaTransportControlDataStatusRequest = (*_MediaTransportControlDataStatusRequest)(nil)
var _ MediaTransportControlDataRequirements = (*_MediaTransportControlDataStatusRequest)(nil)

// NewMediaTransportControlDataStatusRequest factory function for _MediaTransportControlDataStatusRequest
func NewMediaTransportControlDataStatusRequest(commandTypeContainer MediaTransportControlCommandTypeContainer, mediaLinkGroup byte) *_MediaTransportControlDataStatusRequest {
	_result := &_MediaTransportControlDataStatusRequest{
		MediaTransportControlDataContract: NewMediaTransportControlData(commandTypeContainer, mediaLinkGroup),
	}
	_result.MediaTransportControlDataContract.(*_MediaTransportControlData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MediaTransportControlDataStatusRequestBuilder is a builder for MediaTransportControlDataStatusRequest
type MediaTransportControlDataStatusRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() MediaTransportControlDataStatusRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() MediaTransportControlDataBuilder
	// Build builds the MediaTransportControlDataStatusRequest or returns an error if something is wrong
	Build() (MediaTransportControlDataStatusRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MediaTransportControlDataStatusRequest
}

// NewMediaTransportControlDataStatusRequestBuilder() creates a MediaTransportControlDataStatusRequestBuilder
func NewMediaTransportControlDataStatusRequestBuilder() MediaTransportControlDataStatusRequestBuilder {
	return &_MediaTransportControlDataStatusRequestBuilder{_MediaTransportControlDataStatusRequest: new(_MediaTransportControlDataStatusRequest)}
}

type _MediaTransportControlDataStatusRequestBuilder struct {
	*_MediaTransportControlDataStatusRequest

	parentBuilder *_MediaTransportControlDataBuilder

	err *utils.MultiError
}

var _ (MediaTransportControlDataStatusRequestBuilder) = (*_MediaTransportControlDataStatusRequestBuilder)(nil)

func (b *_MediaTransportControlDataStatusRequestBuilder) setParent(contract MediaTransportControlDataContract) {
	b.MediaTransportControlDataContract = contract
	contract.(*_MediaTransportControlData)._SubType = b._MediaTransportControlDataStatusRequest
}

func (b *_MediaTransportControlDataStatusRequestBuilder) WithMandatoryFields() MediaTransportControlDataStatusRequestBuilder {
	return b
}

func (b *_MediaTransportControlDataStatusRequestBuilder) Build() (MediaTransportControlDataStatusRequest, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._MediaTransportControlDataStatusRequest.deepCopy(), nil
}

func (b *_MediaTransportControlDataStatusRequestBuilder) MustBuild() MediaTransportControlDataStatusRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MediaTransportControlDataStatusRequestBuilder) Done() MediaTransportControlDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewMediaTransportControlDataBuilder().(*_MediaTransportControlDataBuilder)
	}
	return b.parentBuilder
}

func (b *_MediaTransportControlDataStatusRequestBuilder) buildForMediaTransportControlData() (MediaTransportControlData, error) {
	return b.Build()
}

func (b *_MediaTransportControlDataStatusRequestBuilder) DeepCopy() any {
	_copy := b.CreateMediaTransportControlDataStatusRequestBuilder().(*_MediaTransportControlDataStatusRequestBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateMediaTransportControlDataStatusRequestBuilder creates a MediaTransportControlDataStatusRequestBuilder
func (b *_MediaTransportControlDataStatusRequest) CreateMediaTransportControlDataStatusRequestBuilder() MediaTransportControlDataStatusRequestBuilder {
	if b == nil {
		return NewMediaTransportControlDataStatusRequestBuilder()
	}
	return &_MediaTransportControlDataStatusRequestBuilder{_MediaTransportControlDataStatusRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_MediaTransportControlDataStatusRequest) GetParent() MediaTransportControlDataContract {
	return m.MediaTransportControlDataContract
}

// Deprecated: use the interface for direct cast
func CastMediaTransportControlDataStatusRequest(structType any) MediaTransportControlDataStatusRequest {
	if casted, ok := structType.(MediaTransportControlDataStatusRequest); ok {
		return casted
	}
	if casted, ok := structType.(*MediaTransportControlDataStatusRequest); ok {
		return *casted
	}
	return nil
}

func (m *_MediaTransportControlDataStatusRequest) GetTypeName() string {
	return "MediaTransportControlDataStatusRequest"
}

func (m *_MediaTransportControlDataStatusRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.MediaTransportControlDataContract.(*_MediaTransportControlData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_MediaTransportControlDataStatusRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_MediaTransportControlDataStatusRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_MediaTransportControlData) (__mediaTransportControlDataStatusRequest MediaTransportControlDataStatusRequest, err error) {
	m.MediaTransportControlDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MediaTransportControlDataStatusRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MediaTransportControlDataStatusRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("MediaTransportControlDataStatusRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MediaTransportControlDataStatusRequest")
	}

	return m, nil
}

func (m *_MediaTransportControlDataStatusRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_MediaTransportControlDataStatusRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("MediaTransportControlDataStatusRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for MediaTransportControlDataStatusRequest")
		}

		if popErr := writeBuffer.PopContext("MediaTransportControlDataStatusRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for MediaTransportControlDataStatusRequest")
		}
		return nil
	}
	return m.MediaTransportControlDataContract.(*_MediaTransportControlData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_MediaTransportControlDataStatusRequest) IsMediaTransportControlDataStatusRequest() {}

func (m *_MediaTransportControlDataStatusRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MediaTransportControlDataStatusRequest) deepCopy() *_MediaTransportControlDataStatusRequest {
	if m == nil {
		return nil
	}
	_MediaTransportControlDataStatusRequestCopy := &_MediaTransportControlDataStatusRequest{
		m.MediaTransportControlDataContract.(*_MediaTransportControlData).deepCopy(),
	}
	_MediaTransportControlDataStatusRequestCopy.MediaTransportControlDataContract.(*_MediaTransportControlData)._SubType = m
	return _MediaTransportControlDataStatusRequestCopy
}

func (m *_MediaTransportControlDataStatusRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
