/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MediaTransportControlDataSourcePowerControl is the corresponding interface of MediaTransportControlDataSourcePowerControl
type MediaTransportControlDataSourcePowerControl interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	MediaTransportControlData
	// GetState returns State (property field)
	GetState() byte
	// GetIsShouldPowerOn returns IsShouldPowerOn (virtual field)
	GetIsShouldPowerOn() bool
	// GetIsShouldPowerOff returns IsShouldPowerOff (virtual field)
	GetIsShouldPowerOff() bool
	// IsMediaTransportControlDataSourcePowerControl is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMediaTransportControlDataSourcePowerControl()
	// CreateBuilder creates a MediaTransportControlDataSourcePowerControlBuilder
	CreateMediaTransportControlDataSourcePowerControlBuilder() MediaTransportControlDataSourcePowerControlBuilder
}

// _MediaTransportControlDataSourcePowerControl is the data-structure of this message
type _MediaTransportControlDataSourcePowerControl struct {
	MediaTransportControlDataContract
	State byte
}

var _ MediaTransportControlDataSourcePowerControl = (*_MediaTransportControlDataSourcePowerControl)(nil)
var _ MediaTransportControlDataRequirements = (*_MediaTransportControlDataSourcePowerControl)(nil)

// NewMediaTransportControlDataSourcePowerControl factory function for _MediaTransportControlDataSourcePowerControl
func NewMediaTransportControlDataSourcePowerControl(commandTypeContainer MediaTransportControlCommandTypeContainer, mediaLinkGroup byte, state byte) *_MediaTransportControlDataSourcePowerControl {
	_result := &_MediaTransportControlDataSourcePowerControl{
		MediaTransportControlDataContract: NewMediaTransportControlData(commandTypeContainer, mediaLinkGroup),
		State:                             state,
	}
	_result.MediaTransportControlDataContract.(*_MediaTransportControlData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MediaTransportControlDataSourcePowerControlBuilder is a builder for MediaTransportControlDataSourcePowerControl
type MediaTransportControlDataSourcePowerControlBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(state byte) MediaTransportControlDataSourcePowerControlBuilder
	// WithState adds State (property field)
	WithState(byte) MediaTransportControlDataSourcePowerControlBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() MediaTransportControlDataBuilder
	// Build builds the MediaTransportControlDataSourcePowerControl or returns an error if something is wrong
	Build() (MediaTransportControlDataSourcePowerControl, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MediaTransportControlDataSourcePowerControl
}

// NewMediaTransportControlDataSourcePowerControlBuilder() creates a MediaTransportControlDataSourcePowerControlBuilder
func NewMediaTransportControlDataSourcePowerControlBuilder() MediaTransportControlDataSourcePowerControlBuilder {
	return &_MediaTransportControlDataSourcePowerControlBuilder{_MediaTransportControlDataSourcePowerControl: new(_MediaTransportControlDataSourcePowerControl)}
}

type _MediaTransportControlDataSourcePowerControlBuilder struct {
	*_MediaTransportControlDataSourcePowerControl

	parentBuilder *_MediaTransportControlDataBuilder

	err *utils.MultiError
}

var _ (MediaTransportControlDataSourcePowerControlBuilder) = (*_MediaTransportControlDataSourcePowerControlBuilder)(nil)

func (b *_MediaTransportControlDataSourcePowerControlBuilder) setParent(contract MediaTransportControlDataContract) {
	b.MediaTransportControlDataContract = contract
	contract.(*_MediaTransportControlData)._SubType = b._MediaTransportControlDataSourcePowerControl
}

func (b *_MediaTransportControlDataSourcePowerControlBuilder) WithMandatoryFields(state byte) MediaTransportControlDataSourcePowerControlBuilder {
	return b.WithState(state)
}

func (b *_MediaTransportControlDataSourcePowerControlBuilder) WithState(state byte) MediaTransportControlDataSourcePowerControlBuilder {
	b.State = state
	return b
}

func (b *_MediaTransportControlDataSourcePowerControlBuilder) Build() (MediaTransportControlDataSourcePowerControl, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._MediaTransportControlDataSourcePowerControl.deepCopy(), nil
}

func (b *_MediaTransportControlDataSourcePowerControlBuilder) MustBuild() MediaTransportControlDataSourcePowerControl {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MediaTransportControlDataSourcePowerControlBuilder) Done() MediaTransportControlDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewMediaTransportControlDataBuilder().(*_MediaTransportControlDataBuilder)
	}
	return b.parentBuilder
}

func (b *_MediaTransportControlDataSourcePowerControlBuilder) buildForMediaTransportControlData() (MediaTransportControlData, error) {
	return b.Build()
}

func (b *_MediaTransportControlDataSourcePowerControlBuilder) DeepCopy() any {
	_copy := b.CreateMediaTransportControlDataSourcePowerControlBuilder().(*_MediaTransportControlDataSourcePowerControlBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateMediaTransportControlDataSourcePowerControlBuilder creates a MediaTransportControlDataSourcePowerControlBuilder
func (b *_MediaTransportControlDataSourcePowerControl) CreateMediaTransportControlDataSourcePowerControlBuilder() MediaTransportControlDataSourcePowerControlBuilder {
	if b == nil {
		return NewMediaTransportControlDataSourcePowerControlBuilder()
	}
	return &_MediaTransportControlDataSourcePowerControlBuilder{_MediaTransportControlDataSourcePowerControl: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_MediaTransportControlDataSourcePowerControl) GetParent() MediaTransportControlDataContract {
	return m.MediaTransportControlDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_MediaTransportControlDataSourcePowerControl) GetState() byte {
	return m.State
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_MediaTransportControlDataSourcePowerControl) GetIsShouldPowerOn() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetState()) == (0x00)))
}

func (m *_MediaTransportControlDataSourcePowerControl) GetIsShouldPowerOff() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetState()) != (0x00)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastMediaTransportControlDataSourcePowerControl(structType any) MediaTransportControlDataSourcePowerControl {
	if casted, ok := structType.(MediaTransportControlDataSourcePowerControl); ok {
		return casted
	}
	if casted, ok := structType.(*MediaTransportControlDataSourcePowerControl); ok {
		return *casted
	}
	return nil
}

func (m *_MediaTransportControlDataSourcePowerControl) GetTypeName() string {
	return "MediaTransportControlDataSourcePowerControl"
}

func (m *_MediaTransportControlDataSourcePowerControl) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.MediaTransportControlDataContract.(*_MediaTransportControlData).getLengthInBits(ctx))

	// Simple field (state)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_MediaTransportControlDataSourcePowerControl) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_MediaTransportControlDataSourcePowerControl) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_MediaTransportControlData) (__mediaTransportControlDataSourcePowerControl MediaTransportControlDataSourcePowerControl, err error) {
	m.MediaTransportControlDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MediaTransportControlDataSourcePowerControl"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MediaTransportControlDataSourcePowerControl")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	state, err := ReadSimpleField(ctx, "state", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'state' field"))
	}
	m.State = state

	isShouldPowerOn, err := ReadVirtualField[bool](ctx, "isShouldPowerOn", (*bool)(nil), bool((state) == (0x00)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isShouldPowerOn' field"))
	}
	_ = isShouldPowerOn

	isShouldPowerOff, err := ReadVirtualField[bool](ctx, "isShouldPowerOff", (*bool)(nil), bool((state) != (0x00)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isShouldPowerOff' field"))
	}
	_ = isShouldPowerOff

	if closeErr := readBuffer.CloseContext("MediaTransportControlDataSourcePowerControl"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MediaTransportControlDataSourcePowerControl")
	}

	return m, nil
}

func (m *_MediaTransportControlDataSourcePowerControl) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_MediaTransportControlDataSourcePowerControl) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("MediaTransportControlDataSourcePowerControl"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for MediaTransportControlDataSourcePowerControl")
		}

		if err := WriteSimpleField[byte](ctx, "state", m.GetState(), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'state' field")
		}
		// Virtual field
		isShouldPowerOn := m.GetIsShouldPowerOn()
		_ = isShouldPowerOn
		if _isShouldPowerOnErr := writeBuffer.WriteVirtual(ctx, "isShouldPowerOn", m.GetIsShouldPowerOn()); _isShouldPowerOnErr != nil {
			return errors.Wrap(_isShouldPowerOnErr, "Error serializing 'isShouldPowerOn' field")
		}
		// Virtual field
		isShouldPowerOff := m.GetIsShouldPowerOff()
		_ = isShouldPowerOff
		if _isShouldPowerOffErr := writeBuffer.WriteVirtual(ctx, "isShouldPowerOff", m.GetIsShouldPowerOff()); _isShouldPowerOffErr != nil {
			return errors.Wrap(_isShouldPowerOffErr, "Error serializing 'isShouldPowerOff' field")
		}

		if popErr := writeBuffer.PopContext("MediaTransportControlDataSourcePowerControl"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for MediaTransportControlDataSourcePowerControl")
		}
		return nil
	}
	return m.MediaTransportControlDataContract.(*_MediaTransportControlData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_MediaTransportControlDataSourcePowerControl) IsMediaTransportControlDataSourcePowerControl() {
}

func (m *_MediaTransportControlDataSourcePowerControl) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MediaTransportControlDataSourcePowerControl) deepCopy() *_MediaTransportControlDataSourcePowerControl {
	if m == nil {
		return nil
	}
	_MediaTransportControlDataSourcePowerControlCopy := &_MediaTransportControlDataSourcePowerControl{
		m.MediaTransportControlDataContract.(*_MediaTransportControlData).deepCopy(),
		m.State,
	}
	_MediaTransportControlDataSourcePowerControlCopy.MediaTransportControlDataContract.(*_MediaTransportControlData)._SubType = m
	return _MediaTransportControlDataSourcePowerControlCopy
}

func (m *_MediaTransportControlDataSourcePowerControl) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
