/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// LightingDataOff is the corresponding interface of LightingDataOff
type LightingDataOff interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	LightingData
	// GetGroup returns Group (property field)
	GetGroup() byte
	// IsLightingDataOff is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsLightingDataOff()
	// CreateBuilder creates a LightingDataOffBuilder
	CreateLightingDataOffBuilder() LightingDataOffBuilder
}

// _LightingDataOff is the data-structure of this message
type _LightingDataOff struct {
	LightingDataContract
	Group byte
}

var _ LightingDataOff = (*_LightingDataOff)(nil)
var _ LightingDataRequirements = (*_LightingDataOff)(nil)

// NewLightingDataOff factory function for _LightingDataOff
func NewLightingDataOff(commandTypeContainer LightingCommandTypeContainer, group byte) *_LightingDataOff {
	_result := &_LightingDataOff{
		LightingDataContract: NewLightingData(commandTypeContainer),
		Group:                group,
	}
	_result.LightingDataContract.(*_LightingData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// LightingDataOffBuilder is a builder for LightingDataOff
type LightingDataOffBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(group byte) LightingDataOffBuilder
	// WithGroup adds Group (property field)
	WithGroup(byte) LightingDataOffBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() LightingDataBuilder
	// Build builds the LightingDataOff or returns an error if something is wrong
	Build() (LightingDataOff, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() LightingDataOff
}

// NewLightingDataOffBuilder() creates a LightingDataOffBuilder
func NewLightingDataOffBuilder() LightingDataOffBuilder {
	return &_LightingDataOffBuilder{_LightingDataOff: new(_LightingDataOff)}
}

type _LightingDataOffBuilder struct {
	*_LightingDataOff

	parentBuilder *_LightingDataBuilder

	err *utils.MultiError
}

var _ (LightingDataOffBuilder) = (*_LightingDataOffBuilder)(nil)

func (b *_LightingDataOffBuilder) setParent(contract LightingDataContract) {
	b.LightingDataContract = contract
	contract.(*_LightingData)._SubType = b._LightingDataOff
}

func (b *_LightingDataOffBuilder) WithMandatoryFields(group byte) LightingDataOffBuilder {
	return b.WithGroup(group)
}

func (b *_LightingDataOffBuilder) WithGroup(group byte) LightingDataOffBuilder {
	b.Group = group
	return b
}

func (b *_LightingDataOffBuilder) Build() (LightingDataOff, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._LightingDataOff.deepCopy(), nil
}

func (b *_LightingDataOffBuilder) MustBuild() LightingDataOff {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_LightingDataOffBuilder) Done() LightingDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewLightingDataBuilder().(*_LightingDataBuilder)
	}
	return b.parentBuilder
}

func (b *_LightingDataOffBuilder) buildForLightingData() (LightingData, error) {
	return b.Build()
}

func (b *_LightingDataOffBuilder) DeepCopy() any {
	_copy := b.CreateLightingDataOffBuilder().(*_LightingDataOffBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateLightingDataOffBuilder creates a LightingDataOffBuilder
func (b *_LightingDataOff) CreateLightingDataOffBuilder() LightingDataOffBuilder {
	if b == nil {
		return NewLightingDataOffBuilder()
	}
	return &_LightingDataOffBuilder{_LightingDataOff: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_LightingDataOff) GetParent() LightingDataContract {
	return m.LightingDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_LightingDataOff) GetGroup() byte {
	return m.Group
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastLightingDataOff(structType any) LightingDataOff {
	if casted, ok := structType.(LightingDataOff); ok {
		return casted
	}
	if casted, ok := structType.(*LightingDataOff); ok {
		return *casted
	}
	return nil
}

func (m *_LightingDataOff) GetTypeName() string {
	return "LightingDataOff"
}

func (m *_LightingDataOff) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.LightingDataContract.(*_LightingData).getLengthInBits(ctx))

	// Simple field (group)
	lengthInBits += 8

	return lengthInBits
}

func (m *_LightingDataOff) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_LightingDataOff) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_LightingData) (__lightingDataOff LightingDataOff, err error) {
	m.LightingDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LightingDataOff"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LightingDataOff")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	group, err := ReadSimpleField(ctx, "group", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'group' field"))
	}
	m.Group = group

	if closeErr := readBuffer.CloseContext("LightingDataOff"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LightingDataOff")
	}

	return m, nil
}

func (m *_LightingDataOff) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LightingDataOff) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LightingDataOff"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for LightingDataOff")
		}

		if err := WriteSimpleField[byte](ctx, "group", m.GetGroup(), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'group' field")
		}

		if popErr := writeBuffer.PopContext("LightingDataOff"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for LightingDataOff")
		}
		return nil
	}
	return m.LightingDataContract.(*_LightingData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_LightingDataOff) IsLightingDataOff() {}

func (m *_LightingDataOff) DeepCopy() any {
	return m.deepCopy()
}

func (m *_LightingDataOff) deepCopy() *_LightingDataOff {
	if m == nil {
		return nil
	}
	_LightingDataOffCopy := &_LightingDataOff{
		m.LightingDataContract.(*_LightingData).deepCopy(),
		m.Group,
	}
	_LightingDataOffCopy.LightingDataContract.(*_LightingData)._SubType = m
	return _LightingDataOffCopy
}

func (m *_LightingDataOff) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
