/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// InterfaceOptions1 is the corresponding interface of InterfaceOptions1
type InterfaceOptions1 interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetIdmon returns Idmon (property field)
	GetIdmon() bool
	// GetMonitor returns Monitor (property field)
	GetMonitor() bool
	// GetSmart returns Smart (property field)
	GetSmart() bool
	// GetSrchk returns Srchk (property field)
	GetSrchk() bool
	// GetXonXoff returns XonXoff (property field)
	GetXonXoff() bool
	// GetConnect returns Connect (property field)
	GetConnect() bool
	// IsInterfaceOptions1 is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsInterfaceOptions1()
	// CreateBuilder creates a InterfaceOptions1Builder
	CreateInterfaceOptions1Builder() InterfaceOptions1Builder
}

// _InterfaceOptions1 is the data-structure of this message
type _InterfaceOptions1 struct {
	Idmon   bool
	Monitor bool
	Smart   bool
	Srchk   bool
	XonXoff bool
	Connect bool
	// Reserved Fields
	reservedField0 *bool
	reservedField1 *bool
}

var _ InterfaceOptions1 = (*_InterfaceOptions1)(nil)

// NewInterfaceOptions1 factory function for _InterfaceOptions1
func NewInterfaceOptions1(idmon bool, monitor bool, smart bool, srchk bool, xonXoff bool, connect bool) *_InterfaceOptions1 {
	return &_InterfaceOptions1{Idmon: idmon, Monitor: monitor, Smart: smart, Srchk: srchk, XonXoff: xonXoff, Connect: connect}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// InterfaceOptions1Builder is a builder for InterfaceOptions1
type InterfaceOptions1Builder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(idmon bool, monitor bool, smart bool, srchk bool, xonXoff bool, connect bool) InterfaceOptions1Builder
	// WithIdmon adds Idmon (property field)
	WithIdmon(bool) InterfaceOptions1Builder
	// WithMonitor adds Monitor (property field)
	WithMonitor(bool) InterfaceOptions1Builder
	// WithSmart adds Smart (property field)
	WithSmart(bool) InterfaceOptions1Builder
	// WithSrchk adds Srchk (property field)
	WithSrchk(bool) InterfaceOptions1Builder
	// WithXonXoff adds XonXoff (property field)
	WithXonXoff(bool) InterfaceOptions1Builder
	// WithConnect adds Connect (property field)
	WithConnect(bool) InterfaceOptions1Builder
	// Build builds the InterfaceOptions1 or returns an error if something is wrong
	Build() (InterfaceOptions1, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() InterfaceOptions1
}

// NewInterfaceOptions1Builder() creates a InterfaceOptions1Builder
func NewInterfaceOptions1Builder() InterfaceOptions1Builder {
	return &_InterfaceOptions1Builder{_InterfaceOptions1: new(_InterfaceOptions1)}
}

type _InterfaceOptions1Builder struct {
	*_InterfaceOptions1

	err *utils.MultiError
}

var _ (InterfaceOptions1Builder) = (*_InterfaceOptions1Builder)(nil)

func (b *_InterfaceOptions1Builder) WithMandatoryFields(idmon bool, monitor bool, smart bool, srchk bool, xonXoff bool, connect bool) InterfaceOptions1Builder {
	return b.WithIdmon(idmon).WithMonitor(monitor).WithSmart(smart).WithSrchk(srchk).WithXonXoff(xonXoff).WithConnect(connect)
}

func (b *_InterfaceOptions1Builder) WithIdmon(idmon bool) InterfaceOptions1Builder {
	b.Idmon = idmon
	return b
}

func (b *_InterfaceOptions1Builder) WithMonitor(monitor bool) InterfaceOptions1Builder {
	b.Monitor = monitor
	return b
}

func (b *_InterfaceOptions1Builder) WithSmart(smart bool) InterfaceOptions1Builder {
	b.Smart = smart
	return b
}

func (b *_InterfaceOptions1Builder) WithSrchk(srchk bool) InterfaceOptions1Builder {
	b.Srchk = srchk
	return b
}

func (b *_InterfaceOptions1Builder) WithXonXoff(xonXoff bool) InterfaceOptions1Builder {
	b.XonXoff = xonXoff
	return b
}

func (b *_InterfaceOptions1Builder) WithConnect(connect bool) InterfaceOptions1Builder {
	b.Connect = connect
	return b
}

func (b *_InterfaceOptions1Builder) Build() (InterfaceOptions1, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._InterfaceOptions1.deepCopy(), nil
}

func (b *_InterfaceOptions1Builder) MustBuild() InterfaceOptions1 {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_InterfaceOptions1Builder) DeepCopy() any {
	_copy := b.CreateInterfaceOptions1Builder().(*_InterfaceOptions1Builder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateInterfaceOptions1Builder creates a InterfaceOptions1Builder
func (b *_InterfaceOptions1) CreateInterfaceOptions1Builder() InterfaceOptions1Builder {
	if b == nil {
		return NewInterfaceOptions1Builder()
	}
	return &_InterfaceOptions1Builder{_InterfaceOptions1: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_InterfaceOptions1) GetIdmon() bool {
	return m.Idmon
}

func (m *_InterfaceOptions1) GetMonitor() bool {
	return m.Monitor
}

func (m *_InterfaceOptions1) GetSmart() bool {
	return m.Smart
}

func (m *_InterfaceOptions1) GetSrchk() bool {
	return m.Srchk
}

func (m *_InterfaceOptions1) GetXonXoff() bool {
	return m.XonXoff
}

func (m *_InterfaceOptions1) GetConnect() bool {
	return m.Connect
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastInterfaceOptions1(structType any) InterfaceOptions1 {
	if casted, ok := structType.(InterfaceOptions1); ok {
		return casted
	}
	if casted, ok := structType.(*InterfaceOptions1); ok {
		return *casted
	}
	return nil
}

func (m *_InterfaceOptions1) GetTypeName() string {
	return "InterfaceOptions1"
}

func (m *_InterfaceOptions1) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Reserved Field (reserved)
	lengthInBits += 1

	// Simple field (idmon)
	lengthInBits += 1

	// Simple field (monitor)
	lengthInBits += 1

	// Simple field (smart)
	lengthInBits += 1

	// Simple field (srchk)
	lengthInBits += 1

	// Simple field (xonXoff)
	lengthInBits += 1

	// Reserved Field (reserved)
	lengthInBits += 1

	// Simple field (connect)
	lengthInBits += 1

	return lengthInBits
}

func (m *_InterfaceOptions1) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func InterfaceOptions1Parse(ctx context.Context, theBytes []byte) (InterfaceOptions1, error) {
	return InterfaceOptions1ParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func InterfaceOptions1ParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (InterfaceOptions1, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (InterfaceOptions1, error) {
		return InterfaceOptions1ParseWithBuffer(ctx, readBuffer)
	}
}

func InterfaceOptions1ParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (InterfaceOptions1, error) {
	v, err := (&_InterfaceOptions1{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_InterfaceOptions1) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__interfaceOptions1 InterfaceOptions1, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("InterfaceOptions1"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for InterfaceOptions1")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadBoolean(readBuffer), bool(false))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	idmon, err := ReadSimpleField(ctx, "idmon", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'idmon' field"))
	}
	m.Idmon = idmon

	monitor, err := ReadSimpleField(ctx, "monitor", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'monitor' field"))
	}
	m.Monitor = monitor

	smart, err := ReadSimpleField(ctx, "smart", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'smart' field"))
	}
	m.Smart = smart

	srchk, err := ReadSimpleField(ctx, "srchk", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'srchk' field"))
	}
	m.Srchk = srchk

	xonXoff, err := ReadSimpleField(ctx, "xonXoff", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'xonXoff' field"))
	}
	m.XonXoff = xonXoff

	reservedField1, err := ReadReservedField(ctx, "reserved", ReadBoolean(readBuffer), bool(false))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField1 = reservedField1

	connect, err := ReadSimpleField(ctx, "connect", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'connect' field"))
	}
	m.Connect = connect

	if closeErr := readBuffer.CloseContext("InterfaceOptions1"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for InterfaceOptions1")
	}

	return m, nil
}

func (m *_InterfaceOptions1) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_InterfaceOptions1) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("InterfaceOptions1"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for InterfaceOptions1")
	}

	if err := WriteReservedField[bool](ctx, "reserved", bool(false), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 1")
	}

	if err := WriteSimpleField[bool](ctx, "idmon", m.GetIdmon(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'idmon' field")
	}

	if err := WriteSimpleField[bool](ctx, "monitor", m.GetMonitor(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'monitor' field")
	}

	if err := WriteSimpleField[bool](ctx, "smart", m.GetSmart(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'smart' field")
	}

	if err := WriteSimpleField[bool](ctx, "srchk", m.GetSrchk(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'srchk' field")
	}

	if err := WriteSimpleField[bool](ctx, "xonXoff", m.GetXonXoff(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'xonXoff' field")
	}

	if err := WriteReservedField[bool](ctx, "reserved", bool(false), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'reserved' field number 2")
	}

	if err := WriteSimpleField[bool](ctx, "connect", m.GetConnect(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'connect' field")
	}

	if popErr := writeBuffer.PopContext("InterfaceOptions1"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for InterfaceOptions1")
	}
	return nil
}

func (m *_InterfaceOptions1) IsInterfaceOptions1() {}

func (m *_InterfaceOptions1) DeepCopy() any {
	return m.deepCopy()
}

func (m *_InterfaceOptions1) deepCopy() *_InterfaceOptions1 {
	if m == nil {
		return nil
	}
	_InterfaceOptions1Copy := &_InterfaceOptions1{
		m.Idmon,
		m.Monitor,
		m.Smart,
		m.Srchk,
		m.XonXoff,
		m.Connect,
		m.reservedField0,
		m.reservedField1,
	}
	return _InterfaceOptions1Copy
}

func (m *_InterfaceOptions1) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
