/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const IdentifyReplyCommandNetworkVoltage_DOT byte = 0x2C
const IdentifyReplyCommandNetworkVoltage_V byte = 0x56

// IdentifyReplyCommandNetworkVoltage is the corresponding interface of IdentifyReplyCommandNetworkVoltage
type IdentifyReplyCommandNetworkVoltage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	IdentifyReplyCommand
	// GetVolts returns Volts (property field)
	GetVolts() string
	// GetVoltsDecimalPlace returns VoltsDecimalPlace (property field)
	GetVoltsDecimalPlace() string
	// IsIdentifyReplyCommandNetworkVoltage is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsIdentifyReplyCommandNetworkVoltage()
	// CreateBuilder creates a IdentifyReplyCommandNetworkVoltageBuilder
	CreateIdentifyReplyCommandNetworkVoltageBuilder() IdentifyReplyCommandNetworkVoltageBuilder
}

// _IdentifyReplyCommandNetworkVoltage is the data-structure of this message
type _IdentifyReplyCommandNetworkVoltage struct {
	IdentifyReplyCommandContract
	Volts             string
	VoltsDecimalPlace string
}

var _ IdentifyReplyCommandNetworkVoltage = (*_IdentifyReplyCommandNetworkVoltage)(nil)
var _ IdentifyReplyCommandRequirements = (*_IdentifyReplyCommandNetworkVoltage)(nil)

// NewIdentifyReplyCommandNetworkVoltage factory function for _IdentifyReplyCommandNetworkVoltage
func NewIdentifyReplyCommandNetworkVoltage(volts string, voltsDecimalPlace string, numBytes uint8) *_IdentifyReplyCommandNetworkVoltage {
	_result := &_IdentifyReplyCommandNetworkVoltage{
		IdentifyReplyCommandContract: NewIdentifyReplyCommand(numBytes),
		Volts:                        volts,
		VoltsDecimalPlace:            voltsDecimalPlace,
	}
	_result.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// IdentifyReplyCommandNetworkVoltageBuilder is a builder for IdentifyReplyCommandNetworkVoltage
type IdentifyReplyCommandNetworkVoltageBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(volts string, voltsDecimalPlace string) IdentifyReplyCommandNetworkVoltageBuilder
	// WithVolts adds Volts (property field)
	WithVolts(string) IdentifyReplyCommandNetworkVoltageBuilder
	// WithVoltsDecimalPlace adds VoltsDecimalPlace (property field)
	WithVoltsDecimalPlace(string) IdentifyReplyCommandNetworkVoltageBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() IdentifyReplyCommandBuilder
	// Build builds the IdentifyReplyCommandNetworkVoltage or returns an error if something is wrong
	Build() (IdentifyReplyCommandNetworkVoltage, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() IdentifyReplyCommandNetworkVoltage
}

// NewIdentifyReplyCommandNetworkVoltageBuilder() creates a IdentifyReplyCommandNetworkVoltageBuilder
func NewIdentifyReplyCommandNetworkVoltageBuilder() IdentifyReplyCommandNetworkVoltageBuilder {
	return &_IdentifyReplyCommandNetworkVoltageBuilder{_IdentifyReplyCommandNetworkVoltage: new(_IdentifyReplyCommandNetworkVoltage)}
}

type _IdentifyReplyCommandNetworkVoltageBuilder struct {
	*_IdentifyReplyCommandNetworkVoltage

	parentBuilder *_IdentifyReplyCommandBuilder

	err *utils.MultiError
}

var _ (IdentifyReplyCommandNetworkVoltageBuilder) = (*_IdentifyReplyCommandNetworkVoltageBuilder)(nil)

func (b *_IdentifyReplyCommandNetworkVoltageBuilder) setParent(contract IdentifyReplyCommandContract) {
	b.IdentifyReplyCommandContract = contract
	contract.(*_IdentifyReplyCommand)._SubType = b._IdentifyReplyCommandNetworkVoltage
}

func (b *_IdentifyReplyCommandNetworkVoltageBuilder) WithMandatoryFields(volts string, voltsDecimalPlace string) IdentifyReplyCommandNetworkVoltageBuilder {
	return b.WithVolts(volts).WithVoltsDecimalPlace(voltsDecimalPlace)
}

func (b *_IdentifyReplyCommandNetworkVoltageBuilder) WithVolts(volts string) IdentifyReplyCommandNetworkVoltageBuilder {
	b.Volts = volts
	return b
}

func (b *_IdentifyReplyCommandNetworkVoltageBuilder) WithVoltsDecimalPlace(voltsDecimalPlace string) IdentifyReplyCommandNetworkVoltageBuilder {
	b.VoltsDecimalPlace = voltsDecimalPlace
	return b
}

func (b *_IdentifyReplyCommandNetworkVoltageBuilder) Build() (IdentifyReplyCommandNetworkVoltage, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._IdentifyReplyCommandNetworkVoltage.deepCopy(), nil
}

func (b *_IdentifyReplyCommandNetworkVoltageBuilder) MustBuild() IdentifyReplyCommandNetworkVoltage {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_IdentifyReplyCommandNetworkVoltageBuilder) Done() IdentifyReplyCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewIdentifyReplyCommandBuilder().(*_IdentifyReplyCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_IdentifyReplyCommandNetworkVoltageBuilder) buildForIdentifyReplyCommand() (IdentifyReplyCommand, error) {
	return b.Build()
}

func (b *_IdentifyReplyCommandNetworkVoltageBuilder) DeepCopy() any {
	_copy := b.CreateIdentifyReplyCommandNetworkVoltageBuilder().(*_IdentifyReplyCommandNetworkVoltageBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateIdentifyReplyCommandNetworkVoltageBuilder creates a IdentifyReplyCommandNetworkVoltageBuilder
func (b *_IdentifyReplyCommandNetworkVoltage) CreateIdentifyReplyCommandNetworkVoltageBuilder() IdentifyReplyCommandNetworkVoltageBuilder {
	if b == nil {
		return NewIdentifyReplyCommandNetworkVoltageBuilder()
	}
	return &_IdentifyReplyCommandNetworkVoltageBuilder{_IdentifyReplyCommandNetworkVoltage: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_IdentifyReplyCommandNetworkVoltage) GetAttribute() Attribute {
	return Attribute_NetworkVoltage
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_IdentifyReplyCommandNetworkVoltage) GetParent() IdentifyReplyCommandContract {
	return m.IdentifyReplyCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_IdentifyReplyCommandNetworkVoltage) GetVolts() string {
	return m.Volts
}

func (m *_IdentifyReplyCommandNetworkVoltage) GetVoltsDecimalPlace() string {
	return m.VoltsDecimalPlace
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_IdentifyReplyCommandNetworkVoltage) GetDot() byte {
	return IdentifyReplyCommandNetworkVoltage_DOT
}

func (m *_IdentifyReplyCommandNetworkVoltage) GetV() byte {
	return IdentifyReplyCommandNetworkVoltage_V
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastIdentifyReplyCommandNetworkVoltage(structType any) IdentifyReplyCommandNetworkVoltage {
	if casted, ok := structType.(IdentifyReplyCommandNetworkVoltage); ok {
		return casted
	}
	if casted, ok := structType.(*IdentifyReplyCommandNetworkVoltage); ok {
		return *casted
	}
	return nil
}

func (m *_IdentifyReplyCommandNetworkVoltage) GetTypeName() string {
	return "IdentifyReplyCommandNetworkVoltage"
}

func (m *_IdentifyReplyCommandNetworkVoltage) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).getLengthInBits(ctx))

	// Simple field (volts)
	lengthInBits += 16

	// Const Field (dot)
	lengthInBits += 8

	// Simple field (voltsDecimalPlace)
	lengthInBits += 16

	// Const Field (v)
	lengthInBits += 8

	return lengthInBits
}

func (m *_IdentifyReplyCommandNetworkVoltage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_IdentifyReplyCommandNetworkVoltage) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_IdentifyReplyCommand, attribute Attribute, numBytes uint8) (__identifyReplyCommandNetworkVoltage IdentifyReplyCommandNetworkVoltage, err error) {
	m.IdentifyReplyCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("IdentifyReplyCommandNetworkVoltage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for IdentifyReplyCommandNetworkVoltage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	volts, err := ReadSimpleField(ctx, "volts", ReadString(readBuffer, uint32(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'volts' field"))
	}
	m.Volts = volts

	dot, err := ReadConstField[byte](ctx, "dot", ReadByte(readBuffer, 8), IdentifyReplyCommandNetworkVoltage_DOT)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dot' field"))
	}
	_ = dot

	voltsDecimalPlace, err := ReadSimpleField(ctx, "voltsDecimalPlace", ReadString(readBuffer, uint32(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'voltsDecimalPlace' field"))
	}
	m.VoltsDecimalPlace = voltsDecimalPlace

	v, err := ReadConstField[byte](ctx, "v", ReadByte(readBuffer, 8), IdentifyReplyCommandNetworkVoltage_V)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'v' field"))
	}
	_ = v

	if closeErr := readBuffer.CloseContext("IdentifyReplyCommandNetworkVoltage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for IdentifyReplyCommandNetworkVoltage")
	}

	return m, nil
}

func (m *_IdentifyReplyCommandNetworkVoltage) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_IdentifyReplyCommandNetworkVoltage) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("IdentifyReplyCommandNetworkVoltage"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for IdentifyReplyCommandNetworkVoltage")
		}

		if err := WriteSimpleField[string](ctx, "volts", m.GetVolts(), WriteString(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'volts' field")
		}

		if err := WriteConstField(ctx, "dot", IdentifyReplyCommandNetworkVoltage_DOT, WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'dot' field")
		}

		if err := WriteSimpleField[string](ctx, "voltsDecimalPlace", m.GetVoltsDecimalPlace(), WriteString(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'voltsDecimalPlace' field")
		}

		if err := WriteConstField(ctx, "v", IdentifyReplyCommandNetworkVoltage_V, WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'v' field")
		}

		if popErr := writeBuffer.PopContext("IdentifyReplyCommandNetworkVoltage"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for IdentifyReplyCommandNetworkVoltage")
		}
		return nil
	}
	return m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_IdentifyReplyCommandNetworkVoltage) IsIdentifyReplyCommandNetworkVoltage() {}

func (m *_IdentifyReplyCommandNetworkVoltage) DeepCopy() any {
	return m.deepCopy()
}

func (m *_IdentifyReplyCommandNetworkVoltage) deepCopy() *_IdentifyReplyCommandNetworkVoltage {
	if m == nil {
		return nil
	}
	_IdentifyReplyCommandNetworkVoltageCopy := &_IdentifyReplyCommandNetworkVoltage{
		m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).deepCopy(),
		m.Volts,
		m.VoltsDecimalPlace,
	}
	_IdentifyReplyCommandNetworkVoltageCopy.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = m
	return _IdentifyReplyCommandNetworkVoltageCopy
}

func (m *_IdentifyReplyCommandNetworkVoltage) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
