/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// IdentifyReplyCommandCurrentSenseLevels is the corresponding interface of IdentifyReplyCommandCurrentSenseLevels
type IdentifyReplyCommandCurrentSenseLevels interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	IdentifyReplyCommand
	// GetCurrentSenseLevels returns CurrentSenseLevels (property field)
	GetCurrentSenseLevels() []byte
	// IsIdentifyReplyCommandCurrentSenseLevels is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsIdentifyReplyCommandCurrentSenseLevels()
	// CreateBuilder creates a IdentifyReplyCommandCurrentSenseLevelsBuilder
	CreateIdentifyReplyCommandCurrentSenseLevelsBuilder() IdentifyReplyCommandCurrentSenseLevelsBuilder
}

// _IdentifyReplyCommandCurrentSenseLevels is the data-structure of this message
type _IdentifyReplyCommandCurrentSenseLevels struct {
	IdentifyReplyCommandContract
	CurrentSenseLevels []byte
}

var _ IdentifyReplyCommandCurrentSenseLevels = (*_IdentifyReplyCommandCurrentSenseLevels)(nil)
var _ IdentifyReplyCommandRequirements = (*_IdentifyReplyCommandCurrentSenseLevels)(nil)

// NewIdentifyReplyCommandCurrentSenseLevels factory function for _IdentifyReplyCommandCurrentSenseLevels
func NewIdentifyReplyCommandCurrentSenseLevels(currentSenseLevels []byte, numBytes uint8) *_IdentifyReplyCommandCurrentSenseLevels {
	_result := &_IdentifyReplyCommandCurrentSenseLevels{
		IdentifyReplyCommandContract: NewIdentifyReplyCommand(numBytes),
		CurrentSenseLevels:           currentSenseLevels,
	}
	_result.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// IdentifyReplyCommandCurrentSenseLevelsBuilder is a builder for IdentifyReplyCommandCurrentSenseLevels
type IdentifyReplyCommandCurrentSenseLevelsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(currentSenseLevels []byte) IdentifyReplyCommandCurrentSenseLevelsBuilder
	// WithCurrentSenseLevels adds CurrentSenseLevels (property field)
	WithCurrentSenseLevels(...byte) IdentifyReplyCommandCurrentSenseLevelsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() IdentifyReplyCommandBuilder
	// Build builds the IdentifyReplyCommandCurrentSenseLevels or returns an error if something is wrong
	Build() (IdentifyReplyCommandCurrentSenseLevels, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() IdentifyReplyCommandCurrentSenseLevels
}

// NewIdentifyReplyCommandCurrentSenseLevelsBuilder() creates a IdentifyReplyCommandCurrentSenseLevelsBuilder
func NewIdentifyReplyCommandCurrentSenseLevelsBuilder() IdentifyReplyCommandCurrentSenseLevelsBuilder {
	return &_IdentifyReplyCommandCurrentSenseLevelsBuilder{_IdentifyReplyCommandCurrentSenseLevels: new(_IdentifyReplyCommandCurrentSenseLevels)}
}

type _IdentifyReplyCommandCurrentSenseLevelsBuilder struct {
	*_IdentifyReplyCommandCurrentSenseLevels

	parentBuilder *_IdentifyReplyCommandBuilder

	err *utils.MultiError
}

var _ (IdentifyReplyCommandCurrentSenseLevelsBuilder) = (*_IdentifyReplyCommandCurrentSenseLevelsBuilder)(nil)

func (b *_IdentifyReplyCommandCurrentSenseLevelsBuilder) setParent(contract IdentifyReplyCommandContract) {
	b.IdentifyReplyCommandContract = contract
	contract.(*_IdentifyReplyCommand)._SubType = b._IdentifyReplyCommandCurrentSenseLevels
}

func (b *_IdentifyReplyCommandCurrentSenseLevelsBuilder) WithMandatoryFields(currentSenseLevels []byte) IdentifyReplyCommandCurrentSenseLevelsBuilder {
	return b.WithCurrentSenseLevels(currentSenseLevels...)
}

func (b *_IdentifyReplyCommandCurrentSenseLevelsBuilder) WithCurrentSenseLevels(currentSenseLevels ...byte) IdentifyReplyCommandCurrentSenseLevelsBuilder {
	b.CurrentSenseLevels = currentSenseLevels
	return b
}

func (b *_IdentifyReplyCommandCurrentSenseLevelsBuilder) Build() (IdentifyReplyCommandCurrentSenseLevels, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._IdentifyReplyCommandCurrentSenseLevels.deepCopy(), nil
}

func (b *_IdentifyReplyCommandCurrentSenseLevelsBuilder) MustBuild() IdentifyReplyCommandCurrentSenseLevels {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_IdentifyReplyCommandCurrentSenseLevelsBuilder) Done() IdentifyReplyCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewIdentifyReplyCommandBuilder().(*_IdentifyReplyCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_IdentifyReplyCommandCurrentSenseLevelsBuilder) buildForIdentifyReplyCommand() (IdentifyReplyCommand, error) {
	return b.Build()
}

func (b *_IdentifyReplyCommandCurrentSenseLevelsBuilder) DeepCopy() any {
	_copy := b.CreateIdentifyReplyCommandCurrentSenseLevelsBuilder().(*_IdentifyReplyCommandCurrentSenseLevelsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateIdentifyReplyCommandCurrentSenseLevelsBuilder creates a IdentifyReplyCommandCurrentSenseLevelsBuilder
func (b *_IdentifyReplyCommandCurrentSenseLevels) CreateIdentifyReplyCommandCurrentSenseLevelsBuilder() IdentifyReplyCommandCurrentSenseLevelsBuilder {
	if b == nil {
		return NewIdentifyReplyCommandCurrentSenseLevelsBuilder()
	}
	return &_IdentifyReplyCommandCurrentSenseLevelsBuilder{_IdentifyReplyCommandCurrentSenseLevels: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_IdentifyReplyCommandCurrentSenseLevels) GetAttribute() Attribute {
	return Attribute_CurrentSenseLevels
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_IdentifyReplyCommandCurrentSenseLevels) GetParent() IdentifyReplyCommandContract {
	return m.IdentifyReplyCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_IdentifyReplyCommandCurrentSenseLevels) GetCurrentSenseLevels() []byte {
	return m.CurrentSenseLevels
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastIdentifyReplyCommandCurrentSenseLevels(structType any) IdentifyReplyCommandCurrentSenseLevels {
	if casted, ok := structType.(IdentifyReplyCommandCurrentSenseLevels); ok {
		return casted
	}
	if casted, ok := structType.(*IdentifyReplyCommandCurrentSenseLevels); ok {
		return *casted
	}
	return nil
}

func (m *_IdentifyReplyCommandCurrentSenseLevels) GetTypeName() string {
	return "IdentifyReplyCommandCurrentSenseLevels"
}

func (m *_IdentifyReplyCommandCurrentSenseLevels) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).getLengthInBits(ctx))

	// Array field
	if len(m.CurrentSenseLevels) > 0 {
		lengthInBits += 8 * uint16(len(m.CurrentSenseLevels))
	}

	return lengthInBits
}

func (m *_IdentifyReplyCommandCurrentSenseLevels) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_IdentifyReplyCommandCurrentSenseLevels) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_IdentifyReplyCommand, attribute Attribute, numBytes uint8) (__identifyReplyCommandCurrentSenseLevels IdentifyReplyCommandCurrentSenseLevels, err error) {
	m.IdentifyReplyCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("IdentifyReplyCommandCurrentSenseLevels"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for IdentifyReplyCommandCurrentSenseLevels")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	currentSenseLevels, err := readBuffer.ReadByteArray("currentSenseLevels", int(numBytes))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'currentSenseLevels' field"))
	}
	m.CurrentSenseLevels = currentSenseLevels

	if closeErr := readBuffer.CloseContext("IdentifyReplyCommandCurrentSenseLevels"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for IdentifyReplyCommandCurrentSenseLevels")
	}

	return m, nil
}

func (m *_IdentifyReplyCommandCurrentSenseLevels) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_IdentifyReplyCommandCurrentSenseLevels) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("IdentifyReplyCommandCurrentSenseLevels"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for IdentifyReplyCommandCurrentSenseLevels")
		}

		if err := WriteByteArrayField(ctx, "currentSenseLevels", m.GetCurrentSenseLevels(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'currentSenseLevels' field")
		}

		if popErr := writeBuffer.PopContext("IdentifyReplyCommandCurrentSenseLevels"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for IdentifyReplyCommandCurrentSenseLevels")
		}
		return nil
	}
	return m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_IdentifyReplyCommandCurrentSenseLevels) IsIdentifyReplyCommandCurrentSenseLevels() {}

func (m *_IdentifyReplyCommandCurrentSenseLevels) DeepCopy() any {
	return m.deepCopy()
}

func (m *_IdentifyReplyCommandCurrentSenseLevels) deepCopy() *_IdentifyReplyCommandCurrentSenseLevels {
	if m == nil {
		return nil
	}
	_IdentifyReplyCommandCurrentSenseLevelsCopy := &_IdentifyReplyCommandCurrentSenseLevels{
		m.IdentifyReplyCommandContract.(*_IdentifyReplyCommand).deepCopy(),
		utils.DeepCopySlice[byte, byte](m.CurrentSenseLevels),
	}
	_IdentifyReplyCommandCurrentSenseLevelsCopy.IdentifyReplyCommandContract.(*_IdentifyReplyCommand)._SubType = m
	return _IdentifyReplyCommandCurrentSenseLevelsCopy
}

func (m *_IdentifyReplyCommandCurrentSenseLevels) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
