/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Checksum is the corresponding interface of Checksum
type Checksum interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetValue returns Value (property field)
	GetValue() byte
	// IsChecksum is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsChecksum()
	// CreateBuilder creates a ChecksumBuilder
	CreateChecksumBuilder() ChecksumBuilder
}

// _Checksum is the data-structure of this message
type _Checksum struct {
	Value byte
}

var _ Checksum = (*_Checksum)(nil)

// NewChecksum factory function for _Checksum
func NewChecksum(value byte) *_Checksum {
	return &_Checksum{Value: value}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ChecksumBuilder is a builder for Checksum
type ChecksumBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(value byte) ChecksumBuilder
	// WithValue adds Value (property field)
	WithValue(byte) ChecksumBuilder
	// Build builds the Checksum or returns an error if something is wrong
	Build() (Checksum, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() Checksum
}

// NewChecksumBuilder() creates a ChecksumBuilder
func NewChecksumBuilder() ChecksumBuilder {
	return &_ChecksumBuilder{_Checksum: new(_Checksum)}
}

type _ChecksumBuilder struct {
	*_Checksum

	err *utils.MultiError
}

var _ (ChecksumBuilder) = (*_ChecksumBuilder)(nil)

func (b *_ChecksumBuilder) WithMandatoryFields(value byte) ChecksumBuilder {
	return b.WithValue(value)
}

func (b *_ChecksumBuilder) WithValue(value byte) ChecksumBuilder {
	b.Value = value
	return b
}

func (b *_ChecksumBuilder) Build() (Checksum, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._Checksum.deepCopy(), nil
}

func (b *_ChecksumBuilder) MustBuild() Checksum {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ChecksumBuilder) DeepCopy() any {
	_copy := b.CreateChecksumBuilder().(*_ChecksumBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateChecksumBuilder creates a ChecksumBuilder
func (b *_Checksum) CreateChecksumBuilder() ChecksumBuilder {
	if b == nil {
		return NewChecksumBuilder()
	}
	return &_ChecksumBuilder{_Checksum: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_Checksum) GetValue() byte {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastChecksum(structType any) Checksum {
	if casted, ok := structType.(Checksum); ok {
		return casted
	}
	if casted, ok := structType.(*Checksum); ok {
		return *casted
	}
	return nil
}

func (m *_Checksum) GetTypeName() string {
	return "Checksum"
}

func (m *_Checksum) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (value)
	lengthInBits += 8

	return lengthInBits
}

func (m *_Checksum) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ChecksumParse(ctx context.Context, theBytes []byte) (Checksum, error) {
	return ChecksumParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ChecksumParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (Checksum, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (Checksum, error) {
		return ChecksumParseWithBuffer(ctx, readBuffer)
	}
}

func ChecksumParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (Checksum, error) {
	v, err := (&_Checksum{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_Checksum) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__checksum Checksum, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("Checksum"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for Checksum")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	value, err := ReadSimpleField(ctx, "value", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("Checksum"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for Checksum")
	}

	return m, nil
}

func (m *_Checksum) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_Checksum) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("Checksum"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for Checksum")
	}

	if err := WriteSimpleField[byte](ctx, "value", m.GetValue(), WriteByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("Checksum"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for Checksum")
	}
	return nil
}

func (m *_Checksum) IsChecksum() {}

func (m *_Checksum) DeepCopy() any {
	return m.deepCopy()
}

func (m *_Checksum) deepCopy() *_Checksum {
	if m == nil {
		return nil
	}
	_ChecksumCopy := &_Checksum{
		m.Value,
	}
	return _ChecksumCopy
}

func (m *_Checksum) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
