/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CBusCommandPointToPoint is the corresponding interface of CBusCommandPointToPoint
type CBusCommandPointToPoint interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CBusCommand
	// GetCommand returns Command (property field)
	GetCommand() CBusPointToPointCommand
	// IsCBusCommandPointToPoint is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCBusCommandPointToPoint()
	// CreateBuilder creates a CBusCommandPointToPointBuilder
	CreateCBusCommandPointToPointBuilder() CBusCommandPointToPointBuilder
}

// _CBusCommandPointToPoint is the data-structure of this message
type _CBusCommandPointToPoint struct {
	CBusCommandContract
	Command CBusPointToPointCommand
}

var _ CBusCommandPointToPoint = (*_CBusCommandPointToPoint)(nil)
var _ CBusCommandRequirements = (*_CBusCommandPointToPoint)(nil)

// NewCBusCommandPointToPoint factory function for _CBusCommandPointToPoint
func NewCBusCommandPointToPoint(header CBusHeader, command CBusPointToPointCommand, cBusOptions CBusOptions) *_CBusCommandPointToPoint {
	if command == nil {
		panic("command of type CBusPointToPointCommand for CBusCommandPointToPoint must not be nil")
	}
	_result := &_CBusCommandPointToPoint{
		CBusCommandContract: NewCBusCommand(header, cBusOptions),
		Command:             command,
	}
	_result.CBusCommandContract.(*_CBusCommand)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CBusCommandPointToPointBuilder is a builder for CBusCommandPointToPoint
type CBusCommandPointToPointBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(command CBusPointToPointCommand) CBusCommandPointToPointBuilder
	// WithCommand adds Command (property field)
	WithCommand(CBusPointToPointCommand) CBusCommandPointToPointBuilder
	// WithCommandBuilder adds Command (property field) which is build by the builder
	WithCommandBuilder(func(CBusPointToPointCommandBuilder) CBusPointToPointCommandBuilder) CBusCommandPointToPointBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CBusCommandBuilder
	// Build builds the CBusCommandPointToPoint or returns an error if something is wrong
	Build() (CBusCommandPointToPoint, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CBusCommandPointToPoint
}

// NewCBusCommandPointToPointBuilder() creates a CBusCommandPointToPointBuilder
func NewCBusCommandPointToPointBuilder() CBusCommandPointToPointBuilder {
	return &_CBusCommandPointToPointBuilder{_CBusCommandPointToPoint: new(_CBusCommandPointToPoint)}
}

type _CBusCommandPointToPointBuilder struct {
	*_CBusCommandPointToPoint

	parentBuilder *_CBusCommandBuilder

	err *utils.MultiError
}

var _ (CBusCommandPointToPointBuilder) = (*_CBusCommandPointToPointBuilder)(nil)

func (b *_CBusCommandPointToPointBuilder) setParent(contract CBusCommandContract) {
	b.CBusCommandContract = contract
	contract.(*_CBusCommand)._SubType = b._CBusCommandPointToPoint
}

func (b *_CBusCommandPointToPointBuilder) WithMandatoryFields(command CBusPointToPointCommand) CBusCommandPointToPointBuilder {
	return b.WithCommand(command)
}

func (b *_CBusCommandPointToPointBuilder) WithCommand(command CBusPointToPointCommand) CBusCommandPointToPointBuilder {
	b.Command = command
	return b
}

func (b *_CBusCommandPointToPointBuilder) WithCommandBuilder(builderSupplier func(CBusPointToPointCommandBuilder) CBusPointToPointCommandBuilder) CBusCommandPointToPointBuilder {
	builder := builderSupplier(b.Command.CreateCBusPointToPointCommandBuilder())
	var err error
	b.Command, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "CBusPointToPointCommandBuilder failed"))
	}
	return b
}

func (b *_CBusCommandPointToPointBuilder) Build() (CBusCommandPointToPoint, error) {
	if b.Command == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'command' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._CBusCommandPointToPoint.deepCopy(), nil
}

func (b *_CBusCommandPointToPointBuilder) MustBuild() CBusCommandPointToPoint {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CBusCommandPointToPointBuilder) Done() CBusCommandBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCBusCommandBuilder().(*_CBusCommandBuilder)
	}
	return b.parentBuilder
}

func (b *_CBusCommandPointToPointBuilder) buildForCBusCommand() (CBusCommand, error) {
	return b.Build()
}

func (b *_CBusCommandPointToPointBuilder) DeepCopy() any {
	_copy := b.CreateCBusCommandPointToPointBuilder().(*_CBusCommandPointToPointBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateCBusCommandPointToPointBuilder creates a CBusCommandPointToPointBuilder
func (b *_CBusCommandPointToPoint) CreateCBusCommandPointToPointBuilder() CBusCommandPointToPointBuilder {
	if b == nil {
		return NewCBusCommandPointToPointBuilder()
	}
	return &_CBusCommandPointToPointBuilder{_CBusCommandPointToPoint: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CBusCommandPointToPoint) GetParent() CBusCommandContract {
	return m.CBusCommandContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CBusCommandPointToPoint) GetCommand() CBusPointToPointCommand {
	return m.Command
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCBusCommandPointToPoint(structType any) CBusCommandPointToPoint {
	if casted, ok := structType.(CBusCommandPointToPoint); ok {
		return casted
	}
	if casted, ok := structType.(*CBusCommandPointToPoint); ok {
		return *casted
	}
	return nil
}

func (m *_CBusCommandPointToPoint) GetTypeName() string {
	return "CBusCommandPointToPoint"
}

func (m *_CBusCommandPointToPoint) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CBusCommandContract.(*_CBusCommand).getLengthInBits(ctx))

	// Simple field (command)
	lengthInBits += m.Command.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_CBusCommandPointToPoint) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_CBusCommandPointToPoint) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CBusCommand, cBusOptions CBusOptions) (__cBusCommandPointToPoint CBusCommandPointToPoint, err error) {
	m.CBusCommandContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CBusCommandPointToPoint"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CBusCommandPointToPoint")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	command, err := ReadSimpleField[CBusPointToPointCommand](ctx, "command", ReadComplex[CBusPointToPointCommand](CBusPointToPointCommandParseWithBufferProducer[CBusPointToPointCommand]((CBusOptions)(cBusOptions)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'command' field"))
	}
	m.Command = command

	if closeErr := readBuffer.CloseContext("CBusCommandPointToPoint"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CBusCommandPointToPoint")
	}

	return m, nil
}

func (m *_CBusCommandPointToPoint) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CBusCommandPointToPoint) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CBusCommandPointToPoint"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CBusCommandPointToPoint")
		}

		if err := WriteSimpleField[CBusPointToPointCommand](ctx, "command", m.GetCommand(), WriteComplex[CBusPointToPointCommand](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'command' field")
		}

		if popErr := writeBuffer.PopContext("CBusCommandPointToPoint"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CBusCommandPointToPoint")
		}
		return nil
	}
	return m.CBusCommandContract.(*_CBusCommand).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CBusCommandPointToPoint) IsCBusCommandPointToPoint() {}

func (m *_CBusCommandPointToPoint) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CBusCommandPointToPoint) deepCopy() *_CBusCommandPointToPoint {
	if m == nil {
		return nil
	}
	_CBusCommandPointToPointCopy := &_CBusCommandPointToPoint{
		m.CBusCommandContract.(*_CBusCommand).deepCopy(),
		utils.DeepCopy[CBusPointToPointCommand](m.Command),
	}
	_CBusCommandPointToPointCopy.CBusCommandContract.(*_CBusCommand)._SubType = m
	return _CBusCommandPointToPointCopy
}

func (m *_CBusCommandPointToPoint) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
