/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// CALDataGetStatus is the corresponding interface of CALDataGetStatus
type CALDataGetStatus interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	CALData
	// GetParamNo returns ParamNo (property field)
	GetParamNo() Parameter
	// GetCount returns Count (property field)
	GetCount() uint8
	// IsCALDataGetStatus is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsCALDataGetStatus()
	// CreateBuilder creates a CALDataGetStatusBuilder
	CreateCALDataGetStatusBuilder() CALDataGetStatusBuilder
}

// _CALDataGetStatus is the data-structure of this message
type _CALDataGetStatus struct {
	CALDataContract
	ParamNo Parameter
	Count   uint8
}

var _ CALDataGetStatus = (*_CALDataGetStatus)(nil)
var _ CALDataRequirements = (*_CALDataGetStatus)(nil)

// NewCALDataGetStatus factory function for _CALDataGetStatus
func NewCALDataGetStatus(commandTypeContainer CALCommandTypeContainer, additionalData CALData, paramNo Parameter, count uint8, requestContext RequestContext) *_CALDataGetStatus {
	_result := &_CALDataGetStatus{
		CALDataContract: NewCALData(commandTypeContainer, additionalData, requestContext),
		ParamNo:         paramNo,
		Count:           count,
	}
	_result.CALDataContract.(*_CALData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// CALDataGetStatusBuilder is a builder for CALDataGetStatus
type CALDataGetStatusBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(paramNo Parameter, count uint8) CALDataGetStatusBuilder
	// WithParamNo adds ParamNo (property field)
	WithParamNo(Parameter) CALDataGetStatusBuilder
	// WithCount adds Count (property field)
	WithCount(uint8) CALDataGetStatusBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() CALDataBuilder
	// Build builds the CALDataGetStatus or returns an error if something is wrong
	Build() (CALDataGetStatus, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() CALDataGetStatus
}

// NewCALDataGetStatusBuilder() creates a CALDataGetStatusBuilder
func NewCALDataGetStatusBuilder() CALDataGetStatusBuilder {
	return &_CALDataGetStatusBuilder{_CALDataGetStatus: new(_CALDataGetStatus)}
}

type _CALDataGetStatusBuilder struct {
	*_CALDataGetStatus

	parentBuilder *_CALDataBuilder

	err *utils.MultiError
}

var _ (CALDataGetStatusBuilder) = (*_CALDataGetStatusBuilder)(nil)

func (b *_CALDataGetStatusBuilder) setParent(contract CALDataContract) {
	b.CALDataContract = contract
	contract.(*_CALData)._SubType = b._CALDataGetStatus
}

func (b *_CALDataGetStatusBuilder) WithMandatoryFields(paramNo Parameter, count uint8) CALDataGetStatusBuilder {
	return b.WithParamNo(paramNo).WithCount(count)
}

func (b *_CALDataGetStatusBuilder) WithParamNo(paramNo Parameter) CALDataGetStatusBuilder {
	b.ParamNo = paramNo
	return b
}

func (b *_CALDataGetStatusBuilder) WithCount(count uint8) CALDataGetStatusBuilder {
	b.Count = count
	return b
}

func (b *_CALDataGetStatusBuilder) Build() (CALDataGetStatus, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._CALDataGetStatus.deepCopy(), nil
}

func (b *_CALDataGetStatusBuilder) MustBuild() CALDataGetStatus {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_CALDataGetStatusBuilder) Done() CALDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewCALDataBuilder().(*_CALDataBuilder)
	}
	return b.parentBuilder
}

func (b *_CALDataGetStatusBuilder) buildForCALData() (CALData, error) {
	return b.Build()
}

func (b *_CALDataGetStatusBuilder) DeepCopy() any {
	_copy := b.CreateCALDataGetStatusBuilder().(*_CALDataGetStatusBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateCALDataGetStatusBuilder creates a CALDataGetStatusBuilder
func (b *_CALDataGetStatus) CreateCALDataGetStatusBuilder() CALDataGetStatusBuilder {
	if b == nil {
		return NewCALDataGetStatusBuilder()
	}
	return &_CALDataGetStatusBuilder{_CALDataGetStatus: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CALDataGetStatus) GetParent() CALDataContract {
	return m.CALDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CALDataGetStatus) GetParamNo() Parameter {
	return m.ParamNo
}

func (m *_CALDataGetStatus) GetCount() uint8 {
	return m.Count
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastCALDataGetStatus(structType any) CALDataGetStatus {
	if casted, ok := structType.(CALDataGetStatus); ok {
		return casted
	}
	if casted, ok := structType.(*CALDataGetStatus); ok {
		return *casted
	}
	return nil
}

func (m *_CALDataGetStatus) GetTypeName() string {
	return "CALDataGetStatus"
}

func (m *_CALDataGetStatus) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.CALDataContract.(*_CALData).getLengthInBits(ctx))

	// Simple field (paramNo)
	lengthInBits += 8

	// Simple field (count)
	lengthInBits += 8

	return lengthInBits
}

func (m *_CALDataGetStatus) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_CALDataGetStatus) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_CALData, requestContext RequestContext) (__cALDataGetStatus CALDataGetStatus, err error) {
	m.CALDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CALDataGetStatus"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CALDataGetStatus")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	paramNo, err := ReadEnumField[Parameter](ctx, "paramNo", "Parameter", ReadEnum(ParameterByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'paramNo' field"))
	}
	m.ParamNo = paramNo

	count, err := ReadSimpleField(ctx, "count", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'count' field"))
	}
	m.Count = count

	if closeErr := readBuffer.CloseContext("CALDataGetStatus"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CALDataGetStatus")
	}

	return m, nil
}

func (m *_CALDataGetStatus) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CALDataGetStatus) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CALDataGetStatus"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CALDataGetStatus")
		}

		if err := WriteSimpleEnumField[Parameter](ctx, "paramNo", "Parameter", m.GetParamNo(), WriteEnum[Parameter, uint8](Parameter.GetValue, Parameter.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
			return errors.Wrap(err, "Error serializing 'paramNo' field")
		}

		if err := WriteSimpleField[uint8](ctx, "count", m.GetCount(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'count' field")
		}

		if popErr := writeBuffer.PopContext("CALDataGetStatus"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CALDataGetStatus")
		}
		return nil
	}
	return m.CALDataContract.(*_CALData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CALDataGetStatus) IsCALDataGetStatus() {}

func (m *_CALDataGetStatus) DeepCopy() any {
	return m.deepCopy()
}

func (m *_CALDataGetStatus) deepCopy() *_CALDataGetStatus {
	if m == nil {
		return nil
	}
	_CALDataGetStatusCopy := &_CALDataGetStatus{
		m.CALDataContract.(*_CALData).deepCopy(),
		m.ParamNo,
		m.Count,
	}
	_CALDataGetStatusCopy.CALDataContract.(*_CALData)._SubType = m
	return _CALDataGetStatusCopy
}

func (m *_CALDataGetStatus) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
