/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BridgeAddress is the corresponding interface of BridgeAddress
type BridgeAddress interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetAddress returns Address (property field)
	GetAddress() byte
	// IsBridgeAddress is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBridgeAddress()
	// CreateBuilder creates a BridgeAddressBuilder
	CreateBridgeAddressBuilder() BridgeAddressBuilder
}

// _BridgeAddress is the data-structure of this message
type _BridgeAddress struct {
	Address byte
}

var _ BridgeAddress = (*_BridgeAddress)(nil)

// NewBridgeAddress factory function for _BridgeAddress
func NewBridgeAddress(address byte) *_BridgeAddress {
	return &_BridgeAddress{Address: address}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BridgeAddressBuilder is a builder for BridgeAddress
type BridgeAddressBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(address byte) BridgeAddressBuilder
	// WithAddress adds Address (property field)
	WithAddress(byte) BridgeAddressBuilder
	// Build builds the BridgeAddress or returns an error if something is wrong
	Build() (BridgeAddress, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BridgeAddress
}

// NewBridgeAddressBuilder() creates a BridgeAddressBuilder
func NewBridgeAddressBuilder() BridgeAddressBuilder {
	return &_BridgeAddressBuilder{_BridgeAddress: new(_BridgeAddress)}
}

type _BridgeAddressBuilder struct {
	*_BridgeAddress

	err *utils.MultiError
}

var _ (BridgeAddressBuilder) = (*_BridgeAddressBuilder)(nil)

func (b *_BridgeAddressBuilder) WithMandatoryFields(address byte) BridgeAddressBuilder {
	return b.WithAddress(address)
}

func (b *_BridgeAddressBuilder) WithAddress(address byte) BridgeAddressBuilder {
	b.Address = address
	return b
}

func (b *_BridgeAddressBuilder) Build() (BridgeAddress, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BridgeAddress.deepCopy(), nil
}

func (b *_BridgeAddressBuilder) MustBuild() BridgeAddress {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BridgeAddressBuilder) DeepCopy() any {
	_copy := b.CreateBridgeAddressBuilder().(*_BridgeAddressBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBridgeAddressBuilder creates a BridgeAddressBuilder
func (b *_BridgeAddress) CreateBridgeAddressBuilder() BridgeAddressBuilder {
	if b == nil {
		return NewBridgeAddressBuilder()
	}
	return &_BridgeAddressBuilder{_BridgeAddress: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BridgeAddress) GetAddress() byte {
	return m.Address
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBridgeAddress(structType any) BridgeAddress {
	if casted, ok := structType.(BridgeAddress); ok {
		return casted
	}
	if casted, ok := structType.(*BridgeAddress); ok {
		return *casted
	}
	return nil
}

func (m *_BridgeAddress) GetTypeName() string {
	return "BridgeAddress"
}

func (m *_BridgeAddress) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (address)
	lengthInBits += 8

	return lengthInBits
}

func (m *_BridgeAddress) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BridgeAddressParse(ctx context.Context, theBytes []byte) (BridgeAddress, error) {
	return BridgeAddressParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BridgeAddressParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BridgeAddress, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BridgeAddress, error) {
		return BridgeAddressParseWithBuffer(ctx, readBuffer)
	}
}

func BridgeAddressParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BridgeAddress, error) {
	v, err := (&_BridgeAddress{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BridgeAddress) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bridgeAddress BridgeAddress, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BridgeAddress"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BridgeAddress")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	address, err := ReadSimpleField(ctx, "address", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'address' field"))
	}
	m.Address = address

	if closeErr := readBuffer.CloseContext("BridgeAddress"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BridgeAddress")
	}

	return m, nil
}

func (m *_BridgeAddress) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BridgeAddress) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BridgeAddress"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BridgeAddress")
	}

	if err := WriteSimpleField[byte](ctx, "address", m.GetAddress(), WriteByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'address' field")
	}

	if popErr := writeBuffer.PopContext("BridgeAddress"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BridgeAddress")
	}
	return nil
}

func (m *_BridgeAddress) IsBridgeAddress() {}

func (m *_BridgeAddress) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BridgeAddress) deepCopy() *_BridgeAddress {
	if m == nil {
		return nil
	}
	_BridgeAddressCopy := &_BridgeAddress{
		m.Address,
	}
	return _BridgeAddressCopy
}

func (m *_BridgeAddress) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
