/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApplicationAddress2 is the corresponding interface of ApplicationAddress2
type ApplicationAddress2 interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetAddress returns Address (property field)
	GetAddress() byte
	// GetIsWildcard returns IsWildcard (virtual field)
	GetIsWildcard() bool
	// IsApplicationAddress2 is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApplicationAddress2()
	// CreateBuilder creates a ApplicationAddress2Builder
	CreateApplicationAddress2Builder() ApplicationAddress2Builder
}

// _ApplicationAddress2 is the data-structure of this message
type _ApplicationAddress2 struct {
	Address byte
}

var _ ApplicationAddress2 = (*_ApplicationAddress2)(nil)

// NewApplicationAddress2 factory function for _ApplicationAddress2
func NewApplicationAddress2(address byte) *_ApplicationAddress2 {
	return &_ApplicationAddress2{Address: address}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApplicationAddress2Builder is a builder for ApplicationAddress2
type ApplicationAddress2Builder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(address byte) ApplicationAddress2Builder
	// WithAddress adds Address (property field)
	WithAddress(byte) ApplicationAddress2Builder
	// Build builds the ApplicationAddress2 or returns an error if something is wrong
	Build() (ApplicationAddress2, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApplicationAddress2
}

// NewApplicationAddress2Builder() creates a ApplicationAddress2Builder
func NewApplicationAddress2Builder() ApplicationAddress2Builder {
	return &_ApplicationAddress2Builder{_ApplicationAddress2: new(_ApplicationAddress2)}
}

type _ApplicationAddress2Builder struct {
	*_ApplicationAddress2

	err *utils.MultiError
}

var _ (ApplicationAddress2Builder) = (*_ApplicationAddress2Builder)(nil)

func (b *_ApplicationAddress2Builder) WithMandatoryFields(address byte) ApplicationAddress2Builder {
	return b.WithAddress(address)
}

func (b *_ApplicationAddress2Builder) WithAddress(address byte) ApplicationAddress2Builder {
	b.Address = address
	return b
}

func (b *_ApplicationAddress2Builder) Build() (ApplicationAddress2, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ApplicationAddress2.deepCopy(), nil
}

func (b *_ApplicationAddress2Builder) MustBuild() ApplicationAddress2 {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApplicationAddress2Builder) DeepCopy() any {
	_copy := b.CreateApplicationAddress2Builder().(*_ApplicationAddress2Builder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateApplicationAddress2Builder creates a ApplicationAddress2Builder
func (b *_ApplicationAddress2) CreateApplicationAddress2Builder() ApplicationAddress2Builder {
	if b == nil {
		return NewApplicationAddress2Builder()
	}
	return &_ApplicationAddress2Builder{_ApplicationAddress2: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ApplicationAddress2) GetAddress() byte {
	return m.Address
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_ApplicationAddress2) GetIsWildcard() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetAddress()) == (0xFF)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastApplicationAddress2(structType any) ApplicationAddress2 {
	if casted, ok := structType.(ApplicationAddress2); ok {
		return casted
	}
	if casted, ok := structType.(*ApplicationAddress2); ok {
		return *casted
	}
	return nil
}

func (m *_ApplicationAddress2) GetTypeName() string {
	return "ApplicationAddress2"
}

func (m *_ApplicationAddress2) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (address)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_ApplicationAddress2) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ApplicationAddress2Parse(ctx context.Context, theBytes []byte) (ApplicationAddress2, error) {
	return ApplicationAddress2ParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ApplicationAddress2ParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (ApplicationAddress2, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (ApplicationAddress2, error) {
		return ApplicationAddress2ParseWithBuffer(ctx, readBuffer)
	}
}

func ApplicationAddress2ParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ApplicationAddress2, error) {
	v, err := (&_ApplicationAddress2{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_ApplicationAddress2) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__applicationAddress2 ApplicationAddress2, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApplicationAddress2"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApplicationAddress2")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	address, err := ReadSimpleField(ctx, "address", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'address' field"))
	}
	m.Address = address

	isWildcard, err := ReadVirtualField[bool](ctx, "isWildcard", (*bool)(nil), bool((address) == (0xFF)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isWildcard' field"))
	}
	_ = isWildcard

	if closeErr := readBuffer.CloseContext("ApplicationAddress2"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApplicationAddress2")
	}

	return m, nil
}

func (m *_ApplicationAddress2) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApplicationAddress2) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ApplicationAddress2"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ApplicationAddress2")
	}

	if err := WriteSimpleField[byte](ctx, "address", m.GetAddress(), WriteByte(writeBuffer, 8)); err != nil {
		return errors.Wrap(err, "Error serializing 'address' field")
	}
	// Virtual field
	isWildcard := m.GetIsWildcard()
	_ = isWildcard
	if _isWildcardErr := writeBuffer.WriteVirtual(ctx, "isWildcard", m.GetIsWildcard()); _isWildcardErr != nil {
		return errors.Wrap(_isWildcardErr, "Error serializing 'isWildcard' field")
	}

	if popErr := writeBuffer.PopContext("ApplicationAddress2"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ApplicationAddress2")
	}
	return nil
}

func (m *_ApplicationAddress2) IsApplicationAddress2() {}

func (m *_ApplicationAddress2) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApplicationAddress2) deepCopy() *_ApplicationAddress2 {
	if m == nil {
		return nil
	}
	_ApplicationAddress2Copy := &_ApplicationAddress2{
		m.Address,
	}
	return _ApplicationAddress2Copy
}

func (m *_ApplicationAddress2) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
