/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AirConditioningDataZoneTemperature is the corresponding interface of AirConditioningDataZoneTemperature
type AirConditioningDataZoneTemperature interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	AirConditioningData
	// GetZoneGroup returns ZoneGroup (property field)
	GetZoneGroup() byte
	// GetZoneList returns ZoneList (property field)
	GetZoneList() HVACZoneList
	// GetTemperature returns Temperature (property field)
	GetTemperature() HVACTemperature
	// GetSensorStatus returns SensorStatus (property field)
	GetSensorStatus() HVACSensorStatus
	// IsAirConditioningDataZoneTemperature is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAirConditioningDataZoneTemperature()
	// CreateBuilder creates a AirConditioningDataZoneTemperatureBuilder
	CreateAirConditioningDataZoneTemperatureBuilder() AirConditioningDataZoneTemperatureBuilder
}

// _AirConditioningDataZoneTemperature is the data-structure of this message
type _AirConditioningDataZoneTemperature struct {
	AirConditioningDataContract
	ZoneGroup    byte
	ZoneList     HVACZoneList
	Temperature  HVACTemperature
	SensorStatus HVACSensorStatus
}

var _ AirConditioningDataZoneTemperature = (*_AirConditioningDataZoneTemperature)(nil)
var _ AirConditioningDataRequirements = (*_AirConditioningDataZoneTemperature)(nil)

// NewAirConditioningDataZoneTemperature factory function for _AirConditioningDataZoneTemperature
func NewAirConditioningDataZoneTemperature(commandTypeContainer AirConditioningCommandTypeContainer, zoneGroup byte, zoneList HVACZoneList, temperature HVACTemperature, sensorStatus HVACSensorStatus) *_AirConditioningDataZoneTemperature {
	if zoneList == nil {
		panic("zoneList of type HVACZoneList for AirConditioningDataZoneTemperature must not be nil")
	}
	if temperature == nil {
		panic("temperature of type HVACTemperature for AirConditioningDataZoneTemperature must not be nil")
	}
	_result := &_AirConditioningDataZoneTemperature{
		AirConditioningDataContract: NewAirConditioningData(commandTypeContainer),
		ZoneGroup:                   zoneGroup,
		ZoneList:                    zoneList,
		Temperature:                 temperature,
		SensorStatus:                sensorStatus,
	}
	_result.AirConditioningDataContract.(*_AirConditioningData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AirConditioningDataZoneTemperatureBuilder is a builder for AirConditioningDataZoneTemperature
type AirConditioningDataZoneTemperatureBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(zoneGroup byte, zoneList HVACZoneList, temperature HVACTemperature, sensorStatus HVACSensorStatus) AirConditioningDataZoneTemperatureBuilder
	// WithZoneGroup adds ZoneGroup (property field)
	WithZoneGroup(byte) AirConditioningDataZoneTemperatureBuilder
	// WithZoneList adds ZoneList (property field)
	WithZoneList(HVACZoneList) AirConditioningDataZoneTemperatureBuilder
	// WithZoneListBuilder adds ZoneList (property field) which is build by the builder
	WithZoneListBuilder(func(HVACZoneListBuilder) HVACZoneListBuilder) AirConditioningDataZoneTemperatureBuilder
	// WithTemperature adds Temperature (property field)
	WithTemperature(HVACTemperature) AirConditioningDataZoneTemperatureBuilder
	// WithTemperatureBuilder adds Temperature (property field) which is build by the builder
	WithTemperatureBuilder(func(HVACTemperatureBuilder) HVACTemperatureBuilder) AirConditioningDataZoneTemperatureBuilder
	// WithSensorStatus adds SensorStatus (property field)
	WithSensorStatus(HVACSensorStatus) AirConditioningDataZoneTemperatureBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() AirConditioningDataBuilder
	// Build builds the AirConditioningDataZoneTemperature or returns an error if something is wrong
	Build() (AirConditioningDataZoneTemperature, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AirConditioningDataZoneTemperature
}

// NewAirConditioningDataZoneTemperatureBuilder() creates a AirConditioningDataZoneTemperatureBuilder
func NewAirConditioningDataZoneTemperatureBuilder() AirConditioningDataZoneTemperatureBuilder {
	return &_AirConditioningDataZoneTemperatureBuilder{_AirConditioningDataZoneTemperature: new(_AirConditioningDataZoneTemperature)}
}

type _AirConditioningDataZoneTemperatureBuilder struct {
	*_AirConditioningDataZoneTemperature

	parentBuilder *_AirConditioningDataBuilder

	err *utils.MultiError
}

var _ (AirConditioningDataZoneTemperatureBuilder) = (*_AirConditioningDataZoneTemperatureBuilder)(nil)

func (b *_AirConditioningDataZoneTemperatureBuilder) setParent(contract AirConditioningDataContract) {
	b.AirConditioningDataContract = contract
	contract.(*_AirConditioningData)._SubType = b._AirConditioningDataZoneTemperature
}

func (b *_AirConditioningDataZoneTemperatureBuilder) WithMandatoryFields(zoneGroup byte, zoneList HVACZoneList, temperature HVACTemperature, sensorStatus HVACSensorStatus) AirConditioningDataZoneTemperatureBuilder {
	return b.WithZoneGroup(zoneGroup).WithZoneList(zoneList).WithTemperature(temperature).WithSensorStatus(sensorStatus)
}

func (b *_AirConditioningDataZoneTemperatureBuilder) WithZoneGroup(zoneGroup byte) AirConditioningDataZoneTemperatureBuilder {
	b.ZoneGroup = zoneGroup
	return b
}

func (b *_AirConditioningDataZoneTemperatureBuilder) WithZoneList(zoneList HVACZoneList) AirConditioningDataZoneTemperatureBuilder {
	b.ZoneList = zoneList
	return b
}

func (b *_AirConditioningDataZoneTemperatureBuilder) WithZoneListBuilder(builderSupplier func(HVACZoneListBuilder) HVACZoneListBuilder) AirConditioningDataZoneTemperatureBuilder {
	builder := builderSupplier(b.ZoneList.CreateHVACZoneListBuilder())
	var err error
	b.ZoneList, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "HVACZoneListBuilder failed"))
	}
	return b
}

func (b *_AirConditioningDataZoneTemperatureBuilder) WithTemperature(temperature HVACTemperature) AirConditioningDataZoneTemperatureBuilder {
	b.Temperature = temperature
	return b
}

func (b *_AirConditioningDataZoneTemperatureBuilder) WithTemperatureBuilder(builderSupplier func(HVACTemperatureBuilder) HVACTemperatureBuilder) AirConditioningDataZoneTemperatureBuilder {
	builder := builderSupplier(b.Temperature.CreateHVACTemperatureBuilder())
	var err error
	b.Temperature, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "HVACTemperatureBuilder failed"))
	}
	return b
}

func (b *_AirConditioningDataZoneTemperatureBuilder) WithSensorStatus(sensorStatus HVACSensorStatus) AirConditioningDataZoneTemperatureBuilder {
	b.SensorStatus = sensorStatus
	return b
}

func (b *_AirConditioningDataZoneTemperatureBuilder) Build() (AirConditioningDataZoneTemperature, error) {
	if b.ZoneList == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'zoneList' not set"))
	}
	if b.Temperature == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'temperature' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._AirConditioningDataZoneTemperature.deepCopy(), nil
}

func (b *_AirConditioningDataZoneTemperatureBuilder) MustBuild() AirConditioningDataZoneTemperature {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AirConditioningDataZoneTemperatureBuilder) Done() AirConditioningDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewAirConditioningDataBuilder().(*_AirConditioningDataBuilder)
	}
	return b.parentBuilder
}

func (b *_AirConditioningDataZoneTemperatureBuilder) buildForAirConditioningData() (AirConditioningData, error) {
	return b.Build()
}

func (b *_AirConditioningDataZoneTemperatureBuilder) DeepCopy() any {
	_copy := b.CreateAirConditioningDataZoneTemperatureBuilder().(*_AirConditioningDataZoneTemperatureBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateAirConditioningDataZoneTemperatureBuilder creates a AirConditioningDataZoneTemperatureBuilder
func (b *_AirConditioningDataZoneTemperature) CreateAirConditioningDataZoneTemperatureBuilder() AirConditioningDataZoneTemperatureBuilder {
	if b == nil {
		return NewAirConditioningDataZoneTemperatureBuilder()
	}
	return &_AirConditioningDataZoneTemperatureBuilder{_AirConditioningDataZoneTemperature: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AirConditioningDataZoneTemperature) GetParent() AirConditioningDataContract {
	return m.AirConditioningDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AirConditioningDataZoneTemperature) GetZoneGroup() byte {
	return m.ZoneGroup
}

func (m *_AirConditioningDataZoneTemperature) GetZoneList() HVACZoneList {
	return m.ZoneList
}

func (m *_AirConditioningDataZoneTemperature) GetTemperature() HVACTemperature {
	return m.Temperature
}

func (m *_AirConditioningDataZoneTemperature) GetSensorStatus() HVACSensorStatus {
	return m.SensorStatus
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAirConditioningDataZoneTemperature(structType any) AirConditioningDataZoneTemperature {
	if casted, ok := structType.(AirConditioningDataZoneTemperature); ok {
		return casted
	}
	if casted, ok := structType.(*AirConditioningDataZoneTemperature); ok {
		return *casted
	}
	return nil
}

func (m *_AirConditioningDataZoneTemperature) GetTypeName() string {
	return "AirConditioningDataZoneTemperature"
}

func (m *_AirConditioningDataZoneTemperature) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.AirConditioningDataContract.(*_AirConditioningData).getLengthInBits(ctx))

	// Simple field (zoneGroup)
	lengthInBits += 8

	// Simple field (zoneList)
	lengthInBits += m.ZoneList.GetLengthInBits(ctx)

	// Simple field (temperature)
	lengthInBits += m.Temperature.GetLengthInBits(ctx)

	// Simple field (sensorStatus)
	lengthInBits += 8

	return lengthInBits
}

func (m *_AirConditioningDataZoneTemperature) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_AirConditioningDataZoneTemperature) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_AirConditioningData) (__airConditioningDataZoneTemperature AirConditioningDataZoneTemperature, err error) {
	m.AirConditioningDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AirConditioningDataZoneTemperature"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AirConditioningDataZoneTemperature")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zoneGroup, err := ReadSimpleField(ctx, "zoneGroup", ReadByte(readBuffer, 8))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zoneGroup' field"))
	}
	m.ZoneGroup = zoneGroup

	zoneList, err := ReadSimpleField[HVACZoneList](ctx, "zoneList", ReadComplex[HVACZoneList](HVACZoneListParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zoneList' field"))
	}
	m.ZoneList = zoneList

	temperature, err := ReadSimpleField[HVACTemperature](ctx, "temperature", ReadComplex[HVACTemperature](HVACTemperatureParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'temperature' field"))
	}
	m.Temperature = temperature

	sensorStatus, err := ReadEnumField[HVACSensorStatus](ctx, "sensorStatus", "HVACSensorStatus", ReadEnum(HVACSensorStatusByValue, ReadUnsignedByte(readBuffer, uint8(8))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'sensorStatus' field"))
	}
	m.SensorStatus = sensorStatus

	if closeErr := readBuffer.CloseContext("AirConditioningDataZoneTemperature"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AirConditioningDataZoneTemperature")
	}

	return m, nil
}

func (m *_AirConditioningDataZoneTemperature) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AirConditioningDataZoneTemperature) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AirConditioningDataZoneTemperature"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AirConditioningDataZoneTemperature")
		}

		if err := WriteSimpleField[byte](ctx, "zoneGroup", m.GetZoneGroup(), WriteByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'zoneGroup' field")
		}

		if err := WriteSimpleField[HVACZoneList](ctx, "zoneList", m.GetZoneList(), WriteComplex[HVACZoneList](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'zoneList' field")
		}

		if err := WriteSimpleField[HVACTemperature](ctx, "temperature", m.GetTemperature(), WriteComplex[HVACTemperature](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'temperature' field")
		}

		if err := WriteSimpleEnumField[HVACSensorStatus](ctx, "sensorStatus", "HVACSensorStatus", m.GetSensorStatus(), WriteEnum[HVACSensorStatus, uint8](HVACSensorStatus.GetValue, HVACSensorStatus.PLC4XEnumName, WriteUnsignedByte(writeBuffer, 8))); err != nil {
			return errors.Wrap(err, "Error serializing 'sensorStatus' field")
		}

		if popErr := writeBuffer.PopContext("AirConditioningDataZoneTemperature"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AirConditioningDataZoneTemperature")
		}
		return nil
	}
	return m.AirConditioningDataContract.(*_AirConditioningData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AirConditioningDataZoneTemperature) IsAirConditioningDataZoneTemperature() {}

func (m *_AirConditioningDataZoneTemperature) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AirConditioningDataZoneTemperature) deepCopy() *_AirConditioningDataZoneTemperature {
	if m == nil {
		return nil
	}
	_AirConditioningDataZoneTemperatureCopy := &_AirConditioningDataZoneTemperature{
		m.AirConditioningDataContract.(*_AirConditioningData).deepCopy(),
		m.ZoneGroup,
		utils.DeepCopy[HVACZoneList](m.ZoneList),
		utils.DeepCopy[HVACTemperature](m.Temperature),
		m.SensorStatus,
	}
	_AirConditioningDataZoneTemperatureCopy.AirConditioningDataContract.(*_AirConditioningData)._SubType = m
	return _AirConditioningDataZoneTemperatureCopy
}

func (m *_AirConditioningDataZoneTemperature) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
