/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NLMInitializeRoutingTable is the corresponding interface of NLMInitializeRoutingTable
type NLMInitializeRoutingTable interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	NLM
	// GetNumberOfPorts returns NumberOfPorts (property field)
	GetNumberOfPorts() uint8
	// GetPortMappings returns PortMappings (property field)
	GetPortMappings() []NLMInitializeRoutingTablePortMapping
	// IsNLMInitializeRoutingTable is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNLMInitializeRoutingTable()
	// CreateBuilder creates a NLMInitializeRoutingTableBuilder
	CreateNLMInitializeRoutingTableBuilder() NLMInitializeRoutingTableBuilder
}

// _NLMInitializeRoutingTable is the data-structure of this message
type _NLMInitializeRoutingTable struct {
	NLMContract
	NumberOfPorts uint8
	PortMappings  []NLMInitializeRoutingTablePortMapping
}

var _ NLMInitializeRoutingTable = (*_NLMInitializeRoutingTable)(nil)
var _ NLMRequirements = (*_NLMInitializeRoutingTable)(nil)

// NewNLMInitializeRoutingTable factory function for _NLMInitializeRoutingTable
func NewNLMInitializeRoutingTable(numberOfPorts uint8, portMappings []NLMInitializeRoutingTablePortMapping, apduLength uint16) *_NLMInitializeRoutingTable {
	_result := &_NLMInitializeRoutingTable{
		NLMContract:   NewNLM(apduLength),
		NumberOfPorts: numberOfPorts,
		PortMappings:  portMappings,
	}
	_result.NLMContract.(*_NLM)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NLMInitializeRoutingTableBuilder is a builder for NLMInitializeRoutingTable
type NLMInitializeRoutingTableBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(numberOfPorts uint8, portMappings []NLMInitializeRoutingTablePortMapping) NLMInitializeRoutingTableBuilder
	// WithNumberOfPorts adds NumberOfPorts (property field)
	WithNumberOfPorts(uint8) NLMInitializeRoutingTableBuilder
	// WithPortMappings adds PortMappings (property field)
	WithPortMappings(...NLMInitializeRoutingTablePortMapping) NLMInitializeRoutingTableBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() NLMBuilder
	// Build builds the NLMInitializeRoutingTable or returns an error if something is wrong
	Build() (NLMInitializeRoutingTable, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NLMInitializeRoutingTable
}

// NewNLMInitializeRoutingTableBuilder() creates a NLMInitializeRoutingTableBuilder
func NewNLMInitializeRoutingTableBuilder() NLMInitializeRoutingTableBuilder {
	return &_NLMInitializeRoutingTableBuilder{_NLMInitializeRoutingTable: new(_NLMInitializeRoutingTable)}
}

type _NLMInitializeRoutingTableBuilder struct {
	*_NLMInitializeRoutingTable

	parentBuilder *_NLMBuilder

	err *utils.MultiError
}

var _ (NLMInitializeRoutingTableBuilder) = (*_NLMInitializeRoutingTableBuilder)(nil)

func (b *_NLMInitializeRoutingTableBuilder) setParent(contract NLMContract) {
	b.NLMContract = contract
	contract.(*_NLM)._SubType = b._NLMInitializeRoutingTable
}

func (b *_NLMInitializeRoutingTableBuilder) WithMandatoryFields(numberOfPorts uint8, portMappings []NLMInitializeRoutingTablePortMapping) NLMInitializeRoutingTableBuilder {
	return b.WithNumberOfPorts(numberOfPorts).WithPortMappings(portMappings...)
}

func (b *_NLMInitializeRoutingTableBuilder) WithNumberOfPorts(numberOfPorts uint8) NLMInitializeRoutingTableBuilder {
	b.NumberOfPorts = numberOfPorts
	return b
}

func (b *_NLMInitializeRoutingTableBuilder) WithPortMappings(portMappings ...NLMInitializeRoutingTablePortMapping) NLMInitializeRoutingTableBuilder {
	b.PortMappings = portMappings
	return b
}

func (b *_NLMInitializeRoutingTableBuilder) Build() (NLMInitializeRoutingTable, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._NLMInitializeRoutingTable.deepCopy(), nil
}

func (b *_NLMInitializeRoutingTableBuilder) MustBuild() NLMInitializeRoutingTable {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NLMInitializeRoutingTableBuilder) Done() NLMBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewNLMBuilder().(*_NLMBuilder)
	}
	return b.parentBuilder
}

func (b *_NLMInitializeRoutingTableBuilder) buildForNLM() (NLM, error) {
	return b.Build()
}

func (b *_NLMInitializeRoutingTableBuilder) DeepCopy() any {
	_copy := b.CreateNLMInitializeRoutingTableBuilder().(*_NLMInitializeRoutingTableBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateNLMInitializeRoutingTableBuilder creates a NLMInitializeRoutingTableBuilder
func (b *_NLMInitializeRoutingTable) CreateNLMInitializeRoutingTableBuilder() NLMInitializeRoutingTableBuilder {
	if b == nil {
		return NewNLMInitializeRoutingTableBuilder()
	}
	return &_NLMInitializeRoutingTableBuilder{_NLMInitializeRoutingTable: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_NLMInitializeRoutingTable) GetMessageType() uint8 {
	return 0x06
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_NLMInitializeRoutingTable) GetParent() NLMContract {
	return m.NLMContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NLMInitializeRoutingTable) GetNumberOfPorts() uint8 {
	return m.NumberOfPorts
}

func (m *_NLMInitializeRoutingTable) GetPortMappings() []NLMInitializeRoutingTablePortMapping {
	return m.PortMappings
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNLMInitializeRoutingTable(structType any) NLMInitializeRoutingTable {
	if casted, ok := structType.(NLMInitializeRoutingTable); ok {
		return casted
	}
	if casted, ok := structType.(*NLMInitializeRoutingTable); ok {
		return *casted
	}
	return nil
}

func (m *_NLMInitializeRoutingTable) GetTypeName() string {
	return "NLMInitializeRoutingTable"
}

func (m *_NLMInitializeRoutingTable) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.NLMContract.(*_NLM).getLengthInBits(ctx))

	// Simple field (numberOfPorts)
	lengthInBits += 8

	// Array field
	if len(m.PortMappings) > 0 {
		for _curItem, element := range m.PortMappings {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.PortMappings), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_NLMInitializeRoutingTable) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_NLMInitializeRoutingTable) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_NLM, apduLength uint16) (__nLMInitializeRoutingTable NLMInitializeRoutingTable, err error) {
	m.NLMContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NLMInitializeRoutingTable"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NLMInitializeRoutingTable")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	numberOfPorts, err := ReadSimpleField(ctx, "numberOfPorts", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberOfPorts' field"))
	}
	m.NumberOfPorts = numberOfPorts

	portMappings, err := ReadCountArrayField[NLMInitializeRoutingTablePortMapping](ctx, "portMappings", ReadComplex[NLMInitializeRoutingTablePortMapping](NLMInitializeRoutingTablePortMappingParseWithBuffer, readBuffer), uint64(numberOfPorts))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'portMappings' field"))
	}
	m.PortMappings = portMappings

	if closeErr := readBuffer.CloseContext("NLMInitializeRoutingTable"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NLMInitializeRoutingTable")
	}

	return m, nil
}

func (m *_NLMInitializeRoutingTable) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NLMInitializeRoutingTable) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("NLMInitializeRoutingTable"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for NLMInitializeRoutingTable")
		}

		if err := WriteSimpleField[uint8](ctx, "numberOfPorts", m.GetNumberOfPorts(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'numberOfPorts' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "portMappings", m.GetPortMappings(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'portMappings' field")
		}

		if popErr := writeBuffer.PopContext("NLMInitializeRoutingTable"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for NLMInitializeRoutingTable")
		}
		return nil
	}
	return m.NLMContract.(*_NLM).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_NLMInitializeRoutingTable) IsNLMInitializeRoutingTable() {}

func (m *_NLMInitializeRoutingTable) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NLMInitializeRoutingTable) deepCopy() *_NLMInitializeRoutingTable {
	if m == nil {
		return nil
	}
	_NLMInitializeRoutingTableCopy := &_NLMInitializeRoutingTable{
		m.NLMContract.(*_NLM).deepCopy(),
		m.NumberOfPorts,
		utils.DeepCopySlice[NLMInitializeRoutingTablePortMapping, NLMInitializeRoutingTablePortMapping](m.PortMappings),
	}
	_NLMInitializeRoutingTableCopy.NLMContract.(*_NLM)._SubType = m
	return _NLMInitializeRoutingTableCopy
}

func (m *_NLMInitializeRoutingTable) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
