/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// NLMICouldBeRouterToNetwork is the corresponding interface of NLMICouldBeRouterToNetwork
type NLMICouldBeRouterToNetwork interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	NLM
	// GetDestinationNetworkAddress returns DestinationNetworkAddress (property field)
	GetDestinationNetworkAddress() uint16
	// GetPerformanceIndex returns PerformanceIndex (property field)
	GetPerformanceIndex() uint8
	// IsNLMICouldBeRouterToNetwork is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsNLMICouldBeRouterToNetwork()
	// CreateBuilder creates a NLMICouldBeRouterToNetworkBuilder
	CreateNLMICouldBeRouterToNetworkBuilder() NLMICouldBeRouterToNetworkBuilder
}

// _NLMICouldBeRouterToNetwork is the data-structure of this message
type _NLMICouldBeRouterToNetwork struct {
	NLMContract
	DestinationNetworkAddress uint16
	PerformanceIndex          uint8
}

var _ NLMICouldBeRouterToNetwork = (*_NLMICouldBeRouterToNetwork)(nil)
var _ NLMRequirements = (*_NLMICouldBeRouterToNetwork)(nil)

// NewNLMICouldBeRouterToNetwork factory function for _NLMICouldBeRouterToNetwork
func NewNLMICouldBeRouterToNetwork(destinationNetworkAddress uint16, performanceIndex uint8, apduLength uint16) *_NLMICouldBeRouterToNetwork {
	_result := &_NLMICouldBeRouterToNetwork{
		NLMContract:               NewNLM(apduLength),
		DestinationNetworkAddress: destinationNetworkAddress,
		PerformanceIndex:          performanceIndex,
	}
	_result.NLMContract.(*_NLM)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// NLMICouldBeRouterToNetworkBuilder is a builder for NLMICouldBeRouterToNetwork
type NLMICouldBeRouterToNetworkBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(destinationNetworkAddress uint16, performanceIndex uint8) NLMICouldBeRouterToNetworkBuilder
	// WithDestinationNetworkAddress adds DestinationNetworkAddress (property field)
	WithDestinationNetworkAddress(uint16) NLMICouldBeRouterToNetworkBuilder
	// WithPerformanceIndex adds PerformanceIndex (property field)
	WithPerformanceIndex(uint8) NLMICouldBeRouterToNetworkBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() NLMBuilder
	// Build builds the NLMICouldBeRouterToNetwork or returns an error if something is wrong
	Build() (NLMICouldBeRouterToNetwork, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() NLMICouldBeRouterToNetwork
}

// NewNLMICouldBeRouterToNetworkBuilder() creates a NLMICouldBeRouterToNetworkBuilder
func NewNLMICouldBeRouterToNetworkBuilder() NLMICouldBeRouterToNetworkBuilder {
	return &_NLMICouldBeRouterToNetworkBuilder{_NLMICouldBeRouterToNetwork: new(_NLMICouldBeRouterToNetwork)}
}

type _NLMICouldBeRouterToNetworkBuilder struct {
	*_NLMICouldBeRouterToNetwork

	parentBuilder *_NLMBuilder

	err *utils.MultiError
}

var _ (NLMICouldBeRouterToNetworkBuilder) = (*_NLMICouldBeRouterToNetworkBuilder)(nil)

func (b *_NLMICouldBeRouterToNetworkBuilder) setParent(contract NLMContract) {
	b.NLMContract = contract
	contract.(*_NLM)._SubType = b._NLMICouldBeRouterToNetwork
}

func (b *_NLMICouldBeRouterToNetworkBuilder) WithMandatoryFields(destinationNetworkAddress uint16, performanceIndex uint8) NLMICouldBeRouterToNetworkBuilder {
	return b.WithDestinationNetworkAddress(destinationNetworkAddress).WithPerformanceIndex(performanceIndex)
}

func (b *_NLMICouldBeRouterToNetworkBuilder) WithDestinationNetworkAddress(destinationNetworkAddress uint16) NLMICouldBeRouterToNetworkBuilder {
	b.DestinationNetworkAddress = destinationNetworkAddress
	return b
}

func (b *_NLMICouldBeRouterToNetworkBuilder) WithPerformanceIndex(performanceIndex uint8) NLMICouldBeRouterToNetworkBuilder {
	b.PerformanceIndex = performanceIndex
	return b
}

func (b *_NLMICouldBeRouterToNetworkBuilder) Build() (NLMICouldBeRouterToNetwork, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._NLMICouldBeRouterToNetwork.deepCopy(), nil
}

func (b *_NLMICouldBeRouterToNetworkBuilder) MustBuild() NLMICouldBeRouterToNetwork {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_NLMICouldBeRouterToNetworkBuilder) Done() NLMBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewNLMBuilder().(*_NLMBuilder)
	}
	return b.parentBuilder
}

func (b *_NLMICouldBeRouterToNetworkBuilder) buildForNLM() (NLM, error) {
	return b.Build()
}

func (b *_NLMICouldBeRouterToNetworkBuilder) DeepCopy() any {
	_copy := b.CreateNLMICouldBeRouterToNetworkBuilder().(*_NLMICouldBeRouterToNetworkBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateNLMICouldBeRouterToNetworkBuilder creates a NLMICouldBeRouterToNetworkBuilder
func (b *_NLMICouldBeRouterToNetwork) CreateNLMICouldBeRouterToNetworkBuilder() NLMICouldBeRouterToNetworkBuilder {
	if b == nil {
		return NewNLMICouldBeRouterToNetworkBuilder()
	}
	return &_NLMICouldBeRouterToNetworkBuilder{_NLMICouldBeRouterToNetwork: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_NLMICouldBeRouterToNetwork) GetMessageType() uint8 {
	return 0x02
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_NLMICouldBeRouterToNetwork) GetParent() NLMContract {
	return m.NLMContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NLMICouldBeRouterToNetwork) GetDestinationNetworkAddress() uint16 {
	return m.DestinationNetworkAddress
}

func (m *_NLMICouldBeRouterToNetwork) GetPerformanceIndex() uint8 {
	return m.PerformanceIndex
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastNLMICouldBeRouterToNetwork(structType any) NLMICouldBeRouterToNetwork {
	if casted, ok := structType.(NLMICouldBeRouterToNetwork); ok {
		return casted
	}
	if casted, ok := structType.(*NLMICouldBeRouterToNetwork); ok {
		return *casted
	}
	return nil
}

func (m *_NLMICouldBeRouterToNetwork) GetTypeName() string {
	return "NLMICouldBeRouterToNetwork"
}

func (m *_NLMICouldBeRouterToNetwork) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.NLMContract.(*_NLM).getLengthInBits(ctx))

	// Simple field (destinationNetworkAddress)
	lengthInBits += 16

	// Simple field (performanceIndex)
	lengthInBits += 8

	return lengthInBits
}

func (m *_NLMICouldBeRouterToNetwork) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_NLMICouldBeRouterToNetwork) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_NLM, apduLength uint16) (__nLMICouldBeRouterToNetwork NLMICouldBeRouterToNetwork, err error) {
	m.NLMContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("NLMICouldBeRouterToNetwork"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NLMICouldBeRouterToNetwork")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	destinationNetworkAddress, err := ReadSimpleField(ctx, "destinationNetworkAddress", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'destinationNetworkAddress' field"))
	}
	m.DestinationNetworkAddress = destinationNetworkAddress

	performanceIndex, err := ReadSimpleField(ctx, "performanceIndex", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'performanceIndex' field"))
	}
	m.PerformanceIndex = performanceIndex

	if closeErr := readBuffer.CloseContext("NLMICouldBeRouterToNetwork"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NLMICouldBeRouterToNetwork")
	}

	return m, nil
}

func (m *_NLMICouldBeRouterToNetwork) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NLMICouldBeRouterToNetwork) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("NLMICouldBeRouterToNetwork"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for NLMICouldBeRouterToNetwork")
		}

		if err := WriteSimpleField[uint16](ctx, "destinationNetworkAddress", m.GetDestinationNetworkAddress(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'destinationNetworkAddress' field")
		}

		if err := WriteSimpleField[uint8](ctx, "performanceIndex", m.GetPerformanceIndex(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'performanceIndex' field")
		}

		if popErr := writeBuffer.PopContext("NLMICouldBeRouterToNetwork"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for NLMICouldBeRouterToNetwork")
		}
		return nil
	}
	return m.NLMContract.(*_NLM).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_NLMICouldBeRouterToNetwork) IsNLMICouldBeRouterToNetwork() {}

func (m *_NLMICouldBeRouterToNetwork) DeepCopy() any {
	return m.deepCopy()
}

func (m *_NLMICouldBeRouterToNetwork) deepCopy() *_NLMICouldBeRouterToNetwork {
	if m == nil {
		return nil
	}
	_NLMICouldBeRouterToNetworkCopy := &_NLMICouldBeRouterToNetwork{
		m.NLMContract.(*_NLM).deepCopy(),
		m.DestinationNetworkAddress,
		m.PerformanceIndex,
	}
	_NLMICouldBeRouterToNetworkCopy.NLMContract.(*_NLM)._SubType = m
	return _NLMICouldBeRouterToNetworkCopy
}

func (m *_NLMICouldBeRouterToNetwork) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
