/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ConfirmedPrivateTransferError is the corresponding interface of ConfirmedPrivateTransferError
type ConfirmedPrivateTransferError interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetError
	// GetErrorType returns ErrorType (property field)
	GetErrorType() ErrorEnclosed
	// GetVendorId returns VendorId (property field)
	GetVendorId() BACnetVendorIdTagged
	// GetServiceNumber returns ServiceNumber (property field)
	GetServiceNumber() BACnetContextTagUnsignedInteger
	// GetErrorParameters returns ErrorParameters (property field)
	GetErrorParameters() BACnetConstructedData
	// IsConfirmedPrivateTransferError is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsConfirmedPrivateTransferError()
	// CreateBuilder creates a ConfirmedPrivateTransferErrorBuilder
	CreateConfirmedPrivateTransferErrorBuilder() ConfirmedPrivateTransferErrorBuilder
}

// _ConfirmedPrivateTransferError is the data-structure of this message
type _ConfirmedPrivateTransferError struct {
	BACnetErrorContract
	ErrorType       ErrorEnclosed
	VendorId        BACnetVendorIdTagged
	ServiceNumber   BACnetContextTagUnsignedInteger
	ErrorParameters BACnetConstructedData
}

var _ ConfirmedPrivateTransferError = (*_ConfirmedPrivateTransferError)(nil)
var _ BACnetErrorRequirements = (*_ConfirmedPrivateTransferError)(nil)

// NewConfirmedPrivateTransferError factory function for _ConfirmedPrivateTransferError
func NewConfirmedPrivateTransferError(errorType ErrorEnclosed, vendorId BACnetVendorIdTagged, serviceNumber BACnetContextTagUnsignedInteger, errorParameters BACnetConstructedData) *_ConfirmedPrivateTransferError {
	if errorType == nil {
		panic("errorType of type ErrorEnclosed for ConfirmedPrivateTransferError must not be nil")
	}
	if vendorId == nil {
		panic("vendorId of type BACnetVendorIdTagged for ConfirmedPrivateTransferError must not be nil")
	}
	if serviceNumber == nil {
		panic("serviceNumber of type BACnetContextTagUnsignedInteger for ConfirmedPrivateTransferError must not be nil")
	}
	_result := &_ConfirmedPrivateTransferError{
		BACnetErrorContract: NewBACnetError(),
		ErrorType:           errorType,
		VendorId:            vendorId,
		ServiceNumber:       serviceNumber,
		ErrorParameters:     errorParameters,
	}
	_result.BACnetErrorContract.(*_BACnetError)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ConfirmedPrivateTransferErrorBuilder is a builder for ConfirmedPrivateTransferError
type ConfirmedPrivateTransferErrorBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(errorType ErrorEnclosed, vendorId BACnetVendorIdTagged, serviceNumber BACnetContextTagUnsignedInteger) ConfirmedPrivateTransferErrorBuilder
	// WithErrorType adds ErrorType (property field)
	WithErrorType(ErrorEnclosed) ConfirmedPrivateTransferErrorBuilder
	// WithErrorTypeBuilder adds ErrorType (property field) which is build by the builder
	WithErrorTypeBuilder(func(ErrorEnclosedBuilder) ErrorEnclosedBuilder) ConfirmedPrivateTransferErrorBuilder
	// WithVendorId adds VendorId (property field)
	WithVendorId(BACnetVendorIdTagged) ConfirmedPrivateTransferErrorBuilder
	// WithVendorIdBuilder adds VendorId (property field) which is build by the builder
	WithVendorIdBuilder(func(BACnetVendorIdTaggedBuilder) BACnetVendorIdTaggedBuilder) ConfirmedPrivateTransferErrorBuilder
	// WithServiceNumber adds ServiceNumber (property field)
	WithServiceNumber(BACnetContextTagUnsignedInteger) ConfirmedPrivateTransferErrorBuilder
	// WithServiceNumberBuilder adds ServiceNumber (property field) which is build by the builder
	WithServiceNumberBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) ConfirmedPrivateTransferErrorBuilder
	// WithErrorParameters adds ErrorParameters (property field)
	WithOptionalErrorParameters(BACnetConstructedData) ConfirmedPrivateTransferErrorBuilder
	// WithOptionalErrorParametersBuilder adds ErrorParameters (property field) which is build by the builder
	WithOptionalErrorParametersBuilder(func(BACnetConstructedDataBuilder) BACnetConstructedDataBuilder) ConfirmedPrivateTransferErrorBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetErrorBuilder
	// Build builds the ConfirmedPrivateTransferError or returns an error if something is wrong
	Build() (ConfirmedPrivateTransferError, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ConfirmedPrivateTransferError
}

// NewConfirmedPrivateTransferErrorBuilder() creates a ConfirmedPrivateTransferErrorBuilder
func NewConfirmedPrivateTransferErrorBuilder() ConfirmedPrivateTransferErrorBuilder {
	return &_ConfirmedPrivateTransferErrorBuilder{_ConfirmedPrivateTransferError: new(_ConfirmedPrivateTransferError)}
}

type _ConfirmedPrivateTransferErrorBuilder struct {
	*_ConfirmedPrivateTransferError

	parentBuilder *_BACnetErrorBuilder

	err *utils.MultiError
}

var _ (ConfirmedPrivateTransferErrorBuilder) = (*_ConfirmedPrivateTransferErrorBuilder)(nil)

func (b *_ConfirmedPrivateTransferErrorBuilder) setParent(contract BACnetErrorContract) {
	b.BACnetErrorContract = contract
	contract.(*_BACnetError)._SubType = b._ConfirmedPrivateTransferError
}

func (b *_ConfirmedPrivateTransferErrorBuilder) WithMandatoryFields(errorType ErrorEnclosed, vendorId BACnetVendorIdTagged, serviceNumber BACnetContextTagUnsignedInteger) ConfirmedPrivateTransferErrorBuilder {
	return b.WithErrorType(errorType).WithVendorId(vendorId).WithServiceNumber(serviceNumber)
}

func (b *_ConfirmedPrivateTransferErrorBuilder) WithErrorType(errorType ErrorEnclosed) ConfirmedPrivateTransferErrorBuilder {
	b.ErrorType = errorType
	return b
}

func (b *_ConfirmedPrivateTransferErrorBuilder) WithErrorTypeBuilder(builderSupplier func(ErrorEnclosedBuilder) ErrorEnclosedBuilder) ConfirmedPrivateTransferErrorBuilder {
	builder := builderSupplier(b.ErrorType.CreateErrorEnclosedBuilder())
	var err error
	b.ErrorType, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "ErrorEnclosedBuilder failed"))
	}
	return b
}

func (b *_ConfirmedPrivateTransferErrorBuilder) WithVendorId(vendorId BACnetVendorIdTagged) ConfirmedPrivateTransferErrorBuilder {
	b.VendorId = vendorId
	return b
}

func (b *_ConfirmedPrivateTransferErrorBuilder) WithVendorIdBuilder(builderSupplier func(BACnetVendorIdTaggedBuilder) BACnetVendorIdTaggedBuilder) ConfirmedPrivateTransferErrorBuilder {
	builder := builderSupplier(b.VendorId.CreateBACnetVendorIdTaggedBuilder())
	var err error
	b.VendorId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetVendorIdTaggedBuilder failed"))
	}
	return b
}

func (b *_ConfirmedPrivateTransferErrorBuilder) WithServiceNumber(serviceNumber BACnetContextTagUnsignedInteger) ConfirmedPrivateTransferErrorBuilder {
	b.ServiceNumber = serviceNumber
	return b
}

func (b *_ConfirmedPrivateTransferErrorBuilder) WithServiceNumberBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) ConfirmedPrivateTransferErrorBuilder {
	builder := builderSupplier(b.ServiceNumber.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.ServiceNumber, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_ConfirmedPrivateTransferErrorBuilder) WithOptionalErrorParameters(errorParameters BACnetConstructedData) ConfirmedPrivateTransferErrorBuilder {
	b.ErrorParameters = errorParameters
	return b
}

func (b *_ConfirmedPrivateTransferErrorBuilder) WithOptionalErrorParametersBuilder(builderSupplier func(BACnetConstructedDataBuilder) BACnetConstructedDataBuilder) ConfirmedPrivateTransferErrorBuilder {
	builder := builderSupplier(b.ErrorParameters.CreateBACnetConstructedDataBuilder())
	var err error
	b.ErrorParameters, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetConstructedDataBuilder failed"))
	}
	return b
}

func (b *_ConfirmedPrivateTransferErrorBuilder) Build() (ConfirmedPrivateTransferError, error) {
	if b.ErrorType == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'errorType' not set"))
	}
	if b.VendorId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'vendorId' not set"))
	}
	if b.ServiceNumber == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'serviceNumber' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._ConfirmedPrivateTransferError.deepCopy(), nil
}

func (b *_ConfirmedPrivateTransferErrorBuilder) MustBuild() ConfirmedPrivateTransferError {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ConfirmedPrivateTransferErrorBuilder) Done() BACnetErrorBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetErrorBuilder().(*_BACnetErrorBuilder)
	}
	return b.parentBuilder
}

func (b *_ConfirmedPrivateTransferErrorBuilder) buildForBACnetError() (BACnetError, error) {
	return b.Build()
}

func (b *_ConfirmedPrivateTransferErrorBuilder) DeepCopy() any {
	_copy := b.CreateConfirmedPrivateTransferErrorBuilder().(*_ConfirmedPrivateTransferErrorBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateConfirmedPrivateTransferErrorBuilder creates a ConfirmedPrivateTransferErrorBuilder
func (b *_ConfirmedPrivateTransferError) CreateConfirmedPrivateTransferErrorBuilder() ConfirmedPrivateTransferErrorBuilder {
	if b == nil {
		return NewConfirmedPrivateTransferErrorBuilder()
	}
	return &_ConfirmedPrivateTransferErrorBuilder{_ConfirmedPrivateTransferError: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ConfirmedPrivateTransferError) GetErrorChoice() BACnetConfirmedServiceChoice {
	return BACnetConfirmedServiceChoice_CONFIRMED_PRIVATE_TRANSFER
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ConfirmedPrivateTransferError) GetParent() BACnetErrorContract {
	return m.BACnetErrorContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ConfirmedPrivateTransferError) GetErrorType() ErrorEnclosed {
	return m.ErrorType
}

func (m *_ConfirmedPrivateTransferError) GetVendorId() BACnetVendorIdTagged {
	return m.VendorId
}

func (m *_ConfirmedPrivateTransferError) GetServiceNumber() BACnetContextTagUnsignedInteger {
	return m.ServiceNumber
}

func (m *_ConfirmedPrivateTransferError) GetErrorParameters() BACnetConstructedData {
	return m.ErrorParameters
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastConfirmedPrivateTransferError(structType any) ConfirmedPrivateTransferError {
	if casted, ok := structType.(ConfirmedPrivateTransferError); ok {
		return casted
	}
	if casted, ok := structType.(*ConfirmedPrivateTransferError); ok {
		return *casted
	}
	return nil
}

func (m *_ConfirmedPrivateTransferError) GetTypeName() string {
	return "ConfirmedPrivateTransferError"
}

func (m *_ConfirmedPrivateTransferError) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetErrorContract.(*_BACnetError).getLengthInBits(ctx))

	// Simple field (errorType)
	lengthInBits += m.ErrorType.GetLengthInBits(ctx)

	// Simple field (vendorId)
	lengthInBits += m.VendorId.GetLengthInBits(ctx)

	// Simple field (serviceNumber)
	lengthInBits += m.ServiceNumber.GetLengthInBits(ctx)

	// Optional Field (errorParameters)
	if m.ErrorParameters != nil {
		lengthInBits += m.ErrorParameters.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_ConfirmedPrivateTransferError) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ConfirmedPrivateTransferError) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetError, errorChoice BACnetConfirmedServiceChoice) (__confirmedPrivateTransferError ConfirmedPrivateTransferError, err error) {
	m.BACnetErrorContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ConfirmedPrivateTransferError"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ConfirmedPrivateTransferError")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	errorType, err := ReadSimpleField[ErrorEnclosed](ctx, "errorType", ReadComplex[ErrorEnclosed](ErrorEnclosedParseWithBufferProducer((uint8)(uint8(0))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'errorType' field"))
	}
	m.ErrorType = errorType

	vendorId, err := ReadSimpleField[BACnetVendorIdTagged](ctx, "vendorId", ReadComplex[BACnetVendorIdTagged](BACnetVendorIdTaggedParseWithBufferProducer((uint8)(uint8(1)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'vendorId' field"))
	}
	m.VendorId = vendorId

	serviceNumber, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "serviceNumber", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(2)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'serviceNumber' field"))
	}
	m.ServiceNumber = serviceNumber

	var errorParameters BACnetConstructedData
	_errorParameters, err := ReadOptionalField[BACnetConstructedData](ctx, "errorParameters", ReadComplex[BACnetConstructedData](BACnetConstructedDataParseWithBufferProducer[BACnetConstructedData]((uint8)(uint8(3)), (BACnetObjectType)(BACnetObjectType_VENDOR_PROPRIETARY_VALUE), (BACnetPropertyIdentifier)(BACnetPropertyIdentifier_VENDOR_PROPRIETARY_VALUE), (BACnetTagPayloadUnsignedInteger)(nil)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'errorParameters' field"))
	}
	if _errorParameters != nil {
		errorParameters = *_errorParameters
		m.ErrorParameters = errorParameters
	}

	if closeErr := readBuffer.CloseContext("ConfirmedPrivateTransferError"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ConfirmedPrivateTransferError")
	}

	return m, nil
}

func (m *_ConfirmedPrivateTransferError) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ConfirmedPrivateTransferError) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ConfirmedPrivateTransferError"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ConfirmedPrivateTransferError")
		}

		if err := WriteSimpleField[ErrorEnclosed](ctx, "errorType", m.GetErrorType(), WriteComplex[ErrorEnclosed](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'errorType' field")
		}

		if err := WriteSimpleField[BACnetVendorIdTagged](ctx, "vendorId", m.GetVendorId(), WriteComplex[BACnetVendorIdTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'vendorId' field")
		}

		if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "serviceNumber", m.GetServiceNumber(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'serviceNumber' field")
		}

		if err := WriteOptionalField[BACnetConstructedData](ctx, "errorParameters", GetRef(m.GetErrorParameters()), WriteComplex[BACnetConstructedData](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'errorParameters' field")
		}

		if popErr := writeBuffer.PopContext("ConfirmedPrivateTransferError"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ConfirmedPrivateTransferError")
		}
		return nil
	}
	return m.BACnetErrorContract.(*_BACnetError).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ConfirmedPrivateTransferError) IsConfirmedPrivateTransferError() {}

func (m *_ConfirmedPrivateTransferError) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ConfirmedPrivateTransferError) deepCopy() *_ConfirmedPrivateTransferError {
	if m == nil {
		return nil
	}
	_ConfirmedPrivateTransferErrorCopy := &_ConfirmedPrivateTransferError{
		m.BACnetErrorContract.(*_BACnetError).deepCopy(),
		utils.DeepCopy[ErrorEnclosed](m.ErrorType),
		utils.DeepCopy[BACnetVendorIdTagged](m.VendorId),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.ServiceNumber),
		utils.DeepCopy[BACnetConstructedData](m.ErrorParameters),
	}
	_ConfirmedPrivateTransferErrorCopy.BACnetErrorContract.(*_BACnetError)._SubType = m
	return _ConfirmedPrivateTransferErrorCopy
}

func (m *_ConfirmedPrivateTransferError) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
