/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"encoding/binary"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/codegen"
	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BVLCOriginalUnicastNPDU is the corresponding interface of BVLCOriginalUnicastNPDU
type BVLCOriginalUnicastNPDU interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BVLC
	// GetNpdu returns Npdu (property field)
	GetNpdu() NPDU
	// IsBVLCOriginalUnicastNPDU is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBVLCOriginalUnicastNPDU()
	// CreateBuilder creates a BVLCOriginalUnicastNPDUBuilder
	CreateBVLCOriginalUnicastNPDUBuilder() BVLCOriginalUnicastNPDUBuilder
}

// _BVLCOriginalUnicastNPDU is the data-structure of this message
type _BVLCOriginalUnicastNPDU struct {
	BVLCContract
	Npdu NPDU

	// Arguments.
	BvlcPayloadLength uint16
}

var _ BVLCOriginalUnicastNPDU = (*_BVLCOriginalUnicastNPDU)(nil)
var _ BVLCRequirements = (*_BVLCOriginalUnicastNPDU)(nil)

// NewBVLCOriginalUnicastNPDU factory function for _BVLCOriginalUnicastNPDU
func NewBVLCOriginalUnicastNPDU(npdu NPDU, bvlcPayloadLength uint16) *_BVLCOriginalUnicastNPDU {
	if npdu == nil {
		panic("npdu of type NPDU for BVLCOriginalUnicastNPDU must not be nil")
	}
	_result := &_BVLCOriginalUnicastNPDU{
		BVLCContract: NewBVLC(),
		Npdu:         npdu,
	}
	_result.BVLCContract.(*_BVLC)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BVLCOriginalUnicastNPDUBuilder is a builder for BVLCOriginalUnicastNPDU
type BVLCOriginalUnicastNPDUBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(npdu NPDU) BVLCOriginalUnicastNPDUBuilder
	// WithNpdu adds Npdu (property field)
	WithNpdu(NPDU) BVLCOriginalUnicastNPDUBuilder
	// WithNpduBuilder adds Npdu (property field) which is build by the builder
	WithNpduBuilder(func(NPDUBuilder) NPDUBuilder) BVLCOriginalUnicastNPDUBuilder
	// WithArgBvlcPayloadLength sets a parser argument
	WithArgBvlcPayloadLength(uint16) BVLCOriginalUnicastNPDUBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BVLCBuilder
	// Build builds the BVLCOriginalUnicastNPDU or returns an error if something is wrong
	Build() (BVLCOriginalUnicastNPDU, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BVLCOriginalUnicastNPDU
}

// NewBVLCOriginalUnicastNPDUBuilder() creates a BVLCOriginalUnicastNPDUBuilder
func NewBVLCOriginalUnicastNPDUBuilder() BVLCOriginalUnicastNPDUBuilder {
	return &_BVLCOriginalUnicastNPDUBuilder{_BVLCOriginalUnicastNPDU: new(_BVLCOriginalUnicastNPDU)}
}

type _BVLCOriginalUnicastNPDUBuilder struct {
	*_BVLCOriginalUnicastNPDU

	parentBuilder *_BVLCBuilder

	err *utils.MultiError
}

var _ (BVLCOriginalUnicastNPDUBuilder) = (*_BVLCOriginalUnicastNPDUBuilder)(nil)

func (b *_BVLCOriginalUnicastNPDUBuilder) setParent(contract BVLCContract) {
	b.BVLCContract = contract
	contract.(*_BVLC)._SubType = b._BVLCOriginalUnicastNPDU
}

func (b *_BVLCOriginalUnicastNPDUBuilder) WithMandatoryFields(npdu NPDU) BVLCOriginalUnicastNPDUBuilder {
	return b.WithNpdu(npdu)
}

func (b *_BVLCOriginalUnicastNPDUBuilder) WithNpdu(npdu NPDU) BVLCOriginalUnicastNPDUBuilder {
	b.Npdu = npdu
	return b
}

func (b *_BVLCOriginalUnicastNPDUBuilder) WithNpduBuilder(builderSupplier func(NPDUBuilder) NPDUBuilder) BVLCOriginalUnicastNPDUBuilder {
	builder := builderSupplier(b.Npdu.CreateNPDUBuilder())
	var err error
	b.Npdu, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "NPDUBuilder failed"))
	}
	return b
}

func (b *_BVLCOriginalUnicastNPDUBuilder) WithArgBvlcPayloadLength(bvlcPayloadLength uint16) BVLCOriginalUnicastNPDUBuilder {
	b.BvlcPayloadLength = bvlcPayloadLength
	return b
}

func (b *_BVLCOriginalUnicastNPDUBuilder) Build() (BVLCOriginalUnicastNPDU, error) {
	if b.Npdu == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'npdu' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BVLCOriginalUnicastNPDU.deepCopy(), nil
}

func (b *_BVLCOriginalUnicastNPDUBuilder) MustBuild() BVLCOriginalUnicastNPDU {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BVLCOriginalUnicastNPDUBuilder) Done() BVLCBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBVLCBuilder().(*_BVLCBuilder)
	}
	return b.parentBuilder
}

func (b *_BVLCOriginalUnicastNPDUBuilder) buildForBVLC() (BVLC, error) {
	return b.Build()
}

func (b *_BVLCOriginalUnicastNPDUBuilder) DeepCopy() any {
	_copy := b.CreateBVLCOriginalUnicastNPDUBuilder().(*_BVLCOriginalUnicastNPDUBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBVLCOriginalUnicastNPDUBuilder creates a BVLCOriginalUnicastNPDUBuilder
func (b *_BVLCOriginalUnicastNPDU) CreateBVLCOriginalUnicastNPDUBuilder() BVLCOriginalUnicastNPDUBuilder {
	if b == nil {
		return NewBVLCOriginalUnicastNPDUBuilder()
	}
	return &_BVLCOriginalUnicastNPDUBuilder{_BVLCOriginalUnicastNPDU: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BVLCOriginalUnicastNPDU) GetBvlcFunction() uint8 {
	return 0x0A
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BVLCOriginalUnicastNPDU) GetParent() BVLCContract {
	return m.BVLCContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BVLCOriginalUnicastNPDU) GetNpdu() NPDU {
	return m.Npdu
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBVLCOriginalUnicastNPDU(structType any) BVLCOriginalUnicastNPDU {
	if casted, ok := structType.(BVLCOriginalUnicastNPDU); ok {
		return casted
	}
	if casted, ok := structType.(*BVLCOriginalUnicastNPDU); ok {
		return *casted
	}
	return nil
}

func (m *_BVLCOriginalUnicastNPDU) GetTypeName() string {
	return "BVLCOriginalUnicastNPDU"
}

func (m *_BVLCOriginalUnicastNPDU) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BVLCContract.(*_BVLC).getLengthInBits(ctx))

	// Simple field (npdu)
	lengthInBits += m.Npdu.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BVLCOriginalUnicastNPDU) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BVLCOriginalUnicastNPDU) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BVLC, bvlcPayloadLength uint16) (__bVLCOriginalUnicastNPDU BVLCOriginalUnicastNPDU, err error) {
	m.BVLCContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BVLCOriginalUnicastNPDU"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BVLCOriginalUnicastNPDU")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	npdu, err := ReadSimpleField[NPDU](ctx, "npdu", ReadComplex[NPDU](NPDUParseWithBufferProducer((uint16)(bvlcPayloadLength)), readBuffer), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'npdu' field"))
	}
	m.Npdu = npdu

	if closeErr := readBuffer.CloseContext("BVLCOriginalUnicastNPDU"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BVLCOriginalUnicastNPDU")
	}

	return m, nil
}

func (m *_BVLCOriginalUnicastNPDU) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))), utils.WithByteOrderForByteBasedBuffer(binary.BigEndian))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BVLCOriginalUnicastNPDU) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BVLCOriginalUnicastNPDU"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BVLCOriginalUnicastNPDU")
		}

		if err := WriteSimpleField[NPDU](ctx, "npdu", m.GetNpdu(), WriteComplex[NPDU](writeBuffer), codegen.WithByteOrder(binary.BigEndian)); err != nil {
			return errors.Wrap(err, "Error serializing 'npdu' field")
		}

		if popErr := writeBuffer.PopContext("BVLCOriginalUnicastNPDU"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BVLCOriginalUnicastNPDU")
		}
		return nil
	}
	return m.BVLCContract.(*_BVLC).serializeParent(ctx, writeBuffer, m, ser)
}

////
// Arguments Getter

func (m *_BVLCOriginalUnicastNPDU) GetBvlcPayloadLength() uint16 {
	return m.BvlcPayloadLength
}

//
////

func (m *_BVLCOriginalUnicastNPDU) IsBVLCOriginalUnicastNPDU() {}

func (m *_BVLCOriginalUnicastNPDU) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BVLCOriginalUnicastNPDU) deepCopy() *_BVLCOriginalUnicastNPDU {
	if m == nil {
		return nil
	}
	_BVLCOriginalUnicastNPDUCopy := &_BVLCOriginalUnicastNPDU{
		m.BVLCContract.(*_BVLC).deepCopy(),
		utils.DeepCopy[NPDU](m.Npdu),
		m.BvlcPayloadLength,
	}
	_BVLCOriginalUnicastNPDUCopy.BVLCContract.(*_BVLC)._SubType = m
	return _BVLCOriginalUnicastNPDUCopy
}

func (m *_BVLCOriginalUnicastNPDU) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
