/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"encoding/binary"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/codegen"
	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const BVLC_BACNETTYPE uint8 = 0x81

// BVLC is the corresponding interface of BVLC
type BVLC interface {
	BVLCContract
	BVLCRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBVLC is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBVLC()
	// CreateBuilder creates a BVLCBuilder
	CreateBVLCBuilder() BVLCBuilder
}

// BVLCContract provides a set of functions which can be overwritten by a sub struct
type BVLCContract interface {
	// GetBvlcPayloadLength returns BvlcPayloadLength (virtual field)
	GetBvlcPayloadLength() uint16
	// IsBVLC is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBVLC()
	// CreateBuilder creates a BVLCBuilder
	CreateBVLCBuilder() BVLCBuilder
}

// BVLCRequirements provides a set of functions which need to be implemented by a sub struct
type BVLCRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetBvlcFunction returns BvlcFunction (discriminator field)
	GetBvlcFunction() uint8
}

// _BVLC is the data-structure of this message
type _BVLC struct {
	_SubType interface {
		BVLCContract
		BVLCRequirements
	}
}

var _ BVLCContract = (*_BVLC)(nil)

// NewBVLC factory function for _BVLC
func NewBVLC() *_BVLC {
	return &_BVLC{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BVLCBuilder is a builder for BVLC
type BVLCBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BVLCBuilder
	// AsBVLCResult converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCResult() BVLCResultBuilder
	// AsBVLCWriteBroadcastDistributionTable converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCWriteBroadcastDistributionTable() BVLCWriteBroadcastDistributionTableBuilder
	// AsBVLCReadBroadcastDistributionTable converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCReadBroadcastDistributionTable() BVLCReadBroadcastDistributionTableBuilder
	// AsBVLCReadBroadcastDistributionTableAck converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCReadBroadcastDistributionTableAck() BVLCReadBroadcastDistributionTableAckBuilder
	// AsBVLCForwardedNPDU converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCForwardedNPDU() BVLCForwardedNPDUBuilder
	// AsBVLCRegisterForeignDevice converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCRegisterForeignDevice() BVLCRegisterForeignDeviceBuilder
	// AsBVLCReadForeignDeviceTable converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCReadForeignDeviceTable() BVLCReadForeignDeviceTableBuilder
	// AsBVLCReadForeignDeviceTableAck converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCReadForeignDeviceTableAck() BVLCReadForeignDeviceTableAckBuilder
	// AsBVLCDeleteForeignDeviceTableEntry converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCDeleteForeignDeviceTableEntry() BVLCDeleteForeignDeviceTableEntryBuilder
	// AsBVLCDistributeBroadcastToNetwork converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCDistributeBroadcastToNetwork() BVLCDistributeBroadcastToNetworkBuilder
	// AsBVLCOriginalUnicastNPDU converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCOriginalUnicastNPDU() BVLCOriginalUnicastNPDUBuilder
	// AsBVLCOriginalBroadcastNPDU converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCOriginalBroadcastNPDU() BVLCOriginalBroadcastNPDUBuilder
	// AsBVLCSecureBVLL converts this build to a subType of BVLC. It is always possible to return to current builder using Done()
	AsBVLCSecureBVLL() BVLCSecureBVLLBuilder
	// Build builds the BVLC or returns an error if something is wrong
	PartialBuild() (BVLCContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BVLCContract
	// Build builds the BVLC or returns an error if something is wrong
	Build() (BVLC, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BVLC
}

// NewBVLCBuilder() creates a BVLCBuilder
func NewBVLCBuilder() BVLCBuilder {
	return &_BVLCBuilder{_BVLC: new(_BVLC)}
}

type _BVLCChildBuilder interface {
	utils.Copyable
	setParent(BVLCContract)
	buildForBVLC() (BVLC, error)
}

type _BVLCBuilder struct {
	*_BVLC

	childBuilder _BVLCChildBuilder

	err *utils.MultiError
}

var _ (BVLCBuilder) = (*_BVLCBuilder)(nil)

func (b *_BVLCBuilder) WithMandatoryFields() BVLCBuilder {
	return b
}

func (b *_BVLCBuilder) PartialBuild() (BVLCContract, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BVLC.deepCopy(), nil
}

func (b *_BVLCBuilder) PartialMustBuild() BVLCContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BVLCBuilder) AsBVLCResult() BVLCResultBuilder {
	if cb, ok := b.childBuilder.(BVLCResultBuilder); ok {
		return cb
	}
	cb := NewBVLCResultBuilder().(*_BVLCResultBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) AsBVLCWriteBroadcastDistributionTable() BVLCWriteBroadcastDistributionTableBuilder {
	if cb, ok := b.childBuilder.(BVLCWriteBroadcastDistributionTableBuilder); ok {
		return cb
	}
	cb := NewBVLCWriteBroadcastDistributionTableBuilder().(*_BVLCWriteBroadcastDistributionTableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) AsBVLCReadBroadcastDistributionTable() BVLCReadBroadcastDistributionTableBuilder {
	if cb, ok := b.childBuilder.(BVLCReadBroadcastDistributionTableBuilder); ok {
		return cb
	}
	cb := NewBVLCReadBroadcastDistributionTableBuilder().(*_BVLCReadBroadcastDistributionTableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) AsBVLCReadBroadcastDistributionTableAck() BVLCReadBroadcastDistributionTableAckBuilder {
	if cb, ok := b.childBuilder.(BVLCReadBroadcastDistributionTableAckBuilder); ok {
		return cb
	}
	cb := NewBVLCReadBroadcastDistributionTableAckBuilder().(*_BVLCReadBroadcastDistributionTableAckBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) AsBVLCForwardedNPDU() BVLCForwardedNPDUBuilder {
	if cb, ok := b.childBuilder.(BVLCForwardedNPDUBuilder); ok {
		return cb
	}
	cb := NewBVLCForwardedNPDUBuilder().(*_BVLCForwardedNPDUBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) AsBVLCRegisterForeignDevice() BVLCRegisterForeignDeviceBuilder {
	if cb, ok := b.childBuilder.(BVLCRegisterForeignDeviceBuilder); ok {
		return cb
	}
	cb := NewBVLCRegisterForeignDeviceBuilder().(*_BVLCRegisterForeignDeviceBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) AsBVLCReadForeignDeviceTable() BVLCReadForeignDeviceTableBuilder {
	if cb, ok := b.childBuilder.(BVLCReadForeignDeviceTableBuilder); ok {
		return cb
	}
	cb := NewBVLCReadForeignDeviceTableBuilder().(*_BVLCReadForeignDeviceTableBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) AsBVLCReadForeignDeviceTableAck() BVLCReadForeignDeviceTableAckBuilder {
	if cb, ok := b.childBuilder.(BVLCReadForeignDeviceTableAckBuilder); ok {
		return cb
	}
	cb := NewBVLCReadForeignDeviceTableAckBuilder().(*_BVLCReadForeignDeviceTableAckBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) AsBVLCDeleteForeignDeviceTableEntry() BVLCDeleteForeignDeviceTableEntryBuilder {
	if cb, ok := b.childBuilder.(BVLCDeleteForeignDeviceTableEntryBuilder); ok {
		return cb
	}
	cb := NewBVLCDeleteForeignDeviceTableEntryBuilder().(*_BVLCDeleteForeignDeviceTableEntryBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) AsBVLCDistributeBroadcastToNetwork() BVLCDistributeBroadcastToNetworkBuilder {
	if cb, ok := b.childBuilder.(BVLCDistributeBroadcastToNetworkBuilder); ok {
		return cb
	}
	cb := NewBVLCDistributeBroadcastToNetworkBuilder().(*_BVLCDistributeBroadcastToNetworkBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) AsBVLCOriginalUnicastNPDU() BVLCOriginalUnicastNPDUBuilder {
	if cb, ok := b.childBuilder.(BVLCOriginalUnicastNPDUBuilder); ok {
		return cb
	}
	cb := NewBVLCOriginalUnicastNPDUBuilder().(*_BVLCOriginalUnicastNPDUBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) AsBVLCOriginalBroadcastNPDU() BVLCOriginalBroadcastNPDUBuilder {
	if cb, ok := b.childBuilder.(BVLCOriginalBroadcastNPDUBuilder); ok {
		return cb
	}
	cb := NewBVLCOriginalBroadcastNPDUBuilder().(*_BVLCOriginalBroadcastNPDUBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) AsBVLCSecureBVLL() BVLCSecureBVLLBuilder {
	if cb, ok := b.childBuilder.(BVLCSecureBVLLBuilder); ok {
		return cb
	}
	cb := NewBVLCSecureBVLLBuilder().(*_BVLCSecureBVLLBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BVLCBuilder) Build() (BVLC, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBVLC()
}

func (b *_BVLCBuilder) MustBuild() BVLC {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BVLCBuilder) DeepCopy() any {
	_copy := b.CreateBVLCBuilder().(*_BVLCBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BVLCChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBVLCBuilder creates a BVLCBuilder
func (b *_BVLC) CreateBVLCBuilder() BVLCBuilder {
	if b == nil {
		return NewBVLCBuilder()
	}
	return &_BVLCBuilder{_BVLC: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BVLC) GetBvlcPayloadLength() uint16 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint16(uint16(uint16(m.GetLengthInBytes(ctx))) - uint16(uint16(4)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_BVLC) GetBacnetType() uint8 {
	return BVLC_BACNETTYPE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBVLC(structType any) BVLC {
	if casted, ok := structType.(BVLC); ok {
		return casted
	}
	if casted, ok := structType.(*BVLC); ok {
		return *casted
	}
	return nil
}

func (m *_BVLC) GetTypeName() string {
	return "BVLC"
}

func (m *_BVLC) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Const Field (bacnetType)
	lengthInBits += 8
	// Discriminator Field (bvlcFunction)
	lengthInBits += 8

	// Implicit Field (bvlcLength)
	lengthInBits += 16

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BVLC) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BVLC) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BVLCParse[T BVLC](ctx context.Context, theBytes []byte) (T, error) {
	return BVLCParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes, utils.WithByteOrderForReadBufferByteBased(binary.BigEndian)))
}

func BVLCParseWithBufferProducer[T BVLC]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BVLCParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BVLCParseWithBuffer[T BVLC](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_BVLC{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BVLC) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bVLC BVLC, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BVLC"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BVLC")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	bacnetType, err := ReadConstField[uint8](ctx, "bacnetType", ReadUnsignedByte(readBuffer, uint8(8)), BVLC_BACNETTYPE, codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bacnetType' field"))
	}
	_ = bacnetType

	bvlcFunction, err := ReadDiscriminatorField[uint8](ctx, "bvlcFunction", ReadUnsignedByte(readBuffer, uint8(8)), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bvlcFunction' field"))
	}

	bvlcLength, err := ReadImplicitField[uint16](ctx, "bvlcLength", ReadUnsignedShort(readBuffer, uint8(16)), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bvlcLength' field"))
	}
	_ = bvlcLength

	bvlcPayloadLength, err := ReadVirtualField[uint16](ctx, "bvlcPayloadLength", (*uint16)(nil), uint16(bvlcLength)-uint16(uint16(4)), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bvlcPayloadLength' field"))
	}
	_ = bvlcPayloadLength

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BVLC
	switch {
	case bvlcFunction == 0x00: // BVLCResult
		if _child, err = new(_BVLCResult).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCResult for type-switch of BVLC")
		}
	case bvlcFunction == 0x01: // BVLCWriteBroadcastDistributionTable
		if _child, err = new(_BVLCWriteBroadcastDistributionTable).parse(ctx, readBuffer, m, bvlcPayloadLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCWriteBroadcastDistributionTable for type-switch of BVLC")
		}
	case bvlcFunction == 0x02: // BVLCReadBroadcastDistributionTable
		if _child, err = new(_BVLCReadBroadcastDistributionTable).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCReadBroadcastDistributionTable for type-switch of BVLC")
		}
	case bvlcFunction == 0x03: // BVLCReadBroadcastDistributionTableAck
		if _child, err = new(_BVLCReadBroadcastDistributionTableAck).parse(ctx, readBuffer, m, bvlcPayloadLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCReadBroadcastDistributionTableAck for type-switch of BVLC")
		}
	case bvlcFunction == 0x04: // BVLCForwardedNPDU
		if _child, err = new(_BVLCForwardedNPDU).parse(ctx, readBuffer, m, bvlcPayloadLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCForwardedNPDU for type-switch of BVLC")
		}
	case bvlcFunction == 0x05: // BVLCRegisterForeignDevice
		if _child, err = new(_BVLCRegisterForeignDevice).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCRegisterForeignDevice for type-switch of BVLC")
		}
	case bvlcFunction == 0x06: // BVLCReadForeignDeviceTable
		if _child, err = new(_BVLCReadForeignDeviceTable).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCReadForeignDeviceTable for type-switch of BVLC")
		}
	case bvlcFunction == 0x07: // BVLCReadForeignDeviceTableAck
		if _child, err = new(_BVLCReadForeignDeviceTableAck).parse(ctx, readBuffer, m, bvlcPayloadLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCReadForeignDeviceTableAck for type-switch of BVLC")
		}
	case bvlcFunction == 0x08: // BVLCDeleteForeignDeviceTableEntry
		if _child, err = new(_BVLCDeleteForeignDeviceTableEntry).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCDeleteForeignDeviceTableEntry for type-switch of BVLC")
		}
	case bvlcFunction == 0x09: // BVLCDistributeBroadcastToNetwork
		if _child, err = new(_BVLCDistributeBroadcastToNetwork).parse(ctx, readBuffer, m, bvlcPayloadLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCDistributeBroadcastToNetwork for type-switch of BVLC")
		}
	case bvlcFunction == 0x0A: // BVLCOriginalUnicastNPDU
		if _child, err = new(_BVLCOriginalUnicastNPDU).parse(ctx, readBuffer, m, bvlcPayloadLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCOriginalUnicastNPDU for type-switch of BVLC")
		}
	case bvlcFunction == 0x0B: // BVLCOriginalBroadcastNPDU
		if _child, err = new(_BVLCOriginalBroadcastNPDU).parse(ctx, readBuffer, m, bvlcPayloadLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCOriginalBroadcastNPDU for type-switch of BVLC")
		}
	case bvlcFunction == 0x0C: // BVLCSecureBVLL
		if _child, err = new(_BVLCSecureBVLL).parse(ctx, readBuffer, m, bvlcPayloadLength); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BVLCSecureBVLL for type-switch of BVLC")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [bvlcFunction=%v]", bvlcFunction)
	}

	if closeErr := readBuffer.CloseContext("BVLC"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BVLC")
	}

	return _child, nil
}

func (pm *_BVLC) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BVLC, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BVLC"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BVLC")
	}

	if err := WriteConstField(ctx, "bacnetType", BVLC_BACNETTYPE, WriteUnsignedByte(writeBuffer, 8), codegen.WithByteOrder(binary.BigEndian)); err != nil {
		return errors.Wrap(err, "Error serializing 'bacnetType' field")
	}

	if err := WriteDiscriminatorField(ctx, "bvlcFunction", m.GetBvlcFunction(), WriteUnsignedByte(writeBuffer, 8), codegen.WithByteOrder(binary.BigEndian)); err != nil {
		return errors.Wrap(err, "Error serializing 'bvlcFunction' field")
	}
	bvlcLength := uint16(uint16(m.GetLengthInBytes(ctx)))
	if err := WriteImplicitField(ctx, "bvlcLength", bvlcLength, WriteUnsignedShort(writeBuffer, 16), codegen.WithByteOrder(binary.BigEndian)); err != nil {
		return errors.Wrap(err, "Error serializing 'bvlcLength' field")
	}
	// Virtual field
	bvlcPayloadLength := m.GetBvlcPayloadLength()
	_ = bvlcPayloadLength
	if _bvlcPayloadLengthErr := writeBuffer.WriteVirtual(ctx, "bvlcPayloadLength", m.GetBvlcPayloadLength()); _bvlcPayloadLengthErr != nil {
		return errors.Wrap(_bvlcPayloadLengthErr, "Error serializing 'bvlcPayloadLength' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BVLC"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BVLC")
	}
	return nil
}

func (m *_BVLC) IsBVLC() {}

func (m *_BVLC) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BVLC) deepCopy() *_BVLC {
	if m == nil {
		return nil
	}
	_BVLCCopy := &_BVLC{
		nil, // will be set by child
	}
	return _BVLCCopy
}
