/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetVTSession is the corresponding interface of BACnetVTSession
type BACnetVTSession interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetLocalVtSessionId returns LocalVtSessionId (property field)
	GetLocalVtSessionId() BACnetApplicationTagUnsignedInteger
	// GetRemoveVtSessionId returns RemoveVtSessionId (property field)
	GetRemoveVtSessionId() BACnetApplicationTagUnsignedInteger
	// GetRemoteVtAddress returns RemoteVtAddress (property field)
	GetRemoteVtAddress() BACnetAddress
	// IsBACnetVTSession is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetVTSession()
	// CreateBuilder creates a BACnetVTSessionBuilder
	CreateBACnetVTSessionBuilder() BACnetVTSessionBuilder
}

// _BACnetVTSession is the data-structure of this message
type _BACnetVTSession struct {
	LocalVtSessionId  BACnetApplicationTagUnsignedInteger
	RemoveVtSessionId BACnetApplicationTagUnsignedInteger
	RemoteVtAddress   BACnetAddress
}

var _ BACnetVTSession = (*_BACnetVTSession)(nil)

// NewBACnetVTSession factory function for _BACnetVTSession
func NewBACnetVTSession(localVtSessionId BACnetApplicationTagUnsignedInteger, removeVtSessionId BACnetApplicationTagUnsignedInteger, remoteVtAddress BACnetAddress) *_BACnetVTSession {
	if localVtSessionId == nil {
		panic("localVtSessionId of type BACnetApplicationTagUnsignedInteger for BACnetVTSession must not be nil")
	}
	if removeVtSessionId == nil {
		panic("removeVtSessionId of type BACnetApplicationTagUnsignedInteger for BACnetVTSession must not be nil")
	}
	if remoteVtAddress == nil {
		panic("remoteVtAddress of type BACnetAddress for BACnetVTSession must not be nil")
	}
	return &_BACnetVTSession{LocalVtSessionId: localVtSessionId, RemoveVtSessionId: removeVtSessionId, RemoteVtAddress: remoteVtAddress}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetVTSessionBuilder is a builder for BACnetVTSession
type BACnetVTSessionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(localVtSessionId BACnetApplicationTagUnsignedInteger, removeVtSessionId BACnetApplicationTagUnsignedInteger, remoteVtAddress BACnetAddress) BACnetVTSessionBuilder
	// WithLocalVtSessionId adds LocalVtSessionId (property field)
	WithLocalVtSessionId(BACnetApplicationTagUnsignedInteger) BACnetVTSessionBuilder
	// WithLocalVtSessionIdBuilder adds LocalVtSessionId (property field) which is build by the builder
	WithLocalVtSessionIdBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetVTSessionBuilder
	// WithRemoveVtSessionId adds RemoveVtSessionId (property field)
	WithRemoveVtSessionId(BACnetApplicationTagUnsignedInteger) BACnetVTSessionBuilder
	// WithRemoveVtSessionIdBuilder adds RemoveVtSessionId (property field) which is build by the builder
	WithRemoveVtSessionIdBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetVTSessionBuilder
	// WithRemoteVtAddress adds RemoteVtAddress (property field)
	WithRemoteVtAddress(BACnetAddress) BACnetVTSessionBuilder
	// WithRemoteVtAddressBuilder adds RemoteVtAddress (property field) which is build by the builder
	WithRemoteVtAddressBuilder(func(BACnetAddressBuilder) BACnetAddressBuilder) BACnetVTSessionBuilder
	// Build builds the BACnetVTSession or returns an error if something is wrong
	Build() (BACnetVTSession, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetVTSession
}

// NewBACnetVTSessionBuilder() creates a BACnetVTSessionBuilder
func NewBACnetVTSessionBuilder() BACnetVTSessionBuilder {
	return &_BACnetVTSessionBuilder{_BACnetVTSession: new(_BACnetVTSession)}
}

type _BACnetVTSessionBuilder struct {
	*_BACnetVTSession

	err *utils.MultiError
}

var _ (BACnetVTSessionBuilder) = (*_BACnetVTSessionBuilder)(nil)

func (b *_BACnetVTSessionBuilder) WithMandatoryFields(localVtSessionId BACnetApplicationTagUnsignedInteger, removeVtSessionId BACnetApplicationTagUnsignedInteger, remoteVtAddress BACnetAddress) BACnetVTSessionBuilder {
	return b.WithLocalVtSessionId(localVtSessionId).WithRemoveVtSessionId(removeVtSessionId).WithRemoteVtAddress(remoteVtAddress)
}

func (b *_BACnetVTSessionBuilder) WithLocalVtSessionId(localVtSessionId BACnetApplicationTagUnsignedInteger) BACnetVTSessionBuilder {
	b.LocalVtSessionId = localVtSessionId
	return b
}

func (b *_BACnetVTSessionBuilder) WithLocalVtSessionIdBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetVTSessionBuilder {
	builder := builderSupplier(b.LocalVtSessionId.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.LocalVtSessionId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetVTSessionBuilder) WithRemoveVtSessionId(removeVtSessionId BACnetApplicationTagUnsignedInteger) BACnetVTSessionBuilder {
	b.RemoveVtSessionId = removeVtSessionId
	return b
}

func (b *_BACnetVTSessionBuilder) WithRemoveVtSessionIdBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetVTSessionBuilder {
	builder := builderSupplier(b.RemoveVtSessionId.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.RemoveVtSessionId, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetVTSessionBuilder) WithRemoteVtAddress(remoteVtAddress BACnetAddress) BACnetVTSessionBuilder {
	b.RemoteVtAddress = remoteVtAddress
	return b
}

func (b *_BACnetVTSessionBuilder) WithRemoteVtAddressBuilder(builderSupplier func(BACnetAddressBuilder) BACnetAddressBuilder) BACnetVTSessionBuilder {
	builder := builderSupplier(b.RemoteVtAddress.CreateBACnetAddressBuilder())
	var err error
	b.RemoteVtAddress, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetAddressBuilder failed"))
	}
	return b
}

func (b *_BACnetVTSessionBuilder) Build() (BACnetVTSession, error) {
	if b.LocalVtSessionId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'localVtSessionId' not set"))
	}
	if b.RemoveVtSessionId == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'removeVtSessionId' not set"))
	}
	if b.RemoteVtAddress == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'remoteVtAddress' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetVTSession.deepCopy(), nil
}

func (b *_BACnetVTSessionBuilder) MustBuild() BACnetVTSession {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetVTSessionBuilder) DeepCopy() any {
	_copy := b.CreateBACnetVTSessionBuilder().(*_BACnetVTSessionBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetVTSessionBuilder creates a BACnetVTSessionBuilder
func (b *_BACnetVTSession) CreateBACnetVTSessionBuilder() BACnetVTSessionBuilder {
	if b == nil {
		return NewBACnetVTSessionBuilder()
	}
	return &_BACnetVTSessionBuilder{_BACnetVTSession: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetVTSession) GetLocalVtSessionId() BACnetApplicationTagUnsignedInteger {
	return m.LocalVtSessionId
}

func (m *_BACnetVTSession) GetRemoveVtSessionId() BACnetApplicationTagUnsignedInteger {
	return m.RemoveVtSessionId
}

func (m *_BACnetVTSession) GetRemoteVtAddress() BACnetAddress {
	return m.RemoteVtAddress
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetVTSession(structType any) BACnetVTSession {
	if casted, ok := structType.(BACnetVTSession); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetVTSession); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetVTSession) GetTypeName() string {
	return "BACnetVTSession"
}

func (m *_BACnetVTSession) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (localVtSessionId)
	lengthInBits += m.LocalVtSessionId.GetLengthInBits(ctx)

	// Simple field (removeVtSessionId)
	lengthInBits += m.RemoveVtSessionId.GetLengthInBits(ctx)

	// Simple field (remoteVtAddress)
	lengthInBits += m.RemoteVtAddress.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetVTSession) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetVTSessionParse(ctx context.Context, theBytes []byte) (BACnetVTSession, error) {
	return BACnetVTSessionParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetVTSessionParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetVTSession, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetVTSession, error) {
		return BACnetVTSessionParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetVTSessionParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetVTSession, error) {
	v, err := (&_BACnetVTSession{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetVTSession) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetVTSession BACnetVTSession, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetVTSession"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetVTSession")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	localVtSessionId, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "localVtSessionId", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'localVtSessionId' field"))
	}
	m.LocalVtSessionId = localVtSessionId

	removeVtSessionId, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "removeVtSessionId", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'removeVtSessionId' field"))
	}
	m.RemoveVtSessionId = removeVtSessionId

	remoteVtAddress, err := ReadSimpleField[BACnetAddress](ctx, "remoteVtAddress", ReadComplex[BACnetAddress](BACnetAddressParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'remoteVtAddress' field"))
	}
	m.RemoteVtAddress = remoteVtAddress

	if closeErr := readBuffer.CloseContext("BACnetVTSession"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetVTSession")
	}

	return m, nil
}

func (m *_BACnetVTSession) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetVTSession) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetVTSession"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetVTSession")
	}

	if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "localVtSessionId", m.GetLocalVtSessionId(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'localVtSessionId' field")
	}

	if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "removeVtSessionId", m.GetRemoveVtSessionId(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'removeVtSessionId' field")
	}

	if err := WriteSimpleField[BACnetAddress](ctx, "remoteVtAddress", m.GetRemoteVtAddress(), WriteComplex[BACnetAddress](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'remoteVtAddress' field")
	}

	if popErr := writeBuffer.PopContext("BACnetVTSession"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetVTSession")
	}
	return nil
}

func (m *_BACnetVTSession) IsBACnetVTSession() {}

func (m *_BACnetVTSession) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetVTSession) deepCopy() *_BACnetVTSession {
	if m == nil {
		return nil
	}
	_BACnetVTSessionCopy := &_BACnetVTSession{
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.LocalVtSessionId),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.RemoveVtSessionId),
		utils.DeepCopy[BACnetAddress](m.RemoteVtAddress),
	}
	return _BACnetVTSessionCopy
}

func (m *_BACnetVTSession) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
