/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetTimerStateChangeValueEnumerated is the corresponding interface of BACnetTimerStateChangeValueEnumerated
type BACnetTimerStateChangeValueEnumerated interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetTimerStateChangeValue
	// GetEnumeratedValue returns EnumeratedValue (property field)
	GetEnumeratedValue() BACnetApplicationTagEnumerated
	// IsBACnetTimerStateChangeValueEnumerated is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetTimerStateChangeValueEnumerated()
	// CreateBuilder creates a BACnetTimerStateChangeValueEnumeratedBuilder
	CreateBACnetTimerStateChangeValueEnumeratedBuilder() BACnetTimerStateChangeValueEnumeratedBuilder
}

// _BACnetTimerStateChangeValueEnumerated is the data-structure of this message
type _BACnetTimerStateChangeValueEnumerated struct {
	BACnetTimerStateChangeValueContract
	EnumeratedValue BACnetApplicationTagEnumerated
}

var _ BACnetTimerStateChangeValueEnumerated = (*_BACnetTimerStateChangeValueEnumerated)(nil)
var _ BACnetTimerStateChangeValueRequirements = (*_BACnetTimerStateChangeValueEnumerated)(nil)

// NewBACnetTimerStateChangeValueEnumerated factory function for _BACnetTimerStateChangeValueEnumerated
func NewBACnetTimerStateChangeValueEnumerated(peekedTagHeader BACnetTagHeader, enumeratedValue BACnetApplicationTagEnumerated, objectTypeArgument BACnetObjectType) *_BACnetTimerStateChangeValueEnumerated {
	if enumeratedValue == nil {
		panic("enumeratedValue of type BACnetApplicationTagEnumerated for BACnetTimerStateChangeValueEnumerated must not be nil")
	}
	_result := &_BACnetTimerStateChangeValueEnumerated{
		BACnetTimerStateChangeValueContract: NewBACnetTimerStateChangeValue(peekedTagHeader, objectTypeArgument),
		EnumeratedValue:                     enumeratedValue,
	}
	_result.BACnetTimerStateChangeValueContract.(*_BACnetTimerStateChangeValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetTimerStateChangeValueEnumeratedBuilder is a builder for BACnetTimerStateChangeValueEnumerated
type BACnetTimerStateChangeValueEnumeratedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(enumeratedValue BACnetApplicationTagEnumerated) BACnetTimerStateChangeValueEnumeratedBuilder
	// WithEnumeratedValue adds EnumeratedValue (property field)
	WithEnumeratedValue(BACnetApplicationTagEnumerated) BACnetTimerStateChangeValueEnumeratedBuilder
	// WithEnumeratedValueBuilder adds EnumeratedValue (property field) which is build by the builder
	WithEnumeratedValueBuilder(func(BACnetApplicationTagEnumeratedBuilder) BACnetApplicationTagEnumeratedBuilder) BACnetTimerStateChangeValueEnumeratedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetTimerStateChangeValueBuilder
	// Build builds the BACnetTimerStateChangeValueEnumerated or returns an error if something is wrong
	Build() (BACnetTimerStateChangeValueEnumerated, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetTimerStateChangeValueEnumerated
}

// NewBACnetTimerStateChangeValueEnumeratedBuilder() creates a BACnetTimerStateChangeValueEnumeratedBuilder
func NewBACnetTimerStateChangeValueEnumeratedBuilder() BACnetTimerStateChangeValueEnumeratedBuilder {
	return &_BACnetTimerStateChangeValueEnumeratedBuilder{_BACnetTimerStateChangeValueEnumerated: new(_BACnetTimerStateChangeValueEnumerated)}
}

type _BACnetTimerStateChangeValueEnumeratedBuilder struct {
	*_BACnetTimerStateChangeValueEnumerated

	parentBuilder *_BACnetTimerStateChangeValueBuilder

	err *utils.MultiError
}

var _ (BACnetTimerStateChangeValueEnumeratedBuilder) = (*_BACnetTimerStateChangeValueEnumeratedBuilder)(nil)

func (b *_BACnetTimerStateChangeValueEnumeratedBuilder) setParent(contract BACnetTimerStateChangeValueContract) {
	b.BACnetTimerStateChangeValueContract = contract
	contract.(*_BACnetTimerStateChangeValue)._SubType = b._BACnetTimerStateChangeValueEnumerated
}

func (b *_BACnetTimerStateChangeValueEnumeratedBuilder) WithMandatoryFields(enumeratedValue BACnetApplicationTagEnumerated) BACnetTimerStateChangeValueEnumeratedBuilder {
	return b.WithEnumeratedValue(enumeratedValue)
}

func (b *_BACnetTimerStateChangeValueEnumeratedBuilder) WithEnumeratedValue(enumeratedValue BACnetApplicationTagEnumerated) BACnetTimerStateChangeValueEnumeratedBuilder {
	b.EnumeratedValue = enumeratedValue
	return b
}

func (b *_BACnetTimerStateChangeValueEnumeratedBuilder) WithEnumeratedValueBuilder(builderSupplier func(BACnetApplicationTagEnumeratedBuilder) BACnetApplicationTagEnumeratedBuilder) BACnetTimerStateChangeValueEnumeratedBuilder {
	builder := builderSupplier(b.EnumeratedValue.CreateBACnetApplicationTagEnumeratedBuilder())
	var err error
	b.EnumeratedValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagEnumeratedBuilder failed"))
	}
	return b
}

func (b *_BACnetTimerStateChangeValueEnumeratedBuilder) Build() (BACnetTimerStateChangeValueEnumerated, error) {
	if b.EnumeratedValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'enumeratedValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetTimerStateChangeValueEnumerated.deepCopy(), nil
}

func (b *_BACnetTimerStateChangeValueEnumeratedBuilder) MustBuild() BACnetTimerStateChangeValueEnumerated {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetTimerStateChangeValueEnumeratedBuilder) Done() BACnetTimerStateChangeValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetTimerStateChangeValueBuilder().(*_BACnetTimerStateChangeValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetTimerStateChangeValueEnumeratedBuilder) buildForBACnetTimerStateChangeValue() (BACnetTimerStateChangeValue, error) {
	return b.Build()
}

func (b *_BACnetTimerStateChangeValueEnumeratedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetTimerStateChangeValueEnumeratedBuilder().(*_BACnetTimerStateChangeValueEnumeratedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetTimerStateChangeValueEnumeratedBuilder creates a BACnetTimerStateChangeValueEnumeratedBuilder
func (b *_BACnetTimerStateChangeValueEnumerated) CreateBACnetTimerStateChangeValueEnumeratedBuilder() BACnetTimerStateChangeValueEnumeratedBuilder {
	if b == nil {
		return NewBACnetTimerStateChangeValueEnumeratedBuilder()
	}
	return &_BACnetTimerStateChangeValueEnumeratedBuilder{_BACnetTimerStateChangeValueEnumerated: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetTimerStateChangeValueEnumerated) GetParent() BACnetTimerStateChangeValueContract {
	return m.BACnetTimerStateChangeValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetTimerStateChangeValueEnumerated) GetEnumeratedValue() BACnetApplicationTagEnumerated {
	return m.EnumeratedValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetTimerStateChangeValueEnumerated(structType any) BACnetTimerStateChangeValueEnumerated {
	if casted, ok := structType.(BACnetTimerStateChangeValueEnumerated); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetTimerStateChangeValueEnumerated); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetTimerStateChangeValueEnumerated) GetTypeName() string {
	return "BACnetTimerStateChangeValueEnumerated"
}

func (m *_BACnetTimerStateChangeValueEnumerated) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetTimerStateChangeValueContract.(*_BACnetTimerStateChangeValue).getLengthInBits(ctx))

	// Simple field (enumeratedValue)
	lengthInBits += m.EnumeratedValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetTimerStateChangeValueEnumerated) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetTimerStateChangeValueEnumerated) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetTimerStateChangeValue, objectTypeArgument BACnetObjectType) (__bACnetTimerStateChangeValueEnumerated BACnetTimerStateChangeValueEnumerated, err error) {
	m.BACnetTimerStateChangeValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetTimerStateChangeValueEnumerated"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetTimerStateChangeValueEnumerated")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	enumeratedValue, err := ReadSimpleField[BACnetApplicationTagEnumerated](ctx, "enumeratedValue", ReadComplex[BACnetApplicationTagEnumerated](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagEnumerated](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'enumeratedValue' field"))
	}
	m.EnumeratedValue = enumeratedValue

	if closeErr := readBuffer.CloseContext("BACnetTimerStateChangeValueEnumerated"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetTimerStateChangeValueEnumerated")
	}

	return m, nil
}

func (m *_BACnetTimerStateChangeValueEnumerated) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetTimerStateChangeValueEnumerated) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetTimerStateChangeValueEnumerated"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetTimerStateChangeValueEnumerated")
		}

		if err := WriteSimpleField[BACnetApplicationTagEnumerated](ctx, "enumeratedValue", m.GetEnumeratedValue(), WriteComplex[BACnetApplicationTagEnumerated](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'enumeratedValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetTimerStateChangeValueEnumerated"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetTimerStateChangeValueEnumerated")
		}
		return nil
	}
	return m.BACnetTimerStateChangeValueContract.(*_BACnetTimerStateChangeValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetTimerStateChangeValueEnumerated) IsBACnetTimerStateChangeValueEnumerated() {}

func (m *_BACnetTimerStateChangeValueEnumerated) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetTimerStateChangeValueEnumerated) deepCopy() *_BACnetTimerStateChangeValueEnumerated {
	if m == nil {
		return nil
	}
	_BACnetTimerStateChangeValueEnumeratedCopy := &_BACnetTimerStateChangeValueEnumerated{
		m.BACnetTimerStateChangeValueContract.(*_BACnetTimerStateChangeValue).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagEnumerated](m.EnumeratedValue),
	}
	_BACnetTimerStateChangeValueEnumeratedCopy.BACnetTimerStateChangeValueContract.(*_BACnetTimerStateChangeValue)._SubType = m
	return _BACnetTimerStateChangeValueEnumeratedCopy
}

func (m *_BACnetTimerStateChangeValueEnumerated) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
