/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetSpecialEventPeriodCalendarEntry is the corresponding interface of BACnetSpecialEventPeriodCalendarEntry
type BACnetSpecialEventPeriodCalendarEntry interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetSpecialEventPeriod
	// GetCalendarEntry returns CalendarEntry (property field)
	GetCalendarEntry() BACnetCalendarEntryEnclosed
	// IsBACnetSpecialEventPeriodCalendarEntry is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetSpecialEventPeriodCalendarEntry()
	// CreateBuilder creates a BACnetSpecialEventPeriodCalendarEntryBuilder
	CreateBACnetSpecialEventPeriodCalendarEntryBuilder() BACnetSpecialEventPeriodCalendarEntryBuilder
}

// _BACnetSpecialEventPeriodCalendarEntry is the data-structure of this message
type _BACnetSpecialEventPeriodCalendarEntry struct {
	BACnetSpecialEventPeriodContract
	CalendarEntry BACnetCalendarEntryEnclosed
}

var _ BACnetSpecialEventPeriodCalendarEntry = (*_BACnetSpecialEventPeriodCalendarEntry)(nil)
var _ BACnetSpecialEventPeriodRequirements = (*_BACnetSpecialEventPeriodCalendarEntry)(nil)

// NewBACnetSpecialEventPeriodCalendarEntry factory function for _BACnetSpecialEventPeriodCalendarEntry
func NewBACnetSpecialEventPeriodCalendarEntry(peekedTagHeader BACnetTagHeader, calendarEntry BACnetCalendarEntryEnclosed) *_BACnetSpecialEventPeriodCalendarEntry {
	if calendarEntry == nil {
		panic("calendarEntry of type BACnetCalendarEntryEnclosed for BACnetSpecialEventPeriodCalendarEntry must not be nil")
	}
	_result := &_BACnetSpecialEventPeriodCalendarEntry{
		BACnetSpecialEventPeriodContract: NewBACnetSpecialEventPeriod(peekedTagHeader),
		CalendarEntry:                    calendarEntry,
	}
	_result.BACnetSpecialEventPeriodContract.(*_BACnetSpecialEventPeriod)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetSpecialEventPeriodCalendarEntryBuilder is a builder for BACnetSpecialEventPeriodCalendarEntry
type BACnetSpecialEventPeriodCalendarEntryBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(calendarEntry BACnetCalendarEntryEnclosed) BACnetSpecialEventPeriodCalendarEntryBuilder
	// WithCalendarEntry adds CalendarEntry (property field)
	WithCalendarEntry(BACnetCalendarEntryEnclosed) BACnetSpecialEventPeriodCalendarEntryBuilder
	// WithCalendarEntryBuilder adds CalendarEntry (property field) which is build by the builder
	WithCalendarEntryBuilder(func(BACnetCalendarEntryEnclosedBuilder) BACnetCalendarEntryEnclosedBuilder) BACnetSpecialEventPeriodCalendarEntryBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetSpecialEventPeriodBuilder
	// Build builds the BACnetSpecialEventPeriodCalendarEntry or returns an error if something is wrong
	Build() (BACnetSpecialEventPeriodCalendarEntry, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetSpecialEventPeriodCalendarEntry
}

// NewBACnetSpecialEventPeriodCalendarEntryBuilder() creates a BACnetSpecialEventPeriodCalendarEntryBuilder
func NewBACnetSpecialEventPeriodCalendarEntryBuilder() BACnetSpecialEventPeriodCalendarEntryBuilder {
	return &_BACnetSpecialEventPeriodCalendarEntryBuilder{_BACnetSpecialEventPeriodCalendarEntry: new(_BACnetSpecialEventPeriodCalendarEntry)}
}

type _BACnetSpecialEventPeriodCalendarEntryBuilder struct {
	*_BACnetSpecialEventPeriodCalendarEntry

	parentBuilder *_BACnetSpecialEventPeriodBuilder

	err *utils.MultiError
}

var _ (BACnetSpecialEventPeriodCalendarEntryBuilder) = (*_BACnetSpecialEventPeriodCalendarEntryBuilder)(nil)

func (b *_BACnetSpecialEventPeriodCalendarEntryBuilder) setParent(contract BACnetSpecialEventPeriodContract) {
	b.BACnetSpecialEventPeriodContract = contract
	contract.(*_BACnetSpecialEventPeriod)._SubType = b._BACnetSpecialEventPeriodCalendarEntry
}

func (b *_BACnetSpecialEventPeriodCalendarEntryBuilder) WithMandatoryFields(calendarEntry BACnetCalendarEntryEnclosed) BACnetSpecialEventPeriodCalendarEntryBuilder {
	return b.WithCalendarEntry(calendarEntry)
}

func (b *_BACnetSpecialEventPeriodCalendarEntryBuilder) WithCalendarEntry(calendarEntry BACnetCalendarEntryEnclosed) BACnetSpecialEventPeriodCalendarEntryBuilder {
	b.CalendarEntry = calendarEntry
	return b
}

func (b *_BACnetSpecialEventPeriodCalendarEntryBuilder) WithCalendarEntryBuilder(builderSupplier func(BACnetCalendarEntryEnclosedBuilder) BACnetCalendarEntryEnclosedBuilder) BACnetSpecialEventPeriodCalendarEntryBuilder {
	builder := builderSupplier(b.CalendarEntry.CreateBACnetCalendarEntryEnclosedBuilder())
	var err error
	b.CalendarEntry, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetCalendarEntryEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetSpecialEventPeriodCalendarEntryBuilder) Build() (BACnetSpecialEventPeriodCalendarEntry, error) {
	if b.CalendarEntry == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'calendarEntry' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetSpecialEventPeriodCalendarEntry.deepCopy(), nil
}

func (b *_BACnetSpecialEventPeriodCalendarEntryBuilder) MustBuild() BACnetSpecialEventPeriodCalendarEntry {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetSpecialEventPeriodCalendarEntryBuilder) Done() BACnetSpecialEventPeriodBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetSpecialEventPeriodBuilder().(*_BACnetSpecialEventPeriodBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetSpecialEventPeriodCalendarEntryBuilder) buildForBACnetSpecialEventPeriod() (BACnetSpecialEventPeriod, error) {
	return b.Build()
}

func (b *_BACnetSpecialEventPeriodCalendarEntryBuilder) DeepCopy() any {
	_copy := b.CreateBACnetSpecialEventPeriodCalendarEntryBuilder().(*_BACnetSpecialEventPeriodCalendarEntryBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetSpecialEventPeriodCalendarEntryBuilder creates a BACnetSpecialEventPeriodCalendarEntryBuilder
func (b *_BACnetSpecialEventPeriodCalendarEntry) CreateBACnetSpecialEventPeriodCalendarEntryBuilder() BACnetSpecialEventPeriodCalendarEntryBuilder {
	if b == nil {
		return NewBACnetSpecialEventPeriodCalendarEntryBuilder()
	}
	return &_BACnetSpecialEventPeriodCalendarEntryBuilder{_BACnetSpecialEventPeriodCalendarEntry: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetSpecialEventPeriodCalendarEntry) GetParent() BACnetSpecialEventPeriodContract {
	return m.BACnetSpecialEventPeriodContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetSpecialEventPeriodCalendarEntry) GetCalendarEntry() BACnetCalendarEntryEnclosed {
	return m.CalendarEntry
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetSpecialEventPeriodCalendarEntry(structType any) BACnetSpecialEventPeriodCalendarEntry {
	if casted, ok := structType.(BACnetSpecialEventPeriodCalendarEntry); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetSpecialEventPeriodCalendarEntry); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetSpecialEventPeriodCalendarEntry) GetTypeName() string {
	return "BACnetSpecialEventPeriodCalendarEntry"
}

func (m *_BACnetSpecialEventPeriodCalendarEntry) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetSpecialEventPeriodContract.(*_BACnetSpecialEventPeriod).getLengthInBits(ctx))

	// Simple field (calendarEntry)
	lengthInBits += m.CalendarEntry.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetSpecialEventPeriodCalendarEntry) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetSpecialEventPeriodCalendarEntry) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetSpecialEventPeriod) (__bACnetSpecialEventPeriodCalendarEntry BACnetSpecialEventPeriodCalendarEntry, err error) {
	m.BACnetSpecialEventPeriodContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetSpecialEventPeriodCalendarEntry"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetSpecialEventPeriodCalendarEntry")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	calendarEntry, err := ReadSimpleField[BACnetCalendarEntryEnclosed](ctx, "calendarEntry", ReadComplex[BACnetCalendarEntryEnclosed](BACnetCalendarEntryEnclosedParseWithBufferProducer((uint8)(uint8(0))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'calendarEntry' field"))
	}
	m.CalendarEntry = calendarEntry

	if closeErr := readBuffer.CloseContext("BACnetSpecialEventPeriodCalendarEntry"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetSpecialEventPeriodCalendarEntry")
	}

	return m, nil
}

func (m *_BACnetSpecialEventPeriodCalendarEntry) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetSpecialEventPeriodCalendarEntry) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetSpecialEventPeriodCalendarEntry"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetSpecialEventPeriodCalendarEntry")
		}

		if err := WriteSimpleField[BACnetCalendarEntryEnclosed](ctx, "calendarEntry", m.GetCalendarEntry(), WriteComplex[BACnetCalendarEntryEnclosed](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'calendarEntry' field")
		}

		if popErr := writeBuffer.PopContext("BACnetSpecialEventPeriodCalendarEntry"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetSpecialEventPeriodCalendarEntry")
		}
		return nil
	}
	return m.BACnetSpecialEventPeriodContract.(*_BACnetSpecialEventPeriod).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetSpecialEventPeriodCalendarEntry) IsBACnetSpecialEventPeriodCalendarEntry() {}

func (m *_BACnetSpecialEventPeriodCalendarEntry) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetSpecialEventPeriodCalendarEntry) deepCopy() *_BACnetSpecialEventPeriodCalendarEntry {
	if m == nil {
		return nil
	}
	_BACnetSpecialEventPeriodCalendarEntryCopy := &_BACnetSpecialEventPeriodCalendarEntry{
		m.BACnetSpecialEventPeriodContract.(*_BACnetSpecialEventPeriod).deepCopy(),
		utils.DeepCopy[BACnetCalendarEntryEnclosed](m.CalendarEntry),
	}
	_BACnetSpecialEventPeriodCalendarEntryCopy.BACnetSpecialEventPeriodContract.(*_BACnetSpecialEventPeriod)._SubType = m
	return _BACnetSpecialEventPeriodCalendarEntryCopy
}

func (m *_BACnetSpecialEventPeriodCalendarEntry) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
