/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetSpecialEvent is the corresponding interface of BACnetSpecialEvent
type BACnetSpecialEvent interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetPeriod returns Period (property field)
	GetPeriod() BACnetSpecialEventPeriod
	// GetListOfTimeValues returns ListOfTimeValues (property field)
	GetListOfTimeValues() BACnetSpecialEventListOfTimeValues
	// GetEventPriority returns EventPriority (property field)
	GetEventPriority() BACnetContextTagUnsignedInteger
	// IsBACnetSpecialEvent is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetSpecialEvent()
	// CreateBuilder creates a BACnetSpecialEventBuilder
	CreateBACnetSpecialEventBuilder() BACnetSpecialEventBuilder
}

// _BACnetSpecialEvent is the data-structure of this message
type _BACnetSpecialEvent struct {
	Period           BACnetSpecialEventPeriod
	ListOfTimeValues BACnetSpecialEventListOfTimeValues
	EventPriority    BACnetContextTagUnsignedInteger
}

var _ BACnetSpecialEvent = (*_BACnetSpecialEvent)(nil)

// NewBACnetSpecialEvent factory function for _BACnetSpecialEvent
func NewBACnetSpecialEvent(period BACnetSpecialEventPeriod, listOfTimeValues BACnetSpecialEventListOfTimeValues, eventPriority BACnetContextTagUnsignedInteger) *_BACnetSpecialEvent {
	if period == nil {
		panic("period of type BACnetSpecialEventPeriod for BACnetSpecialEvent must not be nil")
	}
	if listOfTimeValues == nil {
		panic("listOfTimeValues of type BACnetSpecialEventListOfTimeValues for BACnetSpecialEvent must not be nil")
	}
	if eventPriority == nil {
		panic("eventPriority of type BACnetContextTagUnsignedInteger for BACnetSpecialEvent must not be nil")
	}
	return &_BACnetSpecialEvent{Period: period, ListOfTimeValues: listOfTimeValues, EventPriority: eventPriority}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetSpecialEventBuilder is a builder for BACnetSpecialEvent
type BACnetSpecialEventBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(period BACnetSpecialEventPeriod, listOfTimeValues BACnetSpecialEventListOfTimeValues, eventPriority BACnetContextTagUnsignedInteger) BACnetSpecialEventBuilder
	// WithPeriod adds Period (property field)
	WithPeriod(BACnetSpecialEventPeriod) BACnetSpecialEventBuilder
	// WithPeriodBuilder adds Period (property field) which is build by the builder
	WithPeriodBuilder(func(BACnetSpecialEventPeriodBuilder) BACnetSpecialEventPeriodBuilder) BACnetSpecialEventBuilder
	// WithListOfTimeValues adds ListOfTimeValues (property field)
	WithListOfTimeValues(BACnetSpecialEventListOfTimeValues) BACnetSpecialEventBuilder
	// WithListOfTimeValuesBuilder adds ListOfTimeValues (property field) which is build by the builder
	WithListOfTimeValuesBuilder(func(BACnetSpecialEventListOfTimeValuesBuilder) BACnetSpecialEventListOfTimeValuesBuilder) BACnetSpecialEventBuilder
	// WithEventPriority adds EventPriority (property field)
	WithEventPriority(BACnetContextTagUnsignedInteger) BACnetSpecialEventBuilder
	// WithEventPriorityBuilder adds EventPriority (property field) which is build by the builder
	WithEventPriorityBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetSpecialEventBuilder
	// Build builds the BACnetSpecialEvent or returns an error if something is wrong
	Build() (BACnetSpecialEvent, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetSpecialEvent
}

// NewBACnetSpecialEventBuilder() creates a BACnetSpecialEventBuilder
func NewBACnetSpecialEventBuilder() BACnetSpecialEventBuilder {
	return &_BACnetSpecialEventBuilder{_BACnetSpecialEvent: new(_BACnetSpecialEvent)}
}

type _BACnetSpecialEventBuilder struct {
	*_BACnetSpecialEvent

	err *utils.MultiError
}

var _ (BACnetSpecialEventBuilder) = (*_BACnetSpecialEventBuilder)(nil)

func (b *_BACnetSpecialEventBuilder) WithMandatoryFields(period BACnetSpecialEventPeriod, listOfTimeValues BACnetSpecialEventListOfTimeValues, eventPriority BACnetContextTagUnsignedInteger) BACnetSpecialEventBuilder {
	return b.WithPeriod(period).WithListOfTimeValues(listOfTimeValues).WithEventPriority(eventPriority)
}

func (b *_BACnetSpecialEventBuilder) WithPeriod(period BACnetSpecialEventPeriod) BACnetSpecialEventBuilder {
	b.Period = period
	return b
}

func (b *_BACnetSpecialEventBuilder) WithPeriodBuilder(builderSupplier func(BACnetSpecialEventPeriodBuilder) BACnetSpecialEventPeriodBuilder) BACnetSpecialEventBuilder {
	builder := builderSupplier(b.Period.CreateBACnetSpecialEventPeriodBuilder())
	var err error
	b.Period, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetSpecialEventPeriodBuilder failed"))
	}
	return b
}

func (b *_BACnetSpecialEventBuilder) WithListOfTimeValues(listOfTimeValues BACnetSpecialEventListOfTimeValues) BACnetSpecialEventBuilder {
	b.ListOfTimeValues = listOfTimeValues
	return b
}

func (b *_BACnetSpecialEventBuilder) WithListOfTimeValuesBuilder(builderSupplier func(BACnetSpecialEventListOfTimeValuesBuilder) BACnetSpecialEventListOfTimeValuesBuilder) BACnetSpecialEventBuilder {
	builder := builderSupplier(b.ListOfTimeValues.CreateBACnetSpecialEventListOfTimeValuesBuilder())
	var err error
	b.ListOfTimeValues, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetSpecialEventListOfTimeValuesBuilder failed"))
	}
	return b
}

func (b *_BACnetSpecialEventBuilder) WithEventPriority(eventPriority BACnetContextTagUnsignedInteger) BACnetSpecialEventBuilder {
	b.EventPriority = eventPriority
	return b
}

func (b *_BACnetSpecialEventBuilder) WithEventPriorityBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetSpecialEventBuilder {
	builder := builderSupplier(b.EventPriority.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.EventPriority, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetSpecialEventBuilder) Build() (BACnetSpecialEvent, error) {
	if b.Period == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'period' not set"))
	}
	if b.ListOfTimeValues == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'listOfTimeValues' not set"))
	}
	if b.EventPriority == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'eventPriority' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetSpecialEvent.deepCopy(), nil
}

func (b *_BACnetSpecialEventBuilder) MustBuild() BACnetSpecialEvent {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetSpecialEventBuilder) DeepCopy() any {
	_copy := b.CreateBACnetSpecialEventBuilder().(*_BACnetSpecialEventBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetSpecialEventBuilder creates a BACnetSpecialEventBuilder
func (b *_BACnetSpecialEvent) CreateBACnetSpecialEventBuilder() BACnetSpecialEventBuilder {
	if b == nil {
		return NewBACnetSpecialEventBuilder()
	}
	return &_BACnetSpecialEventBuilder{_BACnetSpecialEvent: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetSpecialEvent) GetPeriod() BACnetSpecialEventPeriod {
	return m.Period
}

func (m *_BACnetSpecialEvent) GetListOfTimeValues() BACnetSpecialEventListOfTimeValues {
	return m.ListOfTimeValues
}

func (m *_BACnetSpecialEvent) GetEventPriority() BACnetContextTagUnsignedInteger {
	return m.EventPriority
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetSpecialEvent(structType any) BACnetSpecialEvent {
	if casted, ok := structType.(BACnetSpecialEvent); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetSpecialEvent); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetSpecialEvent) GetTypeName() string {
	return "BACnetSpecialEvent"
}

func (m *_BACnetSpecialEvent) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (period)
	lengthInBits += m.Period.GetLengthInBits(ctx)

	// Simple field (listOfTimeValues)
	lengthInBits += m.ListOfTimeValues.GetLengthInBits(ctx)

	// Simple field (eventPriority)
	lengthInBits += m.EventPriority.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetSpecialEvent) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetSpecialEventParse(ctx context.Context, theBytes []byte) (BACnetSpecialEvent, error) {
	return BACnetSpecialEventParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetSpecialEventParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetSpecialEvent, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetSpecialEvent, error) {
		return BACnetSpecialEventParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetSpecialEventParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetSpecialEvent, error) {
	v, err := (&_BACnetSpecialEvent{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetSpecialEvent) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetSpecialEvent BACnetSpecialEvent, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetSpecialEvent"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetSpecialEvent")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	period, err := ReadSimpleField[BACnetSpecialEventPeriod](ctx, "period", ReadComplex[BACnetSpecialEventPeriod](BACnetSpecialEventPeriodParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'period' field"))
	}
	m.Period = period

	listOfTimeValues, err := ReadSimpleField[BACnetSpecialEventListOfTimeValues](ctx, "listOfTimeValues", ReadComplex[BACnetSpecialEventListOfTimeValues](BACnetSpecialEventListOfTimeValuesParseWithBufferProducer((uint8)(uint8(2))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'listOfTimeValues' field"))
	}
	m.ListOfTimeValues = listOfTimeValues

	eventPriority, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "eventPriority", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(3)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventPriority' field"))
	}
	m.EventPriority = eventPriority

	if closeErr := readBuffer.CloseContext("BACnetSpecialEvent"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetSpecialEvent")
	}

	return m, nil
}

func (m *_BACnetSpecialEvent) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetSpecialEvent) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetSpecialEvent"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetSpecialEvent")
	}

	if err := WriteSimpleField[BACnetSpecialEventPeriod](ctx, "period", m.GetPeriod(), WriteComplex[BACnetSpecialEventPeriod](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'period' field")
	}

	if err := WriteSimpleField[BACnetSpecialEventListOfTimeValues](ctx, "listOfTimeValues", m.GetListOfTimeValues(), WriteComplex[BACnetSpecialEventListOfTimeValues](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'listOfTimeValues' field")
	}

	if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "eventPriority", m.GetEventPriority(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'eventPriority' field")
	}

	if popErr := writeBuffer.PopContext("BACnetSpecialEvent"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetSpecialEvent")
	}
	return nil
}

func (m *_BACnetSpecialEvent) IsBACnetSpecialEvent() {}

func (m *_BACnetSpecialEvent) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetSpecialEvent) deepCopy() *_BACnetSpecialEvent {
	if m == nil {
		return nil
	}
	_BACnetSpecialEventCopy := &_BACnetSpecialEvent{
		utils.DeepCopy[BACnetSpecialEventPeriod](m.Period),
		utils.DeepCopy[BACnetSpecialEventListOfTimeValues](m.ListOfTimeValues),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.EventPriority),
	}
	return _BACnetSpecialEventCopy
}

func (m *_BACnetSpecialEvent) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
