/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetServiceAckGetAlarmSummary is the corresponding interface of BACnetServiceAckGetAlarmSummary
type BACnetServiceAckGetAlarmSummary interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetServiceAck
	// GetObjectIdentifier returns ObjectIdentifier (property field)
	GetObjectIdentifier() BACnetApplicationTagObjectIdentifier
	// GetEventState returns EventState (property field)
	GetEventState() BACnetEventStateTagged
	// GetAcknowledgedTransitions returns AcknowledgedTransitions (property field)
	GetAcknowledgedTransitions() BACnetEventTransitionBitsTagged
	// IsBACnetServiceAckGetAlarmSummary is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetServiceAckGetAlarmSummary()
	// CreateBuilder creates a BACnetServiceAckGetAlarmSummaryBuilder
	CreateBACnetServiceAckGetAlarmSummaryBuilder() BACnetServiceAckGetAlarmSummaryBuilder
}

// _BACnetServiceAckGetAlarmSummary is the data-structure of this message
type _BACnetServiceAckGetAlarmSummary struct {
	BACnetServiceAckContract
	ObjectIdentifier        BACnetApplicationTagObjectIdentifier
	EventState              BACnetEventStateTagged
	AcknowledgedTransitions BACnetEventTransitionBitsTagged
}

var _ BACnetServiceAckGetAlarmSummary = (*_BACnetServiceAckGetAlarmSummary)(nil)
var _ BACnetServiceAckRequirements = (*_BACnetServiceAckGetAlarmSummary)(nil)

// NewBACnetServiceAckGetAlarmSummary factory function for _BACnetServiceAckGetAlarmSummary
func NewBACnetServiceAckGetAlarmSummary(objectIdentifier BACnetApplicationTagObjectIdentifier, eventState BACnetEventStateTagged, acknowledgedTransitions BACnetEventTransitionBitsTagged, serviceAckLength uint32) *_BACnetServiceAckGetAlarmSummary {
	if objectIdentifier == nil {
		panic("objectIdentifier of type BACnetApplicationTagObjectIdentifier for BACnetServiceAckGetAlarmSummary must not be nil")
	}
	if eventState == nil {
		panic("eventState of type BACnetEventStateTagged for BACnetServiceAckGetAlarmSummary must not be nil")
	}
	if acknowledgedTransitions == nil {
		panic("acknowledgedTransitions of type BACnetEventTransitionBitsTagged for BACnetServiceAckGetAlarmSummary must not be nil")
	}
	_result := &_BACnetServiceAckGetAlarmSummary{
		BACnetServiceAckContract: NewBACnetServiceAck(serviceAckLength),
		ObjectIdentifier:         objectIdentifier,
		EventState:               eventState,
		AcknowledgedTransitions:  acknowledgedTransitions,
	}
	_result.BACnetServiceAckContract.(*_BACnetServiceAck)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetServiceAckGetAlarmSummaryBuilder is a builder for BACnetServiceAckGetAlarmSummary
type BACnetServiceAckGetAlarmSummaryBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(objectIdentifier BACnetApplicationTagObjectIdentifier, eventState BACnetEventStateTagged, acknowledgedTransitions BACnetEventTransitionBitsTagged) BACnetServiceAckGetAlarmSummaryBuilder
	// WithObjectIdentifier adds ObjectIdentifier (property field)
	WithObjectIdentifier(BACnetApplicationTagObjectIdentifier) BACnetServiceAckGetAlarmSummaryBuilder
	// WithObjectIdentifierBuilder adds ObjectIdentifier (property field) which is build by the builder
	WithObjectIdentifierBuilder(func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetServiceAckGetAlarmSummaryBuilder
	// WithEventState adds EventState (property field)
	WithEventState(BACnetEventStateTagged) BACnetServiceAckGetAlarmSummaryBuilder
	// WithEventStateBuilder adds EventState (property field) which is build by the builder
	WithEventStateBuilder(func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) BACnetServiceAckGetAlarmSummaryBuilder
	// WithAcknowledgedTransitions adds AcknowledgedTransitions (property field)
	WithAcknowledgedTransitions(BACnetEventTransitionBitsTagged) BACnetServiceAckGetAlarmSummaryBuilder
	// WithAcknowledgedTransitionsBuilder adds AcknowledgedTransitions (property field) which is build by the builder
	WithAcknowledgedTransitionsBuilder(func(BACnetEventTransitionBitsTaggedBuilder) BACnetEventTransitionBitsTaggedBuilder) BACnetServiceAckGetAlarmSummaryBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetServiceAckBuilder
	// Build builds the BACnetServiceAckGetAlarmSummary or returns an error if something is wrong
	Build() (BACnetServiceAckGetAlarmSummary, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetServiceAckGetAlarmSummary
}

// NewBACnetServiceAckGetAlarmSummaryBuilder() creates a BACnetServiceAckGetAlarmSummaryBuilder
func NewBACnetServiceAckGetAlarmSummaryBuilder() BACnetServiceAckGetAlarmSummaryBuilder {
	return &_BACnetServiceAckGetAlarmSummaryBuilder{_BACnetServiceAckGetAlarmSummary: new(_BACnetServiceAckGetAlarmSummary)}
}

type _BACnetServiceAckGetAlarmSummaryBuilder struct {
	*_BACnetServiceAckGetAlarmSummary

	parentBuilder *_BACnetServiceAckBuilder

	err *utils.MultiError
}

var _ (BACnetServiceAckGetAlarmSummaryBuilder) = (*_BACnetServiceAckGetAlarmSummaryBuilder)(nil)

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) setParent(contract BACnetServiceAckContract) {
	b.BACnetServiceAckContract = contract
	contract.(*_BACnetServiceAck)._SubType = b._BACnetServiceAckGetAlarmSummary
}

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) WithMandatoryFields(objectIdentifier BACnetApplicationTagObjectIdentifier, eventState BACnetEventStateTagged, acknowledgedTransitions BACnetEventTransitionBitsTagged) BACnetServiceAckGetAlarmSummaryBuilder {
	return b.WithObjectIdentifier(objectIdentifier).WithEventState(eventState).WithAcknowledgedTransitions(acknowledgedTransitions)
}

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) WithObjectIdentifier(objectIdentifier BACnetApplicationTagObjectIdentifier) BACnetServiceAckGetAlarmSummaryBuilder {
	b.ObjectIdentifier = objectIdentifier
	return b
}

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) WithObjectIdentifierBuilder(builderSupplier func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetServiceAckGetAlarmSummaryBuilder {
	builder := builderSupplier(b.ObjectIdentifier.CreateBACnetApplicationTagObjectIdentifierBuilder())
	var err error
	b.ObjectIdentifier, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) WithEventState(eventState BACnetEventStateTagged) BACnetServiceAckGetAlarmSummaryBuilder {
	b.EventState = eventState
	return b
}

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) WithEventStateBuilder(builderSupplier func(BACnetEventStateTaggedBuilder) BACnetEventStateTaggedBuilder) BACnetServiceAckGetAlarmSummaryBuilder {
	builder := builderSupplier(b.EventState.CreateBACnetEventStateTaggedBuilder())
	var err error
	b.EventState, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetEventStateTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) WithAcknowledgedTransitions(acknowledgedTransitions BACnetEventTransitionBitsTagged) BACnetServiceAckGetAlarmSummaryBuilder {
	b.AcknowledgedTransitions = acknowledgedTransitions
	return b
}

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) WithAcknowledgedTransitionsBuilder(builderSupplier func(BACnetEventTransitionBitsTaggedBuilder) BACnetEventTransitionBitsTaggedBuilder) BACnetServiceAckGetAlarmSummaryBuilder {
	builder := builderSupplier(b.AcknowledgedTransitions.CreateBACnetEventTransitionBitsTaggedBuilder())
	var err error
	b.AcknowledgedTransitions, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetEventTransitionBitsTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) Build() (BACnetServiceAckGetAlarmSummary, error) {
	if b.ObjectIdentifier == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'objectIdentifier' not set"))
	}
	if b.EventState == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'eventState' not set"))
	}
	if b.AcknowledgedTransitions == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'acknowledgedTransitions' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetServiceAckGetAlarmSummary.deepCopy(), nil
}

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) MustBuild() BACnetServiceAckGetAlarmSummary {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) Done() BACnetServiceAckBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetServiceAckBuilder().(*_BACnetServiceAckBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) buildForBACnetServiceAck() (BACnetServiceAck, error) {
	return b.Build()
}

func (b *_BACnetServiceAckGetAlarmSummaryBuilder) DeepCopy() any {
	_copy := b.CreateBACnetServiceAckGetAlarmSummaryBuilder().(*_BACnetServiceAckGetAlarmSummaryBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetServiceAckGetAlarmSummaryBuilder creates a BACnetServiceAckGetAlarmSummaryBuilder
func (b *_BACnetServiceAckGetAlarmSummary) CreateBACnetServiceAckGetAlarmSummaryBuilder() BACnetServiceAckGetAlarmSummaryBuilder {
	if b == nil {
		return NewBACnetServiceAckGetAlarmSummaryBuilder()
	}
	return &_BACnetServiceAckGetAlarmSummaryBuilder{_BACnetServiceAckGetAlarmSummary: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetServiceAckGetAlarmSummary) GetServiceChoice() BACnetConfirmedServiceChoice {
	return BACnetConfirmedServiceChoice_GET_ALARM_SUMMARY
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetServiceAckGetAlarmSummary) GetParent() BACnetServiceAckContract {
	return m.BACnetServiceAckContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetServiceAckGetAlarmSummary) GetObjectIdentifier() BACnetApplicationTagObjectIdentifier {
	return m.ObjectIdentifier
}

func (m *_BACnetServiceAckGetAlarmSummary) GetEventState() BACnetEventStateTagged {
	return m.EventState
}

func (m *_BACnetServiceAckGetAlarmSummary) GetAcknowledgedTransitions() BACnetEventTransitionBitsTagged {
	return m.AcknowledgedTransitions
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetServiceAckGetAlarmSummary(structType any) BACnetServiceAckGetAlarmSummary {
	if casted, ok := structType.(BACnetServiceAckGetAlarmSummary); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetServiceAckGetAlarmSummary); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetServiceAckGetAlarmSummary) GetTypeName() string {
	return "BACnetServiceAckGetAlarmSummary"
}

func (m *_BACnetServiceAckGetAlarmSummary) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetServiceAckContract.(*_BACnetServiceAck).getLengthInBits(ctx))

	// Simple field (objectIdentifier)
	lengthInBits += m.ObjectIdentifier.GetLengthInBits(ctx)

	// Simple field (eventState)
	lengthInBits += m.EventState.GetLengthInBits(ctx)

	// Simple field (acknowledgedTransitions)
	lengthInBits += m.AcknowledgedTransitions.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetServiceAckGetAlarmSummary) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetServiceAckGetAlarmSummary) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetServiceAck, serviceAckLength uint32) (__bACnetServiceAckGetAlarmSummary BACnetServiceAckGetAlarmSummary, err error) {
	m.BACnetServiceAckContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetServiceAckGetAlarmSummary"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetServiceAckGetAlarmSummary")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	objectIdentifier, err := ReadSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "objectIdentifier", ReadComplex[BACnetApplicationTagObjectIdentifier](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagObjectIdentifier](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'objectIdentifier' field"))
	}
	m.ObjectIdentifier = objectIdentifier

	eventState, err := ReadSimpleField[BACnetEventStateTagged](ctx, "eventState", ReadComplex[BACnetEventStateTagged](BACnetEventStateTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventState' field"))
	}
	m.EventState = eventState

	acknowledgedTransitions, err := ReadSimpleField[BACnetEventTransitionBitsTagged](ctx, "acknowledgedTransitions", ReadComplex[BACnetEventTransitionBitsTagged](BACnetEventTransitionBitsTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'acknowledgedTransitions' field"))
	}
	m.AcknowledgedTransitions = acknowledgedTransitions

	if closeErr := readBuffer.CloseContext("BACnetServiceAckGetAlarmSummary"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetServiceAckGetAlarmSummary")
	}

	return m, nil
}

func (m *_BACnetServiceAckGetAlarmSummary) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetServiceAckGetAlarmSummary) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetServiceAckGetAlarmSummary"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetServiceAckGetAlarmSummary")
		}

		if err := WriteSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "objectIdentifier", m.GetObjectIdentifier(), WriteComplex[BACnetApplicationTagObjectIdentifier](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'objectIdentifier' field")
		}

		if err := WriteSimpleField[BACnetEventStateTagged](ctx, "eventState", m.GetEventState(), WriteComplex[BACnetEventStateTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'eventState' field")
		}

		if err := WriteSimpleField[BACnetEventTransitionBitsTagged](ctx, "acknowledgedTransitions", m.GetAcknowledgedTransitions(), WriteComplex[BACnetEventTransitionBitsTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'acknowledgedTransitions' field")
		}

		if popErr := writeBuffer.PopContext("BACnetServiceAckGetAlarmSummary"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetServiceAckGetAlarmSummary")
		}
		return nil
	}
	return m.BACnetServiceAckContract.(*_BACnetServiceAck).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetServiceAckGetAlarmSummary) IsBACnetServiceAckGetAlarmSummary() {}

func (m *_BACnetServiceAckGetAlarmSummary) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetServiceAckGetAlarmSummary) deepCopy() *_BACnetServiceAckGetAlarmSummary {
	if m == nil {
		return nil
	}
	_BACnetServiceAckGetAlarmSummaryCopy := &_BACnetServiceAckGetAlarmSummary{
		m.BACnetServiceAckContract.(*_BACnetServiceAck).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagObjectIdentifier](m.ObjectIdentifier),
		utils.DeepCopy[BACnetEventStateTagged](m.EventState),
		utils.DeepCopy[BACnetEventTransitionBitsTagged](m.AcknowledgedTransitions),
	}
	_BACnetServiceAckGetAlarmSummaryCopy.BACnetServiceAckContract.(*_BACnetServiceAck)._SubType = m
	return _BACnetServiceAckGetAlarmSummaryCopy
}

func (m *_BACnetServiceAckGetAlarmSummary) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
