/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetSecurityLevelTagged is the corresponding interface of BACnetSecurityLevelTagged
type BACnetSecurityLevelTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetSecurityLevel
	// IsBACnetSecurityLevelTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetSecurityLevelTagged()
	// CreateBuilder creates a BACnetSecurityLevelTaggedBuilder
	CreateBACnetSecurityLevelTaggedBuilder() BACnetSecurityLevelTaggedBuilder
}

// _BACnetSecurityLevelTagged is the data-structure of this message
type _BACnetSecurityLevelTagged struct {
	Header BACnetTagHeader
	Value  BACnetSecurityLevel

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetSecurityLevelTagged = (*_BACnetSecurityLevelTagged)(nil)

// NewBACnetSecurityLevelTagged factory function for _BACnetSecurityLevelTagged
func NewBACnetSecurityLevelTagged(header BACnetTagHeader, value BACnetSecurityLevel, tagNumber uint8, tagClass TagClass) *_BACnetSecurityLevelTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetSecurityLevelTagged must not be nil")
	}
	return &_BACnetSecurityLevelTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetSecurityLevelTaggedBuilder is a builder for BACnetSecurityLevelTagged
type BACnetSecurityLevelTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetSecurityLevel) BACnetSecurityLevelTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetSecurityLevelTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetSecurityLevelTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetSecurityLevel) BACnetSecurityLevelTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetSecurityLevelTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetSecurityLevelTaggedBuilder
	// Build builds the BACnetSecurityLevelTagged or returns an error if something is wrong
	Build() (BACnetSecurityLevelTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetSecurityLevelTagged
}

// NewBACnetSecurityLevelTaggedBuilder() creates a BACnetSecurityLevelTaggedBuilder
func NewBACnetSecurityLevelTaggedBuilder() BACnetSecurityLevelTaggedBuilder {
	return &_BACnetSecurityLevelTaggedBuilder{_BACnetSecurityLevelTagged: new(_BACnetSecurityLevelTagged)}
}

type _BACnetSecurityLevelTaggedBuilder struct {
	*_BACnetSecurityLevelTagged

	err *utils.MultiError
}

var _ (BACnetSecurityLevelTaggedBuilder) = (*_BACnetSecurityLevelTaggedBuilder)(nil)

func (b *_BACnetSecurityLevelTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetSecurityLevel) BACnetSecurityLevelTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetSecurityLevelTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetSecurityLevelTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetSecurityLevelTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetSecurityLevelTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetSecurityLevelTaggedBuilder) WithValue(value BACnetSecurityLevel) BACnetSecurityLevelTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetSecurityLevelTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetSecurityLevelTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetSecurityLevelTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetSecurityLevelTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetSecurityLevelTaggedBuilder) Build() (BACnetSecurityLevelTagged, error) {
	if b.Header == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'header' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetSecurityLevelTagged.deepCopy(), nil
}

func (b *_BACnetSecurityLevelTaggedBuilder) MustBuild() BACnetSecurityLevelTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetSecurityLevelTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetSecurityLevelTaggedBuilder().(*_BACnetSecurityLevelTaggedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetSecurityLevelTaggedBuilder creates a BACnetSecurityLevelTaggedBuilder
func (b *_BACnetSecurityLevelTagged) CreateBACnetSecurityLevelTaggedBuilder() BACnetSecurityLevelTaggedBuilder {
	if b == nil {
		return NewBACnetSecurityLevelTaggedBuilder()
	}
	return &_BACnetSecurityLevelTaggedBuilder{_BACnetSecurityLevelTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetSecurityLevelTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetSecurityLevelTagged) GetValue() BACnetSecurityLevel {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetSecurityLevelTagged(structType any) BACnetSecurityLevelTagged {
	if casted, ok := structType.(BACnetSecurityLevelTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetSecurityLevelTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetSecurityLevelTagged) GetTypeName() string {
	return "BACnetSecurityLevelTagged"
}

func (m *_BACnetSecurityLevelTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetSecurityLevelTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetSecurityLevelTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetSecurityLevelTagged, error) {
	return BACnetSecurityLevelTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetSecurityLevelTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetSecurityLevelTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetSecurityLevelTagged, error) {
		return BACnetSecurityLevelTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetSecurityLevelTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetSecurityLevelTagged, error) {
	v, err := (&_BACnetSecurityLevelTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetSecurityLevelTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetSecurityLevelTagged BACnetSecurityLevelTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetSecurityLevelTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetSecurityLevelTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetSecurityLevel](ctx, "value", readBuffer, EnsureType[BACnetSecurityLevel](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetSecurityLevel_INCAPABLE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetSecurityLevelTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetSecurityLevelTagged")
	}

	return m, nil
}

func (m *_BACnetSecurityLevelTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetSecurityLevelTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetSecurityLevelTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetSecurityLevelTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetSecurityLevel](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetSecurityLevelTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetSecurityLevelTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetSecurityLevelTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetSecurityLevelTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetSecurityLevelTagged) IsBACnetSecurityLevelTagged() {}

func (m *_BACnetSecurityLevelTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetSecurityLevelTagged) deepCopy() *_BACnetSecurityLevelTagged {
	if m == nil {
		return nil
	}
	_BACnetSecurityLevelTaggedCopy := &_BACnetSecurityLevelTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetSecurityLevelTaggedCopy
}

func (m *_BACnetSecurityLevelTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
