/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetRouterEntryStatusTagged is the corresponding interface of BACnetRouterEntryStatusTagged
type BACnetRouterEntryStatusTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetRouterEntryStatus
	// IsBACnetRouterEntryStatusTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetRouterEntryStatusTagged()
	// CreateBuilder creates a BACnetRouterEntryStatusTaggedBuilder
	CreateBACnetRouterEntryStatusTaggedBuilder() BACnetRouterEntryStatusTaggedBuilder
}

// _BACnetRouterEntryStatusTagged is the data-structure of this message
type _BACnetRouterEntryStatusTagged struct {
	Header BACnetTagHeader
	Value  BACnetRouterEntryStatus

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetRouterEntryStatusTagged = (*_BACnetRouterEntryStatusTagged)(nil)

// NewBACnetRouterEntryStatusTagged factory function for _BACnetRouterEntryStatusTagged
func NewBACnetRouterEntryStatusTagged(header BACnetTagHeader, value BACnetRouterEntryStatus, tagNumber uint8, tagClass TagClass) *_BACnetRouterEntryStatusTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetRouterEntryStatusTagged must not be nil")
	}
	return &_BACnetRouterEntryStatusTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetRouterEntryStatusTaggedBuilder is a builder for BACnetRouterEntryStatusTagged
type BACnetRouterEntryStatusTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetRouterEntryStatus) BACnetRouterEntryStatusTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetRouterEntryStatusTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetRouterEntryStatusTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetRouterEntryStatus) BACnetRouterEntryStatusTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetRouterEntryStatusTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetRouterEntryStatusTaggedBuilder
	// Build builds the BACnetRouterEntryStatusTagged or returns an error if something is wrong
	Build() (BACnetRouterEntryStatusTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetRouterEntryStatusTagged
}

// NewBACnetRouterEntryStatusTaggedBuilder() creates a BACnetRouterEntryStatusTaggedBuilder
func NewBACnetRouterEntryStatusTaggedBuilder() BACnetRouterEntryStatusTaggedBuilder {
	return &_BACnetRouterEntryStatusTaggedBuilder{_BACnetRouterEntryStatusTagged: new(_BACnetRouterEntryStatusTagged)}
}

type _BACnetRouterEntryStatusTaggedBuilder struct {
	*_BACnetRouterEntryStatusTagged

	err *utils.MultiError
}

var _ (BACnetRouterEntryStatusTaggedBuilder) = (*_BACnetRouterEntryStatusTaggedBuilder)(nil)

func (b *_BACnetRouterEntryStatusTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetRouterEntryStatus) BACnetRouterEntryStatusTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetRouterEntryStatusTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetRouterEntryStatusTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetRouterEntryStatusTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetRouterEntryStatusTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetRouterEntryStatusTaggedBuilder) WithValue(value BACnetRouterEntryStatus) BACnetRouterEntryStatusTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetRouterEntryStatusTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetRouterEntryStatusTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetRouterEntryStatusTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetRouterEntryStatusTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetRouterEntryStatusTaggedBuilder) Build() (BACnetRouterEntryStatusTagged, error) {
	if b.Header == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'header' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetRouterEntryStatusTagged.deepCopy(), nil
}

func (b *_BACnetRouterEntryStatusTaggedBuilder) MustBuild() BACnetRouterEntryStatusTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetRouterEntryStatusTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetRouterEntryStatusTaggedBuilder().(*_BACnetRouterEntryStatusTaggedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetRouterEntryStatusTaggedBuilder creates a BACnetRouterEntryStatusTaggedBuilder
func (b *_BACnetRouterEntryStatusTagged) CreateBACnetRouterEntryStatusTaggedBuilder() BACnetRouterEntryStatusTaggedBuilder {
	if b == nil {
		return NewBACnetRouterEntryStatusTaggedBuilder()
	}
	return &_BACnetRouterEntryStatusTaggedBuilder{_BACnetRouterEntryStatusTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetRouterEntryStatusTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetRouterEntryStatusTagged) GetValue() BACnetRouterEntryStatus {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetRouterEntryStatusTagged(structType any) BACnetRouterEntryStatusTagged {
	if casted, ok := structType.(BACnetRouterEntryStatusTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetRouterEntryStatusTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetRouterEntryStatusTagged) GetTypeName() string {
	return "BACnetRouterEntryStatusTagged"
}

func (m *_BACnetRouterEntryStatusTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetRouterEntryStatusTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetRouterEntryStatusTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetRouterEntryStatusTagged, error) {
	return BACnetRouterEntryStatusTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetRouterEntryStatusTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetRouterEntryStatusTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetRouterEntryStatusTagged, error) {
		return BACnetRouterEntryStatusTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetRouterEntryStatusTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetRouterEntryStatusTagged, error) {
	v, err := (&_BACnetRouterEntryStatusTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetRouterEntryStatusTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetRouterEntryStatusTagged BACnetRouterEntryStatusTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetRouterEntryStatusTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetRouterEntryStatusTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetRouterEntryStatus](ctx, "value", readBuffer, EnsureType[BACnetRouterEntryStatus](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetRouterEntryStatus_AVAILABLE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetRouterEntryStatusTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetRouterEntryStatusTagged")
	}

	return m, nil
}

func (m *_BACnetRouterEntryStatusTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetRouterEntryStatusTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetRouterEntryStatusTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetRouterEntryStatusTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetRouterEntryStatus](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetRouterEntryStatusTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetRouterEntryStatusTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetRouterEntryStatusTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetRouterEntryStatusTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetRouterEntryStatusTagged) IsBACnetRouterEntryStatusTagged() {}

func (m *_BACnetRouterEntryStatusTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetRouterEntryStatusTagged) deepCopy() *_BACnetRouterEntryStatusTagged {
	if m == nil {
		return nil
	}
	_BACnetRouterEntryStatusTaggedCopy := &_BACnetRouterEntryStatusTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetRouterEntryStatusTaggedCopy
}

func (m *_BACnetRouterEntryStatusTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
