/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetReliabilityTagged is the corresponding interface of BACnetReliabilityTagged
type BACnetReliabilityTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetReliability
	// GetProprietaryValue returns ProprietaryValue (property field)
	GetProprietaryValue() uint32
	// GetIsProprietary returns IsProprietary (virtual field)
	GetIsProprietary() bool
	// IsBACnetReliabilityTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetReliabilityTagged()
	// CreateBuilder creates a BACnetReliabilityTaggedBuilder
	CreateBACnetReliabilityTaggedBuilder() BACnetReliabilityTaggedBuilder
}

// _BACnetReliabilityTagged is the data-structure of this message
type _BACnetReliabilityTagged struct {
	Header           BACnetTagHeader
	Value            BACnetReliability
	ProprietaryValue uint32

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetReliabilityTagged = (*_BACnetReliabilityTagged)(nil)

// NewBACnetReliabilityTagged factory function for _BACnetReliabilityTagged
func NewBACnetReliabilityTagged(header BACnetTagHeader, value BACnetReliability, proprietaryValue uint32, tagNumber uint8, tagClass TagClass) *_BACnetReliabilityTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetReliabilityTagged must not be nil")
	}
	return &_BACnetReliabilityTagged{Header: header, Value: value, ProprietaryValue: proprietaryValue, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetReliabilityTaggedBuilder is a builder for BACnetReliabilityTagged
type BACnetReliabilityTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetReliability, proprietaryValue uint32) BACnetReliabilityTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetReliabilityTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetReliabilityTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetReliability) BACnetReliabilityTaggedBuilder
	// WithProprietaryValue adds ProprietaryValue (property field)
	WithProprietaryValue(uint32) BACnetReliabilityTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetReliabilityTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetReliabilityTaggedBuilder
	// Build builds the BACnetReliabilityTagged or returns an error if something is wrong
	Build() (BACnetReliabilityTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetReliabilityTagged
}

// NewBACnetReliabilityTaggedBuilder() creates a BACnetReliabilityTaggedBuilder
func NewBACnetReliabilityTaggedBuilder() BACnetReliabilityTaggedBuilder {
	return &_BACnetReliabilityTaggedBuilder{_BACnetReliabilityTagged: new(_BACnetReliabilityTagged)}
}

type _BACnetReliabilityTaggedBuilder struct {
	*_BACnetReliabilityTagged

	err *utils.MultiError
}

var _ (BACnetReliabilityTaggedBuilder) = (*_BACnetReliabilityTaggedBuilder)(nil)

func (b *_BACnetReliabilityTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetReliability, proprietaryValue uint32) BACnetReliabilityTaggedBuilder {
	return b.WithHeader(header).WithValue(value).WithProprietaryValue(proprietaryValue)
}

func (b *_BACnetReliabilityTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetReliabilityTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetReliabilityTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetReliabilityTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetReliabilityTaggedBuilder) WithValue(value BACnetReliability) BACnetReliabilityTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetReliabilityTaggedBuilder) WithProprietaryValue(proprietaryValue uint32) BACnetReliabilityTaggedBuilder {
	b.ProprietaryValue = proprietaryValue
	return b
}

func (b *_BACnetReliabilityTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetReliabilityTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetReliabilityTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetReliabilityTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetReliabilityTaggedBuilder) Build() (BACnetReliabilityTagged, error) {
	if b.Header == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'header' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetReliabilityTagged.deepCopy(), nil
}

func (b *_BACnetReliabilityTaggedBuilder) MustBuild() BACnetReliabilityTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetReliabilityTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetReliabilityTaggedBuilder().(*_BACnetReliabilityTaggedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetReliabilityTaggedBuilder creates a BACnetReliabilityTaggedBuilder
func (b *_BACnetReliabilityTagged) CreateBACnetReliabilityTaggedBuilder() BACnetReliabilityTaggedBuilder {
	if b == nil {
		return NewBACnetReliabilityTaggedBuilder()
	}
	return &_BACnetReliabilityTaggedBuilder{_BACnetReliabilityTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetReliabilityTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetReliabilityTagged) GetValue() BACnetReliability {
	return m.Value
}

func (m *_BACnetReliabilityTagged) GetProprietaryValue() uint32 {
	return m.ProprietaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetReliabilityTagged) GetIsProprietary() bool {
	ctx := context.Background()
	_ = ctx
	return bool(bool((m.GetValue()) == (BACnetReliability_VENDOR_PROPRIETARY_VALUE)))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetReliabilityTagged(structType any) BACnetReliabilityTagged {
	if casted, ok := structType.(BACnetReliabilityTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetReliabilityTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetReliabilityTagged) GetTypeName() string {
	return "BACnetReliabilityTagged"
}

func (m *_BACnetReliabilityTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32(int32(0)) }, func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }).(int32))

	// A virtual field doesn't have any in- or output.

	// Manual Field (proprietaryValue)
	lengthInBits += uint16(utils.InlineIf(m.GetIsProprietary(), func() any { return int32((int32(m.GetHeader().GetActualLength()) * int32(int32(8)))) }, func() any { return int32(int32(0)) }).(int32))

	return lengthInBits
}

func (m *_BACnetReliabilityTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetReliabilityTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetReliabilityTagged, error) {
	return BACnetReliabilityTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetReliabilityTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetReliabilityTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetReliabilityTagged, error) {
		return BACnetReliabilityTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetReliabilityTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetReliabilityTagged, error) {
	v, err := (&_BACnetReliabilityTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetReliabilityTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetReliabilityTagged BACnetReliabilityTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetReliabilityTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetReliabilityTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetReliability](ctx, "value", readBuffer, EnsureType[BACnetReliability](ReadEnumGeneric(ctx, readBuffer, header.GetActualLength(), BACnetReliability_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	isProprietary, err := ReadVirtualField[bool](ctx, "isProprietary", (*bool)(nil), bool((value) == (BACnetReliability_VENDOR_PROPRIETARY_VALUE)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'isProprietary' field"))
	}
	_ = isProprietary

	proprietaryValue, err := ReadManualField[uint32](ctx, "proprietaryValue", readBuffer, EnsureType[uint32](ReadProprietaryEnumGeneric(ctx, readBuffer, header.GetActualLength(), isProprietary)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'proprietaryValue' field"))
	}
	m.ProprietaryValue = proprietaryValue

	if closeErr := readBuffer.CloseContext("BACnetReliabilityTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetReliabilityTagged")
	}

	return m, nil
}

func (m *_BACnetReliabilityTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetReliabilityTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetReliabilityTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetReliabilityTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetReliability](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}
	// Virtual field
	isProprietary := m.GetIsProprietary()
	_ = isProprietary
	if _isProprietaryErr := writeBuffer.WriteVirtual(ctx, "isProprietary", m.GetIsProprietary()); _isProprietaryErr != nil {
		return errors.Wrap(_isProprietaryErr, "Error serializing 'isProprietary' field")
	}

	if err := WriteManualField[uint32](ctx, "proprietaryValue", func(ctx context.Context) error {
		return WriteProprietaryEnumGeneric(ctx, writeBuffer, m.GetProprietaryValue(), m.GetIsProprietary())
	}, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'proprietaryValue' field")
	}

	if popErr := writeBuffer.PopContext("BACnetReliabilityTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetReliabilityTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetReliabilityTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetReliabilityTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetReliabilityTagged) IsBACnetReliabilityTagged() {}

func (m *_BACnetReliabilityTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetReliabilityTagged) deepCopy() *_BACnetReliabilityTagged {
	if m == nil {
		return nil
	}
	_BACnetReliabilityTaggedCopy := &_BACnetReliabilityTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.ProprietaryValue,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetReliabilityTaggedCopy
}

func (m *_BACnetReliabilityTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
