/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesNotifyType is the corresponding interface of BACnetPropertyStatesNotifyType
type BACnetPropertyStatesNotifyType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetNotifyType returns NotifyType (property field)
	GetNotifyType() BACnetNotifyTypeTagged
	// IsBACnetPropertyStatesNotifyType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesNotifyType()
	// CreateBuilder creates a BACnetPropertyStatesNotifyTypeBuilder
	CreateBACnetPropertyStatesNotifyTypeBuilder() BACnetPropertyStatesNotifyTypeBuilder
}

// _BACnetPropertyStatesNotifyType is the data-structure of this message
type _BACnetPropertyStatesNotifyType struct {
	BACnetPropertyStatesContract
	NotifyType BACnetNotifyTypeTagged
}

var _ BACnetPropertyStatesNotifyType = (*_BACnetPropertyStatesNotifyType)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesNotifyType)(nil)

// NewBACnetPropertyStatesNotifyType factory function for _BACnetPropertyStatesNotifyType
func NewBACnetPropertyStatesNotifyType(peekedTagHeader BACnetTagHeader, notifyType BACnetNotifyTypeTagged) *_BACnetPropertyStatesNotifyType {
	if notifyType == nil {
		panic("notifyType of type BACnetNotifyTypeTagged for BACnetPropertyStatesNotifyType must not be nil")
	}
	_result := &_BACnetPropertyStatesNotifyType{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		NotifyType:                   notifyType,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesNotifyTypeBuilder is a builder for BACnetPropertyStatesNotifyType
type BACnetPropertyStatesNotifyTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(notifyType BACnetNotifyTypeTagged) BACnetPropertyStatesNotifyTypeBuilder
	// WithNotifyType adds NotifyType (property field)
	WithNotifyType(BACnetNotifyTypeTagged) BACnetPropertyStatesNotifyTypeBuilder
	// WithNotifyTypeBuilder adds NotifyType (property field) which is build by the builder
	WithNotifyTypeBuilder(func(BACnetNotifyTypeTaggedBuilder) BACnetNotifyTypeTaggedBuilder) BACnetPropertyStatesNotifyTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesNotifyType or returns an error if something is wrong
	Build() (BACnetPropertyStatesNotifyType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesNotifyType
}

// NewBACnetPropertyStatesNotifyTypeBuilder() creates a BACnetPropertyStatesNotifyTypeBuilder
func NewBACnetPropertyStatesNotifyTypeBuilder() BACnetPropertyStatesNotifyTypeBuilder {
	return &_BACnetPropertyStatesNotifyTypeBuilder{_BACnetPropertyStatesNotifyType: new(_BACnetPropertyStatesNotifyType)}
}

type _BACnetPropertyStatesNotifyTypeBuilder struct {
	*_BACnetPropertyStatesNotifyType

	parentBuilder *_BACnetPropertyStatesBuilder

	err *utils.MultiError
}

var _ (BACnetPropertyStatesNotifyTypeBuilder) = (*_BACnetPropertyStatesNotifyTypeBuilder)(nil)

func (b *_BACnetPropertyStatesNotifyTypeBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesNotifyType
}

func (b *_BACnetPropertyStatesNotifyTypeBuilder) WithMandatoryFields(notifyType BACnetNotifyTypeTagged) BACnetPropertyStatesNotifyTypeBuilder {
	return b.WithNotifyType(notifyType)
}

func (b *_BACnetPropertyStatesNotifyTypeBuilder) WithNotifyType(notifyType BACnetNotifyTypeTagged) BACnetPropertyStatesNotifyTypeBuilder {
	b.NotifyType = notifyType
	return b
}

func (b *_BACnetPropertyStatesNotifyTypeBuilder) WithNotifyTypeBuilder(builderSupplier func(BACnetNotifyTypeTaggedBuilder) BACnetNotifyTypeTaggedBuilder) BACnetPropertyStatesNotifyTypeBuilder {
	builder := builderSupplier(b.NotifyType.CreateBACnetNotifyTypeTaggedBuilder())
	var err error
	b.NotifyType, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetNotifyTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesNotifyTypeBuilder) Build() (BACnetPropertyStatesNotifyType, error) {
	if b.NotifyType == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'notifyType' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetPropertyStatesNotifyType.deepCopy(), nil
}

func (b *_BACnetPropertyStatesNotifyTypeBuilder) MustBuild() BACnetPropertyStatesNotifyType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesNotifyTypeBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesNotifyTypeBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesNotifyTypeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesNotifyTypeBuilder().(*_BACnetPropertyStatesNotifyTypeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetPropertyStatesNotifyTypeBuilder creates a BACnetPropertyStatesNotifyTypeBuilder
func (b *_BACnetPropertyStatesNotifyType) CreateBACnetPropertyStatesNotifyTypeBuilder() BACnetPropertyStatesNotifyTypeBuilder {
	if b == nil {
		return NewBACnetPropertyStatesNotifyTypeBuilder()
	}
	return &_BACnetPropertyStatesNotifyTypeBuilder{_BACnetPropertyStatesNotifyType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesNotifyType) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesNotifyType) GetNotifyType() BACnetNotifyTypeTagged {
	return m.NotifyType
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesNotifyType(structType any) BACnetPropertyStatesNotifyType {
	if casted, ok := structType.(BACnetPropertyStatesNotifyType); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesNotifyType); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesNotifyType) GetTypeName() string {
	return "BACnetPropertyStatesNotifyType"
}

func (m *_BACnetPropertyStatesNotifyType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (notifyType)
	lengthInBits += m.NotifyType.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesNotifyType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesNotifyType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesNotifyType BACnetPropertyStatesNotifyType, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesNotifyType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesNotifyType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	notifyType, err := ReadSimpleField[BACnetNotifyTypeTagged](ctx, "notifyType", ReadComplex[BACnetNotifyTypeTagged](BACnetNotifyTypeTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notifyType' field"))
	}
	m.NotifyType = notifyType

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesNotifyType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesNotifyType")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesNotifyType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesNotifyType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesNotifyType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesNotifyType")
		}

		if err := WriteSimpleField[BACnetNotifyTypeTagged](ctx, "notifyType", m.GetNotifyType(), WriteComplex[BACnetNotifyTypeTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'notifyType' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesNotifyType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesNotifyType")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesNotifyType) IsBACnetPropertyStatesNotifyType() {}

func (m *_BACnetPropertyStatesNotifyType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesNotifyType) deepCopy() *_BACnetPropertyStatesNotifyType {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesNotifyTypeCopy := &_BACnetPropertyStatesNotifyType{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetNotifyTypeTagged](m.NotifyType),
	}
	_BACnetPropertyStatesNotifyTypeCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesNotifyTypeCopy
}

func (m *_BACnetPropertyStatesNotifyType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
