/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesLockStatus is the corresponding interface of BACnetPropertyStatesLockStatus
type BACnetPropertyStatesLockStatus interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetLockStatus returns LockStatus (property field)
	GetLockStatus() BACnetLockStatusTagged
	// IsBACnetPropertyStatesLockStatus is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesLockStatus()
	// CreateBuilder creates a BACnetPropertyStatesLockStatusBuilder
	CreateBACnetPropertyStatesLockStatusBuilder() BACnetPropertyStatesLockStatusBuilder
}

// _BACnetPropertyStatesLockStatus is the data-structure of this message
type _BACnetPropertyStatesLockStatus struct {
	BACnetPropertyStatesContract
	LockStatus BACnetLockStatusTagged
}

var _ BACnetPropertyStatesLockStatus = (*_BACnetPropertyStatesLockStatus)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesLockStatus)(nil)

// NewBACnetPropertyStatesLockStatus factory function for _BACnetPropertyStatesLockStatus
func NewBACnetPropertyStatesLockStatus(peekedTagHeader BACnetTagHeader, lockStatus BACnetLockStatusTagged) *_BACnetPropertyStatesLockStatus {
	if lockStatus == nil {
		panic("lockStatus of type BACnetLockStatusTagged for BACnetPropertyStatesLockStatus must not be nil")
	}
	_result := &_BACnetPropertyStatesLockStatus{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		LockStatus:                   lockStatus,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesLockStatusBuilder is a builder for BACnetPropertyStatesLockStatus
type BACnetPropertyStatesLockStatusBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(lockStatus BACnetLockStatusTagged) BACnetPropertyStatesLockStatusBuilder
	// WithLockStatus adds LockStatus (property field)
	WithLockStatus(BACnetLockStatusTagged) BACnetPropertyStatesLockStatusBuilder
	// WithLockStatusBuilder adds LockStatus (property field) which is build by the builder
	WithLockStatusBuilder(func(BACnetLockStatusTaggedBuilder) BACnetLockStatusTaggedBuilder) BACnetPropertyStatesLockStatusBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesLockStatus or returns an error if something is wrong
	Build() (BACnetPropertyStatesLockStatus, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesLockStatus
}

// NewBACnetPropertyStatesLockStatusBuilder() creates a BACnetPropertyStatesLockStatusBuilder
func NewBACnetPropertyStatesLockStatusBuilder() BACnetPropertyStatesLockStatusBuilder {
	return &_BACnetPropertyStatesLockStatusBuilder{_BACnetPropertyStatesLockStatus: new(_BACnetPropertyStatesLockStatus)}
}

type _BACnetPropertyStatesLockStatusBuilder struct {
	*_BACnetPropertyStatesLockStatus

	parentBuilder *_BACnetPropertyStatesBuilder

	err *utils.MultiError
}

var _ (BACnetPropertyStatesLockStatusBuilder) = (*_BACnetPropertyStatesLockStatusBuilder)(nil)

func (b *_BACnetPropertyStatesLockStatusBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesLockStatus
}

func (b *_BACnetPropertyStatesLockStatusBuilder) WithMandatoryFields(lockStatus BACnetLockStatusTagged) BACnetPropertyStatesLockStatusBuilder {
	return b.WithLockStatus(lockStatus)
}

func (b *_BACnetPropertyStatesLockStatusBuilder) WithLockStatus(lockStatus BACnetLockStatusTagged) BACnetPropertyStatesLockStatusBuilder {
	b.LockStatus = lockStatus
	return b
}

func (b *_BACnetPropertyStatesLockStatusBuilder) WithLockStatusBuilder(builderSupplier func(BACnetLockStatusTaggedBuilder) BACnetLockStatusTaggedBuilder) BACnetPropertyStatesLockStatusBuilder {
	builder := builderSupplier(b.LockStatus.CreateBACnetLockStatusTaggedBuilder())
	var err error
	b.LockStatus, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetLockStatusTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesLockStatusBuilder) Build() (BACnetPropertyStatesLockStatus, error) {
	if b.LockStatus == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'lockStatus' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetPropertyStatesLockStatus.deepCopy(), nil
}

func (b *_BACnetPropertyStatesLockStatusBuilder) MustBuild() BACnetPropertyStatesLockStatus {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesLockStatusBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesLockStatusBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesLockStatusBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesLockStatusBuilder().(*_BACnetPropertyStatesLockStatusBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetPropertyStatesLockStatusBuilder creates a BACnetPropertyStatesLockStatusBuilder
func (b *_BACnetPropertyStatesLockStatus) CreateBACnetPropertyStatesLockStatusBuilder() BACnetPropertyStatesLockStatusBuilder {
	if b == nil {
		return NewBACnetPropertyStatesLockStatusBuilder()
	}
	return &_BACnetPropertyStatesLockStatusBuilder{_BACnetPropertyStatesLockStatus: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesLockStatus) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesLockStatus) GetLockStatus() BACnetLockStatusTagged {
	return m.LockStatus
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesLockStatus(structType any) BACnetPropertyStatesLockStatus {
	if casted, ok := structType.(BACnetPropertyStatesLockStatus); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesLockStatus); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesLockStatus) GetTypeName() string {
	return "BACnetPropertyStatesLockStatus"
}

func (m *_BACnetPropertyStatesLockStatus) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (lockStatus)
	lengthInBits += m.LockStatus.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesLockStatus) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesLockStatus) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesLockStatus BACnetPropertyStatesLockStatus, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesLockStatus"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesLockStatus")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	lockStatus, err := ReadSimpleField[BACnetLockStatusTagged](ctx, "lockStatus", ReadComplex[BACnetLockStatusTagged](BACnetLockStatusTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lockStatus' field"))
	}
	m.LockStatus = lockStatus

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesLockStatus"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesLockStatus")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesLockStatus) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesLockStatus) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesLockStatus"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesLockStatus")
		}

		if err := WriteSimpleField[BACnetLockStatusTagged](ctx, "lockStatus", m.GetLockStatus(), WriteComplex[BACnetLockStatusTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'lockStatus' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesLockStatus"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesLockStatus")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesLockStatus) IsBACnetPropertyStatesLockStatus() {}

func (m *_BACnetPropertyStatesLockStatus) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesLockStatus) deepCopy() *_BACnetPropertyStatesLockStatus {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesLockStatusCopy := &_BACnetPropertyStatesLockStatus{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetLockStatusTagged](m.LockStatus),
	}
	_BACnetPropertyStatesLockStatusCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesLockStatusCopy
}

func (m *_BACnetPropertyStatesLockStatus) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
