/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesLiftCarDirection is the corresponding interface of BACnetPropertyStatesLiftCarDirection
type BACnetPropertyStatesLiftCarDirection interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetLiftCarDirection returns LiftCarDirection (property field)
	GetLiftCarDirection() BACnetLiftCarDirectionTagged
	// IsBACnetPropertyStatesLiftCarDirection is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesLiftCarDirection()
	// CreateBuilder creates a BACnetPropertyStatesLiftCarDirectionBuilder
	CreateBACnetPropertyStatesLiftCarDirectionBuilder() BACnetPropertyStatesLiftCarDirectionBuilder
}

// _BACnetPropertyStatesLiftCarDirection is the data-structure of this message
type _BACnetPropertyStatesLiftCarDirection struct {
	BACnetPropertyStatesContract
	LiftCarDirection BACnetLiftCarDirectionTagged
}

var _ BACnetPropertyStatesLiftCarDirection = (*_BACnetPropertyStatesLiftCarDirection)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesLiftCarDirection)(nil)

// NewBACnetPropertyStatesLiftCarDirection factory function for _BACnetPropertyStatesLiftCarDirection
func NewBACnetPropertyStatesLiftCarDirection(peekedTagHeader BACnetTagHeader, liftCarDirection BACnetLiftCarDirectionTagged) *_BACnetPropertyStatesLiftCarDirection {
	if liftCarDirection == nil {
		panic("liftCarDirection of type BACnetLiftCarDirectionTagged for BACnetPropertyStatesLiftCarDirection must not be nil")
	}
	_result := &_BACnetPropertyStatesLiftCarDirection{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		LiftCarDirection:             liftCarDirection,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesLiftCarDirectionBuilder is a builder for BACnetPropertyStatesLiftCarDirection
type BACnetPropertyStatesLiftCarDirectionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(liftCarDirection BACnetLiftCarDirectionTagged) BACnetPropertyStatesLiftCarDirectionBuilder
	// WithLiftCarDirection adds LiftCarDirection (property field)
	WithLiftCarDirection(BACnetLiftCarDirectionTagged) BACnetPropertyStatesLiftCarDirectionBuilder
	// WithLiftCarDirectionBuilder adds LiftCarDirection (property field) which is build by the builder
	WithLiftCarDirectionBuilder(func(BACnetLiftCarDirectionTaggedBuilder) BACnetLiftCarDirectionTaggedBuilder) BACnetPropertyStatesLiftCarDirectionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesLiftCarDirection or returns an error if something is wrong
	Build() (BACnetPropertyStatesLiftCarDirection, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesLiftCarDirection
}

// NewBACnetPropertyStatesLiftCarDirectionBuilder() creates a BACnetPropertyStatesLiftCarDirectionBuilder
func NewBACnetPropertyStatesLiftCarDirectionBuilder() BACnetPropertyStatesLiftCarDirectionBuilder {
	return &_BACnetPropertyStatesLiftCarDirectionBuilder{_BACnetPropertyStatesLiftCarDirection: new(_BACnetPropertyStatesLiftCarDirection)}
}

type _BACnetPropertyStatesLiftCarDirectionBuilder struct {
	*_BACnetPropertyStatesLiftCarDirection

	parentBuilder *_BACnetPropertyStatesBuilder

	err *utils.MultiError
}

var _ (BACnetPropertyStatesLiftCarDirectionBuilder) = (*_BACnetPropertyStatesLiftCarDirectionBuilder)(nil)

func (b *_BACnetPropertyStatesLiftCarDirectionBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesLiftCarDirection
}

func (b *_BACnetPropertyStatesLiftCarDirectionBuilder) WithMandatoryFields(liftCarDirection BACnetLiftCarDirectionTagged) BACnetPropertyStatesLiftCarDirectionBuilder {
	return b.WithLiftCarDirection(liftCarDirection)
}

func (b *_BACnetPropertyStatesLiftCarDirectionBuilder) WithLiftCarDirection(liftCarDirection BACnetLiftCarDirectionTagged) BACnetPropertyStatesLiftCarDirectionBuilder {
	b.LiftCarDirection = liftCarDirection
	return b
}

func (b *_BACnetPropertyStatesLiftCarDirectionBuilder) WithLiftCarDirectionBuilder(builderSupplier func(BACnetLiftCarDirectionTaggedBuilder) BACnetLiftCarDirectionTaggedBuilder) BACnetPropertyStatesLiftCarDirectionBuilder {
	builder := builderSupplier(b.LiftCarDirection.CreateBACnetLiftCarDirectionTaggedBuilder())
	var err error
	b.LiftCarDirection, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetLiftCarDirectionTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesLiftCarDirectionBuilder) Build() (BACnetPropertyStatesLiftCarDirection, error) {
	if b.LiftCarDirection == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'liftCarDirection' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetPropertyStatesLiftCarDirection.deepCopy(), nil
}

func (b *_BACnetPropertyStatesLiftCarDirectionBuilder) MustBuild() BACnetPropertyStatesLiftCarDirection {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesLiftCarDirectionBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesLiftCarDirectionBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesLiftCarDirectionBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesLiftCarDirectionBuilder().(*_BACnetPropertyStatesLiftCarDirectionBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetPropertyStatesLiftCarDirectionBuilder creates a BACnetPropertyStatesLiftCarDirectionBuilder
func (b *_BACnetPropertyStatesLiftCarDirection) CreateBACnetPropertyStatesLiftCarDirectionBuilder() BACnetPropertyStatesLiftCarDirectionBuilder {
	if b == nil {
		return NewBACnetPropertyStatesLiftCarDirectionBuilder()
	}
	return &_BACnetPropertyStatesLiftCarDirectionBuilder{_BACnetPropertyStatesLiftCarDirection: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesLiftCarDirection) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesLiftCarDirection) GetLiftCarDirection() BACnetLiftCarDirectionTagged {
	return m.LiftCarDirection
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesLiftCarDirection(structType any) BACnetPropertyStatesLiftCarDirection {
	if casted, ok := structType.(BACnetPropertyStatesLiftCarDirection); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesLiftCarDirection); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesLiftCarDirection) GetTypeName() string {
	return "BACnetPropertyStatesLiftCarDirection"
}

func (m *_BACnetPropertyStatesLiftCarDirection) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (liftCarDirection)
	lengthInBits += m.LiftCarDirection.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesLiftCarDirection) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesLiftCarDirection) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesLiftCarDirection BACnetPropertyStatesLiftCarDirection, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesLiftCarDirection"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesLiftCarDirection")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	liftCarDirection, err := ReadSimpleField[BACnetLiftCarDirectionTagged](ctx, "liftCarDirection", ReadComplex[BACnetLiftCarDirectionTagged](BACnetLiftCarDirectionTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'liftCarDirection' field"))
	}
	m.LiftCarDirection = liftCarDirection

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesLiftCarDirection"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesLiftCarDirection")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesLiftCarDirection) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesLiftCarDirection) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesLiftCarDirection"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesLiftCarDirection")
		}

		if err := WriteSimpleField[BACnetLiftCarDirectionTagged](ctx, "liftCarDirection", m.GetLiftCarDirection(), WriteComplex[BACnetLiftCarDirectionTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'liftCarDirection' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesLiftCarDirection"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesLiftCarDirection")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesLiftCarDirection) IsBACnetPropertyStatesLiftCarDirection() {}

func (m *_BACnetPropertyStatesLiftCarDirection) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesLiftCarDirection) deepCopy() *_BACnetPropertyStatesLiftCarDirection {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesLiftCarDirectionCopy := &_BACnetPropertyStatesLiftCarDirection{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetLiftCarDirectionTagged](m.LiftCarDirection),
	}
	_BACnetPropertyStatesLiftCarDirectionCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesLiftCarDirectionCopy
}

func (m *_BACnetPropertyStatesLiftCarDirection) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
