/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetPropertyStatesBinaryValue is the corresponding interface of BACnetPropertyStatesBinaryValue
type BACnetPropertyStatesBinaryValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetPropertyStates
	// GetBinaryValue returns BinaryValue (property field)
	GetBinaryValue() BACnetBinaryPVTagged
	// IsBACnetPropertyStatesBinaryValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetPropertyStatesBinaryValue()
	// CreateBuilder creates a BACnetPropertyStatesBinaryValueBuilder
	CreateBACnetPropertyStatesBinaryValueBuilder() BACnetPropertyStatesBinaryValueBuilder
}

// _BACnetPropertyStatesBinaryValue is the data-structure of this message
type _BACnetPropertyStatesBinaryValue struct {
	BACnetPropertyStatesContract
	BinaryValue BACnetBinaryPVTagged
}

var _ BACnetPropertyStatesBinaryValue = (*_BACnetPropertyStatesBinaryValue)(nil)
var _ BACnetPropertyStatesRequirements = (*_BACnetPropertyStatesBinaryValue)(nil)

// NewBACnetPropertyStatesBinaryValue factory function for _BACnetPropertyStatesBinaryValue
func NewBACnetPropertyStatesBinaryValue(peekedTagHeader BACnetTagHeader, binaryValue BACnetBinaryPVTagged) *_BACnetPropertyStatesBinaryValue {
	if binaryValue == nil {
		panic("binaryValue of type BACnetBinaryPVTagged for BACnetPropertyStatesBinaryValue must not be nil")
	}
	_result := &_BACnetPropertyStatesBinaryValue{
		BACnetPropertyStatesContract: NewBACnetPropertyStates(peekedTagHeader),
		BinaryValue:                  binaryValue,
	}
	_result.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetPropertyStatesBinaryValueBuilder is a builder for BACnetPropertyStatesBinaryValue
type BACnetPropertyStatesBinaryValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(binaryValue BACnetBinaryPVTagged) BACnetPropertyStatesBinaryValueBuilder
	// WithBinaryValue adds BinaryValue (property field)
	WithBinaryValue(BACnetBinaryPVTagged) BACnetPropertyStatesBinaryValueBuilder
	// WithBinaryValueBuilder adds BinaryValue (property field) which is build by the builder
	WithBinaryValueBuilder(func(BACnetBinaryPVTaggedBuilder) BACnetBinaryPVTaggedBuilder) BACnetPropertyStatesBinaryValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetPropertyStatesBuilder
	// Build builds the BACnetPropertyStatesBinaryValue or returns an error if something is wrong
	Build() (BACnetPropertyStatesBinaryValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetPropertyStatesBinaryValue
}

// NewBACnetPropertyStatesBinaryValueBuilder() creates a BACnetPropertyStatesBinaryValueBuilder
func NewBACnetPropertyStatesBinaryValueBuilder() BACnetPropertyStatesBinaryValueBuilder {
	return &_BACnetPropertyStatesBinaryValueBuilder{_BACnetPropertyStatesBinaryValue: new(_BACnetPropertyStatesBinaryValue)}
}

type _BACnetPropertyStatesBinaryValueBuilder struct {
	*_BACnetPropertyStatesBinaryValue

	parentBuilder *_BACnetPropertyStatesBuilder

	err *utils.MultiError
}

var _ (BACnetPropertyStatesBinaryValueBuilder) = (*_BACnetPropertyStatesBinaryValueBuilder)(nil)

func (b *_BACnetPropertyStatesBinaryValueBuilder) setParent(contract BACnetPropertyStatesContract) {
	b.BACnetPropertyStatesContract = contract
	contract.(*_BACnetPropertyStates)._SubType = b._BACnetPropertyStatesBinaryValue
}

func (b *_BACnetPropertyStatesBinaryValueBuilder) WithMandatoryFields(binaryValue BACnetBinaryPVTagged) BACnetPropertyStatesBinaryValueBuilder {
	return b.WithBinaryValue(binaryValue)
}

func (b *_BACnetPropertyStatesBinaryValueBuilder) WithBinaryValue(binaryValue BACnetBinaryPVTagged) BACnetPropertyStatesBinaryValueBuilder {
	b.BinaryValue = binaryValue
	return b
}

func (b *_BACnetPropertyStatesBinaryValueBuilder) WithBinaryValueBuilder(builderSupplier func(BACnetBinaryPVTaggedBuilder) BACnetBinaryPVTaggedBuilder) BACnetPropertyStatesBinaryValueBuilder {
	builder := builderSupplier(b.BinaryValue.CreateBACnetBinaryPVTaggedBuilder())
	var err error
	b.BinaryValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetBinaryPVTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetPropertyStatesBinaryValueBuilder) Build() (BACnetPropertyStatesBinaryValue, error) {
	if b.BinaryValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'binaryValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetPropertyStatesBinaryValue.deepCopy(), nil
}

func (b *_BACnetPropertyStatesBinaryValueBuilder) MustBuild() BACnetPropertyStatesBinaryValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetPropertyStatesBinaryValueBuilder) Done() BACnetPropertyStatesBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetPropertyStatesBuilder().(*_BACnetPropertyStatesBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetPropertyStatesBinaryValueBuilder) buildForBACnetPropertyStates() (BACnetPropertyStates, error) {
	return b.Build()
}

func (b *_BACnetPropertyStatesBinaryValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetPropertyStatesBinaryValueBuilder().(*_BACnetPropertyStatesBinaryValueBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetPropertyStatesBinaryValueBuilder creates a BACnetPropertyStatesBinaryValueBuilder
func (b *_BACnetPropertyStatesBinaryValue) CreateBACnetPropertyStatesBinaryValueBuilder() BACnetPropertyStatesBinaryValueBuilder {
	if b == nil {
		return NewBACnetPropertyStatesBinaryValueBuilder()
	}
	return &_BACnetPropertyStatesBinaryValueBuilder{_BACnetPropertyStatesBinaryValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetPropertyStatesBinaryValue) GetParent() BACnetPropertyStatesContract {
	return m.BACnetPropertyStatesContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetPropertyStatesBinaryValue) GetBinaryValue() BACnetBinaryPVTagged {
	return m.BinaryValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetPropertyStatesBinaryValue(structType any) BACnetPropertyStatesBinaryValue {
	if casted, ok := structType.(BACnetPropertyStatesBinaryValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetPropertyStatesBinaryValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetPropertyStatesBinaryValue) GetTypeName() string {
	return "BACnetPropertyStatesBinaryValue"
}

func (m *_BACnetPropertyStatesBinaryValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).getLengthInBits(ctx))

	// Simple field (binaryValue)
	lengthInBits += m.BinaryValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetPropertyStatesBinaryValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetPropertyStatesBinaryValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetPropertyStates, peekedTagNumber uint8) (__bACnetPropertyStatesBinaryValue BACnetPropertyStatesBinaryValue, err error) {
	m.BACnetPropertyStatesContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetPropertyStatesBinaryValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetPropertyStatesBinaryValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	binaryValue, err := ReadSimpleField[BACnetBinaryPVTagged](ctx, "binaryValue", ReadComplex[BACnetBinaryPVTagged](BACnetBinaryPVTaggedParseWithBufferProducer((uint8)(peekedTagNumber), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'binaryValue' field"))
	}
	m.BinaryValue = binaryValue

	if closeErr := readBuffer.CloseContext("BACnetPropertyStatesBinaryValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetPropertyStatesBinaryValue")
	}

	return m, nil
}

func (m *_BACnetPropertyStatesBinaryValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetPropertyStatesBinaryValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetPropertyStatesBinaryValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetPropertyStatesBinaryValue")
		}

		if err := WriteSimpleField[BACnetBinaryPVTagged](ctx, "binaryValue", m.GetBinaryValue(), WriteComplex[BACnetBinaryPVTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'binaryValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetPropertyStatesBinaryValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetPropertyStatesBinaryValue")
		}
		return nil
	}
	return m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetPropertyStatesBinaryValue) IsBACnetPropertyStatesBinaryValue() {}

func (m *_BACnetPropertyStatesBinaryValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetPropertyStatesBinaryValue) deepCopy() *_BACnetPropertyStatesBinaryValue {
	if m == nil {
		return nil
	}
	_BACnetPropertyStatesBinaryValueCopy := &_BACnetPropertyStatesBinaryValue{
		m.BACnetPropertyStatesContract.(*_BACnetPropertyStates).deepCopy(),
		utils.DeepCopy[BACnetBinaryPVTagged](m.BinaryValue),
	}
	_BACnetPropertyStatesBinaryValueCopy.BACnetPropertyStatesContract.(*_BACnetPropertyStates)._SubType = m
	return _BACnetPropertyStatesBinaryValueCopy
}

func (m *_BACnetPropertyStatesBinaryValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
