/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetOptionalUnsignedValue is the corresponding interface of BACnetOptionalUnsignedValue
type BACnetOptionalUnsignedValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetOptionalUnsigned
	// GetUnsignedValue returns UnsignedValue (property field)
	GetUnsignedValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetOptionalUnsignedValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetOptionalUnsignedValue()
	// CreateBuilder creates a BACnetOptionalUnsignedValueBuilder
	CreateBACnetOptionalUnsignedValueBuilder() BACnetOptionalUnsignedValueBuilder
}

// _BACnetOptionalUnsignedValue is the data-structure of this message
type _BACnetOptionalUnsignedValue struct {
	BACnetOptionalUnsignedContract
	UnsignedValue BACnetApplicationTagUnsignedInteger
}

var _ BACnetOptionalUnsignedValue = (*_BACnetOptionalUnsignedValue)(nil)
var _ BACnetOptionalUnsignedRequirements = (*_BACnetOptionalUnsignedValue)(nil)

// NewBACnetOptionalUnsignedValue factory function for _BACnetOptionalUnsignedValue
func NewBACnetOptionalUnsignedValue(peekedTagHeader BACnetTagHeader, unsignedValue BACnetApplicationTagUnsignedInteger) *_BACnetOptionalUnsignedValue {
	if unsignedValue == nil {
		panic("unsignedValue of type BACnetApplicationTagUnsignedInteger for BACnetOptionalUnsignedValue must not be nil")
	}
	_result := &_BACnetOptionalUnsignedValue{
		BACnetOptionalUnsignedContract: NewBACnetOptionalUnsigned(peekedTagHeader),
		UnsignedValue:                  unsignedValue,
	}
	_result.BACnetOptionalUnsignedContract.(*_BACnetOptionalUnsigned)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetOptionalUnsignedValueBuilder is a builder for BACnetOptionalUnsignedValue
type BACnetOptionalUnsignedValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(unsignedValue BACnetApplicationTagUnsignedInteger) BACnetOptionalUnsignedValueBuilder
	// WithUnsignedValue adds UnsignedValue (property field)
	WithUnsignedValue(BACnetApplicationTagUnsignedInteger) BACnetOptionalUnsignedValueBuilder
	// WithUnsignedValueBuilder adds UnsignedValue (property field) which is build by the builder
	WithUnsignedValueBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetOptionalUnsignedValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetOptionalUnsignedBuilder
	// Build builds the BACnetOptionalUnsignedValue or returns an error if something is wrong
	Build() (BACnetOptionalUnsignedValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetOptionalUnsignedValue
}

// NewBACnetOptionalUnsignedValueBuilder() creates a BACnetOptionalUnsignedValueBuilder
func NewBACnetOptionalUnsignedValueBuilder() BACnetOptionalUnsignedValueBuilder {
	return &_BACnetOptionalUnsignedValueBuilder{_BACnetOptionalUnsignedValue: new(_BACnetOptionalUnsignedValue)}
}

type _BACnetOptionalUnsignedValueBuilder struct {
	*_BACnetOptionalUnsignedValue

	parentBuilder *_BACnetOptionalUnsignedBuilder

	err *utils.MultiError
}

var _ (BACnetOptionalUnsignedValueBuilder) = (*_BACnetOptionalUnsignedValueBuilder)(nil)

func (b *_BACnetOptionalUnsignedValueBuilder) setParent(contract BACnetOptionalUnsignedContract) {
	b.BACnetOptionalUnsignedContract = contract
	contract.(*_BACnetOptionalUnsigned)._SubType = b._BACnetOptionalUnsignedValue
}

func (b *_BACnetOptionalUnsignedValueBuilder) WithMandatoryFields(unsignedValue BACnetApplicationTagUnsignedInteger) BACnetOptionalUnsignedValueBuilder {
	return b.WithUnsignedValue(unsignedValue)
}

func (b *_BACnetOptionalUnsignedValueBuilder) WithUnsignedValue(unsignedValue BACnetApplicationTagUnsignedInteger) BACnetOptionalUnsignedValueBuilder {
	b.UnsignedValue = unsignedValue
	return b
}

func (b *_BACnetOptionalUnsignedValueBuilder) WithUnsignedValueBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetOptionalUnsignedValueBuilder {
	builder := builderSupplier(b.UnsignedValue.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.UnsignedValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetOptionalUnsignedValueBuilder) Build() (BACnetOptionalUnsignedValue, error) {
	if b.UnsignedValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'unsignedValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetOptionalUnsignedValue.deepCopy(), nil
}

func (b *_BACnetOptionalUnsignedValueBuilder) MustBuild() BACnetOptionalUnsignedValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetOptionalUnsignedValueBuilder) Done() BACnetOptionalUnsignedBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetOptionalUnsignedBuilder().(*_BACnetOptionalUnsignedBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetOptionalUnsignedValueBuilder) buildForBACnetOptionalUnsigned() (BACnetOptionalUnsigned, error) {
	return b.Build()
}

func (b *_BACnetOptionalUnsignedValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetOptionalUnsignedValueBuilder().(*_BACnetOptionalUnsignedValueBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetOptionalUnsignedValueBuilder creates a BACnetOptionalUnsignedValueBuilder
func (b *_BACnetOptionalUnsignedValue) CreateBACnetOptionalUnsignedValueBuilder() BACnetOptionalUnsignedValueBuilder {
	if b == nil {
		return NewBACnetOptionalUnsignedValueBuilder()
	}
	return &_BACnetOptionalUnsignedValueBuilder{_BACnetOptionalUnsignedValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetOptionalUnsignedValue) GetParent() BACnetOptionalUnsignedContract {
	return m.BACnetOptionalUnsignedContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetOptionalUnsignedValue) GetUnsignedValue() BACnetApplicationTagUnsignedInteger {
	return m.UnsignedValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetOptionalUnsignedValue(structType any) BACnetOptionalUnsignedValue {
	if casted, ok := structType.(BACnetOptionalUnsignedValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetOptionalUnsignedValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetOptionalUnsignedValue) GetTypeName() string {
	return "BACnetOptionalUnsignedValue"
}

func (m *_BACnetOptionalUnsignedValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetOptionalUnsignedContract.(*_BACnetOptionalUnsigned).getLengthInBits(ctx))

	// Simple field (unsignedValue)
	lengthInBits += m.UnsignedValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetOptionalUnsignedValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetOptionalUnsignedValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetOptionalUnsigned) (__bACnetOptionalUnsignedValue BACnetOptionalUnsignedValue, err error) {
	m.BACnetOptionalUnsignedContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetOptionalUnsignedValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetOptionalUnsignedValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	unsignedValue, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "unsignedValue", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'unsignedValue' field"))
	}
	m.UnsignedValue = unsignedValue

	if closeErr := readBuffer.CloseContext("BACnetOptionalUnsignedValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetOptionalUnsignedValue")
	}

	return m, nil
}

func (m *_BACnetOptionalUnsignedValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetOptionalUnsignedValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetOptionalUnsignedValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetOptionalUnsignedValue")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "unsignedValue", m.GetUnsignedValue(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'unsignedValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetOptionalUnsignedValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetOptionalUnsignedValue")
		}
		return nil
	}
	return m.BACnetOptionalUnsignedContract.(*_BACnetOptionalUnsigned).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetOptionalUnsignedValue) IsBACnetOptionalUnsignedValue() {}

func (m *_BACnetOptionalUnsignedValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetOptionalUnsignedValue) deepCopy() *_BACnetOptionalUnsignedValue {
	if m == nil {
		return nil
	}
	_BACnetOptionalUnsignedValueCopy := &_BACnetOptionalUnsignedValue{
		m.BACnetOptionalUnsignedContract.(*_BACnetOptionalUnsigned).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.UnsignedValue),
	}
	_BACnetOptionalUnsignedValueCopy.BACnetOptionalUnsignedContract.(*_BACnetOptionalUnsigned)._SubType = m
	return _BACnetOptionalUnsignedValueCopy
}

func (m *_BACnetOptionalUnsignedValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
