/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetOptionalCharacterStringNull is the corresponding interface of BACnetOptionalCharacterStringNull
type BACnetOptionalCharacterStringNull interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetOptionalCharacterString
	// GetNullValue returns NullValue (property field)
	GetNullValue() BACnetApplicationTagNull
	// IsBACnetOptionalCharacterStringNull is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetOptionalCharacterStringNull()
	// CreateBuilder creates a BACnetOptionalCharacterStringNullBuilder
	CreateBACnetOptionalCharacterStringNullBuilder() BACnetOptionalCharacterStringNullBuilder
}

// _BACnetOptionalCharacterStringNull is the data-structure of this message
type _BACnetOptionalCharacterStringNull struct {
	BACnetOptionalCharacterStringContract
	NullValue BACnetApplicationTagNull
}

var _ BACnetOptionalCharacterStringNull = (*_BACnetOptionalCharacterStringNull)(nil)
var _ BACnetOptionalCharacterStringRequirements = (*_BACnetOptionalCharacterStringNull)(nil)

// NewBACnetOptionalCharacterStringNull factory function for _BACnetOptionalCharacterStringNull
func NewBACnetOptionalCharacterStringNull(peekedTagHeader BACnetTagHeader, nullValue BACnetApplicationTagNull) *_BACnetOptionalCharacterStringNull {
	if nullValue == nil {
		panic("nullValue of type BACnetApplicationTagNull for BACnetOptionalCharacterStringNull must not be nil")
	}
	_result := &_BACnetOptionalCharacterStringNull{
		BACnetOptionalCharacterStringContract: NewBACnetOptionalCharacterString(peekedTagHeader),
		NullValue:                             nullValue,
	}
	_result.BACnetOptionalCharacterStringContract.(*_BACnetOptionalCharacterString)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetOptionalCharacterStringNullBuilder is a builder for BACnetOptionalCharacterStringNull
type BACnetOptionalCharacterStringNullBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(nullValue BACnetApplicationTagNull) BACnetOptionalCharacterStringNullBuilder
	// WithNullValue adds NullValue (property field)
	WithNullValue(BACnetApplicationTagNull) BACnetOptionalCharacterStringNullBuilder
	// WithNullValueBuilder adds NullValue (property field) which is build by the builder
	WithNullValueBuilder(func(BACnetApplicationTagNullBuilder) BACnetApplicationTagNullBuilder) BACnetOptionalCharacterStringNullBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetOptionalCharacterStringBuilder
	// Build builds the BACnetOptionalCharacterStringNull or returns an error if something is wrong
	Build() (BACnetOptionalCharacterStringNull, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetOptionalCharacterStringNull
}

// NewBACnetOptionalCharacterStringNullBuilder() creates a BACnetOptionalCharacterStringNullBuilder
func NewBACnetOptionalCharacterStringNullBuilder() BACnetOptionalCharacterStringNullBuilder {
	return &_BACnetOptionalCharacterStringNullBuilder{_BACnetOptionalCharacterStringNull: new(_BACnetOptionalCharacterStringNull)}
}

type _BACnetOptionalCharacterStringNullBuilder struct {
	*_BACnetOptionalCharacterStringNull

	parentBuilder *_BACnetOptionalCharacterStringBuilder

	err *utils.MultiError
}

var _ (BACnetOptionalCharacterStringNullBuilder) = (*_BACnetOptionalCharacterStringNullBuilder)(nil)

func (b *_BACnetOptionalCharacterStringNullBuilder) setParent(contract BACnetOptionalCharacterStringContract) {
	b.BACnetOptionalCharacterStringContract = contract
	contract.(*_BACnetOptionalCharacterString)._SubType = b._BACnetOptionalCharacterStringNull
}

func (b *_BACnetOptionalCharacterStringNullBuilder) WithMandatoryFields(nullValue BACnetApplicationTagNull) BACnetOptionalCharacterStringNullBuilder {
	return b.WithNullValue(nullValue)
}

func (b *_BACnetOptionalCharacterStringNullBuilder) WithNullValue(nullValue BACnetApplicationTagNull) BACnetOptionalCharacterStringNullBuilder {
	b.NullValue = nullValue
	return b
}

func (b *_BACnetOptionalCharacterStringNullBuilder) WithNullValueBuilder(builderSupplier func(BACnetApplicationTagNullBuilder) BACnetApplicationTagNullBuilder) BACnetOptionalCharacterStringNullBuilder {
	builder := builderSupplier(b.NullValue.CreateBACnetApplicationTagNullBuilder())
	var err error
	b.NullValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagNullBuilder failed"))
	}
	return b
}

func (b *_BACnetOptionalCharacterStringNullBuilder) Build() (BACnetOptionalCharacterStringNull, error) {
	if b.NullValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'nullValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetOptionalCharacterStringNull.deepCopy(), nil
}

func (b *_BACnetOptionalCharacterStringNullBuilder) MustBuild() BACnetOptionalCharacterStringNull {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetOptionalCharacterStringNullBuilder) Done() BACnetOptionalCharacterStringBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetOptionalCharacterStringBuilder().(*_BACnetOptionalCharacterStringBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetOptionalCharacterStringNullBuilder) buildForBACnetOptionalCharacterString() (BACnetOptionalCharacterString, error) {
	return b.Build()
}

func (b *_BACnetOptionalCharacterStringNullBuilder) DeepCopy() any {
	_copy := b.CreateBACnetOptionalCharacterStringNullBuilder().(*_BACnetOptionalCharacterStringNullBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetOptionalCharacterStringNullBuilder creates a BACnetOptionalCharacterStringNullBuilder
func (b *_BACnetOptionalCharacterStringNull) CreateBACnetOptionalCharacterStringNullBuilder() BACnetOptionalCharacterStringNullBuilder {
	if b == nil {
		return NewBACnetOptionalCharacterStringNullBuilder()
	}
	return &_BACnetOptionalCharacterStringNullBuilder{_BACnetOptionalCharacterStringNull: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetOptionalCharacterStringNull) GetParent() BACnetOptionalCharacterStringContract {
	return m.BACnetOptionalCharacterStringContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetOptionalCharacterStringNull) GetNullValue() BACnetApplicationTagNull {
	return m.NullValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetOptionalCharacterStringNull(structType any) BACnetOptionalCharacterStringNull {
	if casted, ok := structType.(BACnetOptionalCharacterStringNull); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetOptionalCharacterStringNull); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetOptionalCharacterStringNull) GetTypeName() string {
	return "BACnetOptionalCharacterStringNull"
}

func (m *_BACnetOptionalCharacterStringNull) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetOptionalCharacterStringContract.(*_BACnetOptionalCharacterString).getLengthInBits(ctx))

	// Simple field (nullValue)
	lengthInBits += m.NullValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetOptionalCharacterStringNull) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetOptionalCharacterStringNull) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetOptionalCharacterString) (__bACnetOptionalCharacterStringNull BACnetOptionalCharacterStringNull, err error) {
	m.BACnetOptionalCharacterStringContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetOptionalCharacterStringNull"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetOptionalCharacterStringNull")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	nullValue, err := ReadSimpleField[BACnetApplicationTagNull](ctx, "nullValue", ReadComplex[BACnetApplicationTagNull](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagNull](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'nullValue' field"))
	}
	m.NullValue = nullValue

	if closeErr := readBuffer.CloseContext("BACnetOptionalCharacterStringNull"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetOptionalCharacterStringNull")
	}

	return m, nil
}

func (m *_BACnetOptionalCharacterStringNull) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetOptionalCharacterStringNull) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetOptionalCharacterStringNull"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetOptionalCharacterStringNull")
		}

		if err := WriteSimpleField[BACnetApplicationTagNull](ctx, "nullValue", m.GetNullValue(), WriteComplex[BACnetApplicationTagNull](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'nullValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetOptionalCharacterStringNull"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetOptionalCharacterStringNull")
		}
		return nil
	}
	return m.BACnetOptionalCharacterStringContract.(*_BACnetOptionalCharacterString).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetOptionalCharacterStringNull) IsBACnetOptionalCharacterStringNull() {}

func (m *_BACnetOptionalCharacterStringNull) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetOptionalCharacterStringNull) deepCopy() *_BACnetOptionalCharacterStringNull {
	if m == nil {
		return nil
	}
	_BACnetOptionalCharacterStringNullCopy := &_BACnetOptionalCharacterStringNull{
		m.BACnetOptionalCharacterStringContract.(*_BACnetOptionalCharacterString).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagNull](m.NullValue),
	}
	_BACnetOptionalCharacterStringNullCopy.BACnetOptionalCharacterStringContract.(*_BACnetOptionalCharacterString)._SubType = m
	return _BACnetOptionalCharacterStringNullCopy
}

func (m *_BACnetOptionalCharacterStringNull) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
