/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetOptionalCharacterString is the corresponding interface of BACnetOptionalCharacterString
type BACnetOptionalCharacterString interface {
	BACnetOptionalCharacterStringContract
	BACnetOptionalCharacterStringRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetOptionalCharacterString is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetOptionalCharacterString()
	// CreateBuilder creates a BACnetOptionalCharacterStringBuilder
	CreateBACnetOptionalCharacterStringBuilder() BACnetOptionalCharacterStringBuilder
}

// BACnetOptionalCharacterStringContract provides a set of functions which can be overwritten by a sub struct
type BACnetOptionalCharacterStringContract interface {
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// IsBACnetOptionalCharacterString is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetOptionalCharacterString()
	// CreateBuilder creates a BACnetOptionalCharacterStringBuilder
	CreateBACnetOptionalCharacterStringBuilder() BACnetOptionalCharacterStringBuilder
}

// BACnetOptionalCharacterStringRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetOptionalCharacterStringRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedTagNumber returns PeekedTagNumber (discriminator field)
	GetPeekedTagNumber() uint8
}

// _BACnetOptionalCharacterString is the data-structure of this message
type _BACnetOptionalCharacterString struct {
	_SubType interface {
		BACnetOptionalCharacterStringContract
		BACnetOptionalCharacterStringRequirements
	}
	PeekedTagHeader BACnetTagHeader
}

var _ BACnetOptionalCharacterStringContract = (*_BACnetOptionalCharacterString)(nil)

// NewBACnetOptionalCharacterString factory function for _BACnetOptionalCharacterString
func NewBACnetOptionalCharacterString(peekedTagHeader BACnetTagHeader) *_BACnetOptionalCharacterString {
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetOptionalCharacterString must not be nil")
	}
	return &_BACnetOptionalCharacterString{PeekedTagHeader: peekedTagHeader}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetOptionalCharacterStringBuilder is a builder for BACnetOptionalCharacterString
type BACnetOptionalCharacterStringBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetOptionalCharacterStringBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetOptionalCharacterStringBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetOptionalCharacterStringBuilder
	// AsBACnetOptionalCharacterStringNull converts this build to a subType of BACnetOptionalCharacterString. It is always possible to return to current builder using Done()
	AsBACnetOptionalCharacterStringNull() BACnetOptionalCharacterStringNullBuilder
	// AsBACnetOptionalCharacterStringValue converts this build to a subType of BACnetOptionalCharacterString. It is always possible to return to current builder using Done()
	AsBACnetOptionalCharacterStringValue() BACnetOptionalCharacterStringValueBuilder
	// Build builds the BACnetOptionalCharacterString or returns an error if something is wrong
	PartialBuild() (BACnetOptionalCharacterStringContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetOptionalCharacterStringContract
	// Build builds the BACnetOptionalCharacterString or returns an error if something is wrong
	Build() (BACnetOptionalCharacterString, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetOptionalCharacterString
}

// NewBACnetOptionalCharacterStringBuilder() creates a BACnetOptionalCharacterStringBuilder
func NewBACnetOptionalCharacterStringBuilder() BACnetOptionalCharacterStringBuilder {
	return &_BACnetOptionalCharacterStringBuilder{_BACnetOptionalCharacterString: new(_BACnetOptionalCharacterString)}
}

type _BACnetOptionalCharacterStringChildBuilder interface {
	utils.Copyable
	setParent(BACnetOptionalCharacterStringContract)
	buildForBACnetOptionalCharacterString() (BACnetOptionalCharacterString, error)
}

type _BACnetOptionalCharacterStringBuilder struct {
	*_BACnetOptionalCharacterString

	childBuilder _BACnetOptionalCharacterStringChildBuilder

	err *utils.MultiError
}

var _ (BACnetOptionalCharacterStringBuilder) = (*_BACnetOptionalCharacterStringBuilder)(nil)

func (b *_BACnetOptionalCharacterStringBuilder) WithMandatoryFields(peekedTagHeader BACnetTagHeader) BACnetOptionalCharacterStringBuilder {
	return b.WithPeekedTagHeader(peekedTagHeader)
}

func (b *_BACnetOptionalCharacterStringBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetOptionalCharacterStringBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetOptionalCharacterStringBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetOptionalCharacterStringBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetOptionalCharacterStringBuilder) PartialBuild() (BACnetOptionalCharacterStringContract, error) {
	if b.PeekedTagHeader == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetOptionalCharacterString.deepCopy(), nil
}

func (b *_BACnetOptionalCharacterStringBuilder) PartialMustBuild() BACnetOptionalCharacterStringContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetOptionalCharacterStringBuilder) AsBACnetOptionalCharacterStringNull() BACnetOptionalCharacterStringNullBuilder {
	if cb, ok := b.childBuilder.(BACnetOptionalCharacterStringNullBuilder); ok {
		return cb
	}
	cb := NewBACnetOptionalCharacterStringNullBuilder().(*_BACnetOptionalCharacterStringNullBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetOptionalCharacterStringBuilder) AsBACnetOptionalCharacterStringValue() BACnetOptionalCharacterStringValueBuilder {
	if cb, ok := b.childBuilder.(BACnetOptionalCharacterStringValueBuilder); ok {
		return cb
	}
	cb := NewBACnetOptionalCharacterStringValueBuilder().(*_BACnetOptionalCharacterStringValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetOptionalCharacterStringBuilder) Build() (BACnetOptionalCharacterString, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetOptionalCharacterString()
}

func (b *_BACnetOptionalCharacterStringBuilder) MustBuild() BACnetOptionalCharacterString {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetOptionalCharacterStringBuilder) DeepCopy() any {
	_copy := b.CreateBACnetOptionalCharacterStringBuilder().(*_BACnetOptionalCharacterStringBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetOptionalCharacterStringChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetOptionalCharacterStringBuilder creates a BACnetOptionalCharacterStringBuilder
func (b *_BACnetOptionalCharacterString) CreateBACnetOptionalCharacterStringBuilder() BACnetOptionalCharacterStringBuilder {
	if b == nil {
		return NewBACnetOptionalCharacterStringBuilder()
	}
	return &_BACnetOptionalCharacterStringBuilder{_BACnetOptionalCharacterString: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetOptionalCharacterString) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetOptionalCharacterString) GetPeekedTagNumber() uint8 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetOptionalCharacterString(structType any) BACnetOptionalCharacterString {
	if casted, ok := structType.(BACnetOptionalCharacterString); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetOptionalCharacterString); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetOptionalCharacterString) GetTypeName() string {
	return "BACnetOptionalCharacterString"
}

func (m *_BACnetOptionalCharacterString) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetOptionalCharacterString) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetOptionalCharacterString) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetOptionalCharacterStringParse[T BACnetOptionalCharacterString](ctx context.Context, theBytes []byte) (T, error) {
	return BACnetOptionalCharacterStringParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetOptionalCharacterStringParseWithBufferProducer[T BACnetOptionalCharacterString]() func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetOptionalCharacterStringParseWithBuffer[T](ctx, readBuffer)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetOptionalCharacterStringParseWithBuffer[T BACnetOptionalCharacterString](ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	v, err := (&_BACnetOptionalCharacterString{}).parse(ctx, readBuffer)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetOptionalCharacterString) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetOptionalCharacterString BACnetOptionalCharacterString, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetOptionalCharacterString"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetOptionalCharacterString")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetOptionalCharacterString
	switch {
	case peekedTagNumber == uint8(0): // BACnetOptionalCharacterStringNull
		if _child, err = new(_BACnetOptionalCharacterStringNull).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetOptionalCharacterStringNull for type-switch of BACnetOptionalCharacterString")
		}
	case 0 == 0: // BACnetOptionalCharacterStringValue
		if _child, err = new(_BACnetOptionalCharacterStringValue).parse(ctx, readBuffer, m); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetOptionalCharacterStringValue for type-switch of BACnetOptionalCharacterString")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v]", peekedTagNumber)
	}

	if closeErr := readBuffer.CloseContext("BACnetOptionalCharacterString"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetOptionalCharacterString")
	}

	return _child, nil
}

func (pm *_BACnetOptionalCharacterString) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetOptionalCharacterString, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetOptionalCharacterString"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetOptionalCharacterString")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetOptionalCharacterString"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetOptionalCharacterString")
	}
	return nil
}

func (m *_BACnetOptionalCharacterString) IsBACnetOptionalCharacterString() {}

func (m *_BACnetOptionalCharacterString) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetOptionalCharacterString) deepCopy() *_BACnetOptionalCharacterString {
	if m == nil {
		return nil
	}
	_BACnetOptionalCharacterStringCopy := &_BACnetOptionalCharacterString{
		nil, // will be set by child
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
	}
	return _BACnetOptionalCharacterStringCopy
}
