/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetNotificationParametersChangeOfTimer is the corresponding interface of BACnetNotificationParametersChangeOfTimer
type BACnetNotificationParametersChangeOfTimer interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetNotificationParameters
	// GetInnerOpeningTag returns InnerOpeningTag (property field)
	GetInnerOpeningTag() BACnetOpeningTag
	// GetNewValue returns NewValue (property field)
	GetNewValue() BACnetTimerStateTagged
	// GetStatusFlags returns StatusFlags (property field)
	GetStatusFlags() BACnetStatusFlagsTagged
	// GetUpdateTime returns UpdateTime (property field)
	GetUpdateTime() BACnetDateTimeEnclosed
	// GetLastStateChange returns LastStateChange (property field)
	GetLastStateChange() BACnetTimerTransitionTagged
	// GetInitialTimeout returns InitialTimeout (property field)
	GetInitialTimeout() BACnetContextTagUnsignedInteger
	// GetExpirationTime returns ExpirationTime (property field)
	GetExpirationTime() BACnetDateTimeEnclosed
	// GetInnerClosingTag returns InnerClosingTag (property field)
	GetInnerClosingTag() BACnetClosingTag
	// IsBACnetNotificationParametersChangeOfTimer is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetNotificationParametersChangeOfTimer()
	// CreateBuilder creates a BACnetNotificationParametersChangeOfTimerBuilder
	CreateBACnetNotificationParametersChangeOfTimerBuilder() BACnetNotificationParametersChangeOfTimerBuilder
}

// _BACnetNotificationParametersChangeOfTimer is the data-structure of this message
type _BACnetNotificationParametersChangeOfTimer struct {
	BACnetNotificationParametersContract
	InnerOpeningTag BACnetOpeningTag
	NewValue        BACnetTimerStateTagged
	StatusFlags     BACnetStatusFlagsTagged
	UpdateTime      BACnetDateTimeEnclosed
	LastStateChange BACnetTimerTransitionTagged
	InitialTimeout  BACnetContextTagUnsignedInteger
	ExpirationTime  BACnetDateTimeEnclosed
	InnerClosingTag BACnetClosingTag
}

var _ BACnetNotificationParametersChangeOfTimer = (*_BACnetNotificationParametersChangeOfTimer)(nil)
var _ BACnetNotificationParametersRequirements = (*_BACnetNotificationParametersChangeOfTimer)(nil)

// NewBACnetNotificationParametersChangeOfTimer factory function for _BACnetNotificationParametersChangeOfTimer
func NewBACnetNotificationParametersChangeOfTimer(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, innerOpeningTag BACnetOpeningTag, newValue BACnetTimerStateTagged, statusFlags BACnetStatusFlagsTagged, updateTime BACnetDateTimeEnclosed, lastStateChange BACnetTimerTransitionTagged, initialTimeout BACnetContextTagUnsignedInteger, expirationTime BACnetDateTimeEnclosed, innerClosingTag BACnetClosingTag, tagNumber uint8, objectTypeArgument BACnetObjectType) *_BACnetNotificationParametersChangeOfTimer {
	if innerOpeningTag == nil {
		panic("innerOpeningTag of type BACnetOpeningTag for BACnetNotificationParametersChangeOfTimer must not be nil")
	}
	if newValue == nil {
		panic("newValue of type BACnetTimerStateTagged for BACnetNotificationParametersChangeOfTimer must not be nil")
	}
	if statusFlags == nil {
		panic("statusFlags of type BACnetStatusFlagsTagged for BACnetNotificationParametersChangeOfTimer must not be nil")
	}
	if updateTime == nil {
		panic("updateTime of type BACnetDateTimeEnclosed for BACnetNotificationParametersChangeOfTimer must not be nil")
	}
	if innerClosingTag == nil {
		panic("innerClosingTag of type BACnetClosingTag for BACnetNotificationParametersChangeOfTimer must not be nil")
	}
	_result := &_BACnetNotificationParametersChangeOfTimer{
		BACnetNotificationParametersContract: NewBACnetNotificationParameters(openingTag, peekedTagHeader, closingTag, tagNumber, objectTypeArgument),
		InnerOpeningTag:                      innerOpeningTag,
		NewValue:                             newValue,
		StatusFlags:                          statusFlags,
		UpdateTime:                           updateTime,
		LastStateChange:                      lastStateChange,
		InitialTimeout:                       initialTimeout,
		ExpirationTime:                       expirationTime,
		InnerClosingTag:                      innerClosingTag,
	}
	_result.BACnetNotificationParametersContract.(*_BACnetNotificationParameters)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetNotificationParametersChangeOfTimerBuilder is a builder for BACnetNotificationParametersChangeOfTimer
type BACnetNotificationParametersChangeOfTimerBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(innerOpeningTag BACnetOpeningTag, newValue BACnetTimerStateTagged, statusFlags BACnetStatusFlagsTagged, updateTime BACnetDateTimeEnclosed, innerClosingTag BACnetClosingTag) BACnetNotificationParametersChangeOfTimerBuilder
	// WithInnerOpeningTag adds InnerOpeningTag (property field)
	WithInnerOpeningTag(BACnetOpeningTag) BACnetNotificationParametersChangeOfTimerBuilder
	// WithInnerOpeningTagBuilder adds InnerOpeningTag (property field) which is build by the builder
	WithInnerOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetNotificationParametersChangeOfTimerBuilder
	// WithNewValue adds NewValue (property field)
	WithNewValue(BACnetTimerStateTagged) BACnetNotificationParametersChangeOfTimerBuilder
	// WithNewValueBuilder adds NewValue (property field) which is build by the builder
	WithNewValueBuilder(func(BACnetTimerStateTaggedBuilder) BACnetTimerStateTaggedBuilder) BACnetNotificationParametersChangeOfTimerBuilder
	// WithStatusFlags adds StatusFlags (property field)
	WithStatusFlags(BACnetStatusFlagsTagged) BACnetNotificationParametersChangeOfTimerBuilder
	// WithStatusFlagsBuilder adds StatusFlags (property field) which is build by the builder
	WithStatusFlagsBuilder(func(BACnetStatusFlagsTaggedBuilder) BACnetStatusFlagsTaggedBuilder) BACnetNotificationParametersChangeOfTimerBuilder
	// WithUpdateTime adds UpdateTime (property field)
	WithUpdateTime(BACnetDateTimeEnclosed) BACnetNotificationParametersChangeOfTimerBuilder
	// WithUpdateTimeBuilder adds UpdateTime (property field) which is build by the builder
	WithUpdateTimeBuilder(func(BACnetDateTimeEnclosedBuilder) BACnetDateTimeEnclosedBuilder) BACnetNotificationParametersChangeOfTimerBuilder
	// WithLastStateChange adds LastStateChange (property field)
	WithOptionalLastStateChange(BACnetTimerTransitionTagged) BACnetNotificationParametersChangeOfTimerBuilder
	// WithOptionalLastStateChangeBuilder adds LastStateChange (property field) which is build by the builder
	WithOptionalLastStateChangeBuilder(func(BACnetTimerTransitionTaggedBuilder) BACnetTimerTransitionTaggedBuilder) BACnetNotificationParametersChangeOfTimerBuilder
	// WithInitialTimeout adds InitialTimeout (property field)
	WithOptionalInitialTimeout(BACnetContextTagUnsignedInteger) BACnetNotificationParametersChangeOfTimerBuilder
	// WithOptionalInitialTimeoutBuilder adds InitialTimeout (property field) which is build by the builder
	WithOptionalInitialTimeoutBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetNotificationParametersChangeOfTimerBuilder
	// WithExpirationTime adds ExpirationTime (property field)
	WithOptionalExpirationTime(BACnetDateTimeEnclosed) BACnetNotificationParametersChangeOfTimerBuilder
	// WithOptionalExpirationTimeBuilder adds ExpirationTime (property field) which is build by the builder
	WithOptionalExpirationTimeBuilder(func(BACnetDateTimeEnclosedBuilder) BACnetDateTimeEnclosedBuilder) BACnetNotificationParametersChangeOfTimerBuilder
	// WithInnerClosingTag adds InnerClosingTag (property field)
	WithInnerClosingTag(BACnetClosingTag) BACnetNotificationParametersChangeOfTimerBuilder
	// WithInnerClosingTagBuilder adds InnerClosingTag (property field) which is build by the builder
	WithInnerClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetNotificationParametersChangeOfTimerBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetNotificationParametersBuilder
	// Build builds the BACnetNotificationParametersChangeOfTimer or returns an error if something is wrong
	Build() (BACnetNotificationParametersChangeOfTimer, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetNotificationParametersChangeOfTimer
}

// NewBACnetNotificationParametersChangeOfTimerBuilder() creates a BACnetNotificationParametersChangeOfTimerBuilder
func NewBACnetNotificationParametersChangeOfTimerBuilder() BACnetNotificationParametersChangeOfTimerBuilder {
	return &_BACnetNotificationParametersChangeOfTimerBuilder{_BACnetNotificationParametersChangeOfTimer: new(_BACnetNotificationParametersChangeOfTimer)}
}

type _BACnetNotificationParametersChangeOfTimerBuilder struct {
	*_BACnetNotificationParametersChangeOfTimer

	parentBuilder *_BACnetNotificationParametersBuilder

	err *utils.MultiError
}

var _ (BACnetNotificationParametersChangeOfTimerBuilder) = (*_BACnetNotificationParametersChangeOfTimerBuilder)(nil)

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) setParent(contract BACnetNotificationParametersContract) {
	b.BACnetNotificationParametersContract = contract
	contract.(*_BACnetNotificationParameters)._SubType = b._BACnetNotificationParametersChangeOfTimer
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithMandatoryFields(innerOpeningTag BACnetOpeningTag, newValue BACnetTimerStateTagged, statusFlags BACnetStatusFlagsTagged, updateTime BACnetDateTimeEnclosed, innerClosingTag BACnetClosingTag) BACnetNotificationParametersChangeOfTimerBuilder {
	return b.WithInnerOpeningTag(innerOpeningTag).WithNewValue(newValue).WithStatusFlags(statusFlags).WithUpdateTime(updateTime).WithInnerClosingTag(innerClosingTag)
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithInnerOpeningTag(innerOpeningTag BACnetOpeningTag) BACnetNotificationParametersChangeOfTimerBuilder {
	b.InnerOpeningTag = innerOpeningTag
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithInnerOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetNotificationParametersChangeOfTimerBuilder {
	builder := builderSupplier(b.InnerOpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.InnerOpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithNewValue(newValue BACnetTimerStateTagged) BACnetNotificationParametersChangeOfTimerBuilder {
	b.NewValue = newValue
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithNewValueBuilder(builderSupplier func(BACnetTimerStateTaggedBuilder) BACnetTimerStateTaggedBuilder) BACnetNotificationParametersChangeOfTimerBuilder {
	builder := builderSupplier(b.NewValue.CreateBACnetTimerStateTaggedBuilder())
	var err error
	b.NewValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTimerStateTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithStatusFlags(statusFlags BACnetStatusFlagsTagged) BACnetNotificationParametersChangeOfTimerBuilder {
	b.StatusFlags = statusFlags
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithStatusFlagsBuilder(builderSupplier func(BACnetStatusFlagsTaggedBuilder) BACnetStatusFlagsTaggedBuilder) BACnetNotificationParametersChangeOfTimerBuilder {
	builder := builderSupplier(b.StatusFlags.CreateBACnetStatusFlagsTaggedBuilder())
	var err error
	b.StatusFlags, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetStatusFlagsTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithUpdateTime(updateTime BACnetDateTimeEnclosed) BACnetNotificationParametersChangeOfTimerBuilder {
	b.UpdateTime = updateTime
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithUpdateTimeBuilder(builderSupplier func(BACnetDateTimeEnclosedBuilder) BACnetDateTimeEnclosedBuilder) BACnetNotificationParametersChangeOfTimerBuilder {
	builder := builderSupplier(b.UpdateTime.CreateBACnetDateTimeEnclosedBuilder())
	var err error
	b.UpdateTime, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDateTimeEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithOptionalLastStateChange(lastStateChange BACnetTimerTransitionTagged) BACnetNotificationParametersChangeOfTimerBuilder {
	b.LastStateChange = lastStateChange
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithOptionalLastStateChangeBuilder(builderSupplier func(BACnetTimerTransitionTaggedBuilder) BACnetTimerTransitionTaggedBuilder) BACnetNotificationParametersChangeOfTimerBuilder {
	builder := builderSupplier(b.LastStateChange.CreateBACnetTimerTransitionTaggedBuilder())
	var err error
	b.LastStateChange, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTimerTransitionTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithOptionalInitialTimeout(initialTimeout BACnetContextTagUnsignedInteger) BACnetNotificationParametersChangeOfTimerBuilder {
	b.InitialTimeout = initialTimeout
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithOptionalInitialTimeoutBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetNotificationParametersChangeOfTimerBuilder {
	builder := builderSupplier(b.InitialTimeout.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.InitialTimeout, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithOptionalExpirationTime(expirationTime BACnetDateTimeEnclosed) BACnetNotificationParametersChangeOfTimerBuilder {
	b.ExpirationTime = expirationTime
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithOptionalExpirationTimeBuilder(builderSupplier func(BACnetDateTimeEnclosedBuilder) BACnetDateTimeEnclosedBuilder) BACnetNotificationParametersChangeOfTimerBuilder {
	builder := builderSupplier(b.ExpirationTime.CreateBACnetDateTimeEnclosedBuilder())
	var err error
	b.ExpirationTime, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDateTimeEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithInnerClosingTag(innerClosingTag BACnetClosingTag) BACnetNotificationParametersChangeOfTimerBuilder {
	b.InnerClosingTag = innerClosingTag
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) WithInnerClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetNotificationParametersChangeOfTimerBuilder {
	builder := builderSupplier(b.InnerClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.InnerClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) Build() (BACnetNotificationParametersChangeOfTimer, error) {
	if b.InnerOpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'innerOpeningTag' not set"))
	}
	if b.NewValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'newValue' not set"))
	}
	if b.StatusFlags == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'statusFlags' not set"))
	}
	if b.UpdateTime == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'updateTime' not set"))
	}
	if b.InnerClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'innerClosingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetNotificationParametersChangeOfTimer.deepCopy(), nil
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) MustBuild() BACnetNotificationParametersChangeOfTimer {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) Done() BACnetNotificationParametersBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetNotificationParametersBuilder().(*_BACnetNotificationParametersBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) buildForBACnetNotificationParameters() (BACnetNotificationParameters, error) {
	return b.Build()
}

func (b *_BACnetNotificationParametersChangeOfTimerBuilder) DeepCopy() any {
	_copy := b.CreateBACnetNotificationParametersChangeOfTimerBuilder().(*_BACnetNotificationParametersChangeOfTimerBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetNotificationParametersChangeOfTimerBuilder creates a BACnetNotificationParametersChangeOfTimerBuilder
func (b *_BACnetNotificationParametersChangeOfTimer) CreateBACnetNotificationParametersChangeOfTimerBuilder() BACnetNotificationParametersChangeOfTimerBuilder {
	if b == nil {
		return NewBACnetNotificationParametersChangeOfTimerBuilder()
	}
	return &_BACnetNotificationParametersChangeOfTimerBuilder{_BACnetNotificationParametersChangeOfTimer: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetNotificationParametersChangeOfTimer) GetParent() BACnetNotificationParametersContract {
	return m.BACnetNotificationParametersContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetNotificationParametersChangeOfTimer) GetInnerOpeningTag() BACnetOpeningTag {
	return m.InnerOpeningTag
}

func (m *_BACnetNotificationParametersChangeOfTimer) GetNewValue() BACnetTimerStateTagged {
	return m.NewValue
}

func (m *_BACnetNotificationParametersChangeOfTimer) GetStatusFlags() BACnetStatusFlagsTagged {
	return m.StatusFlags
}

func (m *_BACnetNotificationParametersChangeOfTimer) GetUpdateTime() BACnetDateTimeEnclosed {
	return m.UpdateTime
}

func (m *_BACnetNotificationParametersChangeOfTimer) GetLastStateChange() BACnetTimerTransitionTagged {
	return m.LastStateChange
}

func (m *_BACnetNotificationParametersChangeOfTimer) GetInitialTimeout() BACnetContextTagUnsignedInteger {
	return m.InitialTimeout
}

func (m *_BACnetNotificationParametersChangeOfTimer) GetExpirationTime() BACnetDateTimeEnclosed {
	return m.ExpirationTime
}

func (m *_BACnetNotificationParametersChangeOfTimer) GetInnerClosingTag() BACnetClosingTag {
	return m.InnerClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetNotificationParametersChangeOfTimer(structType any) BACnetNotificationParametersChangeOfTimer {
	if casted, ok := structType.(BACnetNotificationParametersChangeOfTimer); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetNotificationParametersChangeOfTimer); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetNotificationParametersChangeOfTimer) GetTypeName() string {
	return "BACnetNotificationParametersChangeOfTimer"
}

func (m *_BACnetNotificationParametersChangeOfTimer) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetNotificationParametersContract.(*_BACnetNotificationParameters).getLengthInBits(ctx))

	// Simple field (innerOpeningTag)
	lengthInBits += m.InnerOpeningTag.GetLengthInBits(ctx)

	// Simple field (newValue)
	lengthInBits += m.NewValue.GetLengthInBits(ctx)

	// Simple field (statusFlags)
	lengthInBits += m.StatusFlags.GetLengthInBits(ctx)

	// Simple field (updateTime)
	lengthInBits += m.UpdateTime.GetLengthInBits(ctx)

	// Optional Field (lastStateChange)
	if m.LastStateChange != nil {
		lengthInBits += m.LastStateChange.GetLengthInBits(ctx)
	}

	// Optional Field (initialTimeout)
	if m.InitialTimeout != nil {
		lengthInBits += m.InitialTimeout.GetLengthInBits(ctx)
	}

	// Optional Field (expirationTime)
	if m.ExpirationTime != nil {
		lengthInBits += m.ExpirationTime.GetLengthInBits(ctx)
	}

	// Simple field (innerClosingTag)
	lengthInBits += m.InnerClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetNotificationParametersChangeOfTimer) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetNotificationParametersChangeOfTimer) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetNotificationParameters, peekedTagNumber uint8, tagNumber uint8, objectTypeArgument BACnetObjectType) (__bACnetNotificationParametersChangeOfTimer BACnetNotificationParametersChangeOfTimer, err error) {
	m.BACnetNotificationParametersContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetNotificationParametersChangeOfTimer"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetNotificationParametersChangeOfTimer")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	innerOpeningTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "innerOpeningTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(peekedTagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'innerOpeningTag' field"))
	}
	m.InnerOpeningTag = innerOpeningTag

	newValue, err := ReadSimpleField[BACnetTimerStateTagged](ctx, "newValue", ReadComplex[BACnetTimerStateTagged](BACnetTimerStateTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'newValue' field"))
	}
	m.NewValue = newValue

	statusFlags, err := ReadSimpleField[BACnetStatusFlagsTagged](ctx, "statusFlags", ReadComplex[BACnetStatusFlagsTagged](BACnetStatusFlagsTaggedParseWithBufferProducer((uint8)(uint8(1)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'statusFlags' field"))
	}
	m.StatusFlags = statusFlags

	updateTime, err := ReadSimpleField[BACnetDateTimeEnclosed](ctx, "updateTime", ReadComplex[BACnetDateTimeEnclosed](BACnetDateTimeEnclosedParseWithBufferProducer((uint8)(uint8(2))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'updateTime' field"))
	}
	m.UpdateTime = updateTime

	var lastStateChange BACnetTimerTransitionTagged
	_lastStateChange, err := ReadOptionalField[BACnetTimerTransitionTagged](ctx, "lastStateChange", ReadComplex[BACnetTimerTransitionTagged](BACnetTimerTransitionTaggedParseWithBufferProducer((uint8)(uint8(3)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lastStateChange' field"))
	}
	if _lastStateChange != nil {
		lastStateChange = *_lastStateChange
		m.LastStateChange = lastStateChange
	}

	var initialTimeout BACnetContextTagUnsignedInteger
	_initialTimeout, err := ReadOptionalField[BACnetContextTagUnsignedInteger](ctx, "initialTimeout", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(4)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'initialTimeout' field"))
	}
	if _initialTimeout != nil {
		initialTimeout = *_initialTimeout
		m.InitialTimeout = initialTimeout
	}

	var expirationTime BACnetDateTimeEnclosed
	_expirationTime, err := ReadOptionalField[BACnetDateTimeEnclosed](ctx, "expirationTime", ReadComplex[BACnetDateTimeEnclosed](BACnetDateTimeEnclosedParseWithBufferProducer((uint8)(uint8(5))), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'expirationTime' field"))
	}
	if _expirationTime != nil {
		expirationTime = *_expirationTime
		m.ExpirationTime = expirationTime
	}

	innerClosingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "innerClosingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(peekedTagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'innerClosingTag' field"))
	}
	m.InnerClosingTag = innerClosingTag

	if closeErr := readBuffer.CloseContext("BACnetNotificationParametersChangeOfTimer"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetNotificationParametersChangeOfTimer")
	}

	return m, nil
}

func (m *_BACnetNotificationParametersChangeOfTimer) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetNotificationParametersChangeOfTimer) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetNotificationParametersChangeOfTimer"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetNotificationParametersChangeOfTimer")
		}

		if err := WriteSimpleField[BACnetOpeningTag](ctx, "innerOpeningTag", m.GetInnerOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'innerOpeningTag' field")
		}

		if err := WriteSimpleField[BACnetTimerStateTagged](ctx, "newValue", m.GetNewValue(), WriteComplex[BACnetTimerStateTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'newValue' field")
		}

		if err := WriteSimpleField[BACnetStatusFlagsTagged](ctx, "statusFlags", m.GetStatusFlags(), WriteComplex[BACnetStatusFlagsTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'statusFlags' field")
		}

		if err := WriteSimpleField[BACnetDateTimeEnclosed](ctx, "updateTime", m.GetUpdateTime(), WriteComplex[BACnetDateTimeEnclosed](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'updateTime' field")
		}

		if err := WriteOptionalField[BACnetTimerTransitionTagged](ctx, "lastStateChange", GetRef(m.GetLastStateChange()), WriteComplex[BACnetTimerTransitionTagged](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'lastStateChange' field")
		}

		if err := WriteOptionalField[BACnetContextTagUnsignedInteger](ctx, "initialTimeout", GetRef(m.GetInitialTimeout()), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'initialTimeout' field")
		}

		if err := WriteOptionalField[BACnetDateTimeEnclosed](ctx, "expirationTime", GetRef(m.GetExpirationTime()), WriteComplex[BACnetDateTimeEnclosed](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'expirationTime' field")
		}

		if err := WriteSimpleField[BACnetClosingTag](ctx, "innerClosingTag", m.GetInnerClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'innerClosingTag' field")
		}

		if popErr := writeBuffer.PopContext("BACnetNotificationParametersChangeOfTimer"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetNotificationParametersChangeOfTimer")
		}
		return nil
	}
	return m.BACnetNotificationParametersContract.(*_BACnetNotificationParameters).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetNotificationParametersChangeOfTimer) IsBACnetNotificationParametersChangeOfTimer() {}

func (m *_BACnetNotificationParametersChangeOfTimer) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetNotificationParametersChangeOfTimer) deepCopy() *_BACnetNotificationParametersChangeOfTimer {
	if m == nil {
		return nil
	}
	_BACnetNotificationParametersChangeOfTimerCopy := &_BACnetNotificationParametersChangeOfTimer{
		m.BACnetNotificationParametersContract.(*_BACnetNotificationParameters).deepCopy(),
		utils.DeepCopy[BACnetOpeningTag](m.InnerOpeningTag),
		utils.DeepCopy[BACnetTimerStateTagged](m.NewValue),
		utils.DeepCopy[BACnetStatusFlagsTagged](m.StatusFlags),
		utils.DeepCopy[BACnetDateTimeEnclosed](m.UpdateTime),
		utils.DeepCopy[BACnetTimerTransitionTagged](m.LastStateChange),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.InitialTimeout),
		utils.DeepCopy[BACnetDateTimeEnclosed](m.ExpirationTime),
		utils.DeepCopy[BACnetClosingTag](m.InnerClosingTag),
	}
	_BACnetNotificationParametersChangeOfTimerCopy.BACnetNotificationParametersContract.(*_BACnetNotificationParameters)._SubType = m
	return _BACnetNotificationParametersChangeOfTimerCopy
}

func (m *_BACnetNotificationParametersChangeOfTimer) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
