/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetNotificationParametersAccessEvent is the corresponding interface of BACnetNotificationParametersAccessEvent
type BACnetNotificationParametersAccessEvent interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetNotificationParameters
	// GetInnerOpeningTag returns InnerOpeningTag (property field)
	GetInnerOpeningTag() BACnetOpeningTag
	// GetAccessEvent returns AccessEvent (property field)
	GetAccessEvent() BACnetAccessEventTagged
	// GetStatusFlags returns StatusFlags (property field)
	GetStatusFlags() BACnetStatusFlagsTagged
	// GetAccessEventTag returns AccessEventTag (property field)
	GetAccessEventTag() BACnetContextTagUnsignedInteger
	// GetAccessEventTime returns AccessEventTime (property field)
	GetAccessEventTime() BACnetTimeStampEnclosed
	// GetAccessCredential returns AccessCredential (property field)
	GetAccessCredential() BACnetDeviceObjectReferenceEnclosed
	// GetAuthenticationFactor returns AuthenticationFactor (property field)
	GetAuthenticationFactor() BACnetAuthenticationFactorTypeTagged
	// GetInnerClosingTag returns InnerClosingTag (property field)
	GetInnerClosingTag() BACnetClosingTag
	// IsBACnetNotificationParametersAccessEvent is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetNotificationParametersAccessEvent()
	// CreateBuilder creates a BACnetNotificationParametersAccessEventBuilder
	CreateBACnetNotificationParametersAccessEventBuilder() BACnetNotificationParametersAccessEventBuilder
}

// _BACnetNotificationParametersAccessEvent is the data-structure of this message
type _BACnetNotificationParametersAccessEvent struct {
	BACnetNotificationParametersContract
	InnerOpeningTag      BACnetOpeningTag
	AccessEvent          BACnetAccessEventTagged
	StatusFlags          BACnetStatusFlagsTagged
	AccessEventTag       BACnetContextTagUnsignedInteger
	AccessEventTime      BACnetTimeStampEnclosed
	AccessCredential     BACnetDeviceObjectReferenceEnclosed
	AuthenticationFactor BACnetAuthenticationFactorTypeTagged
	InnerClosingTag      BACnetClosingTag
}

var _ BACnetNotificationParametersAccessEvent = (*_BACnetNotificationParametersAccessEvent)(nil)
var _ BACnetNotificationParametersRequirements = (*_BACnetNotificationParametersAccessEvent)(nil)

// NewBACnetNotificationParametersAccessEvent factory function for _BACnetNotificationParametersAccessEvent
func NewBACnetNotificationParametersAccessEvent(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, innerOpeningTag BACnetOpeningTag, accessEvent BACnetAccessEventTagged, statusFlags BACnetStatusFlagsTagged, accessEventTag BACnetContextTagUnsignedInteger, accessEventTime BACnetTimeStampEnclosed, accessCredential BACnetDeviceObjectReferenceEnclosed, authenticationFactor BACnetAuthenticationFactorTypeTagged, innerClosingTag BACnetClosingTag, tagNumber uint8, objectTypeArgument BACnetObjectType) *_BACnetNotificationParametersAccessEvent {
	if innerOpeningTag == nil {
		panic("innerOpeningTag of type BACnetOpeningTag for BACnetNotificationParametersAccessEvent must not be nil")
	}
	if accessEvent == nil {
		panic("accessEvent of type BACnetAccessEventTagged for BACnetNotificationParametersAccessEvent must not be nil")
	}
	if statusFlags == nil {
		panic("statusFlags of type BACnetStatusFlagsTagged for BACnetNotificationParametersAccessEvent must not be nil")
	}
	if accessEventTag == nil {
		panic("accessEventTag of type BACnetContextTagUnsignedInteger for BACnetNotificationParametersAccessEvent must not be nil")
	}
	if accessEventTime == nil {
		panic("accessEventTime of type BACnetTimeStampEnclosed for BACnetNotificationParametersAccessEvent must not be nil")
	}
	if accessCredential == nil {
		panic("accessCredential of type BACnetDeviceObjectReferenceEnclosed for BACnetNotificationParametersAccessEvent must not be nil")
	}
	if innerClosingTag == nil {
		panic("innerClosingTag of type BACnetClosingTag for BACnetNotificationParametersAccessEvent must not be nil")
	}
	_result := &_BACnetNotificationParametersAccessEvent{
		BACnetNotificationParametersContract: NewBACnetNotificationParameters(openingTag, peekedTagHeader, closingTag, tagNumber, objectTypeArgument),
		InnerOpeningTag:                      innerOpeningTag,
		AccessEvent:                          accessEvent,
		StatusFlags:                          statusFlags,
		AccessEventTag:                       accessEventTag,
		AccessEventTime:                      accessEventTime,
		AccessCredential:                     accessCredential,
		AuthenticationFactor:                 authenticationFactor,
		InnerClosingTag:                      innerClosingTag,
	}
	_result.BACnetNotificationParametersContract.(*_BACnetNotificationParameters)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetNotificationParametersAccessEventBuilder is a builder for BACnetNotificationParametersAccessEvent
type BACnetNotificationParametersAccessEventBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(innerOpeningTag BACnetOpeningTag, accessEvent BACnetAccessEventTagged, statusFlags BACnetStatusFlagsTagged, accessEventTag BACnetContextTagUnsignedInteger, accessEventTime BACnetTimeStampEnclosed, accessCredential BACnetDeviceObjectReferenceEnclosed, innerClosingTag BACnetClosingTag) BACnetNotificationParametersAccessEventBuilder
	// WithInnerOpeningTag adds InnerOpeningTag (property field)
	WithInnerOpeningTag(BACnetOpeningTag) BACnetNotificationParametersAccessEventBuilder
	// WithInnerOpeningTagBuilder adds InnerOpeningTag (property field) which is build by the builder
	WithInnerOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetNotificationParametersAccessEventBuilder
	// WithAccessEvent adds AccessEvent (property field)
	WithAccessEvent(BACnetAccessEventTagged) BACnetNotificationParametersAccessEventBuilder
	// WithAccessEventBuilder adds AccessEvent (property field) which is build by the builder
	WithAccessEventBuilder(func(BACnetAccessEventTaggedBuilder) BACnetAccessEventTaggedBuilder) BACnetNotificationParametersAccessEventBuilder
	// WithStatusFlags adds StatusFlags (property field)
	WithStatusFlags(BACnetStatusFlagsTagged) BACnetNotificationParametersAccessEventBuilder
	// WithStatusFlagsBuilder adds StatusFlags (property field) which is build by the builder
	WithStatusFlagsBuilder(func(BACnetStatusFlagsTaggedBuilder) BACnetStatusFlagsTaggedBuilder) BACnetNotificationParametersAccessEventBuilder
	// WithAccessEventTag adds AccessEventTag (property field)
	WithAccessEventTag(BACnetContextTagUnsignedInteger) BACnetNotificationParametersAccessEventBuilder
	// WithAccessEventTagBuilder adds AccessEventTag (property field) which is build by the builder
	WithAccessEventTagBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetNotificationParametersAccessEventBuilder
	// WithAccessEventTime adds AccessEventTime (property field)
	WithAccessEventTime(BACnetTimeStampEnclosed) BACnetNotificationParametersAccessEventBuilder
	// WithAccessEventTimeBuilder adds AccessEventTime (property field) which is build by the builder
	WithAccessEventTimeBuilder(func(BACnetTimeStampEnclosedBuilder) BACnetTimeStampEnclosedBuilder) BACnetNotificationParametersAccessEventBuilder
	// WithAccessCredential adds AccessCredential (property field)
	WithAccessCredential(BACnetDeviceObjectReferenceEnclosed) BACnetNotificationParametersAccessEventBuilder
	// WithAccessCredentialBuilder adds AccessCredential (property field) which is build by the builder
	WithAccessCredentialBuilder(func(BACnetDeviceObjectReferenceEnclosedBuilder) BACnetDeviceObjectReferenceEnclosedBuilder) BACnetNotificationParametersAccessEventBuilder
	// WithAuthenticationFactor adds AuthenticationFactor (property field)
	WithOptionalAuthenticationFactor(BACnetAuthenticationFactorTypeTagged) BACnetNotificationParametersAccessEventBuilder
	// WithOptionalAuthenticationFactorBuilder adds AuthenticationFactor (property field) which is build by the builder
	WithOptionalAuthenticationFactorBuilder(func(BACnetAuthenticationFactorTypeTaggedBuilder) BACnetAuthenticationFactorTypeTaggedBuilder) BACnetNotificationParametersAccessEventBuilder
	// WithInnerClosingTag adds InnerClosingTag (property field)
	WithInnerClosingTag(BACnetClosingTag) BACnetNotificationParametersAccessEventBuilder
	// WithInnerClosingTagBuilder adds InnerClosingTag (property field) which is build by the builder
	WithInnerClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetNotificationParametersAccessEventBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetNotificationParametersBuilder
	// Build builds the BACnetNotificationParametersAccessEvent or returns an error if something is wrong
	Build() (BACnetNotificationParametersAccessEvent, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetNotificationParametersAccessEvent
}

// NewBACnetNotificationParametersAccessEventBuilder() creates a BACnetNotificationParametersAccessEventBuilder
func NewBACnetNotificationParametersAccessEventBuilder() BACnetNotificationParametersAccessEventBuilder {
	return &_BACnetNotificationParametersAccessEventBuilder{_BACnetNotificationParametersAccessEvent: new(_BACnetNotificationParametersAccessEvent)}
}

type _BACnetNotificationParametersAccessEventBuilder struct {
	*_BACnetNotificationParametersAccessEvent

	parentBuilder *_BACnetNotificationParametersBuilder

	err *utils.MultiError
}

var _ (BACnetNotificationParametersAccessEventBuilder) = (*_BACnetNotificationParametersAccessEventBuilder)(nil)

func (b *_BACnetNotificationParametersAccessEventBuilder) setParent(contract BACnetNotificationParametersContract) {
	b.BACnetNotificationParametersContract = contract
	contract.(*_BACnetNotificationParameters)._SubType = b._BACnetNotificationParametersAccessEvent
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithMandatoryFields(innerOpeningTag BACnetOpeningTag, accessEvent BACnetAccessEventTagged, statusFlags BACnetStatusFlagsTagged, accessEventTag BACnetContextTagUnsignedInteger, accessEventTime BACnetTimeStampEnclosed, accessCredential BACnetDeviceObjectReferenceEnclosed, innerClosingTag BACnetClosingTag) BACnetNotificationParametersAccessEventBuilder {
	return b.WithInnerOpeningTag(innerOpeningTag).WithAccessEvent(accessEvent).WithStatusFlags(statusFlags).WithAccessEventTag(accessEventTag).WithAccessEventTime(accessEventTime).WithAccessCredential(accessCredential).WithInnerClosingTag(innerClosingTag)
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithInnerOpeningTag(innerOpeningTag BACnetOpeningTag) BACnetNotificationParametersAccessEventBuilder {
	b.InnerOpeningTag = innerOpeningTag
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithInnerOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetNotificationParametersAccessEventBuilder {
	builder := builderSupplier(b.InnerOpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.InnerOpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithAccessEvent(accessEvent BACnetAccessEventTagged) BACnetNotificationParametersAccessEventBuilder {
	b.AccessEvent = accessEvent
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithAccessEventBuilder(builderSupplier func(BACnetAccessEventTaggedBuilder) BACnetAccessEventTaggedBuilder) BACnetNotificationParametersAccessEventBuilder {
	builder := builderSupplier(b.AccessEvent.CreateBACnetAccessEventTaggedBuilder())
	var err error
	b.AccessEvent, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetAccessEventTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithStatusFlags(statusFlags BACnetStatusFlagsTagged) BACnetNotificationParametersAccessEventBuilder {
	b.StatusFlags = statusFlags
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithStatusFlagsBuilder(builderSupplier func(BACnetStatusFlagsTaggedBuilder) BACnetStatusFlagsTaggedBuilder) BACnetNotificationParametersAccessEventBuilder {
	builder := builderSupplier(b.StatusFlags.CreateBACnetStatusFlagsTaggedBuilder())
	var err error
	b.StatusFlags, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetStatusFlagsTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithAccessEventTag(accessEventTag BACnetContextTagUnsignedInteger) BACnetNotificationParametersAccessEventBuilder {
	b.AccessEventTag = accessEventTag
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithAccessEventTagBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetNotificationParametersAccessEventBuilder {
	builder := builderSupplier(b.AccessEventTag.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.AccessEventTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithAccessEventTime(accessEventTime BACnetTimeStampEnclosed) BACnetNotificationParametersAccessEventBuilder {
	b.AccessEventTime = accessEventTime
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithAccessEventTimeBuilder(builderSupplier func(BACnetTimeStampEnclosedBuilder) BACnetTimeStampEnclosedBuilder) BACnetNotificationParametersAccessEventBuilder {
	builder := builderSupplier(b.AccessEventTime.CreateBACnetTimeStampEnclosedBuilder())
	var err error
	b.AccessEventTime, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTimeStampEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithAccessCredential(accessCredential BACnetDeviceObjectReferenceEnclosed) BACnetNotificationParametersAccessEventBuilder {
	b.AccessCredential = accessCredential
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithAccessCredentialBuilder(builderSupplier func(BACnetDeviceObjectReferenceEnclosedBuilder) BACnetDeviceObjectReferenceEnclosedBuilder) BACnetNotificationParametersAccessEventBuilder {
	builder := builderSupplier(b.AccessCredential.CreateBACnetDeviceObjectReferenceEnclosedBuilder())
	var err error
	b.AccessCredential, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDeviceObjectReferenceEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithOptionalAuthenticationFactor(authenticationFactor BACnetAuthenticationFactorTypeTagged) BACnetNotificationParametersAccessEventBuilder {
	b.AuthenticationFactor = authenticationFactor
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithOptionalAuthenticationFactorBuilder(builderSupplier func(BACnetAuthenticationFactorTypeTaggedBuilder) BACnetAuthenticationFactorTypeTaggedBuilder) BACnetNotificationParametersAccessEventBuilder {
	builder := builderSupplier(b.AuthenticationFactor.CreateBACnetAuthenticationFactorTypeTaggedBuilder())
	var err error
	b.AuthenticationFactor, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetAuthenticationFactorTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithInnerClosingTag(innerClosingTag BACnetClosingTag) BACnetNotificationParametersAccessEventBuilder {
	b.InnerClosingTag = innerClosingTag
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) WithInnerClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetNotificationParametersAccessEventBuilder {
	builder := builderSupplier(b.InnerClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.InnerClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersAccessEventBuilder) Build() (BACnetNotificationParametersAccessEvent, error) {
	if b.InnerOpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'innerOpeningTag' not set"))
	}
	if b.AccessEvent == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'accessEvent' not set"))
	}
	if b.StatusFlags == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'statusFlags' not set"))
	}
	if b.AccessEventTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'accessEventTag' not set"))
	}
	if b.AccessEventTime == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'accessEventTime' not set"))
	}
	if b.AccessCredential == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'accessCredential' not set"))
	}
	if b.InnerClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'innerClosingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetNotificationParametersAccessEvent.deepCopy(), nil
}

func (b *_BACnetNotificationParametersAccessEventBuilder) MustBuild() BACnetNotificationParametersAccessEvent {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetNotificationParametersAccessEventBuilder) Done() BACnetNotificationParametersBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetNotificationParametersBuilder().(*_BACnetNotificationParametersBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetNotificationParametersAccessEventBuilder) buildForBACnetNotificationParameters() (BACnetNotificationParameters, error) {
	return b.Build()
}

func (b *_BACnetNotificationParametersAccessEventBuilder) DeepCopy() any {
	_copy := b.CreateBACnetNotificationParametersAccessEventBuilder().(*_BACnetNotificationParametersAccessEventBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetNotificationParametersAccessEventBuilder creates a BACnetNotificationParametersAccessEventBuilder
func (b *_BACnetNotificationParametersAccessEvent) CreateBACnetNotificationParametersAccessEventBuilder() BACnetNotificationParametersAccessEventBuilder {
	if b == nil {
		return NewBACnetNotificationParametersAccessEventBuilder()
	}
	return &_BACnetNotificationParametersAccessEventBuilder{_BACnetNotificationParametersAccessEvent: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetNotificationParametersAccessEvent) GetParent() BACnetNotificationParametersContract {
	return m.BACnetNotificationParametersContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetNotificationParametersAccessEvent) GetInnerOpeningTag() BACnetOpeningTag {
	return m.InnerOpeningTag
}

func (m *_BACnetNotificationParametersAccessEvent) GetAccessEvent() BACnetAccessEventTagged {
	return m.AccessEvent
}

func (m *_BACnetNotificationParametersAccessEvent) GetStatusFlags() BACnetStatusFlagsTagged {
	return m.StatusFlags
}

func (m *_BACnetNotificationParametersAccessEvent) GetAccessEventTag() BACnetContextTagUnsignedInteger {
	return m.AccessEventTag
}

func (m *_BACnetNotificationParametersAccessEvent) GetAccessEventTime() BACnetTimeStampEnclosed {
	return m.AccessEventTime
}

func (m *_BACnetNotificationParametersAccessEvent) GetAccessCredential() BACnetDeviceObjectReferenceEnclosed {
	return m.AccessCredential
}

func (m *_BACnetNotificationParametersAccessEvent) GetAuthenticationFactor() BACnetAuthenticationFactorTypeTagged {
	return m.AuthenticationFactor
}

func (m *_BACnetNotificationParametersAccessEvent) GetInnerClosingTag() BACnetClosingTag {
	return m.InnerClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetNotificationParametersAccessEvent(structType any) BACnetNotificationParametersAccessEvent {
	if casted, ok := structType.(BACnetNotificationParametersAccessEvent); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetNotificationParametersAccessEvent); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetNotificationParametersAccessEvent) GetTypeName() string {
	return "BACnetNotificationParametersAccessEvent"
}

func (m *_BACnetNotificationParametersAccessEvent) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetNotificationParametersContract.(*_BACnetNotificationParameters).getLengthInBits(ctx))

	// Simple field (innerOpeningTag)
	lengthInBits += m.InnerOpeningTag.GetLengthInBits(ctx)

	// Simple field (accessEvent)
	lengthInBits += m.AccessEvent.GetLengthInBits(ctx)

	// Simple field (statusFlags)
	lengthInBits += m.StatusFlags.GetLengthInBits(ctx)

	// Simple field (accessEventTag)
	lengthInBits += m.AccessEventTag.GetLengthInBits(ctx)

	// Simple field (accessEventTime)
	lengthInBits += m.AccessEventTime.GetLengthInBits(ctx)

	// Simple field (accessCredential)
	lengthInBits += m.AccessCredential.GetLengthInBits(ctx)

	// Optional Field (authenticationFactor)
	if m.AuthenticationFactor != nil {
		lengthInBits += m.AuthenticationFactor.GetLengthInBits(ctx)
	}

	// Simple field (innerClosingTag)
	lengthInBits += m.InnerClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetNotificationParametersAccessEvent) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetNotificationParametersAccessEvent) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetNotificationParameters, peekedTagNumber uint8, tagNumber uint8, objectTypeArgument BACnetObjectType) (__bACnetNotificationParametersAccessEvent BACnetNotificationParametersAccessEvent, err error) {
	m.BACnetNotificationParametersContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetNotificationParametersAccessEvent"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetNotificationParametersAccessEvent")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	innerOpeningTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "innerOpeningTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(peekedTagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'innerOpeningTag' field"))
	}
	m.InnerOpeningTag = innerOpeningTag

	accessEvent, err := ReadSimpleField[BACnetAccessEventTagged](ctx, "accessEvent", ReadComplex[BACnetAccessEventTagged](BACnetAccessEventTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'accessEvent' field"))
	}
	m.AccessEvent = accessEvent

	statusFlags, err := ReadSimpleField[BACnetStatusFlagsTagged](ctx, "statusFlags", ReadComplex[BACnetStatusFlagsTagged](BACnetStatusFlagsTaggedParseWithBufferProducer((uint8)(uint8(1)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'statusFlags' field"))
	}
	m.StatusFlags = statusFlags

	accessEventTag, err := ReadSimpleField[BACnetContextTagUnsignedInteger](ctx, "accessEventTag", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(2)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'accessEventTag' field"))
	}
	m.AccessEventTag = accessEventTag

	accessEventTime, err := ReadSimpleField[BACnetTimeStampEnclosed](ctx, "accessEventTime", ReadComplex[BACnetTimeStampEnclosed](BACnetTimeStampEnclosedParseWithBufferProducer((uint8)(uint8(3))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'accessEventTime' field"))
	}
	m.AccessEventTime = accessEventTime

	accessCredential, err := ReadSimpleField[BACnetDeviceObjectReferenceEnclosed](ctx, "accessCredential", ReadComplex[BACnetDeviceObjectReferenceEnclosed](BACnetDeviceObjectReferenceEnclosedParseWithBufferProducer((uint8)(uint8(4))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'accessCredential' field"))
	}
	m.AccessCredential = accessCredential

	var authenticationFactor BACnetAuthenticationFactorTypeTagged
	_authenticationFactor, err := ReadOptionalField[BACnetAuthenticationFactorTypeTagged](ctx, "authenticationFactor", ReadComplex[BACnetAuthenticationFactorTypeTagged](BACnetAuthenticationFactorTypeTaggedParseWithBufferProducer((uint8)(uint8(5)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'authenticationFactor' field"))
	}
	if _authenticationFactor != nil {
		authenticationFactor = *_authenticationFactor
		m.AuthenticationFactor = authenticationFactor
	}

	innerClosingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "innerClosingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(peekedTagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'innerClosingTag' field"))
	}
	m.InnerClosingTag = innerClosingTag

	if closeErr := readBuffer.CloseContext("BACnetNotificationParametersAccessEvent"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetNotificationParametersAccessEvent")
	}

	return m, nil
}

func (m *_BACnetNotificationParametersAccessEvent) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetNotificationParametersAccessEvent) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetNotificationParametersAccessEvent"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetNotificationParametersAccessEvent")
		}

		if err := WriteSimpleField[BACnetOpeningTag](ctx, "innerOpeningTag", m.GetInnerOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'innerOpeningTag' field")
		}

		if err := WriteSimpleField[BACnetAccessEventTagged](ctx, "accessEvent", m.GetAccessEvent(), WriteComplex[BACnetAccessEventTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'accessEvent' field")
		}

		if err := WriteSimpleField[BACnetStatusFlagsTagged](ctx, "statusFlags", m.GetStatusFlags(), WriteComplex[BACnetStatusFlagsTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'statusFlags' field")
		}

		if err := WriteSimpleField[BACnetContextTagUnsignedInteger](ctx, "accessEventTag", m.GetAccessEventTag(), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'accessEventTag' field")
		}

		if err := WriteSimpleField[BACnetTimeStampEnclosed](ctx, "accessEventTime", m.GetAccessEventTime(), WriteComplex[BACnetTimeStampEnclosed](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'accessEventTime' field")
		}

		if err := WriteSimpleField[BACnetDeviceObjectReferenceEnclosed](ctx, "accessCredential", m.GetAccessCredential(), WriteComplex[BACnetDeviceObjectReferenceEnclosed](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'accessCredential' field")
		}

		if err := WriteOptionalField[BACnetAuthenticationFactorTypeTagged](ctx, "authenticationFactor", GetRef(m.GetAuthenticationFactor()), WriteComplex[BACnetAuthenticationFactorTypeTagged](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'authenticationFactor' field")
		}

		if err := WriteSimpleField[BACnetClosingTag](ctx, "innerClosingTag", m.GetInnerClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'innerClosingTag' field")
		}

		if popErr := writeBuffer.PopContext("BACnetNotificationParametersAccessEvent"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetNotificationParametersAccessEvent")
		}
		return nil
	}
	return m.BACnetNotificationParametersContract.(*_BACnetNotificationParameters).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetNotificationParametersAccessEvent) IsBACnetNotificationParametersAccessEvent() {}

func (m *_BACnetNotificationParametersAccessEvent) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetNotificationParametersAccessEvent) deepCopy() *_BACnetNotificationParametersAccessEvent {
	if m == nil {
		return nil
	}
	_BACnetNotificationParametersAccessEventCopy := &_BACnetNotificationParametersAccessEvent{
		m.BACnetNotificationParametersContract.(*_BACnetNotificationParameters).deepCopy(),
		utils.DeepCopy[BACnetOpeningTag](m.InnerOpeningTag),
		utils.DeepCopy[BACnetAccessEventTagged](m.AccessEvent),
		utils.DeepCopy[BACnetStatusFlagsTagged](m.StatusFlags),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.AccessEventTag),
		utils.DeepCopy[BACnetTimeStampEnclosed](m.AccessEventTime),
		utils.DeepCopy[BACnetDeviceObjectReferenceEnclosed](m.AccessCredential),
		utils.DeepCopy[BACnetAuthenticationFactorTypeTagged](m.AuthenticationFactor),
		utils.DeepCopy[BACnetClosingTag](m.InnerClosingTag),
	}
	_BACnetNotificationParametersAccessEventCopy.BACnetNotificationParametersContract.(*_BACnetNotificationParameters)._SubType = m
	return _BACnetNotificationParametersAccessEventCopy
}

func (m *_BACnetNotificationParametersAccessEvent) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
