/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetNotificationParameters is the corresponding interface of BACnetNotificationParameters
type BACnetNotificationParameters interface {
	BACnetNotificationParametersContract
	BACnetNotificationParametersRequirements
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetNotificationParameters is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetNotificationParameters()
	// CreateBuilder creates a BACnetNotificationParametersBuilder
	CreateBACnetNotificationParametersBuilder() BACnetNotificationParametersBuilder
}

// BACnetNotificationParametersContract provides a set of functions which can be overwritten by a sub struct
type BACnetNotificationParametersContract interface {
	// GetOpeningTag returns OpeningTag (property field)
	GetOpeningTag() BACnetOpeningTag
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetClosingTag returns ClosingTag (property field)
	GetClosingTag() BACnetClosingTag
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
	// GetTagNumber() returns a parser argument
	GetTagNumber() uint8
	// GetObjectTypeArgument() returns a parser argument
	GetObjectTypeArgument() BACnetObjectType
	// IsBACnetNotificationParameters is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetNotificationParameters()
	// CreateBuilder creates a BACnetNotificationParametersBuilder
	CreateBACnetNotificationParametersBuilder() BACnetNotificationParametersBuilder
}

// BACnetNotificationParametersRequirements provides a set of functions which need to be implemented by a sub struct
type BACnetNotificationParametersRequirements interface {
	GetLengthInBits(ctx context.Context) uint16
	GetLengthInBytes(ctx context.Context) uint16
	// GetPeekedTagNumber returns PeekedTagNumber (discriminator field)
	GetPeekedTagNumber() uint8
}

// _BACnetNotificationParameters is the data-structure of this message
type _BACnetNotificationParameters struct {
	_SubType interface {
		BACnetNotificationParametersContract
		BACnetNotificationParametersRequirements
	}
	OpeningTag      BACnetOpeningTag
	PeekedTagHeader BACnetTagHeader
	ClosingTag      BACnetClosingTag

	// Arguments.
	TagNumber          uint8
	ObjectTypeArgument BACnetObjectType
}

var _ BACnetNotificationParametersContract = (*_BACnetNotificationParameters)(nil)

// NewBACnetNotificationParameters factory function for _BACnetNotificationParameters
func NewBACnetNotificationParameters(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, objectTypeArgument BACnetObjectType) *_BACnetNotificationParameters {
	if openingTag == nil {
		panic("openingTag of type BACnetOpeningTag for BACnetNotificationParameters must not be nil")
	}
	if peekedTagHeader == nil {
		panic("peekedTagHeader of type BACnetTagHeader for BACnetNotificationParameters must not be nil")
	}
	if closingTag == nil {
		panic("closingTag of type BACnetClosingTag for BACnetNotificationParameters must not be nil")
	}
	return &_BACnetNotificationParameters{OpeningTag: openingTag, PeekedTagHeader: peekedTagHeader, ClosingTag: closingTag, TagNumber: tagNumber, ObjectTypeArgument: objectTypeArgument}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetNotificationParametersBuilder is a builder for BACnetNotificationParameters
type BACnetNotificationParametersBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) BACnetNotificationParametersBuilder
	// WithOpeningTag adds OpeningTag (property field)
	WithOpeningTag(BACnetOpeningTag) BACnetNotificationParametersBuilder
	// WithOpeningTagBuilder adds OpeningTag (property field) which is build by the builder
	WithOpeningTagBuilder(func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetNotificationParametersBuilder
	// WithPeekedTagHeader adds PeekedTagHeader (property field)
	WithPeekedTagHeader(BACnetTagHeader) BACnetNotificationParametersBuilder
	// WithPeekedTagHeaderBuilder adds PeekedTagHeader (property field) which is build by the builder
	WithPeekedTagHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetNotificationParametersBuilder
	// WithClosingTag adds ClosingTag (property field)
	WithClosingTag(BACnetClosingTag) BACnetNotificationParametersBuilder
	// WithClosingTagBuilder adds ClosingTag (property field) which is build by the builder
	WithClosingTagBuilder(func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetNotificationParametersBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetNotificationParametersBuilder
	// WithArgObjectTypeArgument sets a parser argument
	WithArgObjectTypeArgument(BACnetObjectType) BACnetNotificationParametersBuilder
	// AsBACnetNotificationParametersChangeOfBitString converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersChangeOfBitString() BACnetNotificationParametersChangeOfBitStringBuilder
	// AsBACnetNotificationParametersChangeOfState converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersChangeOfState() BACnetNotificationParametersChangeOfStateBuilder
	// AsBACnetNotificationParametersChangeOfValue converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersChangeOfValue() BACnetNotificationParametersChangeOfValueBuilder
	// AsBACnetNotificationParametersCommandFailure converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersCommandFailure() BACnetNotificationParametersCommandFailureBuilder
	// AsBACnetNotificationParametersFloatingLimit converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersFloatingLimit() BACnetNotificationParametersFloatingLimitBuilder
	// AsBACnetNotificationParametersOutOfRange converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersOutOfRange() BACnetNotificationParametersOutOfRangeBuilder
	// AsBACnetNotificationParametersComplexEventType converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersComplexEventType() BACnetNotificationParametersComplexEventTypeBuilder
	// AsBACnetNotificationParametersChangeOfLifeSafety converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersChangeOfLifeSafety() BACnetNotificationParametersChangeOfLifeSafetyBuilder
	// AsBACnetNotificationParametersExtended converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersExtended() BACnetNotificationParametersExtendedBuilder
	// AsBACnetNotificationParametersBufferReady converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersBufferReady() BACnetNotificationParametersBufferReadyBuilder
	// AsBACnetNotificationParametersUnsignedRange converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersUnsignedRange() BACnetNotificationParametersUnsignedRangeBuilder
	// AsBACnetNotificationParametersAccessEvent converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersAccessEvent() BACnetNotificationParametersAccessEventBuilder
	// AsBACnetNotificationParametersDoubleOutOfRange converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersDoubleOutOfRange() BACnetNotificationParametersDoubleOutOfRangeBuilder
	// AsBACnetNotificationParametersSignedOutOfRange converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersSignedOutOfRange() BACnetNotificationParametersSignedOutOfRangeBuilder
	// AsBACnetNotificationParametersUnsignedOutOfRange converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersUnsignedOutOfRange() BACnetNotificationParametersUnsignedOutOfRangeBuilder
	// AsBACnetNotificationParametersChangeOfCharacterString converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersChangeOfCharacterString() BACnetNotificationParametersChangeOfCharacterStringBuilder
	// AsBACnetNotificationParametersChangeOfStatusFlags converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersChangeOfStatusFlags() BACnetNotificationParametersChangeOfStatusFlagsBuilder
	// AsBACnetNotificationParametersChangeOfReliability converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersChangeOfReliability() BACnetNotificationParametersChangeOfReliabilityBuilder
	// AsBACnetNotificationParametersChangeOfDiscreteValue converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersChangeOfDiscreteValue() BACnetNotificationParametersChangeOfDiscreteValueBuilder
	// AsBACnetNotificationParametersChangeOfTimer converts this build to a subType of BACnetNotificationParameters. It is always possible to return to current builder using Done()
	AsBACnetNotificationParametersChangeOfTimer() BACnetNotificationParametersChangeOfTimerBuilder
	// Build builds the BACnetNotificationParameters or returns an error if something is wrong
	PartialBuild() (BACnetNotificationParametersContract, error)
	// MustBuild does the same as Build but panics on error
	PartialMustBuild() BACnetNotificationParametersContract
	// Build builds the BACnetNotificationParameters or returns an error if something is wrong
	Build() (BACnetNotificationParameters, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetNotificationParameters
}

// NewBACnetNotificationParametersBuilder() creates a BACnetNotificationParametersBuilder
func NewBACnetNotificationParametersBuilder() BACnetNotificationParametersBuilder {
	return &_BACnetNotificationParametersBuilder{_BACnetNotificationParameters: new(_BACnetNotificationParameters)}
}

type _BACnetNotificationParametersChildBuilder interface {
	utils.Copyable
	setParent(BACnetNotificationParametersContract)
	buildForBACnetNotificationParameters() (BACnetNotificationParameters, error)
}

type _BACnetNotificationParametersBuilder struct {
	*_BACnetNotificationParameters

	childBuilder _BACnetNotificationParametersChildBuilder

	err *utils.MultiError
}

var _ (BACnetNotificationParametersBuilder) = (*_BACnetNotificationParametersBuilder)(nil)

func (b *_BACnetNotificationParametersBuilder) WithMandatoryFields(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) BACnetNotificationParametersBuilder {
	return b.WithOpeningTag(openingTag).WithPeekedTagHeader(peekedTagHeader).WithClosingTag(closingTag)
}

func (b *_BACnetNotificationParametersBuilder) WithOpeningTag(openingTag BACnetOpeningTag) BACnetNotificationParametersBuilder {
	b.OpeningTag = openingTag
	return b
}

func (b *_BACnetNotificationParametersBuilder) WithOpeningTagBuilder(builderSupplier func(BACnetOpeningTagBuilder) BACnetOpeningTagBuilder) BACnetNotificationParametersBuilder {
	builder := builderSupplier(b.OpeningTag.CreateBACnetOpeningTagBuilder())
	var err error
	b.OpeningTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetOpeningTagBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersBuilder) WithPeekedTagHeader(peekedTagHeader BACnetTagHeader) BACnetNotificationParametersBuilder {
	b.PeekedTagHeader = peekedTagHeader
	return b
}

func (b *_BACnetNotificationParametersBuilder) WithPeekedTagHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetNotificationParametersBuilder {
	builder := builderSupplier(b.PeekedTagHeader.CreateBACnetTagHeaderBuilder())
	var err error
	b.PeekedTagHeader, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersBuilder) WithClosingTag(closingTag BACnetClosingTag) BACnetNotificationParametersBuilder {
	b.ClosingTag = closingTag
	return b
}

func (b *_BACnetNotificationParametersBuilder) WithClosingTagBuilder(builderSupplier func(BACnetClosingTagBuilder) BACnetClosingTagBuilder) BACnetNotificationParametersBuilder {
	builder := builderSupplier(b.ClosingTag.CreateBACnetClosingTagBuilder())
	var err error
	b.ClosingTag, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetClosingTagBuilder failed"))
	}
	return b
}

func (b *_BACnetNotificationParametersBuilder) WithArgTagNumber(tagNumber uint8) BACnetNotificationParametersBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetNotificationParametersBuilder) WithArgObjectTypeArgument(objectTypeArgument BACnetObjectType) BACnetNotificationParametersBuilder {
	b.ObjectTypeArgument = objectTypeArgument
	return b
}

func (b *_BACnetNotificationParametersBuilder) PartialBuild() (BACnetNotificationParametersContract, error) {
	if b.OpeningTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'openingTag' not set"))
	}
	if b.PeekedTagHeader == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'peekedTagHeader' not set"))
	}
	if b.ClosingTag == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'closingTag' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetNotificationParameters.deepCopy(), nil
}

func (b *_BACnetNotificationParametersBuilder) PartialMustBuild() BACnetNotificationParametersContract {
	build, err := b.PartialBuild()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersChangeOfBitString() BACnetNotificationParametersChangeOfBitStringBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersChangeOfBitStringBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersChangeOfBitStringBuilder().(*_BACnetNotificationParametersChangeOfBitStringBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersChangeOfState() BACnetNotificationParametersChangeOfStateBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersChangeOfStateBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersChangeOfStateBuilder().(*_BACnetNotificationParametersChangeOfStateBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersChangeOfValue() BACnetNotificationParametersChangeOfValueBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersChangeOfValueBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersChangeOfValueBuilder().(*_BACnetNotificationParametersChangeOfValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersCommandFailure() BACnetNotificationParametersCommandFailureBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersCommandFailureBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersCommandFailureBuilder().(*_BACnetNotificationParametersCommandFailureBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersFloatingLimit() BACnetNotificationParametersFloatingLimitBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersFloatingLimitBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersFloatingLimitBuilder().(*_BACnetNotificationParametersFloatingLimitBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersOutOfRange() BACnetNotificationParametersOutOfRangeBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersOutOfRangeBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersOutOfRangeBuilder().(*_BACnetNotificationParametersOutOfRangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersComplexEventType() BACnetNotificationParametersComplexEventTypeBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersComplexEventTypeBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersComplexEventTypeBuilder().(*_BACnetNotificationParametersComplexEventTypeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersChangeOfLifeSafety() BACnetNotificationParametersChangeOfLifeSafetyBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersChangeOfLifeSafetyBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersChangeOfLifeSafetyBuilder().(*_BACnetNotificationParametersChangeOfLifeSafetyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersExtended() BACnetNotificationParametersExtendedBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersExtendedBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersExtendedBuilder().(*_BACnetNotificationParametersExtendedBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersBufferReady() BACnetNotificationParametersBufferReadyBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersBufferReadyBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersBufferReadyBuilder().(*_BACnetNotificationParametersBufferReadyBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersUnsignedRange() BACnetNotificationParametersUnsignedRangeBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersUnsignedRangeBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersUnsignedRangeBuilder().(*_BACnetNotificationParametersUnsignedRangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersAccessEvent() BACnetNotificationParametersAccessEventBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersAccessEventBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersAccessEventBuilder().(*_BACnetNotificationParametersAccessEventBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersDoubleOutOfRange() BACnetNotificationParametersDoubleOutOfRangeBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersDoubleOutOfRangeBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersDoubleOutOfRangeBuilder().(*_BACnetNotificationParametersDoubleOutOfRangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersSignedOutOfRange() BACnetNotificationParametersSignedOutOfRangeBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersSignedOutOfRangeBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersSignedOutOfRangeBuilder().(*_BACnetNotificationParametersSignedOutOfRangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersUnsignedOutOfRange() BACnetNotificationParametersUnsignedOutOfRangeBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersUnsignedOutOfRangeBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersUnsignedOutOfRangeBuilder().(*_BACnetNotificationParametersUnsignedOutOfRangeBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersChangeOfCharacterString() BACnetNotificationParametersChangeOfCharacterStringBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersChangeOfCharacterStringBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersChangeOfCharacterStringBuilder().(*_BACnetNotificationParametersChangeOfCharacterStringBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersChangeOfStatusFlags() BACnetNotificationParametersChangeOfStatusFlagsBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersChangeOfStatusFlagsBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersChangeOfStatusFlagsBuilder().(*_BACnetNotificationParametersChangeOfStatusFlagsBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersChangeOfReliability() BACnetNotificationParametersChangeOfReliabilityBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersChangeOfReliabilityBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersChangeOfReliabilityBuilder().(*_BACnetNotificationParametersChangeOfReliabilityBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersChangeOfDiscreteValue() BACnetNotificationParametersChangeOfDiscreteValueBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersChangeOfDiscreteValueBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersChangeOfDiscreteValueBuilder().(*_BACnetNotificationParametersChangeOfDiscreteValueBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) AsBACnetNotificationParametersChangeOfTimer() BACnetNotificationParametersChangeOfTimerBuilder {
	if cb, ok := b.childBuilder.(BACnetNotificationParametersChangeOfTimerBuilder); ok {
		return cb
	}
	cb := NewBACnetNotificationParametersChangeOfTimerBuilder().(*_BACnetNotificationParametersChangeOfTimerBuilder)
	cb.parentBuilder = b
	b.childBuilder = cb
	return cb
}

func (b *_BACnetNotificationParametersBuilder) Build() (BACnetNotificationParameters, error) {
	v, err := b.PartialBuild()
	if err != nil {
		return nil, errors.Wrap(err, "error occurred during partial build")
	}
	if b.childBuilder == nil {
		return nil, errors.New("no child builder present")
	}
	b.childBuilder.setParent(v)
	return b.childBuilder.buildForBACnetNotificationParameters()
}

func (b *_BACnetNotificationParametersBuilder) MustBuild() BACnetNotificationParameters {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetNotificationParametersBuilder) DeepCopy() any {
	_copy := b.CreateBACnetNotificationParametersBuilder().(*_BACnetNotificationParametersBuilder)
	_copy.childBuilder = b.childBuilder.DeepCopy().(_BACnetNotificationParametersChildBuilder)
	_copy.childBuilder.setParent(_copy)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetNotificationParametersBuilder creates a BACnetNotificationParametersBuilder
func (b *_BACnetNotificationParameters) CreateBACnetNotificationParametersBuilder() BACnetNotificationParametersBuilder {
	if b == nil {
		return NewBACnetNotificationParametersBuilder()
	}
	return &_BACnetNotificationParametersBuilder{_BACnetNotificationParameters: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetNotificationParameters) GetOpeningTag() BACnetOpeningTag {
	return m.OpeningTag
}

func (m *_BACnetNotificationParameters) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

func (m *_BACnetNotificationParameters) GetClosingTag() BACnetClosingTag {
	return m.ClosingTag
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (pm *_BACnetNotificationParameters) GetPeekedTagNumber() uint8 {
	m := pm._SubType
	ctx := context.Background()
	_ = ctx
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetNotificationParameters(structType any) BACnetNotificationParameters {
	if casted, ok := structType.(BACnetNotificationParameters); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetNotificationParameters); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetNotificationParameters) GetTypeName() string {
	return "BACnetNotificationParameters"
}

func (m *_BACnetNotificationParameters) getLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (openingTag)
	lengthInBits += m.OpeningTag.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	// Simple field (closingTag)
	lengthInBits += m.ClosingTag.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetNotificationParameters) GetLengthInBits(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx)
}

func (m *_BACnetNotificationParameters) GetLengthInBytes(ctx context.Context) uint16 {
	return m._SubType.GetLengthInBits(ctx) / 8
}

func BACnetNotificationParametersParse[T BACnetNotificationParameters](ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType) (T, error) {
	return BACnetNotificationParametersParseWithBuffer[T](ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument)
}

func BACnetNotificationParametersParseWithBufferProducer[T BACnetNotificationParameters](tagNumber uint8, objectTypeArgument BACnetObjectType) func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (T, error) {
		v, err := BACnetNotificationParametersParseWithBuffer[T](ctx, readBuffer, tagNumber, objectTypeArgument)
		if err != nil {
			var zero T
			return zero, err
		}
		return v, nil
	}
}

func BACnetNotificationParametersParseWithBuffer[T BACnetNotificationParameters](ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType) (T, error) {
	v, err := (&_BACnetNotificationParameters{TagNumber: tagNumber, ObjectTypeArgument: objectTypeArgument}).parse(ctx, readBuffer, tagNumber, objectTypeArgument)
	if err != nil {
		var zero T
		return zero, err
	}
	vc, ok := v.(T)
	if !ok {
		var zero T
		return zero, errors.Errorf("Unexpected type %T. Expected type %T", v, *new(T))
	}
	return vc, nil
}

func (m *_BACnetNotificationParameters) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType) (__bACnetNotificationParameters BACnetNotificationParameters, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetNotificationParameters"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetNotificationParameters")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	openingTag, err := ReadSimpleField[BACnetOpeningTag](ctx, "openingTag", ReadComplex[BACnetOpeningTag](BACnetOpeningTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'openingTag' field"))
	}
	m.OpeningTag = openingTag

	peekedTagHeader, err := ReadPeekField[BACnetTagHeader](ctx, "peekedTagHeader", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer), 0)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagHeader' field"))
	}
	m.PeekedTagHeader = peekedTagHeader

	peekedTagNumber, err := ReadVirtualField[uint8](ctx, "peekedTagNumber", (*uint8)(nil), peekedTagHeader.GetActualTagNumber())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'peekedTagNumber' field"))
	}
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	var _child BACnetNotificationParameters
	switch {
	case peekedTagNumber == uint8(0): // BACnetNotificationParametersChangeOfBitString
		if _child, err = new(_BACnetNotificationParametersChangeOfBitString).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersChangeOfBitString for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(1): // BACnetNotificationParametersChangeOfState
		if _child, err = new(_BACnetNotificationParametersChangeOfState).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersChangeOfState for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(2): // BACnetNotificationParametersChangeOfValue
		if _child, err = new(_BACnetNotificationParametersChangeOfValue).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersChangeOfValue for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(3): // BACnetNotificationParametersCommandFailure
		if _child, err = new(_BACnetNotificationParametersCommandFailure).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersCommandFailure for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(4): // BACnetNotificationParametersFloatingLimit
		if _child, err = new(_BACnetNotificationParametersFloatingLimit).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersFloatingLimit for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(5): // BACnetNotificationParametersOutOfRange
		if _child, err = new(_BACnetNotificationParametersOutOfRange).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersOutOfRange for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(6): // BACnetNotificationParametersComplexEventType
		if _child, err = new(_BACnetNotificationParametersComplexEventType).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersComplexEventType for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(8): // BACnetNotificationParametersChangeOfLifeSafety
		if _child, err = new(_BACnetNotificationParametersChangeOfLifeSafety).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersChangeOfLifeSafety for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(9): // BACnetNotificationParametersExtended
		if _child, err = new(_BACnetNotificationParametersExtended).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersExtended for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(10): // BACnetNotificationParametersBufferReady
		if _child, err = new(_BACnetNotificationParametersBufferReady).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersBufferReady for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(11): // BACnetNotificationParametersUnsignedRange
		if _child, err = new(_BACnetNotificationParametersUnsignedRange).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersUnsignedRange for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(13): // BACnetNotificationParametersAccessEvent
		if _child, err = new(_BACnetNotificationParametersAccessEvent).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersAccessEvent for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(14): // BACnetNotificationParametersDoubleOutOfRange
		if _child, err = new(_BACnetNotificationParametersDoubleOutOfRange).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersDoubleOutOfRange for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(15): // BACnetNotificationParametersSignedOutOfRange
		if _child, err = new(_BACnetNotificationParametersSignedOutOfRange).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersSignedOutOfRange for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(16): // BACnetNotificationParametersUnsignedOutOfRange
		if _child, err = new(_BACnetNotificationParametersUnsignedOutOfRange).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersUnsignedOutOfRange for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(17): // BACnetNotificationParametersChangeOfCharacterString
		if _child, err = new(_BACnetNotificationParametersChangeOfCharacterString).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersChangeOfCharacterString for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(18): // BACnetNotificationParametersChangeOfStatusFlags
		if _child, err = new(_BACnetNotificationParametersChangeOfStatusFlags).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersChangeOfStatusFlags for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(19): // BACnetNotificationParametersChangeOfReliability
		if _child, err = new(_BACnetNotificationParametersChangeOfReliability).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersChangeOfReliability for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(21): // BACnetNotificationParametersChangeOfDiscreteValue
		if _child, err = new(_BACnetNotificationParametersChangeOfDiscreteValue).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersChangeOfDiscreteValue for type-switch of BACnetNotificationParameters")
		}
	case peekedTagNumber == uint8(22): // BACnetNotificationParametersChangeOfTimer
		if _child, err = new(_BACnetNotificationParametersChangeOfTimer).parse(ctx, readBuffer, m, peekedTagNumber, tagNumber, objectTypeArgument); err != nil {
			return nil, errors.Wrap(err, "Error parsing sub-type BACnetNotificationParametersChangeOfTimer for type-switch of BACnetNotificationParameters")
		}
	default:
		return nil, errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v]", peekedTagNumber)
	}

	closingTag, err := ReadSimpleField[BACnetClosingTag](ctx, "closingTag", ReadComplex[BACnetClosingTag](BACnetClosingTagParseWithBufferProducer((uint8)(tagNumber)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'closingTag' field"))
	}
	m.ClosingTag = closingTag

	if closeErr := readBuffer.CloseContext("BACnetNotificationParameters"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetNotificationParameters")
	}

	return _child, nil
}

func (pm *_BACnetNotificationParameters) serializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child BACnetNotificationParameters, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetNotificationParameters"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetNotificationParameters")
	}

	if err := WriteSimpleField[BACnetOpeningTag](ctx, "openingTag", m.GetOpeningTag(), WriteComplex[BACnetOpeningTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'openingTag' field")
	}
	// Virtual field
	peekedTagNumber := m.GetPeekedTagNumber()
	_ = peekedTagNumber
	if _peekedTagNumberErr := writeBuffer.WriteVirtual(ctx, "peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if err := WriteSimpleField[BACnetClosingTag](ctx, "closingTag", m.GetClosingTag(), WriteComplex[BACnetClosingTag](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'closingTag' field")
	}

	if popErr := writeBuffer.PopContext("BACnetNotificationParameters"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetNotificationParameters")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetNotificationParameters) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetNotificationParameters) GetObjectTypeArgument() BACnetObjectType {
	return m.ObjectTypeArgument
}

//
////

func (m *_BACnetNotificationParameters) IsBACnetNotificationParameters() {}

func (m *_BACnetNotificationParameters) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetNotificationParameters) deepCopy() *_BACnetNotificationParameters {
	if m == nil {
		return nil
	}
	_BACnetNotificationParametersCopy := &_BACnetNotificationParameters{
		nil, // will be set by child
		utils.DeepCopy[BACnetOpeningTag](m.OpeningTag),
		utils.DeepCopy[BACnetTagHeader](m.PeekedTagHeader),
		utils.DeepCopy[BACnetClosingTag](m.ClosingTag),
		m.TagNumber,
		m.ObjectTypeArgument,
	}
	return _BACnetNotificationParametersCopy
}
