/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLiftGroupModeTagged is the corresponding interface of BACnetLiftGroupModeTagged
type BACnetLiftGroupModeTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetLiftGroupMode
	// IsBACnetLiftGroupModeTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLiftGroupModeTagged()
	// CreateBuilder creates a BACnetLiftGroupModeTaggedBuilder
	CreateBACnetLiftGroupModeTaggedBuilder() BACnetLiftGroupModeTaggedBuilder
}

// _BACnetLiftGroupModeTagged is the data-structure of this message
type _BACnetLiftGroupModeTagged struct {
	Header BACnetTagHeader
	Value  BACnetLiftGroupMode

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetLiftGroupModeTagged = (*_BACnetLiftGroupModeTagged)(nil)

// NewBACnetLiftGroupModeTagged factory function for _BACnetLiftGroupModeTagged
func NewBACnetLiftGroupModeTagged(header BACnetTagHeader, value BACnetLiftGroupMode, tagNumber uint8, tagClass TagClass) *_BACnetLiftGroupModeTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetLiftGroupModeTagged must not be nil")
	}
	return &_BACnetLiftGroupModeTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLiftGroupModeTaggedBuilder is a builder for BACnetLiftGroupModeTagged
type BACnetLiftGroupModeTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetLiftGroupMode) BACnetLiftGroupModeTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetLiftGroupModeTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLiftGroupModeTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetLiftGroupMode) BACnetLiftGroupModeTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetLiftGroupModeTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetLiftGroupModeTaggedBuilder
	// Build builds the BACnetLiftGroupModeTagged or returns an error if something is wrong
	Build() (BACnetLiftGroupModeTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLiftGroupModeTagged
}

// NewBACnetLiftGroupModeTaggedBuilder() creates a BACnetLiftGroupModeTaggedBuilder
func NewBACnetLiftGroupModeTaggedBuilder() BACnetLiftGroupModeTaggedBuilder {
	return &_BACnetLiftGroupModeTaggedBuilder{_BACnetLiftGroupModeTagged: new(_BACnetLiftGroupModeTagged)}
}

type _BACnetLiftGroupModeTaggedBuilder struct {
	*_BACnetLiftGroupModeTagged

	err *utils.MultiError
}

var _ (BACnetLiftGroupModeTaggedBuilder) = (*_BACnetLiftGroupModeTaggedBuilder)(nil)

func (b *_BACnetLiftGroupModeTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetLiftGroupMode) BACnetLiftGroupModeTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetLiftGroupModeTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetLiftGroupModeTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetLiftGroupModeTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetLiftGroupModeTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetLiftGroupModeTaggedBuilder) WithValue(value BACnetLiftGroupMode) BACnetLiftGroupModeTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetLiftGroupModeTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetLiftGroupModeTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetLiftGroupModeTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetLiftGroupModeTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetLiftGroupModeTaggedBuilder) Build() (BACnetLiftGroupModeTagged, error) {
	if b.Header == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'header' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetLiftGroupModeTagged.deepCopy(), nil
}

func (b *_BACnetLiftGroupModeTaggedBuilder) MustBuild() BACnetLiftGroupModeTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLiftGroupModeTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLiftGroupModeTaggedBuilder().(*_BACnetLiftGroupModeTaggedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetLiftGroupModeTaggedBuilder creates a BACnetLiftGroupModeTaggedBuilder
func (b *_BACnetLiftGroupModeTagged) CreateBACnetLiftGroupModeTaggedBuilder() BACnetLiftGroupModeTaggedBuilder {
	if b == nil {
		return NewBACnetLiftGroupModeTaggedBuilder()
	}
	return &_BACnetLiftGroupModeTaggedBuilder{_BACnetLiftGroupModeTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLiftGroupModeTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetLiftGroupModeTagged) GetValue() BACnetLiftGroupMode {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLiftGroupModeTagged(structType any) BACnetLiftGroupModeTagged {
	if casted, ok := structType.(BACnetLiftGroupModeTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLiftGroupModeTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLiftGroupModeTagged) GetTypeName() string {
	return "BACnetLiftGroupModeTagged"
}

func (m *_BACnetLiftGroupModeTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetLiftGroupModeTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetLiftGroupModeTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetLiftGroupModeTagged, error) {
	return BACnetLiftGroupModeTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetLiftGroupModeTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLiftGroupModeTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLiftGroupModeTagged, error) {
		return BACnetLiftGroupModeTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetLiftGroupModeTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetLiftGroupModeTagged, error) {
	v, err := (&_BACnetLiftGroupModeTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetLiftGroupModeTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetLiftGroupModeTagged BACnetLiftGroupModeTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLiftGroupModeTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLiftGroupModeTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetLiftGroupMode](ctx, "value", readBuffer, EnsureType[BACnetLiftGroupMode](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetLiftGroupMode_UNKNOWN)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetLiftGroupModeTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLiftGroupModeTagged")
	}

	return m, nil
}

func (m *_BACnetLiftGroupModeTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLiftGroupModeTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLiftGroupModeTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLiftGroupModeTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetLiftGroupMode](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetLiftGroupModeTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLiftGroupModeTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetLiftGroupModeTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetLiftGroupModeTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetLiftGroupModeTagged) IsBACnetLiftGroupModeTagged() {}

func (m *_BACnetLiftGroupModeTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLiftGroupModeTagged) deepCopy() *_BACnetLiftGroupModeTagged {
	if m == nil {
		return nil
	}
	_BACnetLiftGroupModeTaggedCopy := &_BACnetLiftGroupModeTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetLiftGroupModeTaggedCopy
}

func (m *_BACnetLiftGroupModeTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
