/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetLiftCarCallList is the corresponding interface of BACnetLiftCarCallList
type BACnetLiftCarCallList interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetFloorNumbers returns FloorNumbers (property field)
	GetFloorNumbers() BACnetLiftCarCallListFloorList
	// IsBACnetLiftCarCallList is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetLiftCarCallList()
	// CreateBuilder creates a BACnetLiftCarCallListBuilder
	CreateBACnetLiftCarCallListBuilder() BACnetLiftCarCallListBuilder
}

// _BACnetLiftCarCallList is the data-structure of this message
type _BACnetLiftCarCallList struct {
	FloorNumbers BACnetLiftCarCallListFloorList
}

var _ BACnetLiftCarCallList = (*_BACnetLiftCarCallList)(nil)

// NewBACnetLiftCarCallList factory function for _BACnetLiftCarCallList
func NewBACnetLiftCarCallList(floorNumbers BACnetLiftCarCallListFloorList) *_BACnetLiftCarCallList {
	if floorNumbers == nil {
		panic("floorNumbers of type BACnetLiftCarCallListFloorList for BACnetLiftCarCallList must not be nil")
	}
	return &_BACnetLiftCarCallList{FloorNumbers: floorNumbers}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetLiftCarCallListBuilder is a builder for BACnetLiftCarCallList
type BACnetLiftCarCallListBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(floorNumbers BACnetLiftCarCallListFloorList) BACnetLiftCarCallListBuilder
	// WithFloorNumbers adds FloorNumbers (property field)
	WithFloorNumbers(BACnetLiftCarCallListFloorList) BACnetLiftCarCallListBuilder
	// WithFloorNumbersBuilder adds FloorNumbers (property field) which is build by the builder
	WithFloorNumbersBuilder(func(BACnetLiftCarCallListFloorListBuilder) BACnetLiftCarCallListFloorListBuilder) BACnetLiftCarCallListBuilder
	// Build builds the BACnetLiftCarCallList or returns an error if something is wrong
	Build() (BACnetLiftCarCallList, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetLiftCarCallList
}

// NewBACnetLiftCarCallListBuilder() creates a BACnetLiftCarCallListBuilder
func NewBACnetLiftCarCallListBuilder() BACnetLiftCarCallListBuilder {
	return &_BACnetLiftCarCallListBuilder{_BACnetLiftCarCallList: new(_BACnetLiftCarCallList)}
}

type _BACnetLiftCarCallListBuilder struct {
	*_BACnetLiftCarCallList

	err *utils.MultiError
}

var _ (BACnetLiftCarCallListBuilder) = (*_BACnetLiftCarCallListBuilder)(nil)

func (b *_BACnetLiftCarCallListBuilder) WithMandatoryFields(floorNumbers BACnetLiftCarCallListFloorList) BACnetLiftCarCallListBuilder {
	return b.WithFloorNumbers(floorNumbers)
}

func (b *_BACnetLiftCarCallListBuilder) WithFloorNumbers(floorNumbers BACnetLiftCarCallListFloorList) BACnetLiftCarCallListBuilder {
	b.FloorNumbers = floorNumbers
	return b
}

func (b *_BACnetLiftCarCallListBuilder) WithFloorNumbersBuilder(builderSupplier func(BACnetLiftCarCallListFloorListBuilder) BACnetLiftCarCallListFloorListBuilder) BACnetLiftCarCallListBuilder {
	builder := builderSupplier(b.FloorNumbers.CreateBACnetLiftCarCallListFloorListBuilder())
	var err error
	b.FloorNumbers, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetLiftCarCallListFloorListBuilder failed"))
	}
	return b
}

func (b *_BACnetLiftCarCallListBuilder) Build() (BACnetLiftCarCallList, error) {
	if b.FloorNumbers == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'floorNumbers' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetLiftCarCallList.deepCopy(), nil
}

func (b *_BACnetLiftCarCallListBuilder) MustBuild() BACnetLiftCarCallList {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetLiftCarCallListBuilder) DeepCopy() any {
	_copy := b.CreateBACnetLiftCarCallListBuilder().(*_BACnetLiftCarCallListBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetLiftCarCallListBuilder creates a BACnetLiftCarCallListBuilder
func (b *_BACnetLiftCarCallList) CreateBACnetLiftCarCallListBuilder() BACnetLiftCarCallListBuilder {
	if b == nil {
		return NewBACnetLiftCarCallListBuilder()
	}
	return &_BACnetLiftCarCallListBuilder{_BACnetLiftCarCallList: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetLiftCarCallList) GetFloorNumbers() BACnetLiftCarCallListFloorList {
	return m.FloorNumbers
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetLiftCarCallList(structType any) BACnetLiftCarCallList {
	if casted, ok := structType.(BACnetLiftCarCallList); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetLiftCarCallList); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetLiftCarCallList) GetTypeName() string {
	return "BACnetLiftCarCallList"
}

func (m *_BACnetLiftCarCallList) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (floorNumbers)
	lengthInBits += m.FloorNumbers.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetLiftCarCallList) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetLiftCarCallListParse(ctx context.Context, theBytes []byte) (BACnetLiftCarCallList, error) {
	return BACnetLiftCarCallListParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetLiftCarCallListParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLiftCarCallList, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLiftCarCallList, error) {
		return BACnetLiftCarCallListParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetLiftCarCallListParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetLiftCarCallList, error) {
	v, err := (&_BACnetLiftCarCallList{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetLiftCarCallList) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetLiftCarCallList BACnetLiftCarCallList, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetLiftCarCallList"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetLiftCarCallList")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	floorNumbers, err := ReadSimpleField[BACnetLiftCarCallListFloorList](ctx, "floorNumbers", ReadComplex[BACnetLiftCarCallListFloorList](BACnetLiftCarCallListFloorListParseWithBufferProducer((uint8)(uint8(0))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'floorNumbers' field"))
	}
	m.FloorNumbers = floorNumbers

	if closeErr := readBuffer.CloseContext("BACnetLiftCarCallList"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetLiftCarCallList")
	}

	return m, nil
}

func (m *_BACnetLiftCarCallList) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetLiftCarCallList) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetLiftCarCallList"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetLiftCarCallList")
	}

	if err := WriteSimpleField[BACnetLiftCarCallListFloorList](ctx, "floorNumbers", m.GetFloorNumbers(), WriteComplex[BACnetLiftCarCallListFloorList](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'floorNumbers' field")
	}

	if popErr := writeBuffer.PopContext("BACnetLiftCarCallList"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetLiftCarCallList")
	}
	return nil
}

func (m *_BACnetLiftCarCallList) IsBACnetLiftCarCallList() {}

func (m *_BACnetLiftCarCallList) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetLiftCarCallList) deepCopy() *_BACnetLiftCarCallList {
	if m == nil {
		return nil
	}
	_BACnetLiftCarCallListCopy := &_BACnetLiftCarCallList{
		utils.DeepCopy[BACnetLiftCarCallListFloorList](m.FloorNumbers),
	}
	return _BACnetLiftCarCallListCopy
}

func (m *_BACnetLiftCarCallList) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
