/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetContextTagBitString is the corresponding interface of BACnetContextTagBitString
type BACnetContextTagBitString interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetContextTag
	// GetPayload returns Payload (property field)
	GetPayload() BACnetTagPayloadBitString
	// IsBACnetContextTagBitString is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetContextTagBitString()
	// CreateBuilder creates a BACnetContextTagBitStringBuilder
	CreateBACnetContextTagBitStringBuilder() BACnetContextTagBitStringBuilder
}

// _BACnetContextTagBitString is the data-structure of this message
type _BACnetContextTagBitString struct {
	BACnetContextTagContract
	Payload BACnetTagPayloadBitString
}

var _ BACnetContextTagBitString = (*_BACnetContextTagBitString)(nil)
var _ BACnetContextTagRequirements = (*_BACnetContextTagBitString)(nil)

// NewBACnetContextTagBitString factory function for _BACnetContextTagBitString
func NewBACnetContextTagBitString(header BACnetTagHeader, payload BACnetTagPayloadBitString, tagNumberArgument uint8) *_BACnetContextTagBitString {
	if payload == nil {
		panic("payload of type BACnetTagPayloadBitString for BACnetContextTagBitString must not be nil")
	}
	_result := &_BACnetContextTagBitString{
		BACnetContextTagContract: NewBACnetContextTag(header, tagNumberArgument),
		Payload:                  payload,
	}
	_result.BACnetContextTagContract.(*_BACnetContextTag)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetContextTagBitStringBuilder is a builder for BACnetContextTagBitString
type BACnetContextTagBitStringBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(payload BACnetTagPayloadBitString) BACnetContextTagBitStringBuilder
	// WithPayload adds Payload (property field)
	WithPayload(BACnetTagPayloadBitString) BACnetContextTagBitStringBuilder
	// WithPayloadBuilder adds Payload (property field) which is build by the builder
	WithPayloadBuilder(func(BACnetTagPayloadBitStringBuilder) BACnetTagPayloadBitStringBuilder) BACnetContextTagBitStringBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetContextTagBuilder
	// Build builds the BACnetContextTagBitString or returns an error if something is wrong
	Build() (BACnetContextTagBitString, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetContextTagBitString
}

// NewBACnetContextTagBitStringBuilder() creates a BACnetContextTagBitStringBuilder
func NewBACnetContextTagBitStringBuilder() BACnetContextTagBitStringBuilder {
	return &_BACnetContextTagBitStringBuilder{_BACnetContextTagBitString: new(_BACnetContextTagBitString)}
}

type _BACnetContextTagBitStringBuilder struct {
	*_BACnetContextTagBitString

	parentBuilder *_BACnetContextTagBuilder

	err *utils.MultiError
}

var _ (BACnetContextTagBitStringBuilder) = (*_BACnetContextTagBitStringBuilder)(nil)

func (b *_BACnetContextTagBitStringBuilder) setParent(contract BACnetContextTagContract) {
	b.BACnetContextTagContract = contract
	contract.(*_BACnetContextTag)._SubType = b._BACnetContextTagBitString
}

func (b *_BACnetContextTagBitStringBuilder) WithMandatoryFields(payload BACnetTagPayloadBitString) BACnetContextTagBitStringBuilder {
	return b.WithPayload(payload)
}

func (b *_BACnetContextTagBitStringBuilder) WithPayload(payload BACnetTagPayloadBitString) BACnetContextTagBitStringBuilder {
	b.Payload = payload
	return b
}

func (b *_BACnetContextTagBitStringBuilder) WithPayloadBuilder(builderSupplier func(BACnetTagPayloadBitStringBuilder) BACnetTagPayloadBitStringBuilder) BACnetContextTagBitStringBuilder {
	builder := builderSupplier(b.Payload.CreateBACnetTagPayloadBitStringBuilder())
	var err error
	b.Payload, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagPayloadBitStringBuilder failed"))
	}
	return b
}

func (b *_BACnetContextTagBitStringBuilder) Build() (BACnetContextTagBitString, error) {
	if b.Payload == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'payload' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetContextTagBitString.deepCopy(), nil
}

func (b *_BACnetContextTagBitStringBuilder) MustBuild() BACnetContextTagBitString {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetContextTagBitStringBuilder) Done() BACnetContextTagBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetContextTagBuilder().(*_BACnetContextTagBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetContextTagBitStringBuilder) buildForBACnetContextTag() (BACnetContextTag, error) {
	return b.Build()
}

func (b *_BACnetContextTagBitStringBuilder) DeepCopy() any {
	_copy := b.CreateBACnetContextTagBitStringBuilder().(*_BACnetContextTagBitStringBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetContextTagBitStringBuilder creates a BACnetContextTagBitStringBuilder
func (b *_BACnetContextTagBitString) CreateBACnetContextTagBitStringBuilder() BACnetContextTagBitStringBuilder {
	if b == nil {
		return NewBACnetContextTagBitStringBuilder()
	}
	return &_BACnetContextTagBitStringBuilder{_BACnetContextTagBitString: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetContextTagBitString) GetDataType() BACnetDataType {
	return BACnetDataType_BIT_STRING
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetContextTagBitString) GetParent() BACnetContextTagContract {
	return m.BACnetContextTagContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetContextTagBitString) GetPayload() BACnetTagPayloadBitString {
	return m.Payload
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetContextTagBitString(structType any) BACnetContextTagBitString {
	if casted, ok := structType.(BACnetContextTagBitString); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetContextTagBitString); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetContextTagBitString) GetTypeName() string {
	return "BACnetContextTagBitString"
}

func (m *_BACnetContextTagBitString) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetContextTagContract.(*_BACnetContextTag).getLengthInBits(ctx))

	// Simple field (payload)
	lengthInBits += m.Payload.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetContextTagBitString) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetContextTagBitString) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetContextTag, header BACnetTagHeader, tagNumberArgument uint8, dataType BACnetDataType) (__bACnetContextTagBitString BACnetContextTagBitString, err error) {
	m.BACnetContextTagContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetContextTagBitString"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetContextTagBitString")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	payload, err := ReadSimpleField[BACnetTagPayloadBitString](ctx, "payload", ReadComplex[BACnetTagPayloadBitString](BACnetTagPayloadBitStringParseWithBufferProducer((uint32)(header.GetActualLength())), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'payload' field"))
	}
	m.Payload = payload

	if closeErr := readBuffer.CloseContext("BACnetContextTagBitString"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetContextTagBitString")
	}

	return m, nil
}

func (m *_BACnetContextTagBitString) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetContextTagBitString) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetContextTagBitString"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetContextTagBitString")
		}

		if err := WriteSimpleField[BACnetTagPayloadBitString](ctx, "payload", m.GetPayload(), WriteComplex[BACnetTagPayloadBitString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'payload' field")
		}

		if popErr := writeBuffer.PopContext("BACnetContextTagBitString"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetContextTagBitString")
		}
		return nil
	}
	return m.BACnetContextTagContract.(*_BACnetContextTag).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetContextTagBitString) IsBACnetContextTagBitString() {}

func (m *_BACnetContextTagBitString) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetContextTagBitString) deepCopy() *_BACnetContextTagBitString {
	if m == nil {
		return nil
	}
	_BACnetContextTagBitStringCopy := &_BACnetContextTagBitString{
		m.BACnetContextTagContract.(*_BACnetContextTag).deepCopy(),
		utils.DeepCopy[BACnetTagPayloadBitString](m.Payload),
	}
	_BACnetContextTagBitStringCopy.BACnetContextTagContract.(*_BACnetContextTag)._SubType = m
	return _BACnetContextTagBitStringCopy
}

func (m *_BACnetContextTagBitString) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
