/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataZoneFrom is the corresponding interface of BACnetConstructedDataZoneFrom
type BACnetConstructedDataZoneFrom interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetZoneFrom returns ZoneFrom (property field)
	GetZoneFrom() BACnetDeviceObjectReference
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDeviceObjectReference
	// IsBACnetConstructedDataZoneFrom is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataZoneFrom()
	// CreateBuilder creates a BACnetConstructedDataZoneFromBuilder
	CreateBACnetConstructedDataZoneFromBuilder() BACnetConstructedDataZoneFromBuilder
}

// _BACnetConstructedDataZoneFrom is the data-structure of this message
type _BACnetConstructedDataZoneFrom struct {
	BACnetConstructedDataContract
	ZoneFrom BACnetDeviceObjectReference
}

var _ BACnetConstructedDataZoneFrom = (*_BACnetConstructedDataZoneFrom)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataZoneFrom)(nil)

// NewBACnetConstructedDataZoneFrom factory function for _BACnetConstructedDataZoneFrom
func NewBACnetConstructedDataZoneFrom(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, zoneFrom BACnetDeviceObjectReference, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataZoneFrom {
	if zoneFrom == nil {
		panic("zoneFrom of type BACnetDeviceObjectReference for BACnetConstructedDataZoneFrom must not be nil")
	}
	_result := &_BACnetConstructedDataZoneFrom{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ZoneFrom:                      zoneFrom,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataZoneFromBuilder is a builder for BACnetConstructedDataZoneFrom
type BACnetConstructedDataZoneFromBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(zoneFrom BACnetDeviceObjectReference) BACnetConstructedDataZoneFromBuilder
	// WithZoneFrom adds ZoneFrom (property field)
	WithZoneFrom(BACnetDeviceObjectReference) BACnetConstructedDataZoneFromBuilder
	// WithZoneFromBuilder adds ZoneFrom (property field) which is build by the builder
	WithZoneFromBuilder(func(BACnetDeviceObjectReferenceBuilder) BACnetDeviceObjectReferenceBuilder) BACnetConstructedDataZoneFromBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataZoneFrom or returns an error if something is wrong
	Build() (BACnetConstructedDataZoneFrom, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataZoneFrom
}

// NewBACnetConstructedDataZoneFromBuilder() creates a BACnetConstructedDataZoneFromBuilder
func NewBACnetConstructedDataZoneFromBuilder() BACnetConstructedDataZoneFromBuilder {
	return &_BACnetConstructedDataZoneFromBuilder{_BACnetConstructedDataZoneFrom: new(_BACnetConstructedDataZoneFrom)}
}

type _BACnetConstructedDataZoneFromBuilder struct {
	*_BACnetConstructedDataZoneFrom

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataZoneFromBuilder) = (*_BACnetConstructedDataZoneFromBuilder)(nil)

func (b *_BACnetConstructedDataZoneFromBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataZoneFrom
}

func (b *_BACnetConstructedDataZoneFromBuilder) WithMandatoryFields(zoneFrom BACnetDeviceObjectReference) BACnetConstructedDataZoneFromBuilder {
	return b.WithZoneFrom(zoneFrom)
}

func (b *_BACnetConstructedDataZoneFromBuilder) WithZoneFrom(zoneFrom BACnetDeviceObjectReference) BACnetConstructedDataZoneFromBuilder {
	b.ZoneFrom = zoneFrom
	return b
}

func (b *_BACnetConstructedDataZoneFromBuilder) WithZoneFromBuilder(builderSupplier func(BACnetDeviceObjectReferenceBuilder) BACnetDeviceObjectReferenceBuilder) BACnetConstructedDataZoneFromBuilder {
	builder := builderSupplier(b.ZoneFrom.CreateBACnetDeviceObjectReferenceBuilder())
	var err error
	b.ZoneFrom, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDeviceObjectReferenceBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataZoneFromBuilder) Build() (BACnetConstructedDataZoneFrom, error) {
	if b.ZoneFrom == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'zoneFrom' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataZoneFrom.deepCopy(), nil
}

func (b *_BACnetConstructedDataZoneFromBuilder) MustBuild() BACnetConstructedDataZoneFrom {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataZoneFromBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataZoneFromBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataZoneFromBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataZoneFromBuilder().(*_BACnetConstructedDataZoneFromBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataZoneFromBuilder creates a BACnetConstructedDataZoneFromBuilder
func (b *_BACnetConstructedDataZoneFrom) CreateBACnetConstructedDataZoneFromBuilder() BACnetConstructedDataZoneFromBuilder {
	if b == nil {
		return NewBACnetConstructedDataZoneFromBuilder()
	}
	return &_BACnetConstructedDataZoneFromBuilder{_BACnetConstructedDataZoneFrom: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataZoneFrom) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataZoneFrom) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ZONE_FROM
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataZoneFrom) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataZoneFrom) GetZoneFrom() BACnetDeviceObjectReference {
	return m.ZoneFrom
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataZoneFrom) GetActualValue() BACnetDeviceObjectReference {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDeviceObjectReference(m.GetZoneFrom())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataZoneFrom(structType any) BACnetConstructedDataZoneFrom {
	if casted, ok := structType.(BACnetConstructedDataZoneFrom); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataZoneFrom); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataZoneFrom) GetTypeName() string {
	return "BACnetConstructedDataZoneFrom"
}

func (m *_BACnetConstructedDataZoneFrom) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (zoneFrom)
	lengthInBits += m.ZoneFrom.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataZoneFrom) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataZoneFrom) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataZoneFrom BACnetConstructedDataZoneFrom, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataZoneFrom"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataZoneFrom")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zoneFrom, err := ReadSimpleField[BACnetDeviceObjectReference](ctx, "zoneFrom", ReadComplex[BACnetDeviceObjectReference](BACnetDeviceObjectReferenceParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zoneFrom' field"))
	}
	m.ZoneFrom = zoneFrom

	actualValue, err := ReadVirtualField[BACnetDeviceObjectReference](ctx, "actualValue", (*BACnetDeviceObjectReference)(nil), zoneFrom)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataZoneFrom"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataZoneFrom")
	}

	return m, nil
}

func (m *_BACnetConstructedDataZoneFrom) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataZoneFrom) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataZoneFrom"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataZoneFrom")
		}

		if err := WriteSimpleField[BACnetDeviceObjectReference](ctx, "zoneFrom", m.GetZoneFrom(), WriteComplex[BACnetDeviceObjectReference](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'zoneFrom' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataZoneFrom"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataZoneFrom")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataZoneFrom) IsBACnetConstructedDataZoneFrom() {}

func (m *_BACnetConstructedDataZoneFrom) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataZoneFrom) deepCopy() *_BACnetConstructedDataZoneFrom {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataZoneFromCopy := &_BACnetConstructedDataZoneFrom{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDeviceObjectReference](m.ZoneFrom),
	}
	_BACnetConstructedDataZoneFromCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataZoneFromCopy
}

func (m *_BACnetConstructedDataZoneFrom) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
