/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataUserName is the corresponding interface of BACnetConstructedDataUserName
type BACnetConstructedDataUserName interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetUserName returns UserName (property field)
	GetUserName() BACnetApplicationTagCharacterString
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagCharacterString
	// IsBACnetConstructedDataUserName is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataUserName()
	// CreateBuilder creates a BACnetConstructedDataUserNameBuilder
	CreateBACnetConstructedDataUserNameBuilder() BACnetConstructedDataUserNameBuilder
}

// _BACnetConstructedDataUserName is the data-structure of this message
type _BACnetConstructedDataUserName struct {
	BACnetConstructedDataContract
	UserName BACnetApplicationTagCharacterString
}

var _ BACnetConstructedDataUserName = (*_BACnetConstructedDataUserName)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataUserName)(nil)

// NewBACnetConstructedDataUserName factory function for _BACnetConstructedDataUserName
func NewBACnetConstructedDataUserName(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, userName BACnetApplicationTagCharacterString, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataUserName {
	if userName == nil {
		panic("userName of type BACnetApplicationTagCharacterString for BACnetConstructedDataUserName must not be nil")
	}
	_result := &_BACnetConstructedDataUserName{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		UserName:                      userName,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataUserNameBuilder is a builder for BACnetConstructedDataUserName
type BACnetConstructedDataUserNameBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(userName BACnetApplicationTagCharacterString) BACnetConstructedDataUserNameBuilder
	// WithUserName adds UserName (property field)
	WithUserName(BACnetApplicationTagCharacterString) BACnetConstructedDataUserNameBuilder
	// WithUserNameBuilder adds UserName (property field) which is build by the builder
	WithUserNameBuilder(func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetConstructedDataUserNameBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataUserName or returns an error if something is wrong
	Build() (BACnetConstructedDataUserName, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataUserName
}

// NewBACnetConstructedDataUserNameBuilder() creates a BACnetConstructedDataUserNameBuilder
func NewBACnetConstructedDataUserNameBuilder() BACnetConstructedDataUserNameBuilder {
	return &_BACnetConstructedDataUserNameBuilder{_BACnetConstructedDataUserName: new(_BACnetConstructedDataUserName)}
}

type _BACnetConstructedDataUserNameBuilder struct {
	*_BACnetConstructedDataUserName

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataUserNameBuilder) = (*_BACnetConstructedDataUserNameBuilder)(nil)

func (b *_BACnetConstructedDataUserNameBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataUserName
}

func (b *_BACnetConstructedDataUserNameBuilder) WithMandatoryFields(userName BACnetApplicationTagCharacterString) BACnetConstructedDataUserNameBuilder {
	return b.WithUserName(userName)
}

func (b *_BACnetConstructedDataUserNameBuilder) WithUserName(userName BACnetApplicationTagCharacterString) BACnetConstructedDataUserNameBuilder {
	b.UserName = userName
	return b
}

func (b *_BACnetConstructedDataUserNameBuilder) WithUserNameBuilder(builderSupplier func(BACnetApplicationTagCharacterStringBuilder) BACnetApplicationTagCharacterStringBuilder) BACnetConstructedDataUserNameBuilder {
	builder := builderSupplier(b.UserName.CreateBACnetApplicationTagCharacterStringBuilder())
	var err error
	b.UserName, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagCharacterStringBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataUserNameBuilder) Build() (BACnetConstructedDataUserName, error) {
	if b.UserName == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'userName' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataUserName.deepCopy(), nil
}

func (b *_BACnetConstructedDataUserNameBuilder) MustBuild() BACnetConstructedDataUserName {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataUserNameBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataUserNameBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataUserNameBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataUserNameBuilder().(*_BACnetConstructedDataUserNameBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataUserNameBuilder creates a BACnetConstructedDataUserNameBuilder
func (b *_BACnetConstructedDataUserName) CreateBACnetConstructedDataUserNameBuilder() BACnetConstructedDataUserNameBuilder {
	if b == nil {
		return NewBACnetConstructedDataUserNameBuilder()
	}
	return &_BACnetConstructedDataUserNameBuilder{_BACnetConstructedDataUserName: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataUserName) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataUserName) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_USER_NAME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataUserName) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataUserName) GetUserName() BACnetApplicationTagCharacterString {
	return m.UserName
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataUserName) GetActualValue() BACnetApplicationTagCharacterString {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagCharacterString(m.GetUserName())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataUserName(structType any) BACnetConstructedDataUserName {
	if casted, ok := structType.(BACnetConstructedDataUserName); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataUserName); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataUserName) GetTypeName() string {
	return "BACnetConstructedDataUserName"
}

func (m *_BACnetConstructedDataUserName) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (userName)
	lengthInBits += m.UserName.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataUserName) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataUserName) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataUserName BACnetConstructedDataUserName, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataUserName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataUserName")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	userName, err := ReadSimpleField[BACnetApplicationTagCharacterString](ctx, "userName", ReadComplex[BACnetApplicationTagCharacterString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagCharacterString](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'userName' field"))
	}
	m.UserName = userName

	actualValue, err := ReadVirtualField[BACnetApplicationTagCharacterString](ctx, "actualValue", (*BACnetApplicationTagCharacterString)(nil), userName)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataUserName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataUserName")
	}

	return m, nil
}

func (m *_BACnetConstructedDataUserName) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataUserName) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataUserName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataUserName")
		}

		if err := WriteSimpleField[BACnetApplicationTagCharacterString](ctx, "userName", m.GetUserName(), WriteComplex[BACnetApplicationTagCharacterString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'userName' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataUserName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataUserName")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataUserName) IsBACnetConstructedDataUserName() {}

func (m *_BACnetConstructedDataUserName) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataUserName) deepCopy() *_BACnetConstructedDataUserName {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataUserNameCopy := &_BACnetConstructedDataUserName{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagCharacterString](m.UserName),
	}
	_BACnetConstructedDataUserNameCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataUserNameCopy
}

func (m *_BACnetConstructedDataUserName) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
