/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataUTCOffset is the corresponding interface of BACnetConstructedDataUTCOffset
type BACnetConstructedDataUTCOffset interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetUtcOffset returns UtcOffset (property field)
	GetUtcOffset() BACnetApplicationTagSignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagSignedInteger
	// IsBACnetConstructedDataUTCOffset is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataUTCOffset()
	// CreateBuilder creates a BACnetConstructedDataUTCOffsetBuilder
	CreateBACnetConstructedDataUTCOffsetBuilder() BACnetConstructedDataUTCOffsetBuilder
}

// _BACnetConstructedDataUTCOffset is the data-structure of this message
type _BACnetConstructedDataUTCOffset struct {
	BACnetConstructedDataContract
	UtcOffset BACnetApplicationTagSignedInteger
}

var _ BACnetConstructedDataUTCOffset = (*_BACnetConstructedDataUTCOffset)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataUTCOffset)(nil)

// NewBACnetConstructedDataUTCOffset factory function for _BACnetConstructedDataUTCOffset
func NewBACnetConstructedDataUTCOffset(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, utcOffset BACnetApplicationTagSignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataUTCOffset {
	if utcOffset == nil {
		panic("utcOffset of type BACnetApplicationTagSignedInteger for BACnetConstructedDataUTCOffset must not be nil")
	}
	_result := &_BACnetConstructedDataUTCOffset{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		UtcOffset:                     utcOffset,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataUTCOffsetBuilder is a builder for BACnetConstructedDataUTCOffset
type BACnetConstructedDataUTCOffsetBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(utcOffset BACnetApplicationTagSignedInteger) BACnetConstructedDataUTCOffsetBuilder
	// WithUtcOffset adds UtcOffset (property field)
	WithUtcOffset(BACnetApplicationTagSignedInteger) BACnetConstructedDataUTCOffsetBuilder
	// WithUtcOffsetBuilder adds UtcOffset (property field) which is build by the builder
	WithUtcOffsetBuilder(func(BACnetApplicationTagSignedIntegerBuilder) BACnetApplicationTagSignedIntegerBuilder) BACnetConstructedDataUTCOffsetBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataUTCOffset or returns an error if something is wrong
	Build() (BACnetConstructedDataUTCOffset, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataUTCOffset
}

// NewBACnetConstructedDataUTCOffsetBuilder() creates a BACnetConstructedDataUTCOffsetBuilder
func NewBACnetConstructedDataUTCOffsetBuilder() BACnetConstructedDataUTCOffsetBuilder {
	return &_BACnetConstructedDataUTCOffsetBuilder{_BACnetConstructedDataUTCOffset: new(_BACnetConstructedDataUTCOffset)}
}

type _BACnetConstructedDataUTCOffsetBuilder struct {
	*_BACnetConstructedDataUTCOffset

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataUTCOffsetBuilder) = (*_BACnetConstructedDataUTCOffsetBuilder)(nil)

func (b *_BACnetConstructedDataUTCOffsetBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataUTCOffset
}

func (b *_BACnetConstructedDataUTCOffsetBuilder) WithMandatoryFields(utcOffset BACnetApplicationTagSignedInteger) BACnetConstructedDataUTCOffsetBuilder {
	return b.WithUtcOffset(utcOffset)
}

func (b *_BACnetConstructedDataUTCOffsetBuilder) WithUtcOffset(utcOffset BACnetApplicationTagSignedInteger) BACnetConstructedDataUTCOffsetBuilder {
	b.UtcOffset = utcOffset
	return b
}

func (b *_BACnetConstructedDataUTCOffsetBuilder) WithUtcOffsetBuilder(builderSupplier func(BACnetApplicationTagSignedIntegerBuilder) BACnetApplicationTagSignedIntegerBuilder) BACnetConstructedDataUTCOffsetBuilder {
	builder := builderSupplier(b.UtcOffset.CreateBACnetApplicationTagSignedIntegerBuilder())
	var err error
	b.UtcOffset, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagSignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataUTCOffsetBuilder) Build() (BACnetConstructedDataUTCOffset, error) {
	if b.UtcOffset == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'utcOffset' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataUTCOffset.deepCopy(), nil
}

func (b *_BACnetConstructedDataUTCOffsetBuilder) MustBuild() BACnetConstructedDataUTCOffset {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataUTCOffsetBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataUTCOffsetBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataUTCOffsetBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataUTCOffsetBuilder().(*_BACnetConstructedDataUTCOffsetBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataUTCOffsetBuilder creates a BACnetConstructedDataUTCOffsetBuilder
func (b *_BACnetConstructedDataUTCOffset) CreateBACnetConstructedDataUTCOffsetBuilder() BACnetConstructedDataUTCOffsetBuilder {
	if b == nil {
		return NewBACnetConstructedDataUTCOffsetBuilder()
	}
	return &_BACnetConstructedDataUTCOffsetBuilder{_BACnetConstructedDataUTCOffset: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataUTCOffset) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataUTCOffset) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_UTC_OFFSET
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataUTCOffset) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataUTCOffset) GetUtcOffset() BACnetApplicationTagSignedInteger {
	return m.UtcOffset
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataUTCOffset) GetActualValue() BACnetApplicationTagSignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagSignedInteger(m.GetUtcOffset())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataUTCOffset(structType any) BACnetConstructedDataUTCOffset {
	if casted, ok := structType.(BACnetConstructedDataUTCOffset); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataUTCOffset); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataUTCOffset) GetTypeName() string {
	return "BACnetConstructedDataUTCOffset"
}

func (m *_BACnetConstructedDataUTCOffset) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (utcOffset)
	lengthInBits += m.UtcOffset.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataUTCOffset) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataUTCOffset) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataUTCOffset BACnetConstructedDataUTCOffset, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataUTCOffset"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataUTCOffset")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	utcOffset, err := ReadSimpleField[BACnetApplicationTagSignedInteger](ctx, "utcOffset", ReadComplex[BACnetApplicationTagSignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagSignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'utcOffset' field"))
	}
	m.UtcOffset = utcOffset

	actualValue, err := ReadVirtualField[BACnetApplicationTagSignedInteger](ctx, "actualValue", (*BACnetApplicationTagSignedInteger)(nil), utcOffset)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataUTCOffset"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataUTCOffset")
	}

	return m, nil
}

func (m *_BACnetConstructedDataUTCOffset) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataUTCOffset) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataUTCOffset"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataUTCOffset")
		}

		if err := WriteSimpleField[BACnetApplicationTagSignedInteger](ctx, "utcOffset", m.GetUtcOffset(), WriteComplex[BACnetApplicationTagSignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'utcOffset' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataUTCOffset"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataUTCOffset")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataUTCOffset) IsBACnetConstructedDataUTCOffset() {}

func (m *_BACnetConstructedDataUTCOffset) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataUTCOffset) deepCopy() *_BACnetConstructedDataUTCOffset {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataUTCOffsetCopy := &_BACnetConstructedDataUTCOffset{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagSignedInteger](m.UtcOffset),
	}
	_BACnetConstructedDataUTCOffsetCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataUTCOffsetCopy
}

func (m *_BACnetConstructedDataUTCOffset) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
