/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataTrendLogAll is the corresponding interface of BACnetConstructedDataTrendLogAll
type BACnetConstructedDataTrendLogAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataTrendLogAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataTrendLogAll()
	// CreateBuilder creates a BACnetConstructedDataTrendLogAllBuilder
	CreateBACnetConstructedDataTrendLogAllBuilder() BACnetConstructedDataTrendLogAllBuilder
}

// _BACnetConstructedDataTrendLogAll is the data-structure of this message
type _BACnetConstructedDataTrendLogAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataTrendLogAll = (*_BACnetConstructedDataTrendLogAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataTrendLogAll)(nil)

// NewBACnetConstructedDataTrendLogAll factory function for _BACnetConstructedDataTrendLogAll
func NewBACnetConstructedDataTrendLogAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataTrendLogAll {
	_result := &_BACnetConstructedDataTrendLogAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataTrendLogAllBuilder is a builder for BACnetConstructedDataTrendLogAll
type BACnetConstructedDataTrendLogAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataTrendLogAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataTrendLogAll or returns an error if something is wrong
	Build() (BACnetConstructedDataTrendLogAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataTrendLogAll
}

// NewBACnetConstructedDataTrendLogAllBuilder() creates a BACnetConstructedDataTrendLogAllBuilder
func NewBACnetConstructedDataTrendLogAllBuilder() BACnetConstructedDataTrendLogAllBuilder {
	return &_BACnetConstructedDataTrendLogAllBuilder{_BACnetConstructedDataTrendLogAll: new(_BACnetConstructedDataTrendLogAll)}
}

type _BACnetConstructedDataTrendLogAllBuilder struct {
	*_BACnetConstructedDataTrendLogAll

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataTrendLogAllBuilder) = (*_BACnetConstructedDataTrendLogAllBuilder)(nil)

func (b *_BACnetConstructedDataTrendLogAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataTrendLogAll
}

func (b *_BACnetConstructedDataTrendLogAllBuilder) WithMandatoryFields() BACnetConstructedDataTrendLogAllBuilder {
	return b
}

func (b *_BACnetConstructedDataTrendLogAllBuilder) Build() (BACnetConstructedDataTrendLogAll, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataTrendLogAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataTrendLogAllBuilder) MustBuild() BACnetConstructedDataTrendLogAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataTrendLogAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataTrendLogAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataTrendLogAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataTrendLogAllBuilder().(*_BACnetConstructedDataTrendLogAllBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataTrendLogAllBuilder creates a BACnetConstructedDataTrendLogAllBuilder
func (b *_BACnetConstructedDataTrendLogAll) CreateBACnetConstructedDataTrendLogAllBuilder() BACnetConstructedDataTrendLogAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataTrendLogAllBuilder()
	}
	return &_BACnetConstructedDataTrendLogAllBuilder{_BACnetConstructedDataTrendLogAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataTrendLogAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_TREND_LOG
}

func (m *_BACnetConstructedDataTrendLogAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataTrendLogAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataTrendLogAll(structType any) BACnetConstructedDataTrendLogAll {
	if casted, ok := structType.(BACnetConstructedDataTrendLogAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataTrendLogAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataTrendLogAll) GetTypeName() string {
	return "BACnetConstructedDataTrendLogAll"
}

func (m *_BACnetConstructedDataTrendLogAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataTrendLogAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataTrendLogAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataTrendLogAll BACnetConstructedDataTrendLogAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataTrendLogAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataTrendLogAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataTrendLogAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataTrendLogAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataTrendLogAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataTrendLogAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataTrendLogAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataTrendLogAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataTrendLogAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataTrendLogAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataTrendLogAll) IsBACnetConstructedDataTrendLogAll() {}

func (m *_BACnetConstructedDataTrendLogAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataTrendLogAll) deepCopy() *_BACnetConstructedDataTrendLogAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataTrendLogAllCopy := &_BACnetConstructedDataTrendLogAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataTrendLogAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataTrendLogAllCopy
}

func (m *_BACnetConstructedDataTrendLogAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
