/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataSetting is the corresponding interface of BACnetConstructedDataSetting
type BACnetConstructedDataSetting interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetSetting returns Setting (property field)
	GetSetting() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataSetting is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataSetting()
	// CreateBuilder creates a BACnetConstructedDataSettingBuilder
	CreateBACnetConstructedDataSettingBuilder() BACnetConstructedDataSettingBuilder
}

// _BACnetConstructedDataSetting is the data-structure of this message
type _BACnetConstructedDataSetting struct {
	BACnetConstructedDataContract
	Setting BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataSetting = (*_BACnetConstructedDataSetting)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataSetting)(nil)

// NewBACnetConstructedDataSetting factory function for _BACnetConstructedDataSetting
func NewBACnetConstructedDataSetting(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, setting BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataSetting {
	if setting == nil {
		panic("setting of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataSetting must not be nil")
	}
	_result := &_BACnetConstructedDataSetting{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		Setting:                       setting,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataSettingBuilder is a builder for BACnetConstructedDataSetting
type BACnetConstructedDataSettingBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(setting BACnetApplicationTagUnsignedInteger) BACnetConstructedDataSettingBuilder
	// WithSetting adds Setting (property field)
	WithSetting(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataSettingBuilder
	// WithSettingBuilder adds Setting (property field) which is build by the builder
	WithSettingBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataSettingBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataSetting or returns an error if something is wrong
	Build() (BACnetConstructedDataSetting, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataSetting
}

// NewBACnetConstructedDataSettingBuilder() creates a BACnetConstructedDataSettingBuilder
func NewBACnetConstructedDataSettingBuilder() BACnetConstructedDataSettingBuilder {
	return &_BACnetConstructedDataSettingBuilder{_BACnetConstructedDataSetting: new(_BACnetConstructedDataSetting)}
}

type _BACnetConstructedDataSettingBuilder struct {
	*_BACnetConstructedDataSetting

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataSettingBuilder) = (*_BACnetConstructedDataSettingBuilder)(nil)

func (b *_BACnetConstructedDataSettingBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataSetting
}

func (b *_BACnetConstructedDataSettingBuilder) WithMandatoryFields(setting BACnetApplicationTagUnsignedInteger) BACnetConstructedDataSettingBuilder {
	return b.WithSetting(setting)
}

func (b *_BACnetConstructedDataSettingBuilder) WithSetting(setting BACnetApplicationTagUnsignedInteger) BACnetConstructedDataSettingBuilder {
	b.Setting = setting
	return b
}

func (b *_BACnetConstructedDataSettingBuilder) WithSettingBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataSettingBuilder {
	builder := builderSupplier(b.Setting.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.Setting, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataSettingBuilder) Build() (BACnetConstructedDataSetting, error) {
	if b.Setting == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'setting' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataSetting.deepCopy(), nil
}

func (b *_BACnetConstructedDataSettingBuilder) MustBuild() BACnetConstructedDataSetting {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataSettingBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataSettingBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataSettingBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataSettingBuilder().(*_BACnetConstructedDataSettingBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataSettingBuilder creates a BACnetConstructedDataSettingBuilder
func (b *_BACnetConstructedDataSetting) CreateBACnetConstructedDataSettingBuilder() BACnetConstructedDataSettingBuilder {
	if b == nil {
		return NewBACnetConstructedDataSettingBuilder()
	}
	return &_BACnetConstructedDataSettingBuilder{_BACnetConstructedDataSetting: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataSetting) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataSetting) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_SETTING
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataSetting) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataSetting) GetSetting() BACnetApplicationTagUnsignedInteger {
	return m.Setting
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataSetting) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetSetting())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataSetting(structType any) BACnetConstructedDataSetting {
	if casted, ok := structType.(BACnetConstructedDataSetting); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataSetting); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataSetting) GetTypeName() string {
	return "BACnetConstructedDataSetting"
}

func (m *_BACnetConstructedDataSetting) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (setting)
	lengthInBits += m.Setting.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataSetting) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataSetting) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataSetting BACnetConstructedDataSetting, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataSetting"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataSetting")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	setting, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "setting", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'setting' field"))
	}
	m.Setting = setting

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), setting)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataSetting"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataSetting")
	}

	return m, nil
}

func (m *_BACnetConstructedDataSetting) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataSetting) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataSetting"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataSetting")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "setting", m.GetSetting(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'setting' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataSetting"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataSetting")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataSetting) IsBACnetConstructedDataSetting() {}

func (m *_BACnetConstructedDataSetting) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataSetting) deepCopy() *_BACnetConstructedDataSetting {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataSettingCopy := &_BACnetConstructedDataSetting{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.Setting),
	}
	_BACnetConstructedDataSettingCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataSettingCopy
}

func (m *_BACnetConstructedDataSetting) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
