/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataProgramState is the corresponding interface of BACnetConstructedDataProgramState
type BACnetConstructedDataProgramState interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetProgramState returns ProgramState (property field)
	GetProgramState() BACnetProgramStateTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetProgramStateTagged
	// IsBACnetConstructedDataProgramState is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataProgramState()
	// CreateBuilder creates a BACnetConstructedDataProgramStateBuilder
	CreateBACnetConstructedDataProgramStateBuilder() BACnetConstructedDataProgramStateBuilder
}

// _BACnetConstructedDataProgramState is the data-structure of this message
type _BACnetConstructedDataProgramState struct {
	BACnetConstructedDataContract
	ProgramState BACnetProgramStateTagged
}

var _ BACnetConstructedDataProgramState = (*_BACnetConstructedDataProgramState)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataProgramState)(nil)

// NewBACnetConstructedDataProgramState factory function for _BACnetConstructedDataProgramState
func NewBACnetConstructedDataProgramState(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, programState BACnetProgramStateTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataProgramState {
	if programState == nil {
		panic("programState of type BACnetProgramStateTagged for BACnetConstructedDataProgramState must not be nil")
	}
	_result := &_BACnetConstructedDataProgramState{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ProgramState:                  programState,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataProgramStateBuilder is a builder for BACnetConstructedDataProgramState
type BACnetConstructedDataProgramStateBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(programState BACnetProgramStateTagged) BACnetConstructedDataProgramStateBuilder
	// WithProgramState adds ProgramState (property field)
	WithProgramState(BACnetProgramStateTagged) BACnetConstructedDataProgramStateBuilder
	// WithProgramStateBuilder adds ProgramState (property field) which is build by the builder
	WithProgramStateBuilder(func(BACnetProgramStateTaggedBuilder) BACnetProgramStateTaggedBuilder) BACnetConstructedDataProgramStateBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataProgramState or returns an error if something is wrong
	Build() (BACnetConstructedDataProgramState, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataProgramState
}

// NewBACnetConstructedDataProgramStateBuilder() creates a BACnetConstructedDataProgramStateBuilder
func NewBACnetConstructedDataProgramStateBuilder() BACnetConstructedDataProgramStateBuilder {
	return &_BACnetConstructedDataProgramStateBuilder{_BACnetConstructedDataProgramState: new(_BACnetConstructedDataProgramState)}
}

type _BACnetConstructedDataProgramStateBuilder struct {
	*_BACnetConstructedDataProgramState

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataProgramStateBuilder) = (*_BACnetConstructedDataProgramStateBuilder)(nil)

func (b *_BACnetConstructedDataProgramStateBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataProgramState
}

func (b *_BACnetConstructedDataProgramStateBuilder) WithMandatoryFields(programState BACnetProgramStateTagged) BACnetConstructedDataProgramStateBuilder {
	return b.WithProgramState(programState)
}

func (b *_BACnetConstructedDataProgramStateBuilder) WithProgramState(programState BACnetProgramStateTagged) BACnetConstructedDataProgramStateBuilder {
	b.ProgramState = programState
	return b
}

func (b *_BACnetConstructedDataProgramStateBuilder) WithProgramStateBuilder(builderSupplier func(BACnetProgramStateTaggedBuilder) BACnetProgramStateTaggedBuilder) BACnetConstructedDataProgramStateBuilder {
	builder := builderSupplier(b.ProgramState.CreateBACnetProgramStateTaggedBuilder())
	var err error
	b.ProgramState, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetProgramStateTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataProgramStateBuilder) Build() (BACnetConstructedDataProgramState, error) {
	if b.ProgramState == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'programState' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataProgramState.deepCopy(), nil
}

func (b *_BACnetConstructedDataProgramStateBuilder) MustBuild() BACnetConstructedDataProgramState {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataProgramStateBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataProgramStateBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataProgramStateBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataProgramStateBuilder().(*_BACnetConstructedDataProgramStateBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataProgramStateBuilder creates a BACnetConstructedDataProgramStateBuilder
func (b *_BACnetConstructedDataProgramState) CreateBACnetConstructedDataProgramStateBuilder() BACnetConstructedDataProgramStateBuilder {
	if b == nil {
		return NewBACnetConstructedDataProgramStateBuilder()
	}
	return &_BACnetConstructedDataProgramStateBuilder{_BACnetConstructedDataProgramState: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataProgramState) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataProgramState) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_PROGRAM_STATE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataProgramState) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataProgramState) GetProgramState() BACnetProgramStateTagged {
	return m.ProgramState
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataProgramState) GetActualValue() BACnetProgramStateTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetProgramStateTagged(m.GetProgramState())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataProgramState(structType any) BACnetConstructedDataProgramState {
	if casted, ok := structType.(BACnetConstructedDataProgramState); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataProgramState); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataProgramState) GetTypeName() string {
	return "BACnetConstructedDataProgramState"
}

func (m *_BACnetConstructedDataProgramState) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (programState)
	lengthInBits += m.ProgramState.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataProgramState) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataProgramState) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataProgramState BACnetConstructedDataProgramState, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataProgramState"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataProgramState")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	programState, err := ReadSimpleField[BACnetProgramStateTagged](ctx, "programState", ReadComplex[BACnetProgramStateTagged](BACnetProgramStateTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'programState' field"))
	}
	m.ProgramState = programState

	actualValue, err := ReadVirtualField[BACnetProgramStateTagged](ctx, "actualValue", (*BACnetProgramStateTagged)(nil), programState)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataProgramState"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataProgramState")
	}

	return m, nil
}

func (m *_BACnetConstructedDataProgramState) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataProgramState) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataProgramState"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataProgramState")
		}

		if err := WriteSimpleField[BACnetProgramStateTagged](ctx, "programState", m.GetProgramState(), WriteComplex[BACnetProgramStateTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'programState' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataProgramState"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataProgramState")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataProgramState) IsBACnetConstructedDataProgramState() {}

func (m *_BACnetConstructedDataProgramState) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataProgramState) deepCopy() *_BACnetConstructedDataProgramState {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataProgramStateCopy := &_BACnetConstructedDataProgramState{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetProgramStateTagged](m.ProgramState),
	}
	_BACnetConstructedDataProgramStateCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataProgramStateCopy
}

func (m *_BACnetConstructedDataProgramState) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
