/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataPrescale is the corresponding interface of BACnetConstructedDataPrescale
type BACnetConstructedDataPrescale interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetPrescale returns Prescale (property field)
	GetPrescale() BACnetPrescale
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetPrescale
	// IsBACnetConstructedDataPrescale is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataPrescale()
	// CreateBuilder creates a BACnetConstructedDataPrescaleBuilder
	CreateBACnetConstructedDataPrescaleBuilder() BACnetConstructedDataPrescaleBuilder
}

// _BACnetConstructedDataPrescale is the data-structure of this message
type _BACnetConstructedDataPrescale struct {
	BACnetConstructedDataContract
	Prescale BACnetPrescale
}

var _ BACnetConstructedDataPrescale = (*_BACnetConstructedDataPrescale)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataPrescale)(nil)

// NewBACnetConstructedDataPrescale factory function for _BACnetConstructedDataPrescale
func NewBACnetConstructedDataPrescale(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, prescale BACnetPrescale, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataPrescale {
	if prescale == nil {
		panic("prescale of type BACnetPrescale for BACnetConstructedDataPrescale must not be nil")
	}
	_result := &_BACnetConstructedDataPrescale{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		Prescale:                      prescale,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataPrescaleBuilder is a builder for BACnetConstructedDataPrescale
type BACnetConstructedDataPrescaleBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(prescale BACnetPrescale) BACnetConstructedDataPrescaleBuilder
	// WithPrescale adds Prescale (property field)
	WithPrescale(BACnetPrescale) BACnetConstructedDataPrescaleBuilder
	// WithPrescaleBuilder adds Prescale (property field) which is build by the builder
	WithPrescaleBuilder(func(BACnetPrescaleBuilder) BACnetPrescaleBuilder) BACnetConstructedDataPrescaleBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataPrescale or returns an error if something is wrong
	Build() (BACnetConstructedDataPrescale, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataPrescale
}

// NewBACnetConstructedDataPrescaleBuilder() creates a BACnetConstructedDataPrescaleBuilder
func NewBACnetConstructedDataPrescaleBuilder() BACnetConstructedDataPrescaleBuilder {
	return &_BACnetConstructedDataPrescaleBuilder{_BACnetConstructedDataPrescale: new(_BACnetConstructedDataPrescale)}
}

type _BACnetConstructedDataPrescaleBuilder struct {
	*_BACnetConstructedDataPrescale

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataPrescaleBuilder) = (*_BACnetConstructedDataPrescaleBuilder)(nil)

func (b *_BACnetConstructedDataPrescaleBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataPrescale
}

func (b *_BACnetConstructedDataPrescaleBuilder) WithMandatoryFields(prescale BACnetPrescale) BACnetConstructedDataPrescaleBuilder {
	return b.WithPrescale(prescale)
}

func (b *_BACnetConstructedDataPrescaleBuilder) WithPrescale(prescale BACnetPrescale) BACnetConstructedDataPrescaleBuilder {
	b.Prescale = prescale
	return b
}

func (b *_BACnetConstructedDataPrescaleBuilder) WithPrescaleBuilder(builderSupplier func(BACnetPrescaleBuilder) BACnetPrescaleBuilder) BACnetConstructedDataPrescaleBuilder {
	builder := builderSupplier(b.Prescale.CreateBACnetPrescaleBuilder())
	var err error
	b.Prescale, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetPrescaleBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataPrescaleBuilder) Build() (BACnetConstructedDataPrescale, error) {
	if b.Prescale == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'prescale' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataPrescale.deepCopy(), nil
}

func (b *_BACnetConstructedDataPrescaleBuilder) MustBuild() BACnetConstructedDataPrescale {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataPrescaleBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataPrescaleBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataPrescaleBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataPrescaleBuilder().(*_BACnetConstructedDataPrescaleBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataPrescaleBuilder creates a BACnetConstructedDataPrescaleBuilder
func (b *_BACnetConstructedDataPrescale) CreateBACnetConstructedDataPrescaleBuilder() BACnetConstructedDataPrescaleBuilder {
	if b == nil {
		return NewBACnetConstructedDataPrescaleBuilder()
	}
	return &_BACnetConstructedDataPrescaleBuilder{_BACnetConstructedDataPrescale: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataPrescale) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataPrescale) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_PRESCALE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataPrescale) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataPrescale) GetPrescale() BACnetPrescale {
	return m.Prescale
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataPrescale) GetActualValue() BACnetPrescale {
	ctx := context.Background()
	_ = ctx
	return CastBACnetPrescale(m.GetPrescale())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataPrescale(structType any) BACnetConstructedDataPrescale {
	if casted, ok := structType.(BACnetConstructedDataPrescale); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataPrescale); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataPrescale) GetTypeName() string {
	return "BACnetConstructedDataPrescale"
}

func (m *_BACnetConstructedDataPrescale) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (prescale)
	lengthInBits += m.Prescale.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataPrescale) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataPrescale) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataPrescale BACnetConstructedDataPrescale, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataPrescale"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataPrescale")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	prescale, err := ReadSimpleField[BACnetPrescale](ctx, "prescale", ReadComplex[BACnetPrescale](BACnetPrescaleParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'prescale' field"))
	}
	m.Prescale = prescale

	actualValue, err := ReadVirtualField[BACnetPrescale](ctx, "actualValue", (*BACnetPrescale)(nil), prescale)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataPrescale"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataPrescale")
	}

	return m, nil
}

func (m *_BACnetConstructedDataPrescale) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataPrescale) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataPrescale"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataPrescale")
		}

		if err := WriteSimpleField[BACnetPrescale](ctx, "prescale", m.GetPrescale(), WriteComplex[BACnetPrescale](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'prescale' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataPrescale"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataPrescale")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataPrescale) IsBACnetConstructedDataPrescale() {}

func (m *_BACnetConstructedDataPrescale) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataPrescale) deepCopy() *_BACnetConstructedDataPrescale {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataPrescaleCopy := &_BACnetConstructedDataPrescale{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetPrescale](m.Prescale),
	}
	_BACnetConstructedDataPrescaleCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataPrescaleCopy
}

func (m *_BACnetConstructedDataPrescale) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
