/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataPositiveAccessRules is the corresponding interface of BACnetConstructedDataPositiveAccessRules
type BACnetConstructedDataPositiveAccessRules interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetNumberOfDataElements returns NumberOfDataElements (property field)
	GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger
	// GetPositiveAccessRules returns PositiveAccessRules (property field)
	GetPositiveAccessRules() []BACnetAccessRule
	// GetZero returns Zero (virtual field)
	GetZero() uint64
	// IsBACnetConstructedDataPositiveAccessRules is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataPositiveAccessRules()
	// CreateBuilder creates a BACnetConstructedDataPositiveAccessRulesBuilder
	CreateBACnetConstructedDataPositiveAccessRulesBuilder() BACnetConstructedDataPositiveAccessRulesBuilder
}

// _BACnetConstructedDataPositiveAccessRules is the data-structure of this message
type _BACnetConstructedDataPositiveAccessRules struct {
	BACnetConstructedDataContract
	NumberOfDataElements BACnetApplicationTagUnsignedInteger
	PositiveAccessRules  []BACnetAccessRule
}

var _ BACnetConstructedDataPositiveAccessRules = (*_BACnetConstructedDataPositiveAccessRules)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataPositiveAccessRules)(nil)

// NewBACnetConstructedDataPositiveAccessRules factory function for _BACnetConstructedDataPositiveAccessRules
func NewBACnetConstructedDataPositiveAccessRules(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, numberOfDataElements BACnetApplicationTagUnsignedInteger, positiveAccessRules []BACnetAccessRule, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataPositiveAccessRules {
	_result := &_BACnetConstructedDataPositiveAccessRules{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		NumberOfDataElements:          numberOfDataElements,
		PositiveAccessRules:           positiveAccessRules,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataPositiveAccessRulesBuilder is a builder for BACnetConstructedDataPositiveAccessRules
type BACnetConstructedDataPositiveAccessRulesBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(positiveAccessRules []BACnetAccessRule) BACnetConstructedDataPositiveAccessRulesBuilder
	// WithNumberOfDataElements adds NumberOfDataElements (property field)
	WithOptionalNumberOfDataElements(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataPositiveAccessRulesBuilder
	// WithOptionalNumberOfDataElementsBuilder adds NumberOfDataElements (property field) which is build by the builder
	WithOptionalNumberOfDataElementsBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataPositiveAccessRulesBuilder
	// WithPositiveAccessRules adds PositiveAccessRules (property field)
	WithPositiveAccessRules(...BACnetAccessRule) BACnetConstructedDataPositiveAccessRulesBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataPositiveAccessRules or returns an error if something is wrong
	Build() (BACnetConstructedDataPositiveAccessRules, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataPositiveAccessRules
}

// NewBACnetConstructedDataPositiveAccessRulesBuilder() creates a BACnetConstructedDataPositiveAccessRulesBuilder
func NewBACnetConstructedDataPositiveAccessRulesBuilder() BACnetConstructedDataPositiveAccessRulesBuilder {
	return &_BACnetConstructedDataPositiveAccessRulesBuilder{_BACnetConstructedDataPositiveAccessRules: new(_BACnetConstructedDataPositiveAccessRules)}
}

type _BACnetConstructedDataPositiveAccessRulesBuilder struct {
	*_BACnetConstructedDataPositiveAccessRules

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataPositiveAccessRulesBuilder) = (*_BACnetConstructedDataPositiveAccessRulesBuilder)(nil)

func (b *_BACnetConstructedDataPositiveAccessRulesBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataPositiveAccessRules
}

func (b *_BACnetConstructedDataPositiveAccessRulesBuilder) WithMandatoryFields(positiveAccessRules []BACnetAccessRule) BACnetConstructedDataPositiveAccessRulesBuilder {
	return b.WithPositiveAccessRules(positiveAccessRules...)
}

func (b *_BACnetConstructedDataPositiveAccessRulesBuilder) WithOptionalNumberOfDataElements(numberOfDataElements BACnetApplicationTagUnsignedInteger) BACnetConstructedDataPositiveAccessRulesBuilder {
	b.NumberOfDataElements = numberOfDataElements
	return b
}

func (b *_BACnetConstructedDataPositiveAccessRulesBuilder) WithOptionalNumberOfDataElementsBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataPositiveAccessRulesBuilder {
	builder := builderSupplier(b.NumberOfDataElements.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.NumberOfDataElements, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataPositiveAccessRulesBuilder) WithPositiveAccessRules(positiveAccessRules ...BACnetAccessRule) BACnetConstructedDataPositiveAccessRulesBuilder {
	b.PositiveAccessRules = positiveAccessRules
	return b
}

func (b *_BACnetConstructedDataPositiveAccessRulesBuilder) Build() (BACnetConstructedDataPositiveAccessRules, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataPositiveAccessRules.deepCopy(), nil
}

func (b *_BACnetConstructedDataPositiveAccessRulesBuilder) MustBuild() BACnetConstructedDataPositiveAccessRules {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataPositiveAccessRulesBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataPositiveAccessRulesBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataPositiveAccessRulesBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataPositiveAccessRulesBuilder().(*_BACnetConstructedDataPositiveAccessRulesBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataPositiveAccessRulesBuilder creates a BACnetConstructedDataPositiveAccessRulesBuilder
func (b *_BACnetConstructedDataPositiveAccessRules) CreateBACnetConstructedDataPositiveAccessRulesBuilder() BACnetConstructedDataPositiveAccessRulesBuilder {
	if b == nil {
		return NewBACnetConstructedDataPositiveAccessRulesBuilder()
	}
	return &_BACnetConstructedDataPositiveAccessRulesBuilder{_BACnetConstructedDataPositiveAccessRules: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataPositiveAccessRules) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataPositiveAccessRules) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_POSITIVE_ACCESS_RULES
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataPositiveAccessRules) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataPositiveAccessRules) GetNumberOfDataElements() BACnetApplicationTagUnsignedInteger {
	return m.NumberOfDataElements
}

func (m *_BACnetConstructedDataPositiveAccessRules) GetPositiveAccessRules() []BACnetAccessRule {
	return m.PositiveAccessRules
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataPositiveAccessRules) GetZero() uint64 {
	ctx := context.Background()
	_ = ctx
	numberOfDataElements := m.GetNumberOfDataElements()
	_ = numberOfDataElements
	return uint64(uint64(0))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataPositiveAccessRules(structType any) BACnetConstructedDataPositiveAccessRules {
	if casted, ok := structType.(BACnetConstructedDataPositiveAccessRules); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataPositiveAccessRules); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataPositiveAccessRules) GetTypeName() string {
	return "BACnetConstructedDataPositiveAccessRules"
}

func (m *_BACnetConstructedDataPositiveAccessRules) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// A virtual field doesn't have any in- or output.

	// Optional Field (numberOfDataElements)
	if m.NumberOfDataElements != nil {
		lengthInBits += m.NumberOfDataElements.GetLengthInBits(ctx)
	}

	// Array field
	if len(m.PositiveAccessRules) > 0 {
		for _, element := range m.PositiveAccessRules {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataPositiveAccessRules) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataPositiveAccessRules) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataPositiveAccessRules BACnetConstructedDataPositiveAccessRules, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataPositiveAccessRules"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataPositiveAccessRules")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zero, err := ReadVirtualField[uint64](ctx, "zero", (*uint64)(nil), uint64(0))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zero' field"))
	}
	_ = zero

	var numberOfDataElements BACnetApplicationTagUnsignedInteger
	_numberOfDataElements, err := ReadOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfDataElements", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer), bool(bool((arrayIndexArgument) != (nil))) && bool(bool((arrayIndexArgument.GetActualValue()) == (zero))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numberOfDataElements' field"))
	}
	if _numberOfDataElements != nil {
		numberOfDataElements = *_numberOfDataElements
		m.NumberOfDataElements = numberOfDataElements
	}

	positiveAccessRules, err := ReadTerminatedArrayField[BACnetAccessRule](ctx, "positiveAccessRules", ReadComplex[BACnetAccessRule](BACnetAccessRuleParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'positiveAccessRules' field"))
	}
	m.PositiveAccessRules = positiveAccessRules

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataPositiveAccessRules"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataPositiveAccessRules")
	}

	return m, nil
}

func (m *_BACnetConstructedDataPositiveAccessRules) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataPositiveAccessRules) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataPositiveAccessRules"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataPositiveAccessRules")
		}
		// Virtual field
		zero := m.GetZero()
		_ = zero
		if _zeroErr := writeBuffer.WriteVirtual(ctx, "zero", m.GetZero()); _zeroErr != nil {
			return errors.Wrap(_zeroErr, "Error serializing 'zero' field")
		}

		if err := WriteOptionalField[BACnetApplicationTagUnsignedInteger](ctx, "numberOfDataElements", GetRef(m.GetNumberOfDataElements()), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'numberOfDataElements' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "positiveAccessRules", m.GetPositiveAccessRules(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'positiveAccessRules' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataPositiveAccessRules"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataPositiveAccessRules")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataPositiveAccessRules) IsBACnetConstructedDataPositiveAccessRules() {}

func (m *_BACnetConstructedDataPositiveAccessRules) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataPositiveAccessRules) deepCopy() *_BACnetConstructedDataPositiveAccessRules {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataPositiveAccessRulesCopy := &_BACnetConstructedDataPositiveAccessRules{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.NumberOfDataElements),
		utils.DeepCopySlice[BACnetAccessRule, BACnetAccessRule](m.PositiveAccessRules),
	}
	_BACnetConstructedDataPositiveAccessRulesCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataPositiveAccessRulesCopy
}

func (m *_BACnetConstructedDataPositiveAccessRules) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
