/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataPacketReorderTime is the corresponding interface of BACnetConstructedDataPacketReorderTime
type BACnetConstructedDataPacketReorderTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetPacketReorderTime returns PacketReorderTime (property field)
	GetPacketReorderTime() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataPacketReorderTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataPacketReorderTime()
	// CreateBuilder creates a BACnetConstructedDataPacketReorderTimeBuilder
	CreateBACnetConstructedDataPacketReorderTimeBuilder() BACnetConstructedDataPacketReorderTimeBuilder
}

// _BACnetConstructedDataPacketReorderTime is the data-structure of this message
type _BACnetConstructedDataPacketReorderTime struct {
	BACnetConstructedDataContract
	PacketReorderTime BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataPacketReorderTime = (*_BACnetConstructedDataPacketReorderTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataPacketReorderTime)(nil)

// NewBACnetConstructedDataPacketReorderTime factory function for _BACnetConstructedDataPacketReorderTime
func NewBACnetConstructedDataPacketReorderTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, packetReorderTime BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataPacketReorderTime {
	if packetReorderTime == nil {
		panic("packetReorderTime of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataPacketReorderTime must not be nil")
	}
	_result := &_BACnetConstructedDataPacketReorderTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		PacketReorderTime:             packetReorderTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataPacketReorderTimeBuilder is a builder for BACnetConstructedDataPacketReorderTime
type BACnetConstructedDataPacketReorderTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(packetReorderTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataPacketReorderTimeBuilder
	// WithPacketReorderTime adds PacketReorderTime (property field)
	WithPacketReorderTime(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataPacketReorderTimeBuilder
	// WithPacketReorderTimeBuilder adds PacketReorderTime (property field) which is build by the builder
	WithPacketReorderTimeBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataPacketReorderTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataPacketReorderTime or returns an error if something is wrong
	Build() (BACnetConstructedDataPacketReorderTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataPacketReorderTime
}

// NewBACnetConstructedDataPacketReorderTimeBuilder() creates a BACnetConstructedDataPacketReorderTimeBuilder
func NewBACnetConstructedDataPacketReorderTimeBuilder() BACnetConstructedDataPacketReorderTimeBuilder {
	return &_BACnetConstructedDataPacketReorderTimeBuilder{_BACnetConstructedDataPacketReorderTime: new(_BACnetConstructedDataPacketReorderTime)}
}

type _BACnetConstructedDataPacketReorderTimeBuilder struct {
	*_BACnetConstructedDataPacketReorderTime

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataPacketReorderTimeBuilder) = (*_BACnetConstructedDataPacketReorderTimeBuilder)(nil)

func (b *_BACnetConstructedDataPacketReorderTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataPacketReorderTime
}

func (b *_BACnetConstructedDataPacketReorderTimeBuilder) WithMandatoryFields(packetReorderTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataPacketReorderTimeBuilder {
	return b.WithPacketReorderTime(packetReorderTime)
}

func (b *_BACnetConstructedDataPacketReorderTimeBuilder) WithPacketReorderTime(packetReorderTime BACnetApplicationTagUnsignedInteger) BACnetConstructedDataPacketReorderTimeBuilder {
	b.PacketReorderTime = packetReorderTime
	return b
}

func (b *_BACnetConstructedDataPacketReorderTimeBuilder) WithPacketReorderTimeBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataPacketReorderTimeBuilder {
	builder := builderSupplier(b.PacketReorderTime.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.PacketReorderTime, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataPacketReorderTimeBuilder) Build() (BACnetConstructedDataPacketReorderTime, error) {
	if b.PacketReorderTime == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'packetReorderTime' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataPacketReorderTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataPacketReorderTimeBuilder) MustBuild() BACnetConstructedDataPacketReorderTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataPacketReorderTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataPacketReorderTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataPacketReorderTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataPacketReorderTimeBuilder().(*_BACnetConstructedDataPacketReorderTimeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataPacketReorderTimeBuilder creates a BACnetConstructedDataPacketReorderTimeBuilder
func (b *_BACnetConstructedDataPacketReorderTime) CreateBACnetConstructedDataPacketReorderTimeBuilder() BACnetConstructedDataPacketReorderTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataPacketReorderTimeBuilder()
	}
	return &_BACnetConstructedDataPacketReorderTimeBuilder{_BACnetConstructedDataPacketReorderTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataPacketReorderTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataPacketReorderTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_PACKET_REORDER_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataPacketReorderTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataPacketReorderTime) GetPacketReorderTime() BACnetApplicationTagUnsignedInteger {
	return m.PacketReorderTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataPacketReorderTime) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetPacketReorderTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataPacketReorderTime(structType any) BACnetConstructedDataPacketReorderTime {
	if casted, ok := structType.(BACnetConstructedDataPacketReorderTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataPacketReorderTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataPacketReorderTime) GetTypeName() string {
	return "BACnetConstructedDataPacketReorderTime"
}

func (m *_BACnetConstructedDataPacketReorderTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (packetReorderTime)
	lengthInBits += m.PacketReorderTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataPacketReorderTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataPacketReorderTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataPacketReorderTime BACnetConstructedDataPacketReorderTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataPacketReorderTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataPacketReorderTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	packetReorderTime, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "packetReorderTime", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'packetReorderTime' field"))
	}
	m.PacketReorderTime = packetReorderTime

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), packetReorderTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataPacketReorderTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataPacketReorderTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataPacketReorderTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataPacketReorderTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataPacketReorderTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataPacketReorderTime")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "packetReorderTime", m.GetPacketReorderTime(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'packetReorderTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataPacketReorderTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataPacketReorderTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataPacketReorderTime) IsBACnetConstructedDataPacketReorderTime() {}

func (m *_BACnetConstructedDataPacketReorderTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataPacketReorderTime) deepCopy() *_BACnetConstructedDataPacketReorderTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataPacketReorderTimeCopy := &_BACnetConstructedDataPacketReorderTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.PacketReorderTime),
	}
	_BACnetConstructedDataPacketReorderTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataPacketReorderTimeCopy
}

func (m *_BACnetConstructedDataPacketReorderTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
