/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataOccupancyLowerLimitEnforced is the corresponding interface of BACnetConstructedDataOccupancyLowerLimitEnforced
type BACnetConstructedDataOccupancyLowerLimitEnforced interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetOccupancyLowerLimitEnforced returns OccupancyLowerLimitEnforced (property field)
	GetOccupancyLowerLimitEnforced() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
	// IsBACnetConstructedDataOccupancyLowerLimitEnforced is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataOccupancyLowerLimitEnforced()
	// CreateBuilder creates a BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder
	CreateBACnetConstructedDataOccupancyLowerLimitEnforcedBuilder() BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder
}

// _BACnetConstructedDataOccupancyLowerLimitEnforced is the data-structure of this message
type _BACnetConstructedDataOccupancyLowerLimitEnforced struct {
	BACnetConstructedDataContract
	OccupancyLowerLimitEnforced BACnetApplicationTagBoolean
}

var _ BACnetConstructedDataOccupancyLowerLimitEnforced = (*_BACnetConstructedDataOccupancyLowerLimitEnforced)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataOccupancyLowerLimitEnforced)(nil)

// NewBACnetConstructedDataOccupancyLowerLimitEnforced factory function for _BACnetConstructedDataOccupancyLowerLimitEnforced
func NewBACnetConstructedDataOccupancyLowerLimitEnforced(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, occupancyLowerLimitEnforced BACnetApplicationTagBoolean, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataOccupancyLowerLimitEnforced {
	if occupancyLowerLimitEnforced == nil {
		panic("occupancyLowerLimitEnforced of type BACnetApplicationTagBoolean for BACnetConstructedDataOccupancyLowerLimitEnforced must not be nil")
	}
	_result := &_BACnetConstructedDataOccupancyLowerLimitEnforced{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		OccupancyLowerLimitEnforced:   occupancyLowerLimitEnforced,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder is a builder for BACnetConstructedDataOccupancyLowerLimitEnforced
type BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(occupancyLowerLimitEnforced BACnetApplicationTagBoolean) BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder
	// WithOccupancyLowerLimitEnforced adds OccupancyLowerLimitEnforced (property field)
	WithOccupancyLowerLimitEnforced(BACnetApplicationTagBoolean) BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder
	// WithOccupancyLowerLimitEnforcedBuilder adds OccupancyLowerLimitEnforced (property field) which is build by the builder
	WithOccupancyLowerLimitEnforcedBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataOccupancyLowerLimitEnforced or returns an error if something is wrong
	Build() (BACnetConstructedDataOccupancyLowerLimitEnforced, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataOccupancyLowerLimitEnforced
}

// NewBACnetConstructedDataOccupancyLowerLimitEnforcedBuilder() creates a BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder
func NewBACnetConstructedDataOccupancyLowerLimitEnforcedBuilder() BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder {
	return &_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder{_BACnetConstructedDataOccupancyLowerLimitEnforced: new(_BACnetConstructedDataOccupancyLowerLimitEnforced)}
}

type _BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder struct {
	*_BACnetConstructedDataOccupancyLowerLimitEnforced

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder) = (*_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder)(nil)

func (b *_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataOccupancyLowerLimitEnforced
}

func (b *_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder) WithMandatoryFields(occupancyLowerLimitEnforced BACnetApplicationTagBoolean) BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder {
	return b.WithOccupancyLowerLimitEnforced(occupancyLowerLimitEnforced)
}

func (b *_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder) WithOccupancyLowerLimitEnforced(occupancyLowerLimitEnforced BACnetApplicationTagBoolean) BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder {
	b.OccupancyLowerLimitEnforced = occupancyLowerLimitEnforced
	return b
}

func (b *_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder) WithOccupancyLowerLimitEnforcedBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder {
	builder := builderSupplier(b.OccupancyLowerLimitEnforced.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.OccupancyLowerLimitEnforced, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder) Build() (BACnetConstructedDataOccupancyLowerLimitEnforced, error) {
	if b.OccupancyLowerLimitEnforced == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'occupancyLowerLimitEnforced' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataOccupancyLowerLimitEnforced.deepCopy(), nil
}

func (b *_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder) MustBuild() BACnetConstructedDataOccupancyLowerLimitEnforced {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataOccupancyLowerLimitEnforcedBuilder().(*_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataOccupancyLowerLimitEnforcedBuilder creates a BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder
func (b *_BACnetConstructedDataOccupancyLowerLimitEnforced) CreateBACnetConstructedDataOccupancyLowerLimitEnforcedBuilder() BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder {
	if b == nil {
		return NewBACnetConstructedDataOccupancyLowerLimitEnforcedBuilder()
	}
	return &_BACnetConstructedDataOccupancyLowerLimitEnforcedBuilder{_BACnetConstructedDataOccupancyLowerLimitEnforced: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_OCCUPANCY_LOWER_LIMIT_ENFORCED
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) GetOccupancyLowerLimitEnforced() BACnetApplicationTagBoolean {
	return m.OccupancyLowerLimitEnforced
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetOccupancyLowerLimitEnforced())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataOccupancyLowerLimitEnforced(structType any) BACnetConstructedDataOccupancyLowerLimitEnforced {
	if casted, ok := structType.(BACnetConstructedDataOccupancyLowerLimitEnforced); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataOccupancyLowerLimitEnforced); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) GetTypeName() string {
	return "BACnetConstructedDataOccupancyLowerLimitEnforced"
}

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (occupancyLowerLimitEnforced)
	lengthInBits += m.OccupancyLowerLimitEnforced.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataOccupancyLowerLimitEnforced BACnetConstructedDataOccupancyLowerLimitEnforced, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataOccupancyLowerLimitEnforced"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataOccupancyLowerLimitEnforced")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	occupancyLowerLimitEnforced, err := ReadSimpleField[BACnetApplicationTagBoolean](ctx, "occupancyLowerLimitEnforced", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'occupancyLowerLimitEnforced' field"))
	}
	m.OccupancyLowerLimitEnforced = occupancyLowerLimitEnforced

	actualValue, err := ReadVirtualField[BACnetApplicationTagBoolean](ctx, "actualValue", (*BACnetApplicationTagBoolean)(nil), occupancyLowerLimitEnforced)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataOccupancyLowerLimitEnforced"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataOccupancyLowerLimitEnforced")
	}

	return m, nil
}

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataOccupancyLowerLimitEnforced"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataOccupancyLowerLimitEnforced")
		}

		if err := WriteSimpleField[BACnetApplicationTagBoolean](ctx, "occupancyLowerLimitEnforced", m.GetOccupancyLowerLimitEnforced(), WriteComplex[BACnetApplicationTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'occupancyLowerLimitEnforced' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataOccupancyLowerLimitEnforced"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataOccupancyLowerLimitEnforced")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) IsBACnetConstructedDataOccupancyLowerLimitEnforced() {
}

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) deepCopy() *_BACnetConstructedDataOccupancyLowerLimitEnforced {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataOccupancyLowerLimitEnforcedCopy := &_BACnetConstructedDataOccupancyLowerLimitEnforced{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.OccupancyLowerLimitEnforced),
	}
	_BACnetConstructedDataOccupancyLowerLimitEnforcedCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataOccupancyLowerLimitEnforcedCopy
}

func (m *_BACnetConstructedDataOccupancyLowerLimitEnforced) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
