/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataMinimumValue is the corresponding interface of BACnetConstructedDataMinimumValue
type BACnetConstructedDataMinimumValue interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetMinimumValue returns MinimumValue (property field)
	GetMinimumValue() BACnetApplicationTagReal
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagReal
	// IsBACnetConstructedDataMinimumValue is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataMinimumValue()
	// CreateBuilder creates a BACnetConstructedDataMinimumValueBuilder
	CreateBACnetConstructedDataMinimumValueBuilder() BACnetConstructedDataMinimumValueBuilder
}

// _BACnetConstructedDataMinimumValue is the data-structure of this message
type _BACnetConstructedDataMinimumValue struct {
	BACnetConstructedDataContract
	MinimumValue BACnetApplicationTagReal
}

var _ BACnetConstructedDataMinimumValue = (*_BACnetConstructedDataMinimumValue)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataMinimumValue)(nil)

// NewBACnetConstructedDataMinimumValue factory function for _BACnetConstructedDataMinimumValue
func NewBACnetConstructedDataMinimumValue(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, minimumValue BACnetApplicationTagReal, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataMinimumValue {
	if minimumValue == nil {
		panic("minimumValue of type BACnetApplicationTagReal for BACnetConstructedDataMinimumValue must not be nil")
	}
	_result := &_BACnetConstructedDataMinimumValue{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		MinimumValue:                  minimumValue,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataMinimumValueBuilder is a builder for BACnetConstructedDataMinimumValue
type BACnetConstructedDataMinimumValueBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(minimumValue BACnetApplicationTagReal) BACnetConstructedDataMinimumValueBuilder
	// WithMinimumValue adds MinimumValue (property field)
	WithMinimumValue(BACnetApplicationTagReal) BACnetConstructedDataMinimumValueBuilder
	// WithMinimumValueBuilder adds MinimumValue (property field) which is build by the builder
	WithMinimumValueBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataMinimumValueBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataMinimumValue or returns an error if something is wrong
	Build() (BACnetConstructedDataMinimumValue, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataMinimumValue
}

// NewBACnetConstructedDataMinimumValueBuilder() creates a BACnetConstructedDataMinimumValueBuilder
func NewBACnetConstructedDataMinimumValueBuilder() BACnetConstructedDataMinimumValueBuilder {
	return &_BACnetConstructedDataMinimumValueBuilder{_BACnetConstructedDataMinimumValue: new(_BACnetConstructedDataMinimumValue)}
}

type _BACnetConstructedDataMinimumValueBuilder struct {
	*_BACnetConstructedDataMinimumValue

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataMinimumValueBuilder) = (*_BACnetConstructedDataMinimumValueBuilder)(nil)

func (b *_BACnetConstructedDataMinimumValueBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataMinimumValue
}

func (b *_BACnetConstructedDataMinimumValueBuilder) WithMandatoryFields(minimumValue BACnetApplicationTagReal) BACnetConstructedDataMinimumValueBuilder {
	return b.WithMinimumValue(minimumValue)
}

func (b *_BACnetConstructedDataMinimumValueBuilder) WithMinimumValue(minimumValue BACnetApplicationTagReal) BACnetConstructedDataMinimumValueBuilder {
	b.MinimumValue = minimumValue
	return b
}

func (b *_BACnetConstructedDataMinimumValueBuilder) WithMinimumValueBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataMinimumValueBuilder {
	builder := builderSupplier(b.MinimumValue.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.MinimumValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataMinimumValueBuilder) Build() (BACnetConstructedDataMinimumValue, error) {
	if b.MinimumValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'minimumValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataMinimumValue.deepCopy(), nil
}

func (b *_BACnetConstructedDataMinimumValueBuilder) MustBuild() BACnetConstructedDataMinimumValue {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataMinimumValueBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataMinimumValueBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataMinimumValueBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataMinimumValueBuilder().(*_BACnetConstructedDataMinimumValueBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataMinimumValueBuilder creates a BACnetConstructedDataMinimumValueBuilder
func (b *_BACnetConstructedDataMinimumValue) CreateBACnetConstructedDataMinimumValueBuilder() BACnetConstructedDataMinimumValueBuilder {
	if b == nil {
		return NewBACnetConstructedDataMinimumValueBuilder()
	}
	return &_BACnetConstructedDataMinimumValueBuilder{_BACnetConstructedDataMinimumValue: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataMinimumValue) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataMinimumValue) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_MINIMUM_VALUE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataMinimumValue) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataMinimumValue) GetMinimumValue() BACnetApplicationTagReal {
	return m.MinimumValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataMinimumValue) GetActualValue() BACnetApplicationTagReal {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagReal(m.GetMinimumValue())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataMinimumValue(structType any) BACnetConstructedDataMinimumValue {
	if casted, ok := structType.(BACnetConstructedDataMinimumValue); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataMinimumValue); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataMinimumValue) GetTypeName() string {
	return "BACnetConstructedDataMinimumValue"
}

func (m *_BACnetConstructedDataMinimumValue) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (minimumValue)
	lengthInBits += m.MinimumValue.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataMinimumValue) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataMinimumValue) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataMinimumValue BACnetConstructedDataMinimumValue, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataMinimumValue"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataMinimumValue")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	minimumValue, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "minimumValue", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'minimumValue' field"))
	}
	m.MinimumValue = minimumValue

	actualValue, err := ReadVirtualField[BACnetApplicationTagReal](ctx, "actualValue", (*BACnetApplicationTagReal)(nil), minimumValue)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataMinimumValue"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataMinimumValue")
	}

	return m, nil
}

func (m *_BACnetConstructedDataMinimumValue) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataMinimumValue) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataMinimumValue"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataMinimumValue")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "minimumValue", m.GetMinimumValue(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'minimumValue' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataMinimumValue"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataMinimumValue")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataMinimumValue) IsBACnetConstructedDataMinimumValue() {}

func (m *_BACnetConstructedDataMinimumValue) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataMinimumValue) deepCopy() *_BACnetConstructedDataMinimumValue {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataMinimumValueCopy := &_BACnetConstructedDataMinimumValue{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.MinimumValue),
	}
	_BACnetConstructedDataMinimumValueCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataMinimumValueCopy
}

func (m *_BACnetConstructedDataMinimumValue) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
