/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataMaximumOutput is the corresponding interface of BACnetConstructedDataMaximumOutput
type BACnetConstructedDataMaximumOutput interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetMaximumOutput returns MaximumOutput (property field)
	GetMaximumOutput() BACnetApplicationTagReal
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagReal
	// IsBACnetConstructedDataMaximumOutput is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataMaximumOutput()
	// CreateBuilder creates a BACnetConstructedDataMaximumOutputBuilder
	CreateBACnetConstructedDataMaximumOutputBuilder() BACnetConstructedDataMaximumOutputBuilder
}

// _BACnetConstructedDataMaximumOutput is the data-structure of this message
type _BACnetConstructedDataMaximumOutput struct {
	BACnetConstructedDataContract
	MaximumOutput BACnetApplicationTagReal
}

var _ BACnetConstructedDataMaximumOutput = (*_BACnetConstructedDataMaximumOutput)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataMaximumOutput)(nil)

// NewBACnetConstructedDataMaximumOutput factory function for _BACnetConstructedDataMaximumOutput
func NewBACnetConstructedDataMaximumOutput(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, maximumOutput BACnetApplicationTagReal, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataMaximumOutput {
	if maximumOutput == nil {
		panic("maximumOutput of type BACnetApplicationTagReal for BACnetConstructedDataMaximumOutput must not be nil")
	}
	_result := &_BACnetConstructedDataMaximumOutput{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		MaximumOutput:                 maximumOutput,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataMaximumOutputBuilder is a builder for BACnetConstructedDataMaximumOutput
type BACnetConstructedDataMaximumOutputBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(maximumOutput BACnetApplicationTagReal) BACnetConstructedDataMaximumOutputBuilder
	// WithMaximumOutput adds MaximumOutput (property field)
	WithMaximumOutput(BACnetApplicationTagReal) BACnetConstructedDataMaximumOutputBuilder
	// WithMaximumOutputBuilder adds MaximumOutput (property field) which is build by the builder
	WithMaximumOutputBuilder(func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataMaximumOutputBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataMaximumOutput or returns an error if something is wrong
	Build() (BACnetConstructedDataMaximumOutput, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataMaximumOutput
}

// NewBACnetConstructedDataMaximumOutputBuilder() creates a BACnetConstructedDataMaximumOutputBuilder
func NewBACnetConstructedDataMaximumOutputBuilder() BACnetConstructedDataMaximumOutputBuilder {
	return &_BACnetConstructedDataMaximumOutputBuilder{_BACnetConstructedDataMaximumOutput: new(_BACnetConstructedDataMaximumOutput)}
}

type _BACnetConstructedDataMaximumOutputBuilder struct {
	*_BACnetConstructedDataMaximumOutput

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataMaximumOutputBuilder) = (*_BACnetConstructedDataMaximumOutputBuilder)(nil)

func (b *_BACnetConstructedDataMaximumOutputBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataMaximumOutput
}

func (b *_BACnetConstructedDataMaximumOutputBuilder) WithMandatoryFields(maximumOutput BACnetApplicationTagReal) BACnetConstructedDataMaximumOutputBuilder {
	return b.WithMaximumOutput(maximumOutput)
}

func (b *_BACnetConstructedDataMaximumOutputBuilder) WithMaximumOutput(maximumOutput BACnetApplicationTagReal) BACnetConstructedDataMaximumOutputBuilder {
	b.MaximumOutput = maximumOutput
	return b
}

func (b *_BACnetConstructedDataMaximumOutputBuilder) WithMaximumOutputBuilder(builderSupplier func(BACnetApplicationTagRealBuilder) BACnetApplicationTagRealBuilder) BACnetConstructedDataMaximumOutputBuilder {
	builder := builderSupplier(b.MaximumOutput.CreateBACnetApplicationTagRealBuilder())
	var err error
	b.MaximumOutput, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagRealBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataMaximumOutputBuilder) Build() (BACnetConstructedDataMaximumOutput, error) {
	if b.MaximumOutput == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'maximumOutput' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataMaximumOutput.deepCopy(), nil
}

func (b *_BACnetConstructedDataMaximumOutputBuilder) MustBuild() BACnetConstructedDataMaximumOutput {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataMaximumOutputBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataMaximumOutputBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataMaximumOutputBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataMaximumOutputBuilder().(*_BACnetConstructedDataMaximumOutputBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataMaximumOutputBuilder creates a BACnetConstructedDataMaximumOutputBuilder
func (b *_BACnetConstructedDataMaximumOutput) CreateBACnetConstructedDataMaximumOutputBuilder() BACnetConstructedDataMaximumOutputBuilder {
	if b == nil {
		return NewBACnetConstructedDataMaximumOutputBuilder()
	}
	return &_BACnetConstructedDataMaximumOutputBuilder{_BACnetConstructedDataMaximumOutput: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataMaximumOutput) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataMaximumOutput) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_MAXIMUM_OUTPUT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataMaximumOutput) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataMaximumOutput) GetMaximumOutput() BACnetApplicationTagReal {
	return m.MaximumOutput
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataMaximumOutput) GetActualValue() BACnetApplicationTagReal {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagReal(m.GetMaximumOutput())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataMaximumOutput(structType any) BACnetConstructedDataMaximumOutput {
	if casted, ok := structType.(BACnetConstructedDataMaximumOutput); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataMaximumOutput); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataMaximumOutput) GetTypeName() string {
	return "BACnetConstructedDataMaximumOutput"
}

func (m *_BACnetConstructedDataMaximumOutput) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (maximumOutput)
	lengthInBits += m.MaximumOutput.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataMaximumOutput) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataMaximumOutput) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataMaximumOutput BACnetConstructedDataMaximumOutput, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataMaximumOutput"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataMaximumOutput")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	maximumOutput, err := ReadSimpleField[BACnetApplicationTagReal](ctx, "maximumOutput", ReadComplex[BACnetApplicationTagReal](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagReal](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'maximumOutput' field"))
	}
	m.MaximumOutput = maximumOutput

	actualValue, err := ReadVirtualField[BACnetApplicationTagReal](ctx, "actualValue", (*BACnetApplicationTagReal)(nil), maximumOutput)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataMaximumOutput"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataMaximumOutput")
	}

	return m, nil
}

func (m *_BACnetConstructedDataMaximumOutput) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataMaximumOutput) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataMaximumOutput"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataMaximumOutput")
		}

		if err := WriteSimpleField[BACnetApplicationTagReal](ctx, "maximumOutput", m.GetMaximumOutput(), WriteComplex[BACnetApplicationTagReal](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'maximumOutput' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataMaximumOutput"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataMaximumOutput")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataMaximumOutput) IsBACnetConstructedDataMaximumOutput() {}

func (m *_BACnetConstructedDataMaximumOutput) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataMaximumOutput) deepCopy() *_BACnetConstructedDataMaximumOutput {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataMaximumOutputCopy := &_BACnetConstructedDataMaximumOutput{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagReal](m.MaximumOutput),
	}
	_BACnetConstructedDataMaximumOutputCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataMaximumOutputCopy
}

func (m *_BACnetConstructedDataMaximumOutput) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
